/*
 * Decompiled with CFR 0.152.
 */
package ancestris.core.actions;

import ancestris.core.actions.TitleContextMenuPanel;
import ancestris.core.actions.TitleDNDMenuPanel;
import genj.gedcom.Property;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import org.openide.awt.DynamicMenuContent;
import org.openide.util.actions.Presenter;

public class CommonActions {
    public static int TYPE_CONTEXT_MENU = 0;
    public static int TYPE_DND_MENU = 1;
    public static final Action NOOP = new NoOpAction();

    public static Action createTitleAction(int menuType, Property property, Object ... o) {
        return new TitleAction(menuType, property, o);
    }

    private static class TitleAction
    extends AbstractAction
    implements Presenter.Popup {
        private Property property;
        private int menuType;
        private Object[] o;

        public TitleAction(int menuType, Property property, Object ... o) {
            this.property = property;
            this.menuType = menuType;
            this.o = o;
            this.setEnabled(true);
            this.putValue("hideWhenDisabled", true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }

        public JMenuItem getPopupPresenter() {
            return new TitleMenuItem(this.menuType, this.property, this.o);
        }
    }

    private static class NoOpAction
    extends AbstractAction {
        public NoOpAction() {
            this.setEnabled(false);
            this.putValue("Name", "noop");
            this.putValue("hideWhenDisabled", true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    private static class TitleMenuItem
    extends JMenuItem
    implements DynamicMenuContent {
        private JPanel panel;

        public TitleMenuItem(int menuType, Property property, Object ... o) {
            switch (menuType) {
                case 0: {
                    this.panel = new TitleContextMenuPanel(property);
                    break;
                }
                case 1: {
                    this.panel = new TitleDNDMenuPanel(property, o);
                    break;
                }
            }
        }

        public JComponent[] getMenuPresenters() {
            return new JComponent[]{this.panel};
        }

        public JComponent[] synchMenuPresenters(JComponent[] items) {
            return this.getMenuPresenters();
        }
    }
}

