/*
 * Decompiled with CFR 0.152.
 */
package genj.renderer;

import ancestris.core.actions.AbstractAncestrisAction;
import ancestris.swing.UndoTextArea;
import ancestris.util.swing.DialogManager;
import genj.common.PathTreeWidget;
import genj.gedcom.Entity;
import genj.gedcom.Grammar;
import genj.gedcom.Property;
import genj.gedcom.TagPath;
import genj.renderer.Blueprint;
import genj.renderer.BlueprintManager;
import genj.renderer.BlueprintRendererSample;
import genj.util.Resources;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.DialogDescriptor;

public class BlueprintEditor
extends JSplitPane {
    private final JTextArea source;
    private final Preview preview;
    private static final Resources RESOURCES = Resources.get(BlueprintEditor.class);
    private Grammar grammar = Grammar.V55;
    private Blueprint blueprint;
    private AbstractButton bInsert;
    private Entity example;
    private boolean isChanged = false;
    private final BlueprintManager blueprintManager = BlueprintManager.getInstance();

    public BlueprintEditor(Entity recipient) {
        this.example = recipient;
        this.grammar = recipient.getGedcom().getGrammar();
        this.preview = new Preview();
        this.preview.setBorder(BorderFactory.createTitledBorder(RESOURCES.getString("blueprint.preview")));
        JPanel edit = new JPanel(new BorderLayout());
        this.source = new UndoTextArea();
        this.source.setRows(3);
        this.source.setColumns(32);
        this.source.setFont(new Font("Monospaced", 0, 12));
        JScrollPane scroll = new JScrollPane(this.source);
        scroll.setBorder(BorderFactory.createTitledBorder("HTML"));
        this.bInsert = new JButton(new Insert());
        edit.setMinimumSize(new Dimension(0, 0));
        edit.add((Component)scroll, "Center");
        edit.add((Component)this.bInsert, "South");
        this.setLeftComponent(this.preview);
        this.setRightComponent(edit);
        this.setDividerLocation(Integer.MAX_VALUE);
        this.setOrientation(0);
        this.setOneTouchExpandable(true);
        this.source.getDocument().addDocumentListener(this.preview);
        this.set(null);
    }

    @Override
    public int getLastDividerLocation() {
        return this.getSize().height / 2;
    }

    public void set(Blueprint setBlueprint) {
        if (setBlueprint == null) {
            this.blueprint = null;
            this.source.setText("");
        } else {
            this.blueprint = setBlueprint;
            this.source.setText(this.blueprint.getHTML());
            this.source.setCaretPosition(0);
        }
        boolean edit = this.blueprint != null && !this.blueprint.isReadOnly();
        this.bInsert.setEnabled(edit);
        this.source.setEditable(edit);
        this.source.setToolTipText(this.blueprint != null && this.blueprint.isReadOnly() ? RESOURCES.getString("blueprint.readonly", this.blueprint.getDisplayName()) : null);
        if (edit) {
            this.setSourceVisible(true);
        }
        this.isChanged = false;
        this.preview.repaint();
    }

    public void commit() {
        if (this.blueprint != null && this.isChanged) {
            this.blueprint.setSource(this.source.getText());
            try {
                this.blueprintManager.saveBlueprint(this.blueprint);
                this.isChanged = false;
            }
            catch (IOException e) {
                Logger.getLogger("ancestris.renderer").log(Level.WARNING, "can't save blueprint", e);
            }
        }
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    public void setSourceVisible(boolean v) {
        SwingUtilities.invokeLater(new ShowHTML(v));
    }

    private class Preview
    extends JComponent
    implements DocumentListener {
        private Preview() {
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            BlueprintEditor.this.isChanged = true;
            this.repaint();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            BlueprintEditor.this.isChanged = true;
            this.repaint();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            BlueprintEditor.this.isChanged = true;
            this.repaint();
        }

        @Override
        protected void paintComponent(Graphics g) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (BlueprintEditor.this.source.getText().length() == 0) {
                return;
            }
            Rectangle bounds = this.getBounds();
            Insets insets = this.getInsets();
            bounds.x += insets.left;
            bounds.y += insets.top;
            bounds.width -= insets.left + insets.right;
            bounds.height -= insets.top + insets.bottom;
            g.setColor(Color.white);
            g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
            g.setFont(this.getFont());
            BlueprintRendererSample renderer = new BlueprintRendererSample(BlueprintEditor.this.grammar, new Blueprint(BlueprintEditor.this.source.getText()));
            renderer.setDebug(true);
            renderer.render(g, BlueprintEditor.this.example, bounds);
        }
    }

    private class Insert
    extends AbstractAncestrisAction {
        private Insert() {
            super.setText(RESOURCES.getString("prop.insert"));
            super.setTip(RESOURCES.getString("prop.insert.tip"));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            PathTreeWidget tree = new PathTreeWidget();
            TagPath[] paths = BlueprintEditor.this.grammar.getAllPaths(BlueprintEditor.this.blueprint.getTag(), Property.class);
            tree.setPaths(paths, new TagPath[0]);
            Object option = DialogManager.create(RESOURCES.getString("prop.insert.tip"), tree).setOptionType(2).setDialogId("genj.renderer.blueprinteditor").show();
            if (option != DialogDescriptor.OK_OPTION) {
                return;
            }
            paths = tree.getSelection();
            for (int p = 0; p < paths.length; ++p) {
                BlueprintEditor.this.source.insert("<prop path=" + paths[p].toString() + ">" + (p == paths.length - 1 ? "" : "\n"), BlueprintEditor.this.source.getCaretPosition());
            }
            BlueprintEditor.this.source.requestFocusInWindow();
        }
    }

    private class ShowHTML
    implements Runnable {
        private final boolean visible;

        public ShowHTML(boolean visible) {
            this.visible = visible;
        }

        @Override
        public void run() {
            BlueprintEditor.this.setDividerLocation(this.visible ? 0.5 : 1.0);
        }
    }
}

