/*
 * Decompiled with CFR 0.152.
 */
package genj.util;

public class Base64 {
    public static byte decode(char c) throws IllegalArgumentException {
        if (c >= 'A' && c <= 'Z') {
            return (byte)(c - 65);
        }
        if (c >= 'a' && c <= 'z') {
            return (byte)(c - 97 + 26);
        }
        if (c >= '0' && c <= '9') {
            return (byte)(c - 48 + 52);
        }
        if (c == '+') {
            return 62;
        }
        if (c == '/') {
            return 63;
        }
        if (c == '=') {
            return 0;
        }
        throw new IllegalArgumentException("Illegal Base64 byte (" + c + ")");
    }

    public static byte[] decode(String in) throws IllegalArgumentException {
        if (in.length() % 4 != 0 || in.length() == 0) {
            throw new IllegalArgumentException("Illegal Base64 String");
        }
        int pad = 0;
        int i = in.length() - 1;
        while (in.charAt(i) == '=') {
            ++pad;
            --i;
        }
        int len = in.length() * 3 / 4 - pad;
        byte[] raw = new byte[len];
        int rawIndex = 0;
        for (int i2 = 0; i2 < in.length(); i2 += 4) {
            int block = (Base64.decode(in.charAt(i2 + 0)) << 18) + (Base64.decode(in.charAt(i2 + 1)) << 12) + (Base64.decode(in.charAt(i2 + 2)) << 6) + Base64.decode(in.charAt(i2 + 3));
            for (int j = 0; j < 3 && rawIndex + j < raw.length; ++j) {
                raw[rawIndex + j] = (byte)(block >> 8 * (2 - j) & 0xFF);
            }
            rawIndex += 3;
        }
        return raw;
    }

    public static String encode(byte[] raw) {
        StringBuffer encoded = new StringBuffer((raw.length + 1) * 4 / 3);
        for (int i = 0; i < raw.length; i += 3) {
            encoded.append(Base64.encodeBlock(raw, i));
        }
        return encoded.toString();
    }

    public static char encode(int i) {
        if (i >= 0 && i <= 25) {
            return (char)(65 + i);
        }
        if (i >= 26 && i <= 51) {
            return (char)(97 + (i - 26));
        }
        if (i >= 52 && i <= 61) {
            return (char)(48 + (i - 52));
        }
        if (i == 62) {
            return '+';
        }
        if (i == 63) {
            return '/';
        }
        return '?';
    }

    private static char[] encodeBlock(byte[] raw, int offset) {
        int block = 0;
        int left = raw.length - offset - 1;
        int bsize = left >= 2 ? 2 : left;
        for (int i = 0; i <= bsize; ++i) {
            int b = raw[offset + i];
            block += (b < 0 ? b + 256 : b) << 8 * (2 - i);
        }
        char[] base64 = new char[4];
        for (int i = 0; i < 4; ++i) {
            int sixbit = block >>> 6 * (3 - i) & 0x3F;
            base64[i] = Base64.encode(sixbit);
        }
        if (left < 1) {
            base64[2] = 61;
        }
        if (left < 2) {
            base64[3] = 61;
        }
        return base64;
    }
}

