/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.standard;

import ancestris.api.editor.Editor;
import ancestris.swing.UndoTextArea;
import ancestris.util.TimingUtility;
import genj.gedcom.AbstractNote;
import genj.gedcom.Context;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Media;
import genj.gedcom.Property;
import genj.gedcom.PropertyXRef;
import genj.gedcom.Repository;
import genj.gedcom.Source;
import genj.gedcom.Submitter;
import genj.io.InputSource;
import genj.renderer.MediaUtils;
import genj.view.ViewContext;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class BlankPanel
extends Editor {
    private static final Logger LOG = Logger.getLogger("ancestris.editor.blank");
    private Context context;
    private Gedcom gedcom;
    private Entity entity;
    private JLabel addressLabel;
    private JTextField addressText;
    private JTextField cityText;
    private JTextField codetext;
    private JTextField countryText;
    private JTextField countyText;
    private JLabel description;
    private JLabel entityName;
    private JLabel mediaImage;
    private JLabel mediaLabel;
    private JLabel nameLabel;
    private JTextField nameText;
    private JScrollPane scrollPane;
    private JLabel sourceLabel;
    private JTextField sourceText;
    private JTextArea textArea;
    private JLabel textLabel;

    public BlankPanel() {
        this.initComponents();
    }

    public ViewContext getContext() {
        return new ViewContext(this.context);
    }

    public Component getEditorComponent() {
        return this;
    }

    protected void setContextImpl(Context context) {
        LOG.finer(TimingUtility.getInstance().getTime() + ": setContextImpl().start");
        this.context = context;
        Entity localEntity = context.getEntity();
        if (localEntity != null) {
            this.entity = localEntity;
            this.gedcom = localEntity.getGedcom();
            String str = localEntity.getPropertyName() + " (" + localEntity.getId() + ")";
            this.entityName.setText("<html>" + NbBundle.getMessage(BlankPanel.class, (String)"BlankPanel.entityName.text") + " <b>" + str + "</b></html>");
            if (this.entity instanceof Submitter) {
                Submitter subm = (Submitter)this.entity;
                this.displayName(subm.getName());
                this.displayAddress(subm.getAddress(), subm.getCity(), subm.getState(), subm.getPostcode(), subm.getCountry());
                this.displayNote(this.entity);
                this.displayMedia(this.entity);
                this.displaySource(null);
            } else if (this.entity instanceof AbstractNote) {
                AbstractNote note = (AbstractNote)this.entity;
                this.displayName(null);
                this.displayAddress(null);
                this.displayNote(note.getValue());
                this.displayMedia((InputSource)null);
                this.displaySource(this.entity);
            } else if (this.entity instanceof Media) {
                Media media = (Media)this.entity;
                this.displayName(media.getTitle());
                this.displayAddress(null);
                this.displayNote(this.entity);
                this.displayMedia(media.getFile());
                this.displaySource(this.entity);
            } else if (this.entity instanceof Repository) {
                Repository repo = (Repository)this.entity;
                this.displayName(repo.getRepositoryName());
                Property address = repo.getProperty("ADDR");
                if (address != null) {
                    Property pCity = address.getProperty("CITY");
                    Property pState = address.getProperty("STAE");
                    Property pCode = address.getProperty("POST");
                    Property pCtry = address.getProperty("CTRY");
                    this.displayAddress(address.getValue(), pCity != null ? pCity.getValue() : "", pState != null ? pState.getValue() : "", pCode != null ? pCode.getValue() : "", pCtry != null ? pCtry.getValue() : "");
                } else {
                    this.displayAddress(null);
                }
                this.displayNote(this.entity);
                this.displayMedia((InputSource)null);
                this.displaySource(null);
            } else if (this.entity instanceof Source) {
                Source source = (Source)this.entity;
                this.displayName(source.getTitle());
                this.displayAddress(null);
                this.displayNote(source.getText());
                this.displayMedia(this.entity);
                this.displayRepository(this.entity);
            }
        }
        LOG.finer(TimingUtility.getInstance().getTime() + ": setContextImpl().finish");
    }

    public void commit() throws GedcomException {
    }

    private void initComponents() {
        this.entityName = new JLabel();
        this.description = new JLabel();
        this.nameLabel = new JLabel();
        this.nameText = new JTextField();
        this.addressLabel = new JLabel();
        this.addressText = new JTextField();
        this.cityText = new JTextField();
        this.countyText = new JTextField();
        this.codetext = new JTextField();
        this.countryText = new JTextField();
        this.textLabel = new JLabel();
        this.scrollPane = new JScrollPane();
        this.textArea = new UndoTextArea();
        this.mediaLabel = new JLabel();
        this.mediaImage = new JLabel();
        this.sourceLabel = new JLabel();
        this.sourceText = new JTextField();
        Mnemonics.setLocalizedText((JLabel)this.entityName, (String)NbBundle.getMessage(BlankPanel.class, (String)"BlankPanel.entityName.text"));
        Mnemonics.setLocalizedText((JLabel)this.description, (String)NbBundle.getMessage(BlankPanel.class, (String)"BlankPanel.description.text"));
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage(BlankPanel.class, (String)"BlankPanel.nameLabel.text"));
        this.nameText.setEditable(false);
        this.nameText.setText(NbBundle.getMessage(BlankPanel.class, (String)"BlankPanel.nameText.text"));
        Mnemonics.setLocalizedText((JLabel)this.addressLabel, (String)NbBundle.getMessage(BlankPanel.class, (String)"BlankPanel.addressLabel.text"));
        this.addressText.setEditable(false);
        this.addressText.setText(NbBundle.getMessage(BlankPanel.class, (String)"BlankPanel.addressText.text"));
        this.cityText.setEditable(false);
        this.cityText.setText(NbBundle.getMessage(BlankPanel.class, (String)"BlankPanel.cityText.text"));
        this.countyText.setEditable(false);
        this.countyText.setText(NbBundle.getMessage(BlankPanel.class, (String)"BlankPanel.countyText.text"));
        this.codetext.setEditable(false);
        this.codetext.setText(NbBundle.getMessage(BlankPanel.class, (String)"BlankPanel.codetext.text"));
        this.countryText.setEditable(false);
        this.countryText.setText(NbBundle.getMessage(BlankPanel.class, (String)"BlankPanel.countryText.text"));
        Mnemonics.setLocalizedText((JLabel)this.textLabel, (String)NbBundle.getMessage(BlankPanel.class, (String)"BlankPanel.textLabel.text"));
        this.textArea.setEditable(false);
        this.textArea.setColumns(20);
        this.textArea.setLineWrap(true);
        this.textArea.setRows(6);
        this.textArea.setWrapStyleWord(true);
        this.scrollPane.setViewportView(this.textArea);
        Mnemonics.setLocalizedText((JLabel)this.mediaLabel, (String)NbBundle.getMessage(BlankPanel.class, (String)"BlankPanel.mediaLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.mediaImage, (String)NbBundle.getMessage(BlankPanel.class, (String)"BlankPanel.mediaImage.text"));
        this.mediaImage.setBorder(BorderFactory.createEtchedBorder());
        this.mediaImage.setPreferredSize(new Dimension(4, 187));
        Mnemonics.setLocalizedText((JLabel)this.sourceLabel, (String)NbBundle.getMessage(BlankPanel.class, (String)"BlankPanel.sourceLabel.text"));
        this.sourceText.setEditable(false);
        this.sourceText.setText(NbBundle.getMessage(BlankPanel.class, (String)"BlankPanel.sourceText.text"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.entityName, -1, -1, Short.MAX_VALUE).addComponent(this.description, -2, 0, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.addressLabel).addComponent(this.nameLabel).addComponent(this.textLabel).addComponent(this.mediaLabel).addComponent(this.sourceLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sourceText).addGroup(layout.createSequentialGroup().addComponent(this.codetext, -2, 87, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.countryText)).addGroup(layout.createSequentialGroup().addComponent(this.cityText).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.countyText)).addComponent(this.nameText).addComponent(this.addressText).addComponent(this.scrollPane).addComponent(this.mediaImage, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.entityName).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.description, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameLabel).addComponent(this.nameText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.addressLabel).addComponent(this.addressText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cityText, -2, -1, -2).addComponent(this.countyText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.codetext, -2, -1, -2).addComponent(this.countryText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane).addGroup(layout.createSequentialGroup().addGap(8, 8, 8).addComponent(this.textLabel))).addGap(6, 6, 6).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mediaImage, -1, -1, Short.MAX_VALUE).addComponent(this.mediaLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.sourceLabel).addComponent(this.sourceText, -2, -1, -2)).addContainerGap()));
    }

    public Entity getEditedEntity() {
        return this.entity;
    }

    private Property getXRefFromEntity(Entity entity, Object o) {
        Entity target = null;
        for (PropertyXRef xref : entity.getProperties(PropertyXRef.class)) {
            target = xref.getTargetEntity().orElse(null);
            if (target == null || !target.getClass().equals(o)) continue;
            return target;
        }
        return null;
    }

    private void displayName(String name) {
        this.nameLabel.setVisible(name != null);
        this.nameText.setVisible(name != null);
        this.nameText.setText(name != null ? name : "");
    }

    private void displayAddress(String str) {
        this.displayAddress(str, null, null, null, null);
    }

    private void displayAddress(String address, String city, String state, String postcode, String country) {
        this.addressLabel.setVisible(address != null);
        this.addressText.setVisible(address != null);
        this.cityText.setVisible(city != null);
        this.countyText.setVisible(state != null);
        this.codetext.setVisible(postcode != null);
        this.countryText.setVisible(country != null);
        this.addressText.setText(address != null ? address : "");
        this.cityText.setText(city != null ? city : "");
        this.countyText.setText(state != null ? state : "");
        this.codetext.setText(postcode != null ? postcode : "");
        this.countryText.setText(country != null ? country : "");
    }

    private void displayNote(Entity entity) {
        AbstractNote note = (AbstractNote)this.getXRefFromEntity(entity, AbstractNote.class);
        String text = "";
        if (note != null) {
            text = note.getValue().trim();
        }
        this.displayNote(text);
    }

    private void displayNote(String text) {
        boolean display = this.entity != null && !text.isEmpty();
        this.textLabel.setVisible(display);
        this.scrollPane.setVisible(display);
        this.textArea.setVisible(display);
        this.textArea.setText(text);
    }

    private void displayMedia(InputSource f) {
        if (f != null) {
            this.mediaImage.setIcon(MediaUtils.getResizedIcon((ImageIcon)new ImageIcon(MediaUtils.getImageFromFile((InputSource)f, ((Object)((Object)this)).getClass(), (BufferedImage)MediaUtils.IMG_INVALID_PHOTO)), (int)238, (int)187));
        }
        this.mediaLabel.setVisible(this.entity != null && f != null);
        this.mediaImage.setVisible(this.entity != null && f != null);
    }

    private void displayMedia(Entity entity) {
        Media media = (Media)this.getXRefFromEntity(entity, Media.class);
        InputSource f = null;
        if (media != null) {
            f = media.getFile();
        }
        this.displayMedia(f);
    }

    private void displaySource(Entity entity) {
        Source source = null;
        if (entity != null) {
            source = (Source)this.getXRefFromEntity(entity, Source.class);
        }
        String title = "";
        if (source != null) {
            title = source.getTitle().trim();
        }
        this.sourceLabel.setText(source != null ? source.getPropertyName() : "Source");
        this.sourceLabel.setVisible(entity != null && !title.isEmpty());
        this.sourceText.setVisible(entity != null && !title.isEmpty());
        this.sourceText.setText(title);
    }

    private void displayRepository(Entity entity) {
        Repository repo = null;
        if (entity != null) {
            repo = (Repository)this.getXRefFromEntity(entity, Repository.class);
        }
        String title = "";
        if (repo != null) {
            title = repo.getRepositoryName().trim();
        }
        this.sourceLabel.setText(repo != null ? repo.getPropertyName() : "Repo");
        this.sourceLabel.setVisible(entity != null && !title.isEmpty());
        this.sourceText.setVisible(entity != null && !title.isEmpty());
        this.sourceText.setText(title);
    }
}

