#!/usr/bin/make -f
# Makefile for WineASIO #
# --------------------- #
# Created by falkTX
# Initially generated by winemaker
#

ifeq ($(ARCH),)
$(error incorrect use of Makefile, ARCH var is missing)
endif
ifeq ($(M),)
$(error incorrect use of Makefile, M var is missing)
endif

wineasio_dll_MODULE   = wineasio$(M).dll

PREFIX = /usr
DLLS   = $(wineasio_dll_MODULE) $(wineasio_dll_MODULE).so

### Tools

CC        = gcc
WINEBUILD = winebuild
WINECC    = winegcc

### Common settings

CEXTRA                = -m$(M) -D_REENTRANT -fPIC -Wall -pipe
CEXTRA               += -fno-strict-aliasing -Wdeclaration-after-statement -Wwrite-strings -Wpointer-arith
CEXTRA               += -Werror=implicit-function-declaration
RCEXTRA               =
INCLUDE_PATH          = -I.

ifeq ($(DEBUG),true)
CEXTRA               += -O0 -DDEBUG -g -D__WINESRC__
else
CEXTRA               += -O2 -DNDEBUG -fvisibility=hidden
endif

ifneq ($(WINEBUILD_INCLUDEDIR),)
INCLUDE_PATH         += -I$(WINEBUILD_INCLUDEDIR)
else
INCLUDE_PATH         += \
			-I$(PREFIX)/include/wine \
			-I$(PREFIX)/include/wine/windows \
			-I$(PREFIX)/include/wine-development \
			-I$(PREFIX)/include/wine-development/wine/windows \
			-I/opt/wine-stable/include \
			-I/opt/wine-stable/include/wine/windows \
			-I/opt/wine-staging/include \
			-I/opt/wine-staging/include/wine/windows
endif

wineasio_dll_C_SRCS   = asio.c \
			jackbridge.c \
			main.c \
			regsvr.c
wineasio_dll_LDFLAGS  = -shared \
			-m$(M) \
			wineasio.dll.spec

ifneq ($(WINEBUILD_LIBDIR),)
wineasio_dll_LDFLAGS += -L$(WINEBUILD_LIBDIR)
else
wineasio_dll_LDFLAGS += \
			-L/usr/lib$(M)/wine \
			-L/usr/lib/wine \
			-L/usr/lib/$(ARCH)-linux-gnu/wine \
			-L/usr/lib/$(ARCH)-linux-gnu/wine-development \
			-L/opt/wine-stable/lib \
			-L/opt/wine-stable/lib/wine \
			-L/opt/wine-stable/lib$(M) \
			-L/opt/wine-stable/lib$(M)/wine \
			-L/opt/wine-staging/lib \
			-L/opt/wine-staging/lib/wine \
			-L/opt/wine-staging/lib$(M) \
			-L/opt/wine-staging/lib$(M)/wine
endif

wineasio_dll_OBJS     = $(wineasio_dll_C_SRCS:%.c=build$(M)/%.c.o)

### Generic targets

all:
build: $(DLLS:%=build$(M)/%)

### Build rules

.PHONY: all

# Implicit rules

build$(M)/%.c.o: %.c
	@$(shell mkdir -p build$(M))
	$(CC) -c $(INCLUDE_PATH) $(CFLAGS) $(CEXTRA) -o $@ $<

### Target specific build rules

build$(M)/$(wineasio_dll_MODULE): $(wineasio_dll_OBJS)
	$(WINEBUILD) -m$(M) --dll --fake-module -E wineasio.dll.spec $^ -o $@

build$(M)/$(wineasio_dll_MODULE).so: $(wineasio_dll_OBJS)
	$(WINECC) $^ $(wineasio_dll_LDFLAGS) \
		-lodbc32 -lole32 -luuid -lwinmm -o $@
