// ----------------------------------------------------------------------------
//
//     ***     AUTO GENERATED CODE    ***    Type: MMv1     ***
//
// ----------------------------------------------------------------------------
//
//     This file is automatically generated by Magic Modules and manual
//     changes will be clobbered when the file is regenerated.
//
//     Please read more about how to change this file in
//     .github/CONTRIBUTING.md.
//
// ----------------------------------------------------------------------------

package google

import (
	"fmt"
	"log"
	"reflect"
	"strings"
	"time"

	"github.com/hashicorp/terraform-plugin-sdk/v2/helper/schema"
)

func resourceDatastreamConnectionProfile() *schema.Resource {
	return &schema.Resource{
		Create: resourceDatastreamConnectionProfileCreate,
		Read:   resourceDatastreamConnectionProfileRead,
		Update: resourceDatastreamConnectionProfileUpdate,
		Delete: resourceDatastreamConnectionProfileDelete,

		Importer: &schema.ResourceImporter{
			State: resourceDatastreamConnectionProfileImport,
		},

		Timeouts: &schema.ResourceTimeout{
			Create: schema.DefaultTimeout(20 * time.Minute),
			Update: schema.DefaultTimeout(20 * time.Minute),
			Delete: schema.DefaultTimeout(20 * time.Minute),
		},

		Schema: map[string]*schema.Schema{
			"connection_profile_id": {
				Type:        schema.TypeString,
				Required:    true,
				ForceNew:    true,
				Description: `The connection profile identifier.`,
			},
			"display_name": {
				Type:        schema.TypeString,
				Required:    true,
				Description: `Display name.`,
			},
			"location": {
				Type:        schema.TypeString,
				Required:    true,
				ForceNew:    true,
				Description: `The name of the location this repository is located in.`,
			},
			"forward_ssh_connectivity": {
				Type:        schema.TypeList,
				Optional:    true,
				Description: `Forward SSH tunnel connectivity.`,
				MaxItems:    1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"hostname": {
							Type:        schema.TypeString,
							Required:    true,
							Description: `Hostname for the SSH tunnel.`,
						},
						"username": {
							Type:        schema.TypeString,
							Required:    true,
							Description: `Username for the SSH tunnel.`,
						},
						"password": {
							Type:          schema.TypeString,
							Optional:      true,
							ForceNew:      true,
							Description:   `SSH password.`,
							Sensitive:     true,
							ConflictsWith: []string{},
						},
						"port": {
							Type:        schema.TypeInt,
							Optional:    true,
							Description: `Port for the SSH tunnel.`,
							Default:     22,
						},
						"private_key": {
							Type:          schema.TypeString,
							Optional:      true,
							ForceNew:      true,
							Description:   `SSH private key.`,
							Sensitive:     true,
							ConflictsWith: []string{},
						},
					},
				},
			},
			"gcs_profile": {
				Type:        schema.TypeList,
				Optional:    true,
				Description: `Cloud Storage bucket profile.`,
				MaxItems:    1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"bucket": {
							Type:        schema.TypeString,
							Required:    true,
							Description: `The Cloud Storage bucket name.`,
						},
						"root_path": {
							Type:        schema.TypeString,
							Optional:    true,
							Description: `The root path inside the Cloud Storage bucket.`,
						},
					},
				},
				ExactlyOneOf: []string{"oracle_profile", "gcs_profile", "mysql_profile", "postgresql_profile"},
			},
			"labels": {
				Type:        schema.TypeMap,
				Optional:    true,
				Description: `Labels.`,
				Elem:        &schema.Schema{Type: schema.TypeString},
			},
			"mysql_profile": {
				Type:        schema.TypeList,
				Optional:    true,
				Description: `MySQL database profile.`,
				MaxItems:    1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"hostname": {
							Type:        schema.TypeString,
							Required:    true,
							Description: `Hostname for the MySQL connection.`,
						},
						"password": {
							Type:        schema.TypeString,
							Required:    true,
							ForceNew:    true,
							Description: `Password for the MySQL connection.`,
							Sensitive:   true,
						},
						"username": {
							Type:        schema.TypeString,
							Required:    true,
							Description: `Username for the MySQL connection.`,
						},
						"port": {
							Type:        schema.TypeInt,
							Optional:    true,
							Description: `Port for the MySQL connection.`,
							Default:     3306,
						},
						"ssl_config": {
							Type:        schema.TypeList,
							Optional:    true,
							Description: `SSL configuration for the MySQL connection.`,
							MaxItems:    1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"ca_certificate": {
										Type:     schema.TypeString,
										Optional: true,
										ForceNew: true,
										Description: `PEM-encoded certificate of the CA that signed the source database
server's certificate.`,
										Sensitive: true,
									},
									"client_certificate": {
										Type:     schema.TypeString,
										Optional: true,
										ForceNew: true,
										Description: `PEM-encoded certificate that will be used by the replica to
authenticate against the source database server. If this field
is used then the 'clientKey' and the 'caCertificate' fields are
mandatory.`,
										Sensitive: true,
									},
									"client_key": {
										Type:     schema.TypeString,
										Optional: true,
										ForceNew: true,
										Description: `PEM-encoded private key associated with the Client Certificate.
If this field is used then the 'client_certificate' and the
'ca_certificate' fields are mandatory.`,
										Sensitive: true,
									},
									"ca_certificate_set": {
										Type:        schema.TypeBool,
										Computed:    true,
										Description: `Indicates whether the clientKey field is set.`,
									},
									"client_certificate_set": {
										Type:        schema.TypeBool,
										Computed:    true,
										Description: `Indicates whether the clientCertificate field is set.`,
									},
									"client_key_set": {
										Type:        schema.TypeBool,
										Computed:    true,
										Description: `Indicates whether the clientKey field is set.`,
									},
								},
							},
						},
					},
				},
				ExactlyOneOf: []string{"oracle_profile", "gcs_profile", "mysql_profile", "postgresql_profile"},
			},
			"oracle_profile": {
				Type:        schema.TypeList,
				Optional:    true,
				Description: `Oracle database profile.`,
				MaxItems:    1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"database_service": {
							Type:        schema.TypeString,
							Required:    true,
							Description: `Database for the Oracle connection.`,
						},
						"hostname": {
							Type:        schema.TypeString,
							Required:    true,
							Description: `Hostname for the Oracle connection.`,
						},
						"password": {
							Type:        schema.TypeString,
							Required:    true,
							Description: `Password for the Oracle connection.`,
							Sensitive:   true,
						},
						"username": {
							Type:        schema.TypeString,
							Required:    true,
							Description: `Username for the Oracle connection.`,
						},
						"connection_attributes": {
							Type:        schema.TypeMap,
							Optional:    true,
							Description: `Connection string attributes`,
							Elem:        &schema.Schema{Type: schema.TypeString},
						},
						"port": {
							Type:        schema.TypeInt,
							Optional:    true,
							Description: `Port for the Oracle connection.`,
							Default:     1521,
						},
					},
				},
				ExactlyOneOf: []string{"oracle_profile", "gcs_profile", "mysql_profile", "postgresql_profile"},
			},
			"postgresql_profile": {
				Type:        schema.TypeList,
				Optional:    true,
				Description: `PostgreSQL database profile.`,
				MaxItems:    1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"database": {
							Type:        schema.TypeString,
							Required:    true,
							Description: `Database for the PostgreSQL connection.`,
						},
						"hostname": {
							Type:        schema.TypeString,
							Required:    true,
							Description: `Hostname for the PostgreSQL connection.`,
						},
						"password": {
							Type:        schema.TypeString,
							Required:    true,
							Description: `Password for the PostgreSQL connection.`,
							Sensitive:   true,
						},
						"username": {
							Type:        schema.TypeString,
							Required:    true,
							Description: `Username for the PostgreSQL connection.`,
						},
						"port": {
							Type:        schema.TypeInt,
							Optional:    true,
							Description: `Port for the PostgreSQL connection.`,
							Default:     5432,
						},
					},
				},
				ExactlyOneOf: []string{"oracle_profile", "gcs_profile", "mysql_profile", "postgresql_profile"},
			},
			"name": {
				Type:        schema.TypeString,
				Computed:    true,
				Description: `The resource's name.`,
			},
			"project": {
				Type:     schema.TypeString,
				Optional: true,
				Computed: true,
				ForceNew: true,
			},
		},
		UseJSONNumber: true,
	}
}

func resourceDatastreamConnectionProfileCreate(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)
	userAgent, err := generateUserAgentString(d, config.userAgent)
	if err != nil {
		return err
	}

	obj := make(map[string]interface{})
	labelsProp, err := expandDatastreamConnectionProfileLabels(d.Get("labels"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("labels"); !isEmptyValue(reflect.ValueOf(labelsProp)) && (ok || !reflect.DeepEqual(v, labelsProp)) {
		obj["labels"] = labelsProp
	}
	displayNameProp, err := expandDatastreamConnectionProfileDisplayName(d.Get("display_name"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("display_name"); !isEmptyValue(reflect.ValueOf(displayNameProp)) && (ok || !reflect.DeepEqual(v, displayNameProp)) {
		obj["displayName"] = displayNameProp
	}
	oracleProfileProp, err := expandDatastreamConnectionProfileOracleProfile(d.Get("oracle_profile"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("oracle_profile"); !isEmptyValue(reflect.ValueOf(oracleProfileProp)) && (ok || !reflect.DeepEqual(v, oracleProfileProp)) {
		obj["oracleProfile"] = oracleProfileProp
	}
	gcsProfileProp, err := expandDatastreamConnectionProfileGcsProfile(d.Get("gcs_profile"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("gcs_profile"); !isEmptyValue(reflect.ValueOf(gcsProfileProp)) && (ok || !reflect.DeepEqual(v, gcsProfileProp)) {
		obj["gcsProfile"] = gcsProfileProp
	}
	mysqlProfileProp, err := expandDatastreamConnectionProfileMysqlProfile(d.Get("mysql_profile"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("mysql_profile"); !isEmptyValue(reflect.ValueOf(mysqlProfileProp)) && (ok || !reflect.DeepEqual(v, mysqlProfileProp)) {
		obj["mysqlProfile"] = mysqlProfileProp
	}
	postgresqlProfileProp, err := expandDatastreamConnectionProfilePostgresqlProfile(d.Get("postgresql_profile"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("postgresql_profile"); !isEmptyValue(reflect.ValueOf(postgresqlProfileProp)) && (ok || !reflect.DeepEqual(v, postgresqlProfileProp)) {
		obj["postgresqlProfile"] = postgresqlProfileProp
	}
	forwardSshConnectivityProp, err := expandDatastreamConnectionProfileForwardSshConnectivity(d.Get("forward_ssh_connectivity"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("forward_ssh_connectivity"); !isEmptyValue(reflect.ValueOf(forwardSshConnectivityProp)) && (ok || !reflect.DeepEqual(v, forwardSshConnectivityProp)) {
		obj["forwardSshConnectivity"] = forwardSshConnectivityProp
	}

	url, err := replaceVars(d, config, "{{DatastreamBasePath}}projects/{{project}}/locations/{{location}}/connectionProfiles?connectionProfileId={{connection_profile_id}}")
	if err != nil {
		return err
	}

	log.Printf("[DEBUG] Creating new ConnectionProfile: %#v", obj)
	billingProject := ""

	project, err := getProject(d, config)
	if err != nil {
		return fmt.Errorf("Error fetching project for ConnectionProfile: %s", err)
	}
	billingProject = project

	// err == nil indicates that the billing_project value was found
	if bp, err := getBillingProject(d, config); err == nil {
		billingProject = bp
	}

	res, err := sendRequestWithTimeout(config, "POST", billingProject, url, userAgent, obj, d.Timeout(schema.TimeoutCreate))
	if err != nil {
		return fmt.Errorf("Error creating ConnectionProfile: %s", err)
	}

	// Store the ID now
	id, err := replaceVars(d, config, "projects/{{project}}/locations/{{location}}/connectionProfiles/{{connection_profile_id}}")
	if err != nil {
		return fmt.Errorf("Error constructing id: %s", err)
	}
	d.SetId(id)

	// Use the resource in the operation response to populate
	// identity fields and d.Id() before read
	var opRes map[string]interface{}
	err = datastreamOperationWaitTimeWithResponse(
		config, res, &opRes, project, "Creating ConnectionProfile", userAgent,
		d.Timeout(schema.TimeoutCreate))
	if err != nil {
		// The resource didn't actually create
		d.SetId("")
		return fmt.Errorf("Error waiting to create ConnectionProfile: %s", err)
	}

	if err := d.Set("name", flattenDatastreamConnectionProfileName(opRes["name"], d, config)); err != nil {
		return err
	}

	// This may have caused the ID to update - update it if so.
	id, err = replaceVars(d, config, "projects/{{project}}/locations/{{location}}/connectionProfiles/{{connection_profile_id}}")
	if err != nil {
		return fmt.Errorf("Error constructing id: %s", err)
	}
	d.SetId(id)

	log.Printf("[DEBUG] Finished creating ConnectionProfile %q: %#v", d.Id(), res)

	return resourceDatastreamConnectionProfileRead(d, meta)
}

func resourceDatastreamConnectionProfileRead(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)
	userAgent, err := generateUserAgentString(d, config.userAgent)
	if err != nil {
		return err
	}

	url, err := replaceVars(d, config, "{{DatastreamBasePath}}projects/{{project}}/locations/{{location}}/connectionProfiles/{{connection_profile_id}}")
	if err != nil {
		return err
	}

	billingProject := ""

	project, err := getProject(d, config)
	if err != nil {
		return fmt.Errorf("Error fetching project for ConnectionProfile: %s", err)
	}
	billingProject = project

	// err == nil indicates that the billing_project value was found
	if bp, err := getBillingProject(d, config); err == nil {
		billingProject = bp
	}

	res, err := sendRequest(config, "GET", billingProject, url, userAgent, nil)
	if err != nil {
		return handleNotFoundError(err, d, fmt.Sprintf("DatastreamConnectionProfile %q", d.Id()))
	}

	if err := d.Set("project", project); err != nil {
		return fmt.Errorf("Error reading ConnectionProfile: %s", err)
	}

	if err := d.Set("name", flattenDatastreamConnectionProfileName(res["name"], d, config)); err != nil {
		return fmt.Errorf("Error reading ConnectionProfile: %s", err)
	}
	if err := d.Set("labels", flattenDatastreamConnectionProfileLabels(res["labels"], d, config)); err != nil {
		return fmt.Errorf("Error reading ConnectionProfile: %s", err)
	}
	if err := d.Set("display_name", flattenDatastreamConnectionProfileDisplayName(res["displayName"], d, config)); err != nil {
		return fmt.Errorf("Error reading ConnectionProfile: %s", err)
	}
	if err := d.Set("oracle_profile", flattenDatastreamConnectionProfileOracleProfile(res["oracleProfile"], d, config)); err != nil {
		return fmt.Errorf("Error reading ConnectionProfile: %s", err)
	}
	if err := d.Set("gcs_profile", flattenDatastreamConnectionProfileGcsProfile(res["gcsProfile"], d, config)); err != nil {
		return fmt.Errorf("Error reading ConnectionProfile: %s", err)
	}
	if err := d.Set("mysql_profile", flattenDatastreamConnectionProfileMysqlProfile(res["mysqlProfile"], d, config)); err != nil {
		return fmt.Errorf("Error reading ConnectionProfile: %s", err)
	}
	if err := d.Set("postgresql_profile", flattenDatastreamConnectionProfilePostgresqlProfile(res["postgresqlProfile"], d, config)); err != nil {
		return fmt.Errorf("Error reading ConnectionProfile: %s", err)
	}
	if err := d.Set("forward_ssh_connectivity", flattenDatastreamConnectionProfileForwardSshConnectivity(res["forwardSshConnectivity"], d, config)); err != nil {
		return fmt.Errorf("Error reading ConnectionProfile: %s", err)
	}

	return nil
}

func resourceDatastreamConnectionProfileUpdate(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)
	userAgent, err := generateUserAgentString(d, config.userAgent)
	if err != nil {
		return err
	}

	billingProject := ""

	project, err := getProject(d, config)
	if err != nil {
		return fmt.Errorf("Error fetching project for ConnectionProfile: %s", err)
	}
	billingProject = project

	obj := make(map[string]interface{})
	labelsProp, err := expandDatastreamConnectionProfileLabels(d.Get("labels"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("labels"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, labelsProp)) {
		obj["labels"] = labelsProp
	}
	displayNameProp, err := expandDatastreamConnectionProfileDisplayName(d.Get("display_name"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("display_name"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, displayNameProp)) {
		obj["displayName"] = displayNameProp
	}
	oracleProfileProp, err := expandDatastreamConnectionProfileOracleProfile(d.Get("oracle_profile"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("oracle_profile"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, oracleProfileProp)) {
		obj["oracleProfile"] = oracleProfileProp
	}
	gcsProfileProp, err := expandDatastreamConnectionProfileGcsProfile(d.Get("gcs_profile"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("gcs_profile"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, gcsProfileProp)) {
		obj["gcsProfile"] = gcsProfileProp
	}
	mysqlProfileProp, err := expandDatastreamConnectionProfileMysqlProfile(d.Get("mysql_profile"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("mysql_profile"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, mysqlProfileProp)) {
		obj["mysqlProfile"] = mysqlProfileProp
	}
	postgresqlProfileProp, err := expandDatastreamConnectionProfilePostgresqlProfile(d.Get("postgresql_profile"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("postgresql_profile"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, postgresqlProfileProp)) {
		obj["postgresqlProfile"] = postgresqlProfileProp
	}
	forwardSshConnectivityProp, err := expandDatastreamConnectionProfileForwardSshConnectivity(d.Get("forward_ssh_connectivity"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("forward_ssh_connectivity"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, forwardSshConnectivityProp)) {
		obj["forwardSshConnectivity"] = forwardSshConnectivityProp
	}

	url, err := replaceVars(d, config, "{{DatastreamBasePath}}projects/{{project}}/locations/{{location}}/connectionProfiles/{{connection_profile_id}}")
	if err != nil {
		return err
	}

	log.Printf("[DEBUG] Updating ConnectionProfile %q: %#v", d.Id(), obj)
	updateMask := []string{}

	if d.HasChange("labels") {
		updateMask = append(updateMask, "labels")
	}

	if d.HasChange("display_name") {
		updateMask = append(updateMask, "displayName")
	}

	if d.HasChange("oracle_profile") {
		updateMask = append(updateMask, "oracleProfile")
	}

	if d.HasChange("gcs_profile") {
		updateMask = append(updateMask, "gcsProfile")
	}

	if d.HasChange("mysql_profile") {
		updateMask = append(updateMask, "mysqlProfile")
	}

	if d.HasChange("postgresql_profile") {
		updateMask = append(updateMask, "postgresqlProfile")
	}

	if d.HasChange("forward_ssh_connectivity") {
		updateMask = append(updateMask, "forwardSshConnectivity")
	}
	// updateMask is a URL parameter but not present in the schema, so replaceVars
	// won't set it
	url, err = addQueryParams(url, map[string]string{"updateMask": strings.Join(updateMask, ",")})
	if err != nil {
		return err
	}

	// err == nil indicates that the billing_project value was found
	if bp, err := getBillingProject(d, config); err == nil {
		billingProject = bp
	}

	res, err := sendRequestWithTimeout(config, "PATCH", billingProject, url, userAgent, obj, d.Timeout(schema.TimeoutUpdate))

	if err != nil {
		return fmt.Errorf("Error updating ConnectionProfile %q: %s", d.Id(), err)
	} else {
		log.Printf("[DEBUG] Finished updating ConnectionProfile %q: %#v", d.Id(), res)
	}

	err = datastreamOperationWaitTime(
		config, res, project, "Updating ConnectionProfile", userAgent,
		d.Timeout(schema.TimeoutUpdate))

	if err != nil {
		return err
	}

	return resourceDatastreamConnectionProfileRead(d, meta)
}

func resourceDatastreamConnectionProfileDelete(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)
	userAgent, err := generateUserAgentString(d, config.userAgent)
	if err != nil {
		return err
	}

	billingProject := ""

	project, err := getProject(d, config)
	if err != nil {
		return fmt.Errorf("Error fetching project for ConnectionProfile: %s", err)
	}
	billingProject = project

	url, err := replaceVars(d, config, "{{DatastreamBasePath}}projects/{{project}}/locations/{{location}}/connectionProfiles/{{connection_profile_id}}")
	if err != nil {
		return err
	}

	var obj map[string]interface{}
	log.Printf("[DEBUG] Deleting ConnectionProfile %q", d.Id())

	// err == nil indicates that the billing_project value was found
	if bp, err := getBillingProject(d, config); err == nil {
		billingProject = bp
	}

	res, err := sendRequestWithTimeout(config, "DELETE", billingProject, url, userAgent, obj, d.Timeout(schema.TimeoutDelete))
	if err != nil {
		return handleNotFoundError(err, d, "ConnectionProfile")
	}

	err = datastreamOperationWaitTime(
		config, res, project, "Deleting ConnectionProfile", userAgent,
		d.Timeout(schema.TimeoutDelete))

	if err != nil {
		return err
	}

	log.Printf("[DEBUG] Finished deleting ConnectionProfile %q: %#v", d.Id(), res)
	return nil
}

func resourceDatastreamConnectionProfileImport(d *schema.ResourceData, meta interface{}) ([]*schema.ResourceData, error) {
	config := meta.(*Config)
	if err := parseImportId([]string{
		"projects/(?P<project>[^/]+)/locations/(?P<location>[^/]+)/connectionProfiles/(?P<connection_profile_id>[^/]+)",
		"(?P<project>[^/]+)/(?P<location>[^/]+)/(?P<connection_profile_id>[^/]+)",
		"(?P<location>[^/]+)/(?P<connection_profile_id>[^/]+)",
	}, d, config); err != nil {
		return nil, err
	}

	// Replace import id for the resource id
	id, err := replaceVars(d, config, "projects/{{project}}/locations/{{location}}/connectionProfiles/{{connection_profile_id}}")
	if err != nil {
		return nil, fmt.Errorf("Error constructing id: %s", err)
	}
	d.SetId(id)

	return []*schema.ResourceData{d}, nil
}

func flattenDatastreamConnectionProfileName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDatastreamConnectionProfileLabels(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDatastreamConnectionProfileDisplayName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDatastreamConnectionProfileOracleProfile(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["hostname"] =
		flattenDatastreamConnectionProfileOracleProfileHostname(original["hostname"], d, config)
	transformed["port"] =
		flattenDatastreamConnectionProfileOracleProfilePort(original["port"], d, config)
	transformed["username"] =
		flattenDatastreamConnectionProfileOracleProfileUsername(original["username"], d, config)
	transformed["password"] =
		flattenDatastreamConnectionProfileOracleProfilePassword(original["password"], d, config)
	transformed["database_service"] =
		flattenDatastreamConnectionProfileOracleProfileDatabaseService(original["databaseService"], d, config)
	transformed["connection_attributes"] =
		flattenDatastreamConnectionProfileOracleProfileConnectionAttributes(original["connectionAttributes"], d, config)
	return []interface{}{transformed}
}
func flattenDatastreamConnectionProfileOracleProfileHostname(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDatastreamConnectionProfileOracleProfilePort(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	// Handles the string fixed64 format
	if strVal, ok := v.(string); ok {
		if intVal, err := stringToFixed64(strVal); err == nil {
			return intVal
		}
	}

	// number values are represented as float64
	if floatVal, ok := v.(float64); ok {
		intVal := int(floatVal)
		return intVal
	}

	return v // let terraform core handle it otherwise
}

func flattenDatastreamConnectionProfileOracleProfileUsername(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDatastreamConnectionProfileOracleProfilePassword(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return d.Get("oracle_profile.0.password")
}

func flattenDatastreamConnectionProfileOracleProfileDatabaseService(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDatastreamConnectionProfileOracleProfileConnectionAttributes(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDatastreamConnectionProfileGcsProfile(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["bucket"] =
		flattenDatastreamConnectionProfileGcsProfileBucket(original["bucket"], d, config)
	transformed["root_path"] =
		flattenDatastreamConnectionProfileGcsProfileRootPath(original["rootPath"], d, config)
	return []interface{}{transformed}
}
func flattenDatastreamConnectionProfileGcsProfileBucket(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDatastreamConnectionProfileGcsProfileRootPath(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDatastreamConnectionProfileMysqlProfile(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["hostname"] =
		flattenDatastreamConnectionProfileMysqlProfileHostname(original["hostname"], d, config)
	transformed["port"] =
		flattenDatastreamConnectionProfileMysqlProfilePort(original["port"], d, config)
	transformed["username"] =
		flattenDatastreamConnectionProfileMysqlProfileUsername(original["username"], d, config)
	transformed["password"] =
		flattenDatastreamConnectionProfileMysqlProfilePassword(original["password"], d, config)
	transformed["ssl_config"] =
		flattenDatastreamConnectionProfileMysqlProfileSslConfig(original["sslConfig"], d, config)
	return []interface{}{transformed}
}
func flattenDatastreamConnectionProfileMysqlProfileHostname(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDatastreamConnectionProfileMysqlProfilePort(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	// Handles the string fixed64 format
	if strVal, ok := v.(string); ok {
		if intVal, err := stringToFixed64(strVal); err == nil {
			return intVal
		}
	}

	// number values are represented as float64
	if floatVal, ok := v.(float64); ok {
		intVal := int(floatVal)
		return intVal
	}

	return v // let terraform core handle it otherwise
}

func flattenDatastreamConnectionProfileMysqlProfileUsername(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDatastreamConnectionProfileMysqlProfilePassword(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return d.Get("mysql_profile.0.password")
}

func flattenDatastreamConnectionProfileMysqlProfileSslConfig(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["client_key"] =
		flattenDatastreamConnectionProfileMysqlProfileSslConfigClientKey(original["clientKey"], d, config)
	transformed["client_key_set"] =
		flattenDatastreamConnectionProfileMysqlProfileSslConfigClientKeySet(original["clientKeySet"], d, config)
	transformed["client_certificate"] =
		flattenDatastreamConnectionProfileMysqlProfileSslConfigClientCertificate(original["clientCertificate"], d, config)
	transformed["client_certificate_set"] =
		flattenDatastreamConnectionProfileMysqlProfileSslConfigClientCertificateSet(original["clientCertificateSet"], d, config)
	transformed["ca_certificate"] =
		flattenDatastreamConnectionProfileMysqlProfileSslConfigCaCertificate(original["caCertificate"], d, config)
	transformed["ca_certificate_set"] =
		flattenDatastreamConnectionProfileMysqlProfileSslConfigCaCertificateSet(original["caCertificateSet"], d, config)
	return []interface{}{transformed}
}

func flattenDatastreamConnectionProfileMysqlProfileSslConfigClientKey(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return d.Get("mysql_profile.0.ssl_config.0.client_key")
}

func flattenDatastreamConnectionProfileMysqlProfileSslConfigClientKeySet(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDatastreamConnectionProfileMysqlProfileSslConfigClientCertificate(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return d.Get("mysql_profile.0.ssl_config.0.client_certificate")
}

func flattenDatastreamConnectionProfileMysqlProfileSslConfigClientCertificateSet(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDatastreamConnectionProfileMysqlProfileSslConfigCaCertificate(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return d.Get("mysql_profile.0.ssl_config.0.ca_certificate")
}

func flattenDatastreamConnectionProfileMysqlProfileSslConfigCaCertificateSet(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDatastreamConnectionProfilePostgresqlProfile(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["hostname"] =
		flattenDatastreamConnectionProfilePostgresqlProfileHostname(original["hostname"], d, config)
	transformed["port"] =
		flattenDatastreamConnectionProfilePostgresqlProfilePort(original["port"], d, config)
	transformed["username"] =
		flattenDatastreamConnectionProfilePostgresqlProfileUsername(original["username"], d, config)
	transformed["password"] =
		flattenDatastreamConnectionProfilePostgresqlProfilePassword(original["password"], d, config)
	transformed["database"] =
		flattenDatastreamConnectionProfilePostgresqlProfileDatabase(original["database"], d, config)
	return []interface{}{transformed}
}
func flattenDatastreamConnectionProfilePostgresqlProfileHostname(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDatastreamConnectionProfilePostgresqlProfilePort(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	// Handles the string fixed64 format
	if strVal, ok := v.(string); ok {
		if intVal, err := stringToFixed64(strVal); err == nil {
			return intVal
		}
	}

	// number values are represented as float64
	if floatVal, ok := v.(float64); ok {
		intVal := int(floatVal)
		return intVal
	}

	return v // let terraform core handle it otherwise
}

func flattenDatastreamConnectionProfilePostgresqlProfileUsername(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDatastreamConnectionProfilePostgresqlProfilePassword(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return d.Get("postgresql_profile.0.password")
}

func flattenDatastreamConnectionProfilePostgresqlProfileDatabase(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDatastreamConnectionProfileForwardSshConnectivity(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["hostname"] =
		flattenDatastreamConnectionProfileForwardSshConnectivityHostname(original["hostname"], d, config)
	transformed["username"] =
		flattenDatastreamConnectionProfileForwardSshConnectivityUsername(original["username"], d, config)
	transformed["port"] =
		flattenDatastreamConnectionProfileForwardSshConnectivityPort(original["port"], d, config)
	transformed["password"] =
		flattenDatastreamConnectionProfileForwardSshConnectivityPassword(original["password"], d, config)
	transformed["private_key"] =
		flattenDatastreamConnectionProfileForwardSshConnectivityPrivateKey(original["privateKey"], d, config)
	return []interface{}{transformed}
}
func flattenDatastreamConnectionProfileForwardSshConnectivityHostname(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDatastreamConnectionProfileForwardSshConnectivityUsername(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenDatastreamConnectionProfileForwardSshConnectivityPort(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	// Handles the string fixed64 format
	if strVal, ok := v.(string); ok {
		if intVal, err := stringToFixed64(strVal); err == nil {
			return intVal
		}
	}

	// number values are represented as float64
	if floatVal, ok := v.(float64); ok {
		intVal := int(floatVal)
		return intVal
	}

	return v // let terraform core handle it otherwise
}

func flattenDatastreamConnectionProfileForwardSshConnectivityPassword(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return d.Get("forward_ssh_connectivity.0.password")
}

func flattenDatastreamConnectionProfileForwardSshConnectivityPrivateKey(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return d.Get("forward_ssh_connectivity.0.private_key")
}

func expandDatastreamConnectionProfileLabels(v interface{}, d TerraformResourceData, config *Config) (map[string]string, error) {
	if v == nil {
		return map[string]string{}, nil
	}
	m := make(map[string]string)
	for k, val := range v.(map[string]interface{}) {
		m[k] = val.(string)
	}
	return m, nil
}

func expandDatastreamConnectionProfileDisplayName(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDatastreamConnectionProfileOracleProfile(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedHostname, err := expandDatastreamConnectionProfileOracleProfileHostname(original["hostname"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedHostname); val.IsValid() && !isEmptyValue(val) {
		transformed["hostname"] = transformedHostname
	}

	transformedPort, err := expandDatastreamConnectionProfileOracleProfilePort(original["port"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedPort); val.IsValid() && !isEmptyValue(val) {
		transformed["port"] = transformedPort
	}

	transformedUsername, err := expandDatastreamConnectionProfileOracleProfileUsername(original["username"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedUsername); val.IsValid() && !isEmptyValue(val) {
		transformed["username"] = transformedUsername
	}

	transformedPassword, err := expandDatastreamConnectionProfileOracleProfilePassword(original["password"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedPassword); val.IsValid() && !isEmptyValue(val) {
		transformed["password"] = transformedPassword
	}

	transformedDatabaseService, err := expandDatastreamConnectionProfileOracleProfileDatabaseService(original["database_service"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedDatabaseService); val.IsValid() && !isEmptyValue(val) {
		transformed["databaseService"] = transformedDatabaseService
	}

	transformedConnectionAttributes, err := expandDatastreamConnectionProfileOracleProfileConnectionAttributes(original["connection_attributes"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedConnectionAttributes); val.IsValid() && !isEmptyValue(val) {
		transformed["connectionAttributes"] = transformedConnectionAttributes
	}

	return transformed, nil
}

func expandDatastreamConnectionProfileOracleProfileHostname(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDatastreamConnectionProfileOracleProfilePort(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDatastreamConnectionProfileOracleProfileUsername(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDatastreamConnectionProfileOracleProfilePassword(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDatastreamConnectionProfileOracleProfileDatabaseService(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDatastreamConnectionProfileOracleProfileConnectionAttributes(v interface{}, d TerraformResourceData, config *Config) (map[string]string, error) {
	if v == nil {
		return map[string]string{}, nil
	}
	m := make(map[string]string)
	for k, val := range v.(map[string]interface{}) {
		m[k] = val.(string)
	}
	return m, nil
}

func expandDatastreamConnectionProfileGcsProfile(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedBucket, err := expandDatastreamConnectionProfileGcsProfileBucket(original["bucket"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedBucket); val.IsValid() && !isEmptyValue(val) {
		transformed["bucket"] = transformedBucket
	}

	transformedRootPath, err := expandDatastreamConnectionProfileGcsProfileRootPath(original["root_path"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedRootPath); val.IsValid() && !isEmptyValue(val) {
		transformed["rootPath"] = transformedRootPath
	}

	return transformed, nil
}

func expandDatastreamConnectionProfileGcsProfileBucket(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDatastreamConnectionProfileGcsProfileRootPath(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDatastreamConnectionProfileMysqlProfile(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedHostname, err := expandDatastreamConnectionProfileMysqlProfileHostname(original["hostname"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedHostname); val.IsValid() && !isEmptyValue(val) {
		transformed["hostname"] = transformedHostname
	}

	transformedPort, err := expandDatastreamConnectionProfileMysqlProfilePort(original["port"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedPort); val.IsValid() && !isEmptyValue(val) {
		transformed["port"] = transformedPort
	}

	transformedUsername, err := expandDatastreamConnectionProfileMysqlProfileUsername(original["username"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedUsername); val.IsValid() && !isEmptyValue(val) {
		transformed["username"] = transformedUsername
	}

	transformedPassword, err := expandDatastreamConnectionProfileMysqlProfilePassword(original["password"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedPassword); val.IsValid() && !isEmptyValue(val) {
		transformed["password"] = transformedPassword
	}

	transformedSslConfig, err := expandDatastreamConnectionProfileMysqlProfileSslConfig(original["ssl_config"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedSslConfig); val.IsValid() && !isEmptyValue(val) {
		transformed["sslConfig"] = transformedSslConfig
	}

	return transformed, nil
}

func expandDatastreamConnectionProfileMysqlProfileHostname(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDatastreamConnectionProfileMysqlProfilePort(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDatastreamConnectionProfileMysqlProfileUsername(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDatastreamConnectionProfileMysqlProfilePassword(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDatastreamConnectionProfileMysqlProfileSslConfig(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedClientKey, err := expandDatastreamConnectionProfileMysqlProfileSslConfigClientKey(original["client_key"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedClientKey); val.IsValid() && !isEmptyValue(val) {
		transformed["clientKey"] = transformedClientKey
	}

	transformedClientKeySet, err := expandDatastreamConnectionProfileMysqlProfileSslConfigClientKeySet(original["client_key_set"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedClientKeySet); val.IsValid() && !isEmptyValue(val) {
		transformed["clientKeySet"] = transformedClientKeySet
	}

	transformedClientCertificate, err := expandDatastreamConnectionProfileMysqlProfileSslConfigClientCertificate(original["client_certificate"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedClientCertificate); val.IsValid() && !isEmptyValue(val) {
		transformed["clientCertificate"] = transformedClientCertificate
	}

	transformedClientCertificateSet, err := expandDatastreamConnectionProfileMysqlProfileSslConfigClientCertificateSet(original["client_certificate_set"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedClientCertificateSet); val.IsValid() && !isEmptyValue(val) {
		transformed["clientCertificateSet"] = transformedClientCertificateSet
	}

	transformedCaCertificate, err := expandDatastreamConnectionProfileMysqlProfileSslConfigCaCertificate(original["ca_certificate"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedCaCertificate); val.IsValid() && !isEmptyValue(val) {
		transformed["caCertificate"] = transformedCaCertificate
	}

	transformedCaCertificateSet, err := expandDatastreamConnectionProfileMysqlProfileSslConfigCaCertificateSet(original["ca_certificate_set"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedCaCertificateSet); val.IsValid() && !isEmptyValue(val) {
		transformed["caCertificateSet"] = transformedCaCertificateSet
	}

	return transformed, nil
}

func expandDatastreamConnectionProfileMysqlProfileSslConfigClientKey(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDatastreamConnectionProfileMysqlProfileSslConfigClientKeySet(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDatastreamConnectionProfileMysqlProfileSslConfigClientCertificate(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDatastreamConnectionProfileMysqlProfileSslConfigClientCertificateSet(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDatastreamConnectionProfileMysqlProfileSslConfigCaCertificate(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDatastreamConnectionProfileMysqlProfileSslConfigCaCertificateSet(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDatastreamConnectionProfilePostgresqlProfile(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedHostname, err := expandDatastreamConnectionProfilePostgresqlProfileHostname(original["hostname"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedHostname); val.IsValid() && !isEmptyValue(val) {
		transformed["hostname"] = transformedHostname
	}

	transformedPort, err := expandDatastreamConnectionProfilePostgresqlProfilePort(original["port"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedPort); val.IsValid() && !isEmptyValue(val) {
		transformed["port"] = transformedPort
	}

	transformedUsername, err := expandDatastreamConnectionProfilePostgresqlProfileUsername(original["username"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedUsername); val.IsValid() && !isEmptyValue(val) {
		transformed["username"] = transformedUsername
	}

	transformedPassword, err := expandDatastreamConnectionProfilePostgresqlProfilePassword(original["password"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedPassword); val.IsValid() && !isEmptyValue(val) {
		transformed["password"] = transformedPassword
	}

	transformedDatabase, err := expandDatastreamConnectionProfilePostgresqlProfileDatabase(original["database"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedDatabase); val.IsValid() && !isEmptyValue(val) {
		transformed["database"] = transformedDatabase
	}

	return transformed, nil
}

func expandDatastreamConnectionProfilePostgresqlProfileHostname(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDatastreamConnectionProfilePostgresqlProfilePort(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDatastreamConnectionProfilePostgresqlProfileUsername(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDatastreamConnectionProfilePostgresqlProfilePassword(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDatastreamConnectionProfilePostgresqlProfileDatabase(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDatastreamConnectionProfileForwardSshConnectivity(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedHostname, err := expandDatastreamConnectionProfileForwardSshConnectivityHostname(original["hostname"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedHostname); val.IsValid() && !isEmptyValue(val) {
		transformed["hostname"] = transformedHostname
	}

	transformedUsername, err := expandDatastreamConnectionProfileForwardSshConnectivityUsername(original["username"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedUsername); val.IsValid() && !isEmptyValue(val) {
		transformed["username"] = transformedUsername
	}

	transformedPort, err := expandDatastreamConnectionProfileForwardSshConnectivityPort(original["port"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedPort); val.IsValid() && !isEmptyValue(val) {
		transformed["port"] = transformedPort
	}

	transformedPassword, err := expandDatastreamConnectionProfileForwardSshConnectivityPassword(original["password"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedPassword); val.IsValid() && !isEmptyValue(val) {
		transformed["password"] = transformedPassword
	}

	transformedPrivateKey, err := expandDatastreamConnectionProfileForwardSshConnectivityPrivateKey(original["private_key"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedPrivateKey); val.IsValid() && !isEmptyValue(val) {
		transformed["privateKey"] = transformedPrivateKey
	}

	return transformed, nil
}

func expandDatastreamConnectionProfileForwardSshConnectivityHostname(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDatastreamConnectionProfileForwardSshConnectivityUsername(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDatastreamConnectionProfileForwardSshConnectivityPort(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDatastreamConnectionProfileForwardSshConnectivityPassword(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandDatastreamConnectionProfileForwardSshConnectivityPrivateKey(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}
