"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMustQuery = getMustQuery;
exports.getSearchString = getSearchString;
exports.transformManagedIndexMetaData = transformManagedIndexMetaData;

var _lodash = _interopRequireDefault(require("lodash"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function transformManagedIndexMetaData(metaData) {
  if (!metaData) return null; // If this is not a managed index or we are still initializing we still return the
  // plugins.index_state_management.policy_id setting, but nothing else from the explain API

  if (!metaData.index) return null;
  return {
    index: metaData.index,
    // We know indexUuid and policyName exist if index exists
    indexUuid: metaData.index_uuid,
    policyId: metaData.policy_id,
    policySeqNo: metaData.policy_seq_no,
    policyPrimaryTerm: metaData.policy_primary_term,
    policyCompleted: metaData.policy_completed,
    rolledOver: metaData.rolled_over,
    transitionTo: metaData.transition_to,
    state: metaData.state ? {
      name: metaData.state.name,
      startTime: metaData.state.start_time
    } : undefined,
    action: metaData.action ? {
      name: metaData.action.name,
      startTime: metaData.action.start_time,
      index: metaData.action.index,
      failed: metaData.action.failed,
      consumedRetries: metaData.action.consumed_retries
    } : undefined,
    retryInfo: metaData.retry_info ? {
      failed: metaData.retry_info.failed,
      consumedRetries: metaData.retry_info.consumed_retries
    } : undefined,
    info: metaData.info
  };
}

function getMustQuery(field, search) {
  const str = search.trim();

  if (search.trim()) {
    return {
      query_string: {
        default_field: field,
        default_operator: "AND",
        query: str ? `*${str.split(" ").join("* *")}*` : "*"
      }
    };
  }

  return {
    match_all: {}
  };
}

function getSearchString(terms, indices, dataStreams, showDataStreams = true) {
  // Terms are searched with a wildcard around them.
  const searchTerms = terms ? `*${_lodash.default.castArray(terms).join("*,*")}*` : ""; // Indices and data streams are searched with wildcards around them.

  const searchIndices = indices ? `*${_lodash.default.castArray(indices).join("*,*")}*` : "";
  const searchDataStreams = dataStreams ? `*${_lodash.default.castArray(dataStreams).join("*,*")}*` : ""; // The overall search string is a combination of terms, indices, and data streams.
  // If the search string is blank, then '*' is used to match everything.

  const resolved = [searchTerms, searchIndices, searchDataStreams].filter(value => value !== "").join(",") || "*"; // We don't want to fetch managed datastream indices if there are not selected by caller.

  return showDataStreams ? resolved : resolved + " -.ds*";
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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