"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "getDefaultEuiMarkdownParsingPlugins", {
  enumerable: true,
  get: function get() {
    return _markdown_default_plugins.getDefaultEuiMarkdownParsingPlugins;
  }
});
Object.defineProperty(exports, "getDefaultEuiMarkdownProcessingPlugins", {
  enumerable: true,
  get: function get() {
    return _markdown_default_plugins.getDefaultEuiMarkdownProcessingPlugins;
  }
});
Object.defineProperty(exports, "getDefaultEuiMarkdownUiPlugins", {
  enumerable: true,
  get: function get() {
    return _markdown_default_plugins.getDefaultEuiMarkdownUiPlugins;
  }
});
exports.defaultUiPlugins = exports.getDefaultOuiMarkdownUiPlugins = exports.defaultProcessingPlugins = exports.getDefaultOuiMarkdownProcessingPlugins = exports.defaultParsingPlugins = exports.getDefaultOuiMarkdownParsingPlugins = void 0;

var _react = _interopRequireWildcard(require("react"));

var _all = _interopRequireDefault(require("mdast-util-to-hast/lib/all"));

var _rehypeReact = _interopRequireDefault(require("rehype-react"));

var _remarkParse = _interopRequireDefault(require("remark-parse"));

var _remarkEmoji = _interopRequireDefault(require("remark-emoji"));

var _remarkRehype = _interopRequireDefault(require("remark-rehype"));

var _remark_prismjs = _interopRequireDefault(require("./remark/remark_prismjs"));

var MarkdownTooltip = _interopRequireWildcard(require("./markdown_tooltip"));

var MarkdownCheckbox = _interopRequireWildcard(require("./markdown_checkbox"));

var _markdown_link_validator = require("./markdown_link_validator");

var _link = require("../../link");

var _code = require("../../code");

var _markdown_default_plugins = require("../../../eui_components/markdown_editor/plugins/markdown_default_plugins");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

var getDefaultOuiMarkdownParsingPlugins = function getDefaultOuiMarkdownParsingPlugins() {
  return [[_remarkParse.default, {}], [_remark_prismjs.default, {}], [_remarkEmoji.default, {
    emoticon: false
  }], [MarkdownTooltip.parser, {}], [MarkdownCheckbox.parser, {}], [_markdown_link_validator.markdownLinkValidator, {}]];
};

exports.getDefaultOuiMarkdownParsingPlugins = getDefaultOuiMarkdownParsingPlugins;
var defaultParsingPlugins = getDefaultOuiMarkdownParsingPlugins();
exports.defaultParsingPlugins = defaultParsingPlugins;

var unknownHandler = function unknownHandler(h, node) {
  return h(node, node.type, node, (0, _all.default)(h, node));
};

var getDefaultOuiMarkdownProcessingPlugins = function getDefaultOuiMarkdownProcessingPlugins() {
  return [[_remarkRehype.default, {
    allowDangerousHtml: true,
    unknownHandler: unknownHandler,
    handlers: {} // intentionally empty, allows plugins to extend if they need to

  }], [_rehypeReact.default, {
    createElement: _react.createElement,
    components: {
      a: _link.OuiLink,
      code: function code(props) {
        return (// If there are linebreaks use codeblock, otherwise code
          /\r|\n/.exec(props.children) ? /*#__PURE__*/_react.default.createElement(_code.OuiCodeBlock, _extends({
            fontSize: "m",
            paddingSize: "s"
          }, props)) : /*#__PURE__*/_react.default.createElement(_code.OuiCode, props)
        );
      },
      tooltipPlugin: MarkdownTooltip.renderer,
      checkboxPlugin: MarkdownCheckbox.renderer
    }
  }]];
};

exports.getDefaultOuiMarkdownProcessingPlugins = getDefaultOuiMarkdownProcessingPlugins;
var defaultProcessingPlugins = getDefaultOuiMarkdownProcessingPlugins();
exports.defaultProcessingPlugins = defaultProcessingPlugins;

var getDefaultOuiMarkdownUiPlugins = function getDefaultOuiMarkdownUiPlugins() {
  var array = [MarkdownTooltip.plugin]; // @ts-ignore __originatedFromOui is a custom property

  array.__originatedFromOui = true;
  return array;
};

exports.getDefaultOuiMarkdownUiPlugins = getDefaultOuiMarkdownUiPlugins;
var defaultUiPlugins = getDefaultOuiMarkdownUiPlugins();
/* OUI -> EUI Aliases: Build-Time */

exports.defaultUiPlugins = defaultUiPlugins;