"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.eventRoutes = eventRoutes;

var _configSchema = require("@osd/config-schema");

var _common = require("../../common");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function eventRoutes(router) {
  router.get({
    path: `${_common.NODE_API.GET_EVENT}/{eventId}`,
    validate: {
      params: _configSchema.schema.object({
        eventId: _configSchema.schema.string()
      })
    }
  }, async (context, request, response) => {
    // @ts-ignore
    const client = context.notificationsContext.notificationsClient.asScoped(request);

    try {
      const resp = await client.callAsCurrentUser('notifications.getEventById', {
        eventId: request.params.eventId
      });
      return response.ok({
        body: resp
      });
    } catch (error) {
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });
  router.post({
    path: `${_common.NODE_API.SEND_TEST_MESSAGE}/{configId}`,
    validate: {
      params: _configSchema.schema.object({
        configId: _configSchema.schema.string()
      })
    }
  }, async (context, request, response) => {
    // @ts-ignore
    const client = context.notificationsContext.notificationsClient.asScoped(request);

    try {
      const resp = await client.callAsCurrentUser('notifications.sendTestMessage', {
        configId: request.params.configId
      });
      return response.ok({
        body: resp
      });
    } catch (error) {
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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