/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink;

import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import java.util.ArrayList;
import java.util.List;
import org.almworks.util.detach.Detach;
import org.almworks.util.detach.DetachComposite;

@State(name="TL_CHECKIN_OPTIONS", storages={@Storage(id="other", file="$APP_CONFIG$/tlsettings.xml")})
public class CheckinOptions {
    private static final int DEFAULT_COLUMNS = 80;
    private final List<Runnable> myListeners = new ArrayList<Runnable>();
    public boolean myAllowMultiline = false;
    public boolean myReplaceUserComment = false;
    public boolean myIncludeSummary = true;
    public int myMaximumColumns = 80;

    public CheckinOptions getState() {
        return this;
    }

    public void loadState(CheckinOptions state) {
        this.setAllowMultiline(state.myAllowMultiline);
        this.setReplaceUserComment(state.myReplaceUserComment);
        this.setIncludeSummary(state.myIncludeSummary);
        this.setMaximumColumns(state.myMaximumColumns);
    }

    public boolean isAllowMultiline() {
        return this.myAllowMultiline;
    }

    public void setAllowMultiline(boolean allowMultiline) {
        if (this.myAllowMultiline != allowMultiline) {
            this.myAllowMultiline = allowMultiline;
            this.fireChanged();
        }
    }

    public boolean isIncludeSummary() {
        return this.myIncludeSummary;
    }

    public void setIncludeSummary(boolean includeSummary) {
        this.myIncludeSummary = includeSummary;
        this.fireChanged();
    }

    public int getMaximumColumns() {
        return this.myMaximumColumns;
    }

    public void setMaximumColumns(int maximumColumns) {
        this.myMaximumColumns = Math.max(0, Math.min(9999, maximumColumns));
        this.fireChanged();
    }

    public boolean isReplaceUserComment() {
        return this.myReplaceUserComment;
    }

    public void setReplaceUserComment(boolean replaceUserComment) {
        this.myReplaceUserComment = replaceUserComment;
        this.fireChanged();
    }

    public void addChangeListener(DetachComposite lifespan, final Runnable listener) {
        this.myListeners.add(listener);
        lifespan.add(new Detach(){

            protected void doDetach() {
                CheckinOptions.this.myListeners.remove(listener);
            }
        });
    }

    protected void fireChanged() {
        Object[] objects;
        for (Object obj : objects = this.myListeners.toArray()) {
            ((Runnable)obj).run();
        }
    }
}

