/*
 * Decompiled with CFR 0.152.
 */
package liquibase;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import liquibase.util.StringUtils;

public class Labels {
    private Set<String> labels = new LinkedHashSet<String>();

    public Labels() {
    }

    public Labels(String ... labels) {
        if (labels.length == 1) {
            this.parseLabelString(labels[0]);
        } else {
            for (String label : labels) {
                this.labels.add(label.toLowerCase());
            }
        }
    }

    public Labels(String labels) {
        this.parseLabelString(labels);
    }

    private void parseLabelString(String labels) {
        if ((labels = StringUtils.trimToNull(labels)) == null) {
            return;
        }
        for (String label : StringUtils.splitAndTrim(labels, ",")) {
            this.labels.add(label.toLowerCase());
        }
    }

    public Labels(Collection<String> labels) {
        if (labels != null) {
            for (String label : labels) {
                this.labels.add(label.toLowerCase());
            }
        }
    }

    public boolean add(String label) {
        return this.labels.add(label.toLowerCase());
    }

    public boolean remove(String label) {
        return this.labels.remove(label.toLowerCase());
    }

    public String toString() {
        return StringUtils.join(new LinkedHashSet<String>(this.labels), ",");
    }

    public boolean isEmpty() {
        return this.labels == null || this.labels.isEmpty();
    }

    public Set<String> getLabels() {
        return Collections.unmodifiableSet(this.labels);
    }
}

