/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.api;

import jakarta.inject.Inject;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Response;
import org.traccar.api.BaseResource;
import org.traccar.helper.LogAction;
import org.traccar.model.BaseModel;
import org.traccar.model.Group;
import org.traccar.model.ObjectOperation;
import org.traccar.model.Permission;
import org.traccar.model.User;
import org.traccar.session.ConnectionManager;
import org.traccar.session.cache.CacheManager;
import org.traccar.storage.StorageException;
import org.traccar.storage.query.Columns;
import org.traccar.storage.query.Condition;
import org.traccar.storage.query.Request;

public abstract class BaseObjectResource<T extends BaseModel>
extends BaseResource {
    @Inject
    private CacheManager cacheManager;
    @Inject
    private ConnectionManager connectionManager;
    protected final Class<T> baseClass;

    public BaseObjectResource(Class<T> baseClass) {
        this.baseClass = baseClass;
    }

    @Path(value="{id}")
    @GET
    public Response getSingle(@PathParam(value="id") long id) throws StorageException {
        this.permissionsService.checkPermission(this.baseClass, this.getUserId(), id);
        BaseModel entity = (BaseModel)this.storage.getObject(this.baseClass, new Request((Columns)new Columns.All(), new Condition.Equals("id", id)));
        if (entity != null) {
            return Response.ok((Object)entity).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @POST
    public Response add(T entity) throws Exception {
        this.permissionsService.checkEdit(this.getUserId(), (BaseModel)entity, true, false);
        ((BaseModel)entity).setId(this.storage.addObject(entity, new Request(new Columns.Exclude("id"))));
        LogAction.create(this.getUserId(), entity);
        if (this.getUserId() != 9000000000000000000L) {
            this.storage.addPermission(new Permission(User.class, this.getUserId(), this.baseClass, ((BaseModel)entity).getId()));
            this.cacheManager.invalidatePermission(true, User.class, this.getUserId(), this.baseClass, ((BaseModel)entity).getId(), true);
            this.connectionManager.invalidatePermission(true, User.class, this.getUserId(), this.baseClass, ((BaseModel)entity).getId(), true);
            LogAction.link(this.getUserId(), User.class, this.getUserId(), this.baseClass, ((BaseModel)entity).getId());
        }
        return Response.ok(entity).build();
    }

    @Path(value="{id}")
    @PUT
    public Response update(T entity) throws Exception {
        User user;
        Group group;
        this.permissionsService.checkPermission(this.baseClass, this.getUserId(), ((BaseModel)entity).getId());
        boolean skipReadonly = false;
        if (entity instanceof User) {
            User after = (User)entity;
            User before = this.storage.getObject(User.class, new Request((Columns)new Columns.All(), new Condition.Equals("id", ((BaseModel)entity).getId())));
            this.permissionsService.checkUserUpdate(this.getUserId(), before, (User)entity);
            skipReadonly = this.permissionsService.getUser(this.getUserId()).compare(after, "notificationTokens", "termsAccepted");
        } else if (entity instanceof Group && (group = (Group)entity).getId() == group.getGroupId()) {
            throw new IllegalArgumentException("Cycle in group hierarchy");
        }
        this.permissionsService.checkEdit(this.getUserId(), (BaseModel)entity, false, skipReadonly);
        this.storage.updateObject(entity, new Request((Columns)new Columns.Exclude("id"), new Condition.Equals("id", ((BaseModel)entity).getId())));
        if (entity instanceof User && (user = (User)entity).getHashedPassword() != null) {
            this.storage.updateObject(entity, new Request((Columns)new Columns.Include("hashedPassword", "salt"), new Condition.Equals("id", ((BaseModel)entity).getId())));
        }
        this.cacheManager.invalidateObject(true, entity.getClass(), ((BaseModel)entity).getId(), ObjectOperation.UPDATE);
        LogAction.edit(this.getUserId(), entity);
        return Response.ok(entity).build();
    }

    @Path(value="{id}")
    @DELETE
    public Response remove(@PathParam(value="id") long id) throws Exception {
        this.permissionsService.checkPermission(this.baseClass, this.getUserId(), id);
        this.permissionsService.checkEdit(this.getUserId(), this.baseClass, false, false);
        this.storage.removeObject(this.baseClass, new Request(new Condition.Equals("id", id)));
        this.cacheManager.invalidateObject(true, this.baseClass, id, ObjectOperation.DELETE);
        LogAction.remove(this.getUserId(), this.baseClass, id);
        return Response.noContent().build();
    }
}

