/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.io.Reader;
import java.io.StringReader;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.LinkedList;
import java.util.Map;
import org.traccar.BaseHttpProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class FlespiProtocolDecoder
extends BaseHttpProtocolDecoder {
    public FlespiProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        FullHttpRequest request = (FullHttpRequest)msg;
        JsonArray result = Json.createReader((Reader)new StringReader(request.content().toString(StandardCharsets.UTF_8))).readArray();
        LinkedList<Position> positions = new LinkedList<Position>();
        for (int i = 0; i < result.size(); ++i) {
            JsonObject message = result.getJsonObject(i);
            JsonString identifier = message.getJsonString("ident");
            if (identifier == null) continue;
            DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, identifier.getString());
            if (deviceSession == null) continue;
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            position.setValid(true);
            this.decodePosition(message, position);
            positions.add(position);
        }
        this.sendResponse(channel, HttpResponseStatus.OK);
        return positions;
    }

    private void decodePosition(JsonObject object, Position position) {
        for (Map.Entry param : object.entrySet()) {
            String paramName = (String)param.getKey();
            JsonValue paramValue = (JsonValue)param.getValue();
            int index = -1;
            if (paramName.contains("#")) {
                String[] parts = paramName.split("#");
                paramName = parts[0];
                index = Integer.parseInt(parts[1]);
            }
            if (this.decodeParam(paramName, index, paramValue, position)) continue;
            this.decodeUnknownParam((String)param.getKey(), (JsonValue)param.getValue(), position);
        }
        if (position.getLatitude() == 0.0 && position.getLongitude() == 0.0) {
            this.getLastLocation(position, position.getDeviceTime());
        }
    }

    private boolean decodeParam(String name, int index, JsonValue value, Position position) {
        return switch (name) {
            case "timestamp" -> {
                position.setTime(new Date(((JsonNumber)value).longValue() * 1000L));
                yield true;
            }
            case "position.latitude" -> {
                position.setLatitude(((JsonNumber)value).doubleValue());
                yield true;
            }
            case "position.longitude" -> {
                position.setLongitude(((JsonNumber)value).doubleValue());
                yield true;
            }
            case "position.speed" -> {
                position.setSpeed(UnitsConverter.knotsFromKph(((JsonNumber)value).doubleValue()));
                yield true;
            }
            case "position.direction" -> {
                position.setCourse(((JsonNumber)value).doubleValue());
                yield true;
            }
            case "position.altitude" -> {
                position.setAltitude(((JsonNumber)value).doubleValue());
                yield true;
            }
            case "position.satellites" -> {
                position.set("sat", ((JsonNumber)value).intValue());
                yield true;
            }
            case "position.valid" -> {
                position.setValid(value == JsonValue.TRUE);
                yield true;
            }
            case "position.hdop" -> {
                position.set("hdop", ((JsonNumber)value).doubleValue());
                yield true;
            }
            case "position.pdop" -> {
                position.set("pdop", ((JsonNumber)value).doubleValue());
                yield true;
            }
            case "din" -> {
                position.set("input", ((JsonNumber)value).intValue());
                yield true;
            }
            case "dout" -> {
                position.set("output", ((JsonNumber)value).intValue());
                yield true;
            }
            case "report.reason" -> {
                position.set("event", ((JsonNumber)value).intValue());
                yield true;
            }
            case "gps.vehicle.mileage" -> {
                position.set("odometer", ((JsonNumber)value).doubleValue());
                yield true;
            }
            case "external.powersource.voltage" -> {
                position.set("power", ((JsonNumber)value).doubleValue());
                yield true;
            }
            case "battery.voltage" -> {
                position.set("battery", ((JsonNumber)value).doubleValue());
                yield true;
            }
            case "battery.level" -> {
                position.set("batteryLevel", ((JsonNumber)value).intValue());
                yield true;
            }
            case "fuel.level", "can.fuel.level" -> {
                position.set("fuel", ((JsonNumber)value).doubleValue());
                yield true;
            }
            case "engine.rpm", "can.engine.rpm" -> {
                position.set("rpm", ((JsonNumber)value).doubleValue());
                yield true;
            }
            case "can.engine.temperature" -> {
                position.set("temp" + Math.max(index, 0), ((JsonNumber)value).doubleValue());
                yield true;
            }
            case "engine.ignition.status" -> {
                position.set("ignition", value == JsonValue.TRUE);
                yield true;
            }
            case "movement.status" -> {
                position.set("motion", value == JsonValue.TRUE);
                yield true;
            }
            case "device.temperature" -> {
                position.set("deviceTemp", ((JsonNumber)value).doubleValue());
                yield true;
            }
            case "ibutton.code" -> {
                position.set("driverUniqueId", ((JsonString)value).getString());
                yield true;
            }
            case "vehicle.vin" -> {
                position.set("vin", ((JsonString)value).getString());
                yield true;
            }
            case "alarm.event.trigger" -> {
                if (value == JsonValue.TRUE) {
                    position.addAlarm("general");
                }
                yield true;
            }
            case "towing.event.trigger", "towing.alarm.status" -> {
                if (value == JsonValue.TRUE) {
                    position.addAlarm("tow");
                }
                yield true;
            }
            case "geofence.event.enter" -> {
                if (value == JsonValue.TRUE) {
                    position.addAlarm("geofenceEnter");
                }
                yield true;
            }
            case "geofence.event.exit" -> {
                if (value == JsonValue.TRUE) {
                    position.addAlarm("geofenceExit");
                }
                yield true;
            }
            case "shock.event.trigger" -> {
                if (value == JsonValue.TRUE) {
                    position.addAlarm("vibration");
                }
                yield true;
            }
            case "overspeeding.event.trigger" -> {
                if (value == JsonValue.TRUE) {
                    position.addAlarm("overspeed");
                }
                yield true;
            }
            case "harsh.acceleration.event.trigger" -> {
                if (value == JsonValue.TRUE) {
                    position.addAlarm("hardAcceleration");
                }
                yield true;
            }
            case "harsh.braking.event.trigger" -> {
                if (value == JsonValue.TRUE) {
                    position.addAlarm("hardBraking");
                }
                yield true;
            }
            case "harsh.cornering.event.trigger" -> {
                if (value == JsonValue.TRUE) {
                    position.addAlarm("hardCornering");
                }
                yield true;
            }
            case "gnss.antenna.cut.status" -> {
                if (value == JsonValue.TRUE) {
                    position.addAlarm("gpsAntennaCut");
                }
                yield true;
            }
            case "gsm.jamming.event.trigger" -> {
                if (value == JsonValue.TRUE) {
                    position.addAlarm("jamming");
                }
                yield true;
            }
            case "hood.open.status" -> {
                if (value == JsonValue.TRUE) {
                    position.addAlarm("bonnet");
                }
                yield true;
            }
            case "custom.wln_accel_max" -> {
                position.set("maxAcceleration", ((JsonNumber)value).doubleValue());
                yield true;
            }
            case "custom.wln_brk_max" -> {
                position.set("maxBraking", ((JsonNumber)value).doubleValue());
                yield true;
            }
            case "custom.wln_crn_max" -> {
                position.set("maxCornering", ((JsonNumber)value).doubleValue());
                yield true;
            }
            default -> false;
        };
    }

    private void decodeUnknownParam(String name, JsonValue value, Position position) {
        if (value instanceof JsonNumber) {
            JsonNumber jsonNumber = (JsonNumber)value;
            if (jsonNumber.isIntegral()) {
                position.set(name, jsonNumber.longValue());
            } else {
                position.set(name, jsonNumber.doubleValue());
            }
            position.set(name, jsonNumber.doubleValue());
        } else if (value instanceof JsonString) {
            JsonString jsonString = (JsonString)value;
            position.set(name, jsonString.getString());
        } else if (value == JsonValue.TRUE || value == JsonValue.FALSE) {
            position.set(name, value == JsonValue.TRUE);
        }
    }
}

