/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.evaluatetablecontent;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobEntryType;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.evaluatetablecontent.Messages;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntryEvalTableContent
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    public boolean isAddRowsResult;
    public boolean isClearResultList;
    public boolean isUseVars;
    public boolean iscustomSQL;
    public String customSQL;
    private DatabaseMeta connection;
    public String tablename;
    public String schemaname;
    private static final String selectCount = "SELECT count(*) FROM ";
    public static final String[] successConditionsDesc = new String[]{Messages.getString("JobEntryEvalTableContent.SuccessWhenRowCountEqual.Label"), Messages.getString("JobEntryEvalTableContent.SuccessWhenRowCountDifferent.Label"), Messages.getString("JobEntryEvalTableContent.SuccessWhenRowCountSmallerThan.Label"), Messages.getString("JobEntryEvalTableContent.SuccessWhenRowCountSmallerOrEqualThan.Label"), Messages.getString("JobEntryEvalTableContent.SuccessWhenRowCountGreaterThan.Label"), Messages.getString("JobEntryEvalTableContent.SuccessWhenRowCountGreaterOrEqual.Label")};
    public static final String[] successConditionsCode = new String[]{"rows_count_equal", "rows_count_different", "rows_count_smaller", "rows_count_smaller_equal", "rows_count_greater", "rows_count_greater_equal"};
    public static final int SUCCESS_CONDITION_ROWS_COUNT_EQUAL = 0;
    public static final int SUCCESS_CONDITION_ROWS_COUNT_DIFFERENT = 1;
    public static final int SUCCESS_CONDITION_ROWS_COUNT_SMALLER = 2;
    public static final int SUCCESS_CONDITION_ROWS_COUNT_SMALLER_EQUAL = 3;
    public static final int SUCCESS_CONDITION_ROWS_COUNT_GREATER = 4;
    public static final int SUCCESS_CONDITION_ROWS_COUNT_GREATER_EQUAL = 5;
    public String limit;
    public int successCondition;

    public JobEntryEvalTableContent(String n) {
        super(n, "");
        this.limit = "0";
        this.successCondition = 4;
        this.iscustomSQL = false;
        this.isUseVars = false;
        this.isAddRowsResult = false;
        this.isClearResultList = true;
        this.customSQL = null;
        this.schemaname = null;
        this.tablename = null;
        this.connection = null;
        this.setID(-1L);
        this.setJobEntryType(JobEntryType.EVAL_TABLE_CONTENT);
    }

    public JobEntryEvalTableContent() {
        this("");
    }

    public JobEntryEvalTableContent(JobEntryBase jeb) {
        super(jeb);
    }

    @Override
    public Object clone() {
        JobEntryEvalTableContent je = (JobEntryEvalTableContent)super.clone();
        return je;
    }

    public int getSuccessCobdition() {
        return this.successCondition;
    }

    public static int getSuccessConditionByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < successConditionsDesc.length; ++i) {
            if (!successConditionsDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return JobEntryEvalTableContent.getSuccessConditionByCode(tt);
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(200);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"connection", this.connection == null ? null : this.connection.getName()));
        retval.append("      ").append(XMLHandler.addTagValue((String)"schemaname", (String)this.schemaname));
        retval.append("      ").append(XMLHandler.addTagValue((String)"tablename", (String)this.tablename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"success_condition", (String)JobEntryEvalTableContent.getSuccessConditionCode(this.successCondition)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"limit", (String)this.limit));
        retval.append("      ").append(XMLHandler.addTagValue((String)"is_custom_sql", (boolean)this.iscustomSQL));
        retval.append("      ").append(XMLHandler.addTagValue((String)"is_usevars", (boolean)this.isUseVars));
        retval.append("      ").append(XMLHandler.addTagValue((String)"custom_sql", (String)this.customSQL));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_rows_result", (boolean)this.isAddRowsResult));
        retval.append("      ").append(XMLHandler.addTagValue((String)"clear_result_rows", (boolean)this.isClearResultList));
        return retval.toString();
    }

    private static String getSuccessConditionCode(int i) {
        if (i < 0 || i >= successConditionsCode.length) {
            return successConditionsCode[0];
        }
        return successConditionsCode[i];
    }

    private static int getSucessConditionByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < successConditionsCode.length; ++i) {
            if (!successConditionsCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public static String getSuccessConditionDesc(int i) {
        if (i < 0 || i >= successConditionsDesc.length) {
            return successConditionsDesc[0];
        }
        return successConditionsDesc[i];
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            String dbname = XMLHandler.getTagValue((Node)entrynode, (String)"connection");
            this.connection = DatabaseMeta.findDatabase(databases, (String)dbname);
            this.schemaname = XMLHandler.getTagValue((Node)entrynode, (String)"schemaname");
            this.tablename = XMLHandler.getTagValue((Node)entrynode, (String)"tablename");
            this.successCondition = JobEntryEvalTableContent.getSucessConditionByCode(Const.NVL((String)XMLHandler.getTagValue((Node)entrynode, (String)"success_condition"), (String)""));
            this.limit = Const.NVL((String)XMLHandler.getTagValue((Node)entrynode, (String)"limit"), (String)"0");
            this.iscustomSQL = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"is_custom_sql"));
            this.isUseVars = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"is_usevars"));
            this.customSQL = XMLHandler.getTagValue((Node)entrynode, (String)"custom_sql");
            this.isAddRowsResult = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"add_rows_result"));
            this.isClearResultList = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"clear_result_rows"));
        }
        catch (KettleException e) {
            throw new KettleXMLException(Messages.getString("JobEntryEvalTableContent.UnableLoadXML"), (Throwable)e);
        }
    }

    @Override
    public void loadRep(Repository rep, long id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            super.loadRep(rep, id_jobentry, databases, slaveServers);
            long id_db = rep.getJobEntryAttributeInteger(id_jobentry, "id_database");
            this.connection = id_db > 0L ? DatabaseMeta.findDatabase(databases, (long)id_db) : DatabaseMeta.findDatabase(databases, (String)rep.getJobEntryAttributeString(id_jobentry, "connection"));
            this.schemaname = rep.getJobEntryAttributeString(id_jobentry, "schemaname");
            this.tablename = rep.getJobEntryAttributeString(id_jobentry, "tablename");
            this.successCondition = JobEntryEvalTableContent.getSuccessConditionByCode(Const.NVL((String)rep.getJobEntryAttributeString(id_jobentry, "success_condition"), (String)""));
            this.limit = rep.getJobEntryAttributeString(id_jobentry, "limit");
            this.iscustomSQL = rep.getJobEntryAttributeBoolean(id_jobentry, "is_custom_sql");
            this.isUseVars = rep.getJobEntryAttributeBoolean(id_jobentry, "is_usevars");
            this.isAddRowsResult = rep.getJobEntryAttributeBoolean(id_jobentry, "add_rows_result");
            this.isClearResultList = rep.getJobEntryAttributeBoolean(id_jobentry, "clear_result_rows");
            this.customSQL = rep.getJobEntryAttributeString(id_jobentry, "custom_sql");
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(Messages.getString("JobEntryEvalTableContent.UnableLoadRep", "" + id_jobentry), (Throwable)dbe);
        }
    }

    private static int getSuccessConditionByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < successConditionsCode.length; ++i) {
            if (!successConditionsCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    @Override
    public void saveRep(Repository rep, long id_job) throws KettleException {
        try {
            super.saveRep(rep, id_job);
            if (this.connection != null) {
                rep.saveJobEntryAttribute(id_job, this.getID(), "connection", this.connection.getName());
            }
            rep.saveJobEntryAttribute(id_job, this.getID(), "schemaname", this.schemaname);
            rep.saveJobEntryAttribute(id_job, this.getID(), "tablename", this.tablename);
            rep.saveJobEntryAttribute(id_job, this.getID(), "success_condition", JobEntryEvalTableContent.getSuccessConditionCode(this.successCondition));
            rep.saveJobEntryAttribute(id_job, this.getID(), "limit", this.limit);
            rep.saveJobEntryAttribute(id_job, this.getID(), "custom_sql", this.customSQL);
            rep.saveJobEntryAttribute(id_job, this.getID(), "is_custom_sql", this.iscustomSQL);
            rep.saveJobEntryAttribute(id_job, this.getID(), "is_usevars", this.isUseVars);
            rep.saveJobEntryAttribute(id_job, this.getID(), "add_rows_result", this.isAddRowsResult);
            rep.saveJobEntryAttribute(id_job, this.getID(), "clear_result_rows", this.isClearResultList);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(Messages.getString("JobEntryEvalTableContent.UnableSaveRep", "" + id_job), (Throwable)dbe);
        }
    }

    public void setDatabase(DatabaseMeta database) {
        this.connection = database;
    }

    public DatabaseMeta getDatabase() {
        return this.connection;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public boolean isUnconditional() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public Result execute(Result previousResult, int nr, Repository rep, Job parentJob) {
        block38: {
            log = LogWriter.getInstance();
            result = previousResult;
            result.setResult(false);
            result.setNrErrors(1L);
            countSQLStatement = null;
            rowsCount = 0L;
            successOK = false;
            nrRowsLimit = Const.toInt((String)this.environmentSubstitute(this.limit), (int)0);
            if (log.isDetailed()) {
                log.logDetailed(this.toString(), Messages.getString("JobEntryEvalTableContent.Log.nrRowsLimit", "" + nrRowsLimit), new Object[0]);
            }
            if (this.connection != null) {
                db = new Database(this.connection);
                try {
                    block37: {
                        db.connect();
                        if (this.iscustomSQL) {
                            realCustomSQL = this.customSQL;
                            if (this.isUseVars) {
                                realCustomSQL = this.environmentSubstitute(realCustomSQL);
                            }
                            if (log.isDebug()) {
                                log.logDebug(this.toString(), Messages.getString("JobEntryEvalTableContent.Log.EnteredCustomSQL", realCustomSQL), new Object[0]);
                            }
                            if (!Const.isEmpty((String)realCustomSQL)) {
                                countSQLStatement = realCustomSQL;
                            } else {
                                log.logError(this.toString(), Messages.getString("JobEntryEvalTableContent.Error.NoCustomSQL"), new Object[0]);
                            }
                        } else {
                            realTablename = this.environmentSubstitute(this.tablename);
                            realSchemaname = this.environmentSubstitute(this.schemaname);
                            if (!Const.isEmpty((String)realTablename)) {
                                countSQLStatement = !Const.isEmpty((String)realSchemaname) ? "SELECT count(*) FROM " + db.getDatabaseMeta().getQuotedSchemaTableCombination(realSchemaname, realTablename) : "SELECT count(*) FROM " + db.getDatabaseMeta().quoteField(realTablename);
                            } else {
                                log.logError(this.toString(), Messages.getString("JobEntryEvalTableContent.Error.NoTableName"), new Object[0]);
                            }
                        }
                        if (countSQLStatement == null) break block37;
                        if (log.isDetailed()) {
                            log.logDetailed(this.toString(), Messages.getString("JobEntryEvalTableContent.Log.RunSQLStatement", countSQLStatement), new Object[0]);
                        }
                        if (this.iscustomSQL) {
                            if (this.isClearResultList) {
                                result.getRows().clear();
                            }
                            if ((ar = db.getRows(countSQLStatement, 0)) != null) {
                                rowsCount = ar.size();
                                rowMeta = db.getQueryFields(countSQLStatement, false);
                                rows = new ArrayList<RowMetaAndData>();
                                for (i = 0; i < ar.size(); ++i) {
                                    rows.add(new RowMetaAndData(rowMeta, (Object[])ar.get(i)));
                                }
                                if (this.isAddRowsResult && this.iscustomSQL && rows != null) {
                                    result.getRows().addAll(rows);
                                }
                            } else if (log.isDebug()) {
                                log.logDebug(this.toString(), Messages.getString("JobEntryEvalTableContent.Log.customSQLreturnedNothing", countSQLStatement), new Object[0]);
                            }
                        } else {
                            row = db.getOneRow(countSQLStatement);
                            if (row != null) {
                                rowsCount = row.getInteger(0);
                            }
                        }
                        if (log.isDetailed()) {
                            log.logDetailed(this.toString(), Messages.getString("JobEntryEvalTableContent.Log.NrRowsReturned", "" + rowsCount), new Object[0]);
                        }
                        switch (this.successCondition) {
                            case 0: {
                                successOK = rowsCount == (long)nrRowsLimit;
                                break;
                            }
                            case 1: {
                                successOK = rowsCount != (long)nrRowsLimit;
                                break;
                            }
                            case 2: {
                                successOK = rowsCount < (long)nrRowsLimit;
                                break;
                            }
                            case 3: {
                                successOK = rowsCount <= (long)nrRowsLimit;
                                break;
                            }
                            case 4: {
                                successOK = rowsCount > (long)nrRowsLimit;
                                break;
                            }
                            case 5: {
                                successOK = rowsCount >= (long)nrRowsLimit;
                                break;
                            }
                        }
                    }
                    var18_17 = null;
                    ** if (db == null) goto lbl-1000
                }
                catch (Throwable var17_20) {
                    var18_19 = null;
                    if (db != null) {
                        db.disconnect();
                    }
                    throw var17_20;
                }
lbl-1000:
                // 1 sources

                {
                    db.disconnect();
                }
lbl-1000:
                // 2 sources

                {
                    break block38;
                    catch (KettleException dbe) {
                        log.logError(this.toString(), Messages.getString("JobEntryEvalTableContent.Error.RunningEntry", dbe.getMessage()), new Object[0]);
                        var18_18 = null;
                        if (db != null) {
                            db.disconnect();
                        }
                        break block38;
                    }
                }
            }
            log.logError(this.toString(), Messages.getString("JobEntryEvalTableContent.NoDbConnection"), new Object[0]);
        }
        if (successOK) {
            result.setResult(true);
            result.setNrErrors(0L);
        }
        result.setNrLinesRead(rowsCount);
        return result;
    }

    @Override
    public DatabaseMeta[] getUsedDatabaseConnections() {
        return new DatabaseMeta[]{this.connection};
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        if (this.connection != null) {
            ResourceReference reference = new ResourceReference(this);
            reference.getEntries().add(new ResourceEntry(this.connection.getHostname(), ResourceEntry.ResourceType.SERVER));
            reference.getEntries().add(new ResourceEntry(this.connection.getDatabaseName(), ResourceEntry.ResourceType.DATABASENAME));
            references.add(reference);
        }
        return references;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta) {
        JobEntryValidatorUtils.andValidator().validate(this, "WaitForSQL", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
    }
}

