/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.internal.provider.AbstractMinimalProvider;
import org.gradle.api.internal.provider.AbstractProperty;
import org.gradle.api.internal.provider.CollectionPropertyInternal;
import org.gradle.api.internal.provider.CollectionSupplier;
import org.gradle.api.internal.provider.Collector;
import org.gradle.api.internal.provider.Collectors;
import org.gradle.api.internal.provider.PropertyHost;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.internal.provider.ValidatingValueCollector;
import org.gradle.api.internal.provider.ValueCollector;
import org.gradle.api.internal.provider.ValueSanitizers;
import org.gradle.api.internal.provider.ValueSupplier;
import org.gradle.api.provider.HasMultipleValues;
import org.gradle.api.provider.Provider;
import org.gradle.internal.Cast;

public abstract class AbstractCollectionProperty<T, C extends Collection<T>>
extends AbstractProperty<C, CollectionSupplier<T, C>>
implements CollectionPropertyInternal<T, C> {
    private static final CollectionSupplier<Object, Collection<Object>> NO_VALUE = new NoValueSupplier<Object, Object>(ValueSupplier.Value.missing());
    private final Class<? extends Collection> collectionType;
    private final Class<T> elementType;
    private final Supplier<ImmutableCollection.Builder<T>> collectionFactory;
    private final ValueCollector<T> valueCollector;
    private CollectionSupplier<T, C> defaultValue = this.emptySupplier();

    AbstractCollectionProperty(PropertyHost host, Class<? extends Collection> collectionType, Class<T> elementType, Supplier<ImmutableCollection.Builder<T>> collectionFactory) {
        super(host);
        this.collectionType = collectionType;
        this.elementType = elementType;
        this.collectionFactory = collectionFactory;
        this.valueCollector = new ValidatingValueCollector<T>(collectionType, elementType, ValueSanitizers.forType(elementType));
        this.init(this.defaultValue, this.noValueSupplier());
    }

    private CollectionSupplier<T, C> emptySupplier() {
        return new EmptySupplier();
    }

    private CollectionSupplier<T, C> noValueSupplier() {
        return (CollectionSupplier)Cast.uncheckedCast(NO_VALUE);
    }

    protected abstract C emptyCollection();

    public void add(T element) {
        Preconditions.checkNotNull(element, (String)"Cannot add a null element to a property of type %s.", (Object)this.collectionType.getSimpleName());
        this.addCollector(new Collectors.SingleElement<T>(element));
    }

    public void add(Provider<? extends T> providerOfElement) {
        this.addCollector(new Collectors.ElementFromProvider<T>(Providers.internal(providerOfElement)));
    }

    @SafeVarargs
    public final void addAll(T ... elements) {
        this.addCollector(new Collectors.ElementsFromArray<T>(elements));
    }

    public void addAll(Iterable<? extends T> elements) {
        this.addCollector(new Collectors.ElementsFromCollection<T>(elements));
    }

    public void addAll(Provider<? extends Iterable<? extends T>> provider) {
        this.addCollector(new Collectors.ElementsFromCollectionProvider(Providers.internal(provider)));
    }

    @Override
    public int size() {
        return ((Collection)this.calculateOwnPresentValue().getWithoutSideEffect()).size();
    }

    private void addCollector(Collector<T> collector) {
        this.assertCanMutate();
        this.setSupplier(this.getExplicitValue(this.defaultValue).plus(collector));
    }

    @Override
    @Nullable
    public Class<C> getType() {
        return (Class)Cast.uncheckedCast(this.collectionType);
    }

    @Override
    public Class<T> getElementType() {
        return this.elementType;
    }

    public void fromState(ValueSupplier.ExecutionTimeValue<? extends C> value) {
        if (value.isMissing()) {
            this.setSupplier(this.noValueSupplier());
        } else if (value.hasFixedValue()) {
            this.setSupplier(new FixedSupplier((Collection)value.getFixedValue(), (ValueSupplier.SideEffect)Cast.uncheckedCast(value.getSideEffect())));
        } else {
            this.setSupplier(new CollectingSupplier(new Collectors.ElementsFromCollectionProvider(value.getChangingValue())));
        }
    }

    @Override
    public void setFromAnyValue(Object object) {
        if (object instanceof Provider) {
            this.set((Provider)Cast.uncheckedCast((Object)object));
        } else {
            if (object != null && !(object instanceof Iterable)) {
                throw new IllegalArgumentException(String.format("Cannot set the value of a property of type %s using an instance of type %s.", this.collectionType.getName(), object.getClass().getName()));
            }
            this.set((Iterable)Cast.uncheckedCast((Object)object));
        }
    }

    public void set(@Nullable Iterable<? extends T> elements) {
        if (elements == null) {
            this.discardValue();
            this.defaultValue = this.noValueSupplier();
        } else {
            this.setSupplier(new CollectingSupplier(new Collectors.ElementsFromCollection<T>(elements)));
        }
    }

    public void set(Provider<? extends Iterable<? extends T>> provider) {
        CollectionPropertyInternal collectionProp;
        if (provider == null) {
            throw new IllegalArgumentException("Cannot set the value of a property using a null provider.");
        }
        ProviderInternal<Iterable<T>> p = Providers.internal(provider);
        if (p.getType() != null && !Iterable.class.isAssignableFrom(p.getType())) {
            throw new IllegalArgumentException(String.format("Cannot set the value of a property of type %s using a provider of type %s.", this.collectionType.getName(), p.getType().getName()));
        }
        if (p instanceof CollectionPropertyInternal && !this.elementType.isAssignableFrom((collectionProp = (CollectionPropertyInternal)Cast.uncheckedCast(p)).getElementType())) {
            throw new IllegalArgumentException(String.format("Cannot set the value of a property of type %s with element type %s using a provider with element type %s.", this.collectionType.getName(), this.elementType.getName(), collectionProp.getElementType().getName()));
        }
        this.setSupplier(new CollectingSupplier(new Collectors.ElementsFromCollectionProvider(p)));
    }

    public HasMultipleValues<T> value(@Nullable Iterable<? extends T> elements) {
        this.set(elements);
        return this;
    }

    public HasMultipleValues<T> value(Provider<? extends Iterable<? extends T>> provider) {
        this.set(provider);
        return this;
    }

    public HasMultipleValues<T> empty() {
        this.setSupplier(this.emptySupplier());
        return this;
    }

    @Override
    protected ValueSupplier.Value<? extends C> calculateValueFrom(CollectionSupplier<T, C> value, ValueSupplier.ValueConsumer consumer) {
        return value.calculateValue(consumer);
    }

    @Override
    protected CollectionSupplier<T, C> finalValue(CollectionSupplier<T, C> value, ValueSupplier.ValueConsumer consumer) {
        ValueSupplier.Value<C> result = value.calculateValue(consumer);
        if (!result.isMissing()) {
            return new FixedSupplier((Collection)result.getWithoutSideEffect(), (ValueSupplier.SideEffect)Cast.uncheckedCast(result.getSideEffect()));
        }
        if (result.getPathToOrigin().isEmpty()) {
            return this.noValueSupplier();
        }
        return new NoValueSupplier(result);
    }

    @Override
    protected ValueSupplier.ExecutionTimeValue<? extends C> calculateOwnExecutionTimeValue(CollectionSupplier<T, C> value) {
        return value.calculateExecutionTimeValue();
    }

    public HasMultipleValues<T> convention(@Nullable Iterable<? extends T> elements) {
        if (elements == null) {
            this.setConvention(this.noValueSupplier());
        } else {
            this.setConvention(new CollectingSupplier(new Collectors.ElementsFromCollection<T>(elements)));
        }
        return this;
    }

    public HasMultipleValues<T> convention(Provider<? extends Iterable<? extends T>> provider) {
        this.setConvention(new CollectingSupplier(new Collectors.ElementsFromCollectionProvider(Providers.internal(provider))));
        return this;
    }

    @Override
    protected String describeContents() {
        return String.format("%s(%s, %s)", this.collectionType.getSimpleName().toLowerCase(), this.elementType, ((CollectionSupplier)this.getSupplier()).toString());
    }

    private static class PlusCollector<T>
    implements Collector<T> {
        private final Collector<T> left;
        private final Collector<T> right;

        public PlusCollector(Collector<T> left, Collector<T> right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
            return this.left.calculatePresence(consumer) && this.right.calculatePresence(consumer);
        }

        @Override
        public int size() {
            return this.left.size() + this.right.size();
        }

        @Override
        public ValueSupplier.Value<Void> collectEntries(ValueSupplier.ValueConsumer consumer, ValueCollector<T> collector, ImmutableCollection.Builder<T> dest) {
            ValueSupplier.Value<Void> leftValue = this.left.collectEntries(consumer, collector, dest);
            if (leftValue.isMissing()) {
                return leftValue;
            }
            ValueSupplier.Value<Void> rightValue = this.right.collectEntries(consumer, collector, dest);
            if (rightValue.isMissing()) {
                return rightValue;
            }
            return ValueSupplier.Value.present().withSideEffect(ValueSupplier.SideEffect.fixedFrom(leftValue)).withSideEffect(ValueSupplier.SideEffect.fixedFrom(rightValue));
        }

        @Override
        public void calculateExecutionTimeValue(Action<? super ValueSupplier.ExecutionTimeValue<? extends Iterable<? extends T>>> visitor) {
            this.left.calculateExecutionTimeValue(visitor);
            this.right.calculateExecutionTimeValue(visitor);
        }

        @Override
        public ValueSupplier.ValueProducer getProducer() {
            return this.left.getProducer().plus(this.right.getProducer());
        }
    }

    private static class CollectingProvider<T, C extends Collection<? extends T>>
    extends AbstractMinimalProvider<C> {
        private final Class<C> type;
        private final List<ProviderInternal<? extends Iterable<? extends T>>> providers;
        private final Supplier<ImmutableCollection.Builder<T>> collectionFactory;

        public CollectingProvider(Class<C> type, List<ProviderInternal<? extends Iterable<? extends T>>> providers, Supplier<ImmutableCollection.Builder<T>> collectionFactory) {
            this.type = type;
            this.providers = providers;
            this.collectionFactory = collectionFactory;
        }

        @Override
        @Nullable
        public Class<C> getType() {
            return this.type;
        }

        @Override
        public ValueSupplier.ExecutionTimeValue<? extends C> calculateExecutionTimeValue() {
            return ValueSupplier.ExecutionTimeValue.changingValue(this);
        }

        @Override
        protected ValueSupplier.Value<? extends C> calculateOwnValue(ValueSupplier.ValueConsumer consumer) {
            ImmutableCollection.Builder<T> builder = this.collectionFactory.get();
            ValueSupplier.SideEffectBuilder sideEffectBuilder = ValueSupplier.SideEffect.builder();
            for (ProviderInternal<Iterable<T>> provider : this.providers) {
                ValueSupplier.Value<Iterable<T>> value = provider.calculateValue(consumer);
                if (value.isMissing()) {
                    return ValueSupplier.Value.missing();
                }
                builder.addAll(value.getWithoutSideEffect());
                sideEffectBuilder.add(ValueSupplier.SideEffect.fixedFrom(value));
            }
            ValueSupplier.Value<Collection> resultValue = ValueSupplier.Value.of((Collection)Cast.uncheckedNonnullCast((Object)builder.build()));
            return resultValue.withSideEffect(sideEffectBuilder.build());
        }
    }

    private class CollectingSupplier
    implements CollectionSupplier<T, C> {
        private final Collector<T> value;

        public CollectingSupplier(Collector<T> value) {
            this.value = value;
        }

        @Override
        public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
            return this.value.calculatePresence(consumer);
        }

        @Override
        public ValueSupplier.Value<C> calculateValue(ValueSupplier.ValueConsumer consumer) {
            ImmutableCollection.Builder builder = (ImmutableCollection.Builder)AbstractCollectionProperty.this.collectionFactory.get();
            ValueSupplier.Value<Void> result = this.value.collectEntries(consumer, AbstractCollectionProperty.this.valueCollector, builder);
            if (result.isMissing()) {
                return result.asType();
            }
            return ValueSupplier.Value.of((Collection)Cast.uncheckedNonnullCast((Object)builder.build())).withSideEffect(ValueSupplier.SideEffect.fixedFrom(result));
        }

        @Override
        public CollectionSupplier<T, C> plus(Collector<T> collector) {
            return new CollectingSupplier(new PlusCollector(this.value, collector));
        }

        @Override
        public ValueSupplier.ExecutionTimeValue<? extends C> calculateExecutionTimeValue() {
            ArrayList values = new ArrayList();
            this.value.calculateExecutionTimeValue(values::add);
            boolean fixed = true;
            boolean changingContent = false;
            for (ValueSupplier.ExecutionTimeValue value : values) {
                if (value.isMissing()) {
                    return ValueSupplier.ExecutionTimeValue.missing();
                }
                if (value.isChangingValue()) {
                    fixed = false;
                }
                changingContent |= value.hasChangingContent();
            }
            if (fixed) {
                ImmutableCollection.Builder builder = (ImmutableCollection.Builder)AbstractCollectionProperty.this.collectionFactory.get();
                ValueSupplier.SideEffectBuilder sideEffectBuilder = ValueSupplier.SideEffect.builder();
                for (ValueSupplier.ExecutionTimeValue value : values) {
                    builder.addAll((Iterable)value.getFixedValue());
                    sideEffectBuilder.add(ValueSupplier.SideEffect.fixedFrom(value));
                }
                ValueSupplier.ExecutionTimeValue<Collection> mergedValue = ValueSupplier.ExecutionTimeValue.fixedValue((Collection)Cast.uncheckedNonnullCast((Object)builder.build()));
                if (changingContent) {
                    mergedValue = mergedValue.withChangingContent();
                }
                return mergedValue.withSideEffect(sideEffectBuilder.build());
            }
            ArrayList providers = new ArrayList(values.size());
            for (ValueSupplier.ExecutionTimeValue value : values) {
                providers.add(value.toProvider());
            }
            return ValueSupplier.ExecutionTimeValue.changingValue(new CollectingProvider(AbstractCollectionProperty.this.getType(), providers, AbstractCollectionProperty.this.collectionFactory));
        }

        @Override
        public ValueSupplier.ValueProducer getProducer() {
            return this.value.getProducer();
        }
    }

    private static class FixedSupplier<T, C extends Collection<? extends T>>
    implements CollectionSupplier<T, C> {
        private final C value;
        private final ValueSupplier.SideEffect<? super C> sideEffect;

        public FixedSupplier(C value, @Nullable ValueSupplier.SideEffect<? super C> sideEffect) {
            this.value = value;
            this.sideEffect = sideEffect;
        }

        @Override
        public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
            return true;
        }

        @Override
        public ValueSupplier.Value<? extends C> calculateValue(ValueSupplier.ValueConsumer consumer) {
            return ValueSupplier.Value.of(this.value).withSideEffect(this.sideEffect);
        }

        @Override
        public CollectionSupplier<T, C> plus(Collector<T> collector) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ValueSupplier.ExecutionTimeValue<? extends C> calculateExecutionTimeValue() {
            return ValueSupplier.ExecutionTimeValue.fixedValue(this.value).withSideEffect(this.sideEffect);
        }

        @Override
        public ValueSupplier.ValueProducer getProducer() {
            return ValueSupplier.ValueProducer.unknown();
        }
    }

    private class EmptySupplier
    implements CollectionSupplier<T, C> {
        private EmptySupplier() {
        }

        @Override
        public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
            return true;
        }

        @Override
        public ValueSupplier.Value<? extends C> calculateValue(ValueSupplier.ValueConsumer consumer) {
            return ValueSupplier.Value.of(AbstractCollectionProperty.this.emptyCollection());
        }

        @Override
        public CollectionSupplier<T, C> plus(Collector<T> collector) {
            return new CollectingSupplier(collector);
        }

        @Override
        public ValueSupplier.ExecutionTimeValue<? extends C> calculateExecutionTimeValue() {
            return ValueSupplier.ExecutionTimeValue.fixedValue(AbstractCollectionProperty.this.emptyCollection());
        }

        @Override
        public ValueSupplier.ValueProducer getProducer() {
            return ValueSupplier.ValueProducer.noProducer();
        }
    }

    static class NoValueSupplier<T, C extends Collection<? extends T>>
    implements CollectionSupplier<T, C> {
        private final ValueSupplier.Value<? extends C> value;

        public NoValueSupplier(ValueSupplier.Value<? extends C> value) {
            assert (value.isMissing());
            this.value = value.asType();
        }

        @Override
        public boolean calculatePresence(ValueSupplier.ValueConsumer consumer) {
            return false;
        }

        @Override
        public ValueSupplier.Value<? extends C> calculateValue(ValueSupplier.ValueConsumer consumer) {
            return this.value;
        }

        @Override
        public CollectionSupplier<T, C> plus(Collector<T> collector) {
            return this;
        }

        @Override
        public ValueSupplier.ExecutionTimeValue<? extends C> calculateExecutionTimeValue() {
            return ValueSupplier.ExecutionTimeValue.missing();
        }

        @Override
        public ValueSupplier.ValueProducer getProducer() {
            return ValueSupplier.ValueProducer.unknown();
        }
    }
}

