/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.handlers;

import io.quarkus.vertx.http.runtime.handlers.DevClasspathStaticHandlerOptions;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.impl.MimeMapping;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;

public class DevStaticHandler
implements Handler<RoutingContext> {
    private static final Logger LOG = Logger.getLogger(DevStaticHandler.class);
    private static final int HTTP_STATUS_OK = 200;
    private static final int HTTP_STATUS_NO_CONTENT = 204;
    private static final String ALLOW_HEADER = "Allow";
    private static final String ALLOW_HEADER_VALUE = "HEAD,GET,OPTIONS";
    private final Set<String> generatedClasspathResources;
    private final Map<String, String> generatedFilesResources;
    private final Set<String> compressedMediaTypes;
    private final ClassLoader currentClassLoader;
    private final boolean enableCompression;
    private final String indexPage;
    private final Charset defaultEncoding;

    public DevStaticHandler(Set<String> generatedClasspathResources, Map<String, String> generatedFilesResources, DevClasspathStaticHandlerOptions options) {
        this.generatedClasspathResources = generatedClasspathResources;
        this.generatedFilesResources = generatedFilesResources;
        this.compressedMediaTypes = options.getCompressMediaTypes();
        this.currentClassLoader = Thread.currentThread().getContextClassLoader();
        this.enableCompression = options.isEnableCompression();
        this.indexPage = options.getIndexPage();
        this.defaultEncoding = options.getDefaultEncoding();
    }

    public void handle(RoutingContext context) {
        boolean containsGeneratedResource;
        String path;
        String resolvedPath = DevStaticHandler.resolvePath(context);
        String string = path = resolvedPath.endsWith("/") ? resolvedPath.concat(this.indexPage) : resolvedPath;
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Handling request for path '%s'", (Object)path);
        }
        boolean bl = containsGeneratedResource = this.generatedClasspathResources.contains(path) || this.generatedFilesResources.containsKey(path);
        if (!containsGeneratedResource) {
            DevStaticHandler.beforeNextHandler(this.currentClassLoader, context);
            return;
        }
        if (context.request().method().equals((Object)HttpMethod.OPTIONS)) {
            context.response().putHeader(ALLOW_HEADER, ALLOW_HEADER_VALUE).setStatusCode(204).send();
            return;
        }
        this.compressIfNeeded(context, path);
        if (this.generatedFilesResources.containsKey(path)) {
            context.vertx().fileSystem().readFile(this.generatedFilesResources.get(path), r -> {
                if (r.succeeded()) {
                    this.handleAsyncResultSucceeded(context, (Buffer)r.result(), path);
                } else {
                    context.fail(r.cause());
                }
            });
            return;
        }
        context.vertx().executeBlocking(future -> {
            try {
                byte[] content = this.getClasspathResourceContent(path);
                future.complete((Object)content);
            }
            catch (Exception e) {
                future.fail((Throwable)e);
            }
        }, asyncResult -> {
            if (asyncResult.succeeded()) {
                byte[] result = (byte[])asyncResult.result();
                this.handleAsyncResultSucceeded(context, result == null ? null : Buffer.buffer((byte[])result), path);
            } else {
                context.fail(asyncResult.cause());
            }
        });
    }

    private void handleAsyncResultSucceeded(RoutingContext context, Buffer result, String path) {
        if (result == null) {
            LOG.warnf("The '%s' file does not contain any content. Proceeding to the next handler if it exists", (Object)path);
            DevStaticHandler.beforeNextHandler(this.currentClassLoader, context);
            return;
        }
        String contentType = MimeMapping.getMimeTypeForFilename((String)path);
        if (contentType != null) {
            if (contentType.startsWith("text")) {
                context.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)(contentType + ";charset=" + String.valueOf(this.defaultEncoding)));
            } else {
                context.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)contentType);
            }
        }
        if (context.request().method().equals((Object)HttpMethod.HEAD)) {
            this.handleHeadMethod(context, result);
        } else {
            context.response().send(result);
        }
    }

    private void handleHeadMethod(RoutingContext context, Buffer content) {
        context.response().putHeader(HttpHeaders.CONTENT_LENGTH, (CharSequence)Long.toString(content.length()));
        context.response().setStatusCode(200).end();
    }

    private byte[] getClasspathResourceContent(String name) {
        byte[] byArray;
        block9: {
            String resourceName = "META-INF/resources" + name;
            URL resource = this.getClassLoader().getResource(resourceName);
            if (resource == null) {
                LOG.warnf("The resource '%s' does not exist on classpath", (Object)resourceName);
                return null;
            }
            InputStream inputStream = resource.openStream();
            try {
                byArray = inputStream.readAllBytes();
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOG.error((Object)("Error while reading file from Classpath for path " + resourceName), (Throwable)e);
                    return null;
                }
            }
            inputStream.close();
        }
        return byArray;
    }

    private static String resolvePath(RoutingContext ctx) {
        return ctx.mountPoint() == null ? ctx.normalizedPath() : ctx.normalizedPath().substring(ctx.mountPoint().endsWith("/") ? ctx.mountPoint().length() - 1 : ctx.mountPoint().length());
    }

    private static void beforeNextHandler(ClassLoader cl, RoutingContext ctx) {
        Thread.currentThread().setContextClassLoader(cl);
        ctx.next();
    }

    private void compressIfNeeded(RoutingContext ctx, String path) {
        if (this.enableCompression && this.isCompressed(path)) {
            ctx.response().headers().remove(HttpHeaders.CONTENT_ENCODING);
        }
    }

    private boolean isCompressed(String path) {
        if (this.compressedMediaTypes.isEmpty()) {
            return false;
        }
        String resourcePath = path.endsWith("/") ? path + this.indexPage : path;
        String contentType = MimeMapping.getMimeTypeForFilename((String)resourcePath);
        return contentType != null && this.compressedMediaTypes.contains(contentType);
    }

    private ClassLoader getClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        if (cl == null) {
            cl = Object.class.getClassLoader();
        }
        return cl;
    }
}

