/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor.actions;

import java.awt.event.ActionEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.indent.api.Indent;
import org.openide.util.Exceptions;

public abstract class InsertSemicolonAction
extends BaseAction {
    private static final String SEMICOLON = ";";
    private final NewLineProcessor newLineProcessor;

    protected InsertSemicolonAction(NewLineProcessor newLineProcessor) {
        this.newLineProcessor = newLineProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent evt, final JTextComponent target) {
        if (target.isEditable() && target.isEnabled()) {
            final BaseDocument doc = (BaseDocument)target.getDocument();
            final Indent indenter = Indent.get((Document)doc);
            indenter.lock();
            try {
                final class R
                implements Runnable {
                    R() {
                    }

                    @Override
                    public void run() {
                        try {
                            Caret caret = target.getCaret();
                            int caretPosition = caret.getDot();
                            int eolOffset = Utilities.getRowEnd((JTextComponent)target, (int)caretPosition);
                            doc.insertString(eolOffset, InsertSemicolonAction.SEMICOLON, null);
                            InsertSemicolonAction.this.newLineProcessor.processNewLine(eolOffset, caret, indenter);
                        }
                        catch (BadLocationException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }
                doc.runAtomicAsUser((Runnable)new R());
            }
            finally {
                indenter.unlock();
            }
        }
    }

    public static enum NewLineProcessor {
        WITH_NEW_LINE{

            @Override
            public void processNewLine(int endOfLineOffset, Caret caret, Indent indenter) throws BadLocationException {
                int newCaretPosition = indenter.indentNewLine(endOfLineOffset + InsertSemicolonAction.SEMICOLON.length());
                caret.setDot(newCaretPosition);
            }
        }
        ,
        WITHOUT_NEW_LINE{

            @Override
            public void processNewLine(int endOfLineOffset, Caret caret, Indent indenter) throws BadLocationException {
            }
        };


        public abstract void processNewLine(int var1, Caret var2, Indent var3) throws BadLocationException;
    }

    public static class CompleteLine
    extends InsertSemicolonAction {
        static final String ACTION_NAME = "complete-line";

        public CompleteLine() {
            super(NewLineProcessor.WITHOUT_NEW_LINE);
        }
    }

    public static class CompleteLineNewLine
    extends InsertSemicolonAction {
        static final String ACTION_NAME = "complete-line-newline";

        public CompleteLineNewLine() {
            super(NewLineProcessor.WITH_NEW_LINE);
        }
    }
}

