/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetVolumeGroupBackupRequest
extends BmcRequest<Void> {
    private String volumeGroupBackupId;

    public String getVolumeGroupBackupId() {
        return this.volumeGroupBackupId;
    }

    public Builder toBuilder() {
        return new Builder().volumeGroupBackupId(this.volumeGroupBackupId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",volumeGroupBackupId=").append(String.valueOf(this.volumeGroupBackupId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetVolumeGroupBackupRequest)) {
            return false;
        }
        GetVolumeGroupBackupRequest other = (GetVolumeGroupBackupRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.volumeGroupBackupId, other.volumeGroupBackupId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.volumeGroupBackupId == null ? 43 : this.volumeGroupBackupId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetVolumeGroupBackupRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String volumeGroupBackupId = null;

        public Builder volumeGroupBackupId(String volumeGroupBackupId) {
            this.volumeGroupBackupId = volumeGroupBackupId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetVolumeGroupBackupRequest o) {
            this.volumeGroupBackupId(o.getVolumeGroupBackupId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetVolumeGroupBackupRequest build() {
            GetVolumeGroupBackupRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetVolumeGroupBackupRequest buildWithoutInvocationCallback() {
            GetVolumeGroupBackupRequest request = new GetVolumeGroupBackupRequest();
            request.volumeGroupBackupId = this.volumeGroupBackupId;
            return request;
        }
    }
}

