/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.dlg;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import org.netbeans.modules.db.explorer.dlg.ColumnItem;
import org.openide.util.NbBundle;

public class DataModel
extends AbstractTableModel {
    private List<ColumnItem> data;
    private transient List<ColumnItem> primaryKeys = new ArrayList<ColumnItem>();
    private transient List<ColumnItem> uniqueKeys = new ArrayList<ColumnItem>();
    static final long serialVersionUID = 4162743695966976536L;

    public DataModel() {
        this.data = new ArrayList<ColumnItem>(1);
    }

    public List getData() {
        return this.data;
    }

    @Override
    public int getColumnCount() {
        return ColumnItem.getProperties().size();
    }

    @Override
    public int getRowCount() {
        return this.data.size();
    }

    public Object getValue(String pname, int row) {
        ColumnItem xcol = this.data.get(row);
        return xcol.getProperty(pname);
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this.getValue((String)ColumnItem.getColumnNames().elementAt(col), row);
    }

    public void setValue(Object val, String pname, int row) {
        if (row < this.getRowCount()) {
            int srow = row;
            int erow = row;
            ColumnItem xcol = this.data.get(row);
            xcol.setProperty(pname, val);
            if (pname.equals("pkey")) {
                if (val.equals(Boolean.TRUE)) {
                    if (xcol.allowsNull()) {
                        xcol.setProperty("nullable", Boolean.FALSE);
                    }
                    if (!xcol.isIndexed()) {
                        xcol.setProperty("idx", Boolean.TRUE);
                    }
                    if (!xcol.isUnique()) {
                        xcol.setProperty("unique", Boolean.TRUE);
                    }
                    this.primaryKeys.add(xcol);
                } else {
                    this.primaryKeys.remove(xcol);
                }
            }
            if (pname.equals("nullable") && val.equals(Boolean.TRUE) && xcol.isPrimaryKey()) {
                xcol.setProperty("pkey", Boolean.FALSE);
            }
            if (pname.equals("idx") && val.equals(Boolean.FALSE)) {
                if (xcol.isUnique()) {
                    xcol.setProperty("unique", Boolean.FALSE);
                }
                if (xcol.isPrimaryKey()) {
                    xcol.setProperty("pkey", Boolean.FALSE);
                }
            }
            if (pname.equals("unique")) {
                if (val.equals(Boolean.TRUE)) {
                    if (!xcol.isIndexed()) {
                        xcol.setProperty("idx", Boolean.TRUE);
                    }
                } else {
                    if (xcol.isPrimaryKey()) {
                        xcol.setProperty("pkey", Boolean.FALSE);
                    }
                    if (xcol.isIndexed()) {
                        xcol.setProperty("idx", Boolean.FALSE);
                    }
                }
            }
            this.fireTableRowsUpdated(srow, erow);
        }
    }

    @Override
    public void setValueAt(Object val, int row, int col) {
        if (row == -1 || col == -1) {
            return;
        }
        if (row < this.getRowCount() && col < this.getColumnCount()) {
            String pname = (String)ColumnItem.getColumnNames().elementAt(col);
            this.setValue(val, pname, row);
        }
    }

    @Override
    public String getColumnName(int col) {
        return NbBundle.getMessage(DataModel.class, (String)("CreateTable_" + col));
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    public boolean isTablePrimaryKey() {
        return this.primaryKeys.size() > 1;
    }

    public List<ColumnItem> getTablePrimaryKeys() {
        return this.primaryKeys;
    }

    public List<ColumnItem> getTableUniqueKeys() {
        return this.uniqueKeys;
    }

    public boolean isTableUniqueKey() {
        return this.uniqueKeys.size() > 1;
    }

    public void addRow(ColumnItem object) {
        this.data.add(object);
        this.addToKeyLists(object);
        this.fireTableChanged(new TableModelEvent(this, this.getRowCount() - 1, this.getRowCount() - 1, -1, 1));
    }

    public void insertRow(int row, ColumnItem item) {
        this.data.add(row, item);
        this.addToKeyLists(item);
        this.fireTableRowsInserted(row, row);
    }

    public void removeRow(int row) {
        if (row >= this.data.size()) {
            return;
        }
        ColumnItem column = this.data.get(row);
        if (column != null) {
            this.primaryKeys.remove(column);
            this.uniqueKeys.remove(column);
        }
        this.data.remove(row);
        this.fireTableRowsDeleted(row, row);
    }

    public ColumnItem getRow(int rowIndex) {
        return this.data.get(rowIndex);
    }

    private void addToKeyLists(ColumnItem item) {
        if (item.isPrimaryKey()) {
            this.primaryKeys.add(item);
        } else if (item.isUnique()) {
            this.uniqueKeys.add(item);
        }
    }
}

