/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen.java.support;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.Parameterizable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.websvc.saas.codegen.java.support.AbstractTask;
import org.netbeans.modules.websvc.saas.codegen.java.support.JavaUtil;
import org.netbeans.modules.websvc.saas.codegen.java.support.SourceGroupSupport;
import org.openide.ErrorManager;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Parameters;

public class JavaSourceHelper {
    static final String CLASS_TEMPLATE = "Templates/Classes/Class.java";
    static final String INTERFACE_TEMPLATE = "Templates/Classes/Interface.java";
    static final String JAVA_EXT = "java";

    public static List<JavaSource> getJavaSources(Project project) {
        SourceGroup[] groups;
        ArrayList<JavaSource> result = new ArrayList<JavaSource>();
        for (SourceGroup group : groups = SourceGroupSupport.getJavaSourceGroups(project)) {
            FileObject root = group.getRootFolder();
            Enumeration files = root.getData(true);
            while (files.hasMoreElements()) {
                FileObject fobj = (FileObject)files.nextElement();
                if (!fobj.getExt().equals(JAVA_EXT)) continue;
                JavaSource source = JavaSource.forFileObject((FileObject)fobj);
                result.add(source);
            }
        }
        return result;
    }

    public static List<JavaSource> getEntityClasses(Project project) {
        List<JavaSource> sources = JavaSourceHelper.getJavaSources(project);
        ArrayList<JavaSource> entityClasses = new ArrayList<JavaSource>();
        for (JavaSource source : sources) {
            if (!JavaSourceHelper.isEntity(source)) continue;
            entityClasses.add(source);
        }
        return entityClasses;
    }

    public static boolean isEntity(JavaSource source) {
        final boolean[] isBoolean = new boolean[1];
        try {
            source.runUserActionTask((Task)new AbstractTask<CompilationController>(){

                public void run(CompilationController controller) throws IOException {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TypeElement classElement = JavaSourceHelper.getTopLevelClassElement(controller);
                    if (classElement == null) {
                        return;
                    }
                    List<? extends AnnotationMirror> annotations = controller.getElements().getAllAnnotationMirrors(classElement);
                    for (AnnotationMirror annotationMirror : annotations) {
                        if (!annotationMirror.toString().equals("@javax.persistence.Entity")) continue;
                        isBoolean[0] = true;
                        break;
                    }
                }
            }, true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return isBoolean[0];
    }

    public static String getClassNameQuietly(JavaSource source) {
        try {
            return JavaSourceHelper.getClassName(source);
        }
        catch (IOException ioe) {
            Logger.getLogger(JavaSourceHelper.class.getName()).log(Level.WARNING, ioe.getLocalizedMessage());
            return null;
        }
    }

    public static String getClassName(JavaSource source) throws IOException {
        return JavaSourceHelper.getTypeElement(source).getSimpleName().toString();
    }

    public static String getClassType(JavaSource source) throws IOException {
        return JavaSourceHelper.getTypeElement(source).getQualifiedName().toString();
    }

    public static String getPackageName(JavaSource source) {
        if (source == null) {
            return "";
        }
        final String[] packageName = new String[1];
        try {
            source.runUserActionTask((Task)new AbstractTask<CompilationController>(){

                public void run(CompilationController controller) throws IOException {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    ExpressionTree packageTree = controller.getCompilationUnit().getPackageName();
                    if (packageTree != null) {
                        packageName[0] = packageTree.toString();
                    }
                }
            }, true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return packageName[0];
    }

    public static String getIdFieldName(JavaSource source) {
        final String[] fieldName = new String[1];
        try {
            source.runUserActionTask((Task)new AbstractTask<CompilationController>(){

                public void run(CompilationController controller) throws IOException {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TypeElement classElement = JavaSourceHelper.getTopLevelClassElement(controller);
                    List<VariableElement> fields = ElementFilter.fieldsIn(classElement.getEnclosedElements());
                    for (VariableElement field : fields) {
                        List<? extends AnnotationMirror> annotations = field.getAnnotationMirrors();
                        for (AnnotationMirror annotationMirror : annotations) {
                            if (!annotationMirror.toString().equals("@javax.persistence.Id")) continue;
                            fieldName[0] = field.getSimpleName().toString();
                            return;
                        }
                    }
                }
            }, true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return fieldName[0];
    }

    public static ClassTree getTopLevelClassTree(CompilationController controller) {
        String className = controller.getFileObject().getName();
        CompilationUnitTree cu = controller.getCompilationUnit();
        if (cu != null) {
            List<? extends Tree> decls = cu.getTypeDecls();
            for (Tree tree : decls) {
                ClassTree classTree;
                if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind()) || !(classTree = (ClassTree)tree).getSimpleName().contentEquals(className) || !classTree.getModifiers().getFlags().contains((Object)Modifier.PUBLIC)) continue;
                return classTree;
            }
        }
        return null;
    }

    public static TypeElement getTopLevelClassElement(CompilationController controller) {
        ClassTree classTree = JavaSourceHelper.getTopLevelClassTree(controller);
        if (classTree == null) {
            return null;
        }
        Trees trees = controller.getTrees();
        TreePath path = trees.getPath(controller.getCompilationUnit(), classTree);
        return (TypeElement)trees.getElement(path);
    }

    public static Collection<String> getImports(CompilationController controller) {
        HashSet<String> imports = new HashSet<String>();
        CompilationUnitTree cu = controller.getCompilationUnit();
        if (cu != null) {
            List<? extends ImportTree> importTrees = cu.getImports();
            for (ImportTree importTree : importTrees) {
                imports.add(importTree.getQualifiedIdentifier().toString());
            }
        }
        return imports;
    }

    public static MethodTree getDefaultConstructor(CompilationController controller) {
        TypeElement classElement = JavaSourceHelper.getTopLevelClassElement(controller);
        List<ExecutableElement> constructors = ElementFilter.constructorsIn(classElement.getEnclosedElements());
        for (ExecutableElement constructor : constructors) {
            if (constructor.getParameters().size() != 0) continue;
            return controller.getTrees().getTree(constructor);
        }
        return null;
    }

    public static MethodTree getMethodByName(CompilationController controller, String methodName) {
        TypeElement classElement = JavaSourceHelper.getTopLevelClassElement(controller);
        List<ExecutableElement> methods = ElementFilter.methodsIn(classElement.getEnclosedElements());
        ArrayList<MethodTree> found = new ArrayList<MethodTree>();
        for (ExecutableElement method : methods) {
            if (!method.getSimpleName().toString().equals(methodName)) continue;
            found.add(controller.getTrees().getTree(method));
        }
        if (found.size() > 1) {
            throw new IllegalArgumentException("Unexpected overloading methods of '" + methodName + "' found.");
        }
        if (found.size() == 1) {
            return (MethodTree)found.get(0);
        }
        return null;
    }

    public static VariableTree getField(CompilationController controller, String fieldName) {
        TypeElement classElement = JavaSourceHelper.getTopLevelClassElement(controller);
        List<VariableElement> fields = ElementFilter.fieldsIn(classElement.getEnclosedElements());
        for (VariableElement field : fields) {
            if (!field.getSimpleName().toString().equals(fieldName)) continue;
            return (VariableTree)controller.getTrees().getTree(field);
        }
        return null;
    }

    public static JavaSource createJavaSource(FileObject targetFolder, String packageName, String className) {
        return JavaSourceHelper.createJavaSource(CLASS_TEMPLATE, targetFolder, packageName, className);
    }

    public static JavaSource createJavaSource(String template, FileObject targetFolder, String packageName, String className) {
        try {
            FileObject fobj = targetFolder.getFileObject(className, JAVA_EXT);
            if (fobj == null) {
                fobj = JavaSourceHelper.createDataObjectFromTemplate(template, targetFolder, packageName, className).getPrimaryFile();
            }
            return JavaSource.forFileObject((FileObject)fobj);
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            return null;
        }
    }

    private static DataObject createDataObjectFromTemplate(String template, FileObject targetFolder, String packageName, String targetName) throws IOException {
        assert (template != null);
        assert (targetFolder != null);
        assert (targetName != null && targetName.trim().length() > 0);
        FileObject templateFO = FileUtil.getConfigFile((String)template);
        DataObject templateDO = DataObject.find((FileObject)templateFO);
        DataFolder dataFolder = DataFolder.findFolder((FileObject)targetFolder);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("package", packageName);
        return templateDO.createFromTemplate(dataFolder, targetName, params);
    }

    public static void addClassAnnotation(WorkingCopy copy, String[] annotations, Object[] annotationAttrs) {
        TreeMaker maker = copy.getTreeMaker();
        ClassTree tree = JavaSourceHelper.getTopLevelClassTree((CompilationController)copy);
        ModifiersTree modifiers = tree.getModifiers();
        for (int i = 0; i < annotations.length; ++i) {
            List attrTrees = null;
            Object attr = annotationAttrs[i];
            if (attr != null) {
                attrTrees = new ArrayList();
                if (attr instanceof ExpressionTree) {
                    attrTrees.add((ExpressionTree)attr);
                } else {
                    attrTrees.add(maker.Literal(attr));
                }
            } else {
                attrTrees = Collections.emptyList();
            }
            AnnotationTree newAnnotation = maker.Annotation((Tree)maker.Identifier((CharSequence)annotations[i]), attrTrees);
            if (modifiers == null) continue;
            modifiers = maker.addModifiersAnnotation(modifiers, newAnnotation);
        }
        copy.rewrite((Tree)tree.getModifiers(), (Tree)modifiers);
    }

    public static void addImports(WorkingCopy copy, String[] imports) {
        CompilationUnitTree tree;
        Collection<String> existingImports = JavaSourceHelper.getImports((CompilationController)copy);
        TreeMaker maker = copy.getTreeMaker();
        CompilationUnitTree modifiedTree = tree = copy.getCompilationUnit();
        for (String imp : imports) {
            if (existingImports.contains(imp)) continue;
            modifiedTree = maker.addCompUnitImport(modifiedTree, maker.Import((Tree)maker.Identifier((CharSequence)imp), false));
        }
        copy.rewrite((Tree)tree, (Tree)modifiedTree);
    }

    public static ClassTree addField(WorkingCopy copy, ClassTree tree, Modifier[] modifiers, String[] annotations, Object[] annotationAttrs, String name, Object type) {
        return JavaSourceHelper.addField(copy, tree, modifiers, annotations, annotationAttrs, name, type, null);
    }

    public static ClassTree addField(WorkingCopy copy, ClassTree tree, Modifier[] modifiers, String[] annotations, Object[] annotationAttrs, String name, Object type, Object initialValue) {
        TreeMaker maker = copy.getTreeMaker();
        ClassTree modifiedTree = tree;
        Tree typeTree = JavaSourceHelper.createTypeTree(copy, type);
        ModifiersTree modifiersTree = JavaSourceHelper.createModifiersTree(copy, modifiers, annotations, annotationAttrs);
        LiteralTree init = initialValue == null ? null : maker.Literal(initialValue);
        VariableTree variableTree = maker.Variable(modifiersTree, (CharSequence)name, typeTree, (ExpressionTree)init);
        return maker.insertClassMember(modifiedTree, 0, (Tree)variableTree);
    }

    public static void addFields(WorkingCopy copy, String[] names, Object[] types) {
        Object[] initValues = new Object[types.length];
        for (int i = 0; i < types.length; ++i) {
            Object type = types[i];
            initValues[i] = String.class.equals(type) || String.class.getName().equals(type) ? "" : (type instanceof Class && Number.class.isAssignableFrom((Class)type) ? Integer.valueOf(0) : null);
        }
        JavaSourceHelper.addFields(copy, names, types, initValues);
    }

    public static void addFields(WorkingCopy copy, String[] names, Object[] types, Object[] initialValues) {
        JavaSourceHelper.addFields(copy, names, types, initialValues, JavaUtil.PRIVATE);
    }

    public static void addConstants(WorkingCopy copy, String[] names, Object[] types, Object[] initialValues) {
        JavaSourceHelper.addFields(copy, names, types, initialValues, JavaUtil.PUBLIC_STATIC_FINAL);
    }

    public static void addFields(WorkingCopy copy, String[] names, Object[] types, Object[] initialValues, Modifier[] modifiers) {
        ClassTree classTree;
        TreeMaker maker = copy.getTreeMaker();
        ClassTree modifiedTree = classTree = JavaSourceHelper.getTopLevelClassTree((CompilationController)copy);
        String[] annotations = new String[]{};
        Object[] annotationAttrs = new Object[]{};
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            Object type = types[i];
            Object initialValue = initialValues[i];
            if (initialValue instanceof Enum) continue;
            Tree typeTree = JavaSourceHelper.createTypeTree(copy, type);
            ModifiersTree modifiersTree = JavaSourceHelper.createModifiersTree(copy, modifiers, annotations, annotationAttrs);
            LiteralTree init = initialValue == null ? null : maker.Literal(initialValue);
            VariableTree variableTree = maker.Variable(modifiersTree, (CharSequence)name, typeTree, (ExpressionTree)init);
            modifiedTree = maker.insertClassMember(modifiedTree, 0, (Tree)variableTree);
        }
        copy.rewrite((Tree)classTree, (Tree)modifiedTree);
    }

    public static ClassTree addConstructor(WorkingCopy copy, ClassTree tree, Modifier[] modifiers, String[] parameters, Object[] paramTypes, String bodyText, String comment) {
        TreeMaker maker = copy.getTreeMaker();
        ModifiersTree modifiersTree = JavaSourceHelper.createModifiersTree(copy, modifiers, null, null);
        ModifiersTree paramModTree = maker.Modifiers(Collections.emptySet());
        ArrayList<VariableTree> paramTrees = new ArrayList<VariableTree>();
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                paramTrees.add(maker.Variable(paramModTree, (CharSequence)parameters[i], JavaSourceHelper.createTypeTree(copy, paramTypes[i]), null));
            }
        }
        MethodTree methodTree = maker.Constructor(modifiersTree, Collections.emptyList(), paramTrees, Collections.emptyList(), bodyText);
        if (comment != null) {
            maker.addComment((Tree)methodTree, JavaSourceHelper.createJavaDocComment(comment), true);
        }
        return maker.addClassMember(tree, (Tree)methodTree);
    }

    public static void replaceFieldValue(WorkingCopy copy, VariableTree tree, String value) {
        TreeMaker maker = copy.getTreeMaker();
        VariableTree modifiedTree = maker.Variable(tree.getModifiers(), (CharSequence)tree.getName(), tree.getType(), (ExpressionTree)maker.Literal((Object)value));
        copy.rewrite((Tree)tree, (Tree)modifiedTree);
    }

    public static void replaceMethodBody(WorkingCopy copy, MethodTree tree, String body) {
        TreeMaker maker = copy.getTreeMaker();
        MethodTree modifiedTree = maker.Method(tree.getModifiers(), (CharSequence)tree.getName(), tree.getReturnType(), tree.getTypeParameters(), tree.getParameters(), tree.getThrows(), body, null);
        copy.rewrite((Tree)tree, (Tree)modifiedTree);
    }

    public static ClassTree addMethod(WorkingCopy copy, ClassTree tree, Modifier[] modifiers, String[] annotations, Object[] annotationAttrs, String name, Object returnType, String[] parameters, Object[] paramTypes, Object[] paramAnnotationsArray, Object[] paramAnnotationAttrsArray, String bodyText, String comment) {
        return JavaSourceHelper.addMethod(copy, tree, modifiers, annotations, annotationAttrs, name, returnType, parameters, paramTypes, paramAnnotationsArray, paramAnnotationAttrsArray, null, bodyText, comment);
    }

    public static ClassTree addMethod(WorkingCopy copy, ClassTree tree, Modifier[] modifiers, String[] annotations, Object[] annotationAttrs, String name, Object returnType, String[] parameters, Object[] paramTypes, Object[] paramAnnotationsArray, Object[] paramAnnotationAttrsArray, Object[] throwList, String bodyText, String comment) {
        TreeMaker maker = copy.getTreeMaker();
        ModifiersTree modifiersTree = JavaSourceHelper.createModifiersTree(copy, modifiers, annotations, annotationAttrs);
        Tree returnTypeTree = JavaSourceHelper.createTypeTree(copy, returnType);
        ArrayList<VariableTree> paramTrees = new ArrayList<VariableTree>();
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                ModifiersTree paramModTree = maker.Modifiers(Collections.emptySet());
                String[] paramAnnotations = null;
                Object[] paramAnnotationAttrs = null;
                if (paramAnnotationsArray != null && paramAnnotationsArray.length > 0) {
                    if (paramAnnotationsArray[i] instanceof String) {
                        paramAnnotations = new String[]{(String)paramAnnotationsArray[i]};
                        paramAnnotationAttrs = new Object[]{paramAnnotationAttrsArray[i]};
                    } else {
                        paramAnnotations = (String[])paramAnnotationsArray[i];
                        paramAnnotationAttrs = (Object[])paramAnnotationAttrsArray[i];
                    }
                    if (paramAnnotations != null) {
                        paramModTree = JavaSourceHelper.createModifiersTree(copy, new Modifier[0], paramAnnotations, paramAnnotationAttrs);
                    }
                }
                paramTrees.add(maker.Variable(paramModTree, (CharSequence)parameters[i], JavaSourceHelper.createTypeTree(copy, paramTypes[i]), null));
            }
        }
        List<ExpressionTree> throwsExpressions = JavaSourceHelper.createThrowTrees(copy, throwList);
        MethodTree methodTree = maker.Method(modifiersTree, (CharSequence)name, returnTypeTree, Collections.emptyList(), paramTrees, throwsExpressions, bodyText, null);
        if (comment != null) {
            maker.addComment((Tree)methodTree, JavaSourceHelper.createJavaDocComment(comment), true);
        }
        return maker.addClassMember(tree, (Tree)methodTree);
    }

    public static AssignmentTree createAssignmentTree(WorkingCopy copy, String variable, Object value) {
        TreeMaker maker = copy.getTreeMaker();
        return maker.Assignment((ExpressionTree)maker.Identifier((CharSequence)variable), (ExpressionTree)maker.Literal(value));
    }

    private static Tree createTypeTree(WorkingCopy copy, Object type) {
        if (type instanceof String) {
            String typeString = (String)type;
            if (typeString.indexOf("<") != -1) {
                return JavaSourceHelper.createParameterizedTypeTree(copy, typeString);
            }
            TypeElement element = copy.getElements().getTypeElement(typeString);
            if (element != null) {
                return copy.getTreeMaker().QualIdent((Element)element);
            }
            return copy.getTreeMaker().Identifier((CharSequence)typeString);
        }
        return (Tree)type;
    }

    public static Tree createIdentifierTree(WorkingCopy copy, String value) {
        return copy.getTreeMaker().Identifier((CharSequence)value);
    }

    private static Tree createParameterizedTypeTree(WorkingCopy copy, String parameterizedType) {
        int left = parameterizedType.indexOf("<");
        int right = parameterizedType.lastIndexOf(">");
        String genericType = parameterizedType.substring(0, left);
        String types = parameterizedType.substring(left + 1, right);
        StringTokenizer tokenizer = new StringTokenizer(types, ",");
        String[] typeArgs = new String[tokenizer.countTokens()];
        int count = 0;
        while (tokenizer.hasMoreTokens()) {
            typeArgs[count++] = tokenizer.nextToken();
        }
        return JavaSourceHelper.createParameterizedTypeTree(copy, genericType, typeArgs);
    }

    public static Tree createParameterizedTypeTree(WorkingCopy copy, String type, String[] typeArgs) {
        TreeMaker maker = copy.getTreeMaker();
        Tree typeTree = JavaSourceHelper.createTypeTree(copy, type);
        ArrayList<ExpressionTree> typeArgTrees = new ArrayList<ExpressionTree>();
        for (String arg : typeArgs) {
            typeArgTrees.add((ExpressionTree)JavaSourceHelper.createTypeTree(copy, arg));
        }
        return maker.ParameterizedType(typeTree, typeArgTrees);
    }

    private static ModifiersTree createModifiersTree(WorkingCopy copy, Modifier[] modifiers, String[] annotations, Object[] annotationAttrs) {
        TreeMaker maker = copy.getTreeMaker();
        EnumSet<Modifier> modifierSet = EnumSet.noneOf(Modifier.class);
        modifierSet.addAll(Arrays.asList(modifiers));
        List<AnnotationTree> annotationTrees = JavaSourceHelper.createAnnotationTrees(copy, annotations, annotationAttrs);
        return maker.Modifiers(modifierSet, annotationTrees);
    }

    private static List<AnnotationTree> createAnnotationTrees(WorkingCopy copy, String[] annotations, Object[] annotationAttrs) {
        TreeMaker maker = copy.getTreeMaker();
        List<AnnotationTree> annotationTrees = null;
        if (annotations != null) {
            annotationTrees = new ArrayList();
            for (int i = 0; i < annotations.length; ++i) {
                Object attr;
                String annotation = annotations[i];
                List expressionTrees = Collections.emptyList();
                if (annotationAttrs != null && (attr = annotationAttrs[i]) != null) {
                    expressionTrees = new ArrayList();
                    if (attr instanceof ExpressionTree) {
                        expressionTrees.add((ExpressionTree)attr);
                    } else {
                        expressionTrees.add(maker.Literal(attr));
                    }
                }
                annotationTrees.add(maker.Annotation(JavaSourceHelper.createTypeTree(copy, annotation), expressionTrees));
            }
        } else {
            annotationTrees = Collections.emptyList();
        }
        return annotationTrees;
    }

    private static List<ExpressionTree> createThrowTrees(WorkingCopy copy, Object[] throwList) {
        TreeMaker maker = copy.getTreeMaker();
        List<ExpressionTree> throwTrees = Collections.emptyList();
        if (throwList != null) {
            throwTrees = new ArrayList<ExpressionTree>();
            for (int i = 0; i < throwList.length; ++i) {
                Object throwType = throwList[i];
                TypeElement element = copy.getElements().getTypeElement((String)throwType);
                throwTrees.add(maker.QualIdent((Element)element));
            }
        }
        return throwTrees;
    }

    private static Comment createJavaDocComment(String text) {
        return Comment.create((Comment.Style)Comment.Style.JAVADOC, (int)-2, (int)-2, (int)-2, (String)text);
    }

    public static ClassTree findPublicTopLevelClass(CompilationController controller) throws IOException {
        controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
        String mainElementName = controller.getFileObject().getName();
        for (Tree tree : controller.getCompilationUnit().getTypeDecls()) {
            ClassTree classTree;
            if (!TreeUtilities.CLASS_TREE_KINDS.contains((Object)tree.getKind()) || !(classTree = (ClassTree)tree).getSimpleName().contentEquals(mainElementName) || !classTree.getModifiers().getFlags().contains((Object)Modifier.PUBLIC)) continue;
            return classTree;
        }
        return null;
    }

    public static boolean isInjectionTarget(CompilationController controller) throws IOException {
        Parameters.notNull((CharSequence)"controller", (Object)controller);
        ClassTree classTree = JavaSourceHelper.findPublicTopLevelClass(controller);
        if (classTree == null) {
            throw new IllegalArgumentException();
        }
        return JavaSourceHelper.isInjectionTarget(controller, JavaSourceHelper.getTypeElement(controller, classTree));
    }

    public static boolean isInjectionTarget(CompilationController controller, TypeElement typeElement) {
        FileObject fo = controller.getFileObject();
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        if (ElementKind.INTERFACE != typeElement.getKind()) {
            List<? extends AnnotationMirror> annotations = typeElement.getAnnotationMirrors();
            boolean found = false;
            for (AnnotationMirror annotationMirror : annotations) {
                Name qualifiedName = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName();
                if (qualifiedName.contentEquals("javax.jws.WebService")) {
                    found = true;
                    break;
                }
                if (!qualifiedName.contentEquals("javax.jws.WebServiceProvider")) continue;
                found = true;
                break;
            }
            if (found) {
                return true;
            }
        }
        return false;
    }

    public static TypeElement getTypeElement(CompilationController controller, ClassTree classTree) {
        TreePath classTreePath = controller.getTrees().getPath(controller.getCompilationUnit(), classTree);
        return (TypeElement)controller.getTrees().getElement(classTreePath);
    }

    public static TypeElement getTypeElement(CompilationController controller, TreePath treePath) {
        return (TypeElement)controller.getTrees().getElement(treePath);
    }

    public static ClassTree getClassTree(CompilationController controller, TypeElement typeElement) {
        return controller.getTrees().getTree(typeElement);
    }

    public static void saveSource(FileObject[] files) throws IOException {
        for (FileObject f : files) {
            try {
                DataObject dobj = DataObject.find((FileObject)f);
                SaveCookie sc = (SaveCookie)dobj.getCookie(SaveCookie.class);
                if (sc == null) continue;
                sc.save();
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
    }

    public static boolean isOfAnnotationType(AnnotationMirror am, String annotationType) {
        return annotationType.equals(am.toString().substring(1));
    }

    public static AnnotationMirror findAnnotation(List<? extends AnnotationMirror> anmirs, String annotationString) {
        for (AnnotationMirror annotationMirror : anmirs) {
            if (!JavaSourceHelper.isOfAnnotationType(annotationMirror, annotationString)) continue;
            return annotationMirror;
        }
        return null;
    }

    public static boolean annotationHasAttributeValue(AnnotationMirror am, String attr, String value) {
        return value.equals(am.getElementValues().get(attr));
    }

    public static boolean annotationHasAttributeValue(AnnotationMirror am, String value) {
        if (am != null) {
            for (AnnotationValue annotationValue : am.getElementValues().values()) {
                if (!value.equals(annotationValue.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    public static TypeElement getXmlRepresentationClass(TypeElement typeElement, String defaultSuffix) {
        List<ExecutableElement> methods = ElementFilter.methodsIn(typeElement.getEnclosedElements());
        for (ExecutableElement method : methods) {
            TypeElement returnType;
            TypeMirror tm;
            List<? extends AnnotationMirror> anmirs = method.getAnnotationMirrors();
            AnnotationMirror mirrorHttpMethod = JavaSourceHelper.findAnnotation(anmirs, "javax.ws.rs.GET");
            if (mirrorHttpMethod == null || (tm = method.getReturnType()) == null || tm.getKind() != TypeKind.DECLARED || !(returnType = (TypeElement)((DeclaredType)tm).asElement()).getSimpleName().toString().endsWith(defaultSuffix)) continue;
            return returnType;
        }
        return null;
    }

    public static TypeElement getTypeElement(JavaSource source) throws IOException {
        final TypeElement[] results = new TypeElement[1];
        source.runUserActionTask((Task)new AbstractTask<CompilationController>(){

            public void run(CompilationController controller) throws IOException {
                controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                results[0] = JavaSourceHelper.getTopLevelClassElement(controller);
            }
        }, true);
        return results[0];
    }

    public static JavaSource forTypeElement(TypeElement typeElement, Project project) throws IOException {
        for (JavaSource js : JavaSourceHelper.getJavaSources(project)) {
            String className = JavaSourceHelper.getClassType(js);
            if (!typeElement.getQualifiedName().contentEquals(className)) continue;
            return js;
        }
        return null;
    }

    public static List<? extends AnnotationMirror> getClassAnnotations(JavaSource source) {
        final List[] classAnons = new List[1];
        try {
            source.runUserActionTask((Task)new AbstractTask<CompilationController>(){

                public void run(CompilationController controller) throws IOException {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TypeElement classElement = JavaSourceHelper.getTopLevelClassElement(controller);
                    if (classElement == null) {
                        return;
                    }
                    classAnons[0] = controller.getElements().getAllAnnotationMirrors(classElement);
                }
            }, true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return classAnons[0];
    }

    public static List<? extends Tree> getAllTree(JavaSource source) {
        final List[] allTree = new List[1];
        try {
            source.runUserActionTask((Task)new AbstractTask<CompilationController>(){

                public void run(CompilationController controller) throws IOException {
                    String className = controller.getFileObject().getName();
                    CompilationUnitTree cu = controller.getCompilationUnit();
                    if (cu != null) {
                        allTree[0] = cu.getTypeDecls();
                    }
                }
            }, true);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return allTree[0];
    }

    public static List<VariableTree> getAllFields(JavaSource source) {
        final ArrayList<VariableTree> allFields = new ArrayList<VariableTree>();
        try {
            source.runUserActionTask((Task)new AbstractTask<CompilationController>(){

                public void run(CompilationController controller) throws IOException {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TypeElement classElement = JavaSourceHelper.getTopLevelClassElement(controller);
                    List<VariableElement> fields = ElementFilter.fieldsIn(classElement.getEnclosedElements());
                    for (VariableElement field : fields) {
                        allFields.add((VariableTree)controller.getTrees().getTree(field));
                    }
                }
            }, true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return allFields;
    }

    public static List<MethodTree> getAllConstuctors(JavaSource source) {
        final ArrayList<MethodTree> allConstuctors = new ArrayList<MethodTree>();
        try {
            source.runUserActionTask((Task)new AbstractTask<CompilationController>(){

                public void run(CompilationController controller) throws IOException {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TypeElement classElement = JavaSourceHelper.getTopLevelClassElement(controller);
                    List<ExecutableElement> constuctors = ElementFilter.constructorsIn(classElement.getEnclosedElements());
                    for (ExecutableElement constuctor : constuctors) {
                        allConstuctors.add(controller.getTrees().getTree(constuctor));
                    }
                }
            }, true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return allConstuctors;
    }

    public static List<MethodTree> getAllMethods(JavaSource source) {
        final ArrayList<MethodTree> allMethods = new ArrayList<MethodTree>();
        try {
            source.runUserActionTask((Task)new AbstractTask<CompilationController>(){

                public void run(CompilationController controller) throws IOException {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TypeElement classElement = JavaSourceHelper.getTopLevelClassElement(controller);
                    List<ExecutableElement> methods = ElementFilter.methodsIn(classElement.getEnclosedElements());
                    for (ExecutableElement method : methods) {
                        allMethods.add(controller.getTrees().getTree(method));
                    }
                }
            }, true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return allMethods;
    }

    public static Collection<String> getAnnotationValuesForAllMethods(JavaSource source, final String annotation) {
        final HashSet<String> results = new HashSet<String>();
        try {
            source.runUserActionTask((Task)new AbstractTask<CompilationController>(){

                public void run(CompilationController controller) throws IOException {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TypeElement classElement = JavaSourceHelper.getTopLevelClassElement(controller);
                    List<ExecutableElement> methods = ElementFilter.methodsIn(classElement.getEnclosedElements());
                    for (ExecutableElement method : methods) {
                        for (AnnotationMirror annotationMirror : method.getAnnotationMirrors()) {
                            if (!((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().contentEquals(annotation)) continue;
                            for (AnnotationValue annotationValue : annotationMirror.getElementValues().values()) {
                                results.add(annotationValue.getValue().toString());
                            }
                        }
                    }
                }
            }, true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return results;
    }

    public static long[] getPosition(JavaSource source, final String methodName) {
        final long[] position = new long[]{0L, 0L};
        try {
            source.runUserActionTask((Task)new AbstractTask<CompilationController>(){

                public void run(CompilationController controller) throws IOException {
                    controller.toPhase(JavaSource.Phase.RESOLVED);
                    TypeElement classElement = JavaSourceHelper.getTopLevelClassElement(controller);
                    CompilationUnitTree tree = controller.getCompilationUnit();
                    Trees trees = controller.getTrees();
                    Parameterizable element = null;
                    if (methodName == null) {
                        element = classElement;
                    } else {
                        List<ExecutableElement> methods = ElementFilter.methodsIn(classElement.getEnclosedElements());
                        for (ExecutableElement method : methods) {
                            if (!method.getSimpleName().toString().equals(methodName)) continue;
                            element = method;
                            break;
                        }
                    }
                    if (element != null) {
                        Tree elementTree = trees.getTree(element);
                        long pos = trees.getSourcePositions().getStartPosition(tree, elementTree);
                        position[0] = tree.getLineMap().getLineNumber(pos) - 1L;
                        position[1] = tree.getLineMap().getColumnNumber(pos) - 1L;
                    }
                }
            }, true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return position;
    }

    public static ExecutableElement getLongestContructor(JavaSource source) throws IOException {
        return JavaSourceHelper.getLongestContructor(JavaSourceHelper.getTypeElement(source));
    }

    public static ExecutableElement getLongestContructor(TypeElement typeElement) {
        List<ExecutableElement> constructors = ElementFilter.constructorsIn(typeElement.getEnclosedElements());
        int max = -1;
        ExecutableElement current = null;
        for (ExecutableElement constructor : constructors) {
            if (constructor.getParameters().size() <= max) continue;
            max = constructor.getParameters().size();
            current = constructor;
        }
        return current;
    }

    public static boolean isContainsConstuctor(JavaSource source, String[] paramNames, Object[] paramTypes) {
        String sign = JavaSourceHelper.createMethodSignature("", paramTypes);
        List<MethodTree> methods = JavaSourceHelper.getAllConstuctors(source);
        for (MethodTree m : methods) {
            if (!sign.equals(JavaSourceHelper.createMethodSignature(m, false))) continue;
            return true;
        }
        return false;
    }

    public static boolean isContainsMethod(JavaSource source, String methodName, String[] paramNames, Object[] paramTypes) {
        String sign = JavaSourceHelper.createMethodSignature(methodName, paramTypes);
        List<MethodTree> methods = JavaSourceHelper.getAllMethods(source);
        for (MethodTree m : methods) {
            if (!sign.equals(JavaSourceHelper.createMethodSignature(m))) continue;
            return true;
        }
        return false;
    }

    public static void getAvailableFieldSignature(JavaSource source, Map<String, String> map) {
        List<VariableTree> fields = JavaSourceHelper.getAllFields(source);
        for (VariableTree v : fields) {
            map.put(JavaSourceHelper.createFieldSignature(v), v.getName().toString());
        }
    }

    public static void getAvailableConstructorSignature(JavaSource source, Map<String, String> map) {
        List<MethodTree> constructors = JavaSourceHelper.getAllConstuctors(source);
        for (MethodTree c : constructors) {
            map.put(JavaSourceHelper.createMethodSignature(c, true), c.getName().toString());
        }
    }

    public static void getAvailableMethodSignature(JavaSource source, Map<String, String> map) {
        List<MethodTree> methods = JavaSourceHelper.getAllMethods(source);
        for (MethodTree m : methods) {
            map.put(JavaSourceHelper.createMethodSignature(m), m.getName().toString());
        }
    }

    public static String createFieldSignature(Object type, String name) {
        return JavaSourceHelper.getShortTypeName(type.toString()) + " " + name;
    }

    public static String createFieldSignature(VariableTree v) {
        return JavaSourceHelper.getShortTypeName(v.getType().toString()) + " " + v.getName();
    }

    public static String createMethodSignature(MethodTree m, boolean skipName) {
        String sign = "";
        if (!skipName) {
            sign = sign + m.getName();
        }
        sign = sign + "(";
        if (m.getParameters() != null) {
            for (VariableTree variableTree : m.getParameters()) {
                sign = sign + JavaSourceHelper.getShortTypeName(variableTree.getType()) + ",";
            }
            if (m.getParameters().size() > 0) {
                sign = sign.substring(0, sign.length() - 1);
            }
        }
        sign = sign + ")";
        return sign;
    }

    public static String createMethodSignature(MethodTree m) {
        return JavaSourceHelper.createMethodSignature(m, false);
    }

    public static String createMethodSignature(String name, Object[] paramTypes) {
        String sign = name + "(";
        if (paramTypes != null) {
            for (Object p : paramTypes) {
                sign = sign + JavaSourceHelper.getShortTypeName(p) + ",";
            }
            if (paramTypes.length > 0) {
                sign = sign.substring(0, sign.length() - 1);
            }
        }
        sign = sign + ")";
        return sign;
    }

    public static String getShortTypeName(Object type) {
        String shortName = type.toString();
        if (shortName.contains(".")) {
            shortName = shortName.substring(shortName.lastIndexOf(".") + 1);
        }
        return shortName;
    }

    public static String findUri(JavaSource rSrc) {
        String path = null;
        List<? extends AnnotationMirror> annotations = JavaSourceHelper.getClassAnnotations(rSrc);
        for (AnnotationMirror annotationMirror : annotations) {
            String cAnonType = annotationMirror.getAnnotationType().toString();
            if (!"javax.ws.rs.Path".equals(cAnonType) && !"Path".equals(cAnonType)) continue;
            path = JavaSourceHelper.getValueFromAnnotation(annotationMirror);
        }
        return path;
    }

    public static String getValueFromAnnotation(AnnotationMirror annotation) {
        return JavaSourceHelper.getValueFromAnnotation(annotation.getElementValues().values().toString());
    }

    public static String getValueFromAnnotation(String value) {
        if (value.indexOf("\"") != -1) {
            value = value.substring(value.indexOf("\"") + 1, value.lastIndexOf("\""));
        }
        return value;
    }
}

