/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.database.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetDbHomePatchRequest
extends BmcRequest<Void> {
    private String dbHomeId;
    private String patchId;

    public String getDbHomeId() {
        return this.dbHomeId;
    }

    public String getPatchId() {
        return this.patchId;
    }

    public Builder toBuilder() {
        return new Builder().dbHomeId(this.dbHomeId).patchId(this.patchId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",dbHomeId=").append(String.valueOf(this.dbHomeId));
        sb.append(",patchId=").append(String.valueOf(this.patchId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetDbHomePatchRequest)) {
            return false;
        }
        GetDbHomePatchRequest other = (GetDbHomePatchRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.dbHomeId, other.dbHomeId) && Objects.equals(this.patchId, other.patchId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.dbHomeId == null ? 43 : this.dbHomeId.hashCode());
        result = result * 59 + (this.patchId == null ? 43 : this.patchId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetDbHomePatchRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String dbHomeId = null;
        private String patchId = null;

        public Builder dbHomeId(String dbHomeId) {
            this.dbHomeId = dbHomeId;
            return this;
        }

        public Builder patchId(String patchId) {
            this.patchId = patchId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetDbHomePatchRequest o) {
            this.dbHomeId(o.getDbHomeId());
            this.patchId(o.getPatchId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetDbHomePatchRequest build() {
            GetDbHomePatchRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetDbHomePatchRequest buildWithoutInvocationCallback() {
            GetDbHomePatchRequest request = new GetDbHomePatchRequest();
            request.dbHomeId = this.dbHomeId;
            request.patchId = this.patchId;
            return request;
        }
    }
}

