/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.wseditor.support;

import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.support.EditWSAttributesCookie;
import org.netbeans.modules.websvc.api.wseditor.InvalidDataException;
import org.netbeans.modules.websvc.api.wseditor.WSEditor;
import org.netbeans.modules.websvc.api.wseditor.WSEditorProviderRegistry;
import org.netbeans.modules.websvc.core.wseditor.support.EditWSAttributesPanel;
import org.netbeans.modules.websvc.spi.wseditor.WSEditorProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.windows.WindowManager;

public class EditWSAttributesCookieImpl
implements EditWSAttributesCookie {
    private Set<WSEditorProvider> providers;
    private Set<WSEditor> editors;
    private static Map<EditWSAttributesCookie, EditWSAttributesPanel> cachedTopComponents = new WeakHashMap<EditWSAttributesCookie, EditWSAttributesPanel>();
    private EditWSAttributesPanel tc;
    private Node node;
    private JaxWsModel jaxWsModel;
    private DialogWindowListener windowListener;

    public EditWSAttributesCookieImpl(Node node, JaxWsModel jaxWsModel) {
        this.node = node;
        this.jaxWsModel = jaxWsModel;
    }

    public void openWSAttributesEditor() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.openEditor();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EditWSAttributesCookieImpl.this.openEditor();
                }
            });
        }
    }

    private void openEditor() {
        try {
            this.doOpenEditor();
        }
        catch (InvalidDataException ex) {
            NotifyDescriptor.Message descriptor = new NotifyDescriptor.Message((Object)ex.getLocalizedMessage(), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
        }
    }

    private void doOpenEditor() throws InvalidDataException {
        JFrame mainWin = (JFrame)WindowManager.getDefault().getMainWindow();
        Cursor origCursor = mainWin.getGlassPane().getCursor();
        mainWin.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
        mainWin.getGlassPane().setVisible(true);
        this.tc = cachedTopComponents.get(this);
        if (this.tc == null) {
            this.populateWSEditorProviderRegistry();
            this.providers = WSEditorProviderRegistry.getDefault().getEditorProviders();
            this.tc = new EditWSAttributesPanel();
            cachedTopComponents.put(this, this.tc);
        }
        this.populatePanels();
        this.tc.addTabs(this.editors, this.node);
        DialogDescriptor dialogDesc = new DialogDescriptor((Object)this.tc, this.node.getName());
        dialogDesc.setHelpCtx(new HelpCtx(EditWSAttributesCookieImpl.class));
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDesc);
        dialog.getAccessibleContext().setAccessibleDescription(dialog.getTitle());
        dialog.setVisible(true);
        mainWin.getGlassPane().setCursor(origCursor);
        mainWin.getGlassPane().setVisible(false);
        if (dialogDesc.getValue() == NotifyDescriptor.OK_OPTION) {
            for (WSEditor editor : this.editors) {
                editor.save(this.node);
            }
        } else {
            for (WSEditor editor : this.editors) {
                editor.cancel(this.node);
            }
        }
    }

    private Set getWSEditorProviders() {
        return this.providers;
    }

    private void populatePanels() {
        this.editors = new HashSet<WSEditor>();
        for (WSEditorProvider provider : this.providers) {
            WSEditor editor;
            if (!provider.enable(this.node) || (editor = provider.createWSEditor(this.node.getLookup())) == null) continue;
            this.editors.add(editor);
        }
    }

    private void populateWSEditorProviderRegistry() {
        WSEditorProviderRegistry registry = WSEditorProviderRegistry.getDefault();
        if (registry.getEditorProviders().isEmpty()) {
            Lookup.Result results = Lookup.getDefault().lookup(new Lookup.Template(WSEditorProvider.class));
            Collection services = results.allInstances();
            for (WSEditorProvider provider : services) {
                registry.register(provider);
            }
        }
    }

    class DialogWindowListener
    extends WindowAdapter {
        Set<WSEditor> editors;

        public DialogWindowListener(Set<WSEditor> editors) {
            this.editors = editors;
        }

        @Override
        public void windowClosing(WindowEvent e) {
            for (WSEditor editor : this.editors) {
                editor.cancel(EditWSAttributesCookieImpl.this.node);
            }
        }
    }
}

