/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.module.script;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.module.script.ScriptExtensionProvider;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true)
@NonNullByDefault
public class LifecycleScriptExtensionProvider
implements ScriptExtensionProvider {
    private static final String LIFECYCLE_PRESET_NAME = "lifecycle";
    private static final String LIFECYCLE_TRACKER_NAME = "lifecycleTracker";
    private final Map<String, LifecycleTracker> idToTracker = new ConcurrentHashMap<String, LifecycleTracker>();

    @Override
    public Collection<String> getDefaultPresets() {
        return Set.of(LIFECYCLE_PRESET_NAME);
    }

    @Override
    public Collection<String> getPresets() {
        return Set.of(LIFECYCLE_PRESET_NAME);
    }

    @Override
    public Collection<String> getTypes() {
        return Set.of(LIFECYCLE_TRACKER_NAME);
    }

    @Override
    public @Nullable Object get(String scriptIdentifier, String type) throws IllegalArgumentException {
        if (LIFECYCLE_TRACKER_NAME.equals(type)) {
            return this.idToTracker.computeIfAbsent(scriptIdentifier, k -> new LifecycleTracker());
        }
        return null;
    }

    @Override
    public Map<String, Object> importPreset(String scriptIdentifier, String preset) {
        Object requestedType;
        if (LIFECYCLE_PRESET_NAME.equals(preset) && (requestedType = this.get(scriptIdentifier, LIFECYCLE_TRACKER_NAME)) != null) {
            return Map.of(LIFECYCLE_TRACKER_NAME, requestedType);
        }
        return Map.of();
    }

    @Override
    public void unload(String scriptIdentifier) {
        LifecycleTracker tracker = this.idToTracker.remove(scriptIdentifier);
        if (tracker != null) {
            tracker.dispose();
        }
    }

    @FunctionalInterface
    public static interface Disposable {
        public void dispose();
    }

    public static class LifecycleTracker {
        List<Disposable> disposables = new ArrayList<Disposable>();

        public void addDisposeHook(Disposable disposable) {
            this.disposables.add(disposable);
        }

        void dispose() {
            for (Disposable disposable : this.disposables) {
                disposable.dispose();
            }
        }
    }
}

