/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls.cipher;

import org.eclipse.californium.scandium.dtls.CertificateType;
import org.eclipse.californium.scandium.dtls.SignatureAndHashAlgorithm;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuiteParameters;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuiteSelector;
import org.eclipse.californium.scandium.dtls.cipher.XECDHECryptography;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCipherSuiteSelector
implements CipherSuiteSelector {
    protected static final Logger LOGGER = LoggerFactory.getLogger(DefaultCipherSuiteSelector.class);

    @Override
    public boolean select(CipherSuiteParameters parameters) {
        boolean certificateSupportFailed = false;
        for (CipherSuite cipherSuite : parameters.getCipherSuites()) {
            if (cipherSuite.requiresServerCertificateMessage()) {
                if (certificateSupportFailed) continue;
                if (this.select(cipherSuite, parameters)) {
                    return true;
                }
                certificateSupportFailed = true;
                continue;
            }
            if (!this.select(cipherSuite, parameters)) continue;
            return true;
        }
        return false;
    }

    protected boolean select(CipherSuite cipherSuite, CipherSuiteParameters parameters) {
        if (cipherSuite.isEccBased() && (parameters.getSupportedGroups().isEmpty() || parameters.getFormat() == null)) {
            return false;
        }
        if (cipherSuite.requiresServerCertificateMessage()) {
            return this.selectForCertificate(parameters, cipherSuite);
        }
        parameters.select(cipherSuite);
        return true;
    }

    protected boolean selectForCertificate(CipherSuiteParameters parameters, CipherSuite cipherSuite) {
        boolean clientAuthentication;
        if (parameters.getServerCertTypes().isEmpty()) {
            return false;
        }
        boolean bl = clientAuthentication = parameters.isClientAuthenticationRequired() || parameters.isClientAuthenticationWanted();
        if (clientAuthentication && parameters.getClientCertTypes().isEmpty()) {
            return false;
        }
        if (parameters.getSignatures().isEmpty()) {
            return false;
        }
        if (cipherSuite.getCertificateKeyAlgorithm() == CipherSuite.CertificateKeyAlgorithm.EC) {
            XECDHECryptography.SupportedGroup group = XECDHECryptography.SupportedGroup.fromPublicKey(parameters.getPublicKey());
            if (group == null || !parameters.getSupportedGroups().contains((Object)group)) {
                return false;
            }
            SignatureAndHashAlgorithm signatureAndHashAlgorithm = SignatureAndHashAlgorithm.getSupportedSignatureAlgorithm(parameters.getSignatures(), parameters.getPublicKey());
            if (signatureAndHashAlgorithm == null) {
                return false;
            }
            CertificateType certificateType = parameters.getServerCertTypes().get(0);
            if (CertificateType.X_509.equals((Object)certificateType)) {
                if (parameters.getCertificateChain() == null) {
                    throw new IllegalArgumentException("Certificate type x509 requires a certificate chain!");
                }
                boolean supported = SignatureAndHashAlgorithm.isSignedWithSupportedAlgorithms(parameters.getSignatures(), parameters.getCertificateChain());
                if (supported) {
                    supported = XECDHECryptography.SupportedGroup.isSupported(parameters.getSupportedGroups(), parameters.getCertificateChain());
                }
                if (!supported) {
                    if (parameters.getServerCertTypes().contains((Object)CertificateType.RAW_PUBLIC_KEY)) {
                        certificateType = CertificateType.RAW_PUBLIC_KEY;
                    } else {
                        return false;
                    }
                }
            }
            parameters.select(cipherSuite);
            parameters.selectServerCertificateType(certificateType);
            parameters.selectSignatureAndHashAlgorithm(signatureAndHashAlgorithm);
            certificateType = clientAuthentication ? parameters.getClientCertTypes().get(0) : null;
            parameters.selectClientCertificateType(certificateType);
            return true;
        }
        throw new IllegalArgumentException("Only ECDSA certificate based cipher suites are supported!");
    }
}

