/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol;

import de.rub.nds.tlsattacker.core.exceptions.ObjectCreationException;
import de.rub.nds.tlsattacker.core.protocol.message.ProtocolMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtensionMessage;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class MessageFactory {
    private static final Logger LOGGER = LogManager.getLogger();

    public static List<ProtocolMessage> generateProtocolMessages() {
        LinkedList<ProtocolMessage> protocolMessageList = new LinkedList<ProtocolMessage>();
        Set<Class<? extends ProtocolMessage>> classes = MessageFactory.getAllNonAbstractProtocolMessageClasses();
        for (Class<? extends ProtocolMessage> someClass : classes) {
            protocolMessageList.add(MessageFactory.createProtocolMessage(someClass));
        }
        return protocolMessageList;
    }

    public static List<ExtensionMessage> generateExtensionMessages() {
        LinkedList<ExtensionMessage> extensionMessageList = new LinkedList<ExtensionMessage>();
        Set<Class<? extends ExtensionMessage>> classes = MessageFactory.getAllNonAbstractExtensionClasses();
        for (Class<? extends ExtensionMessage> someClass : classes) {
            extensionMessageList.add(MessageFactory.createExtensionMessage(someClass));
        }
        return extensionMessageList;
    }

    private static ExtensionMessage createExtensionMessage(Class<? extends ExtensionMessage> extensionClass) {
        if (Modifier.isAbstract(extensionClass.getModifiers())) {
            throw new IllegalArgumentException("Provided class is abstract");
        }
        try {
            return extensionClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new ObjectCreationException("Could not create Extension", ex);
        }
    }

    private static ProtocolMessage createProtocolMessage(Class<? extends ProtocolMessage> protocolMessageClass) {
        if (Modifier.isAbstract(protocolMessageClass.getModifiers())) {
            throw new IllegalArgumentException("Provided class is abstract");
        }
        try {
            return protocolMessageClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            throw new ObjectCreationException("Could not create ProtocolMessage", ex);
        }
    }

    private static Set<Class<? extends ExtensionMessage>> getAllNonAbstractExtensionClasses() {
        Reflections reflections = new Reflections("de.rub.nds.tlsattacker.core.protocol.message.extension", new Scanner[0]);
        Set classes = reflections.getSubTypesOf(ExtensionMessage.class);
        HashSet<Class<? extends ExtensionMessage>> filteredClassSet = new HashSet<Class<? extends ExtensionMessage>>();
        for (Class someClass : classes) {
            if (Modifier.isAbstract(someClass.getModifiers())) continue;
            filteredClassSet.add(someClass);
        }
        return filteredClassSet;
    }

    private static Set<Class<? extends ProtocolMessage>> getAllNonAbstractProtocolMessageClasses() {
        Reflections reflections = new Reflections("de.rub.nds.tlsattacker.core.protocol.message", new Scanner[0]);
        Set classes = reflections.getSubTypesOf(ProtocolMessage.class);
        HashSet<Class<? extends ProtocolMessage>> filteredClassSet = new HashSet<Class<? extends ProtocolMessage>>();
        for (Class someClass : classes) {
            if (Modifier.isAbstract(someClass.getModifiers())) continue;
            filteredClassSet.add(someClass);
        }
        return filteredClassSet;
    }

    public static ProtocolMessage generateRandomProtocolMessage(Random r) {
        List<ProtocolMessage> generateProtocolMessages = MessageFactory.generateProtocolMessages();
        return generateProtocolMessages.get(r.nextInt(generateProtocolMessages.size()));
    }

    public static ExtensionMessage generateRandomExtension(Random r) {
        List<ExtensionMessage> extensionMessages = MessageFactory.generateExtensionMessages();
        return extensionMessages.get(r.nextInt(extensionMessages.size()));
    }

    private MessageFactory() {
    }
}

