/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import io.quarkus.runtime.util.StringUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.microprofile.config.spi.Converter;

@Deprecated(forRemoval=true)
public final class HyphenateEnumConverter<E extends Enum<E>>
implements Converter<E>,
Serializable {
    private static final String HYPHEN = "-";
    private static final Pattern PATTERN = Pattern.compile("([-_]+)");
    private static final long serialVersionUID = 5675903245398498741L;
    private final Class<E> enumType;
    private final Map<String, E> values = new HashMap<String, E>();

    public HyphenateEnumConverter(Class<E> enumType) {
        this.enumType = enumType;
        for (Enum enumValue : (Enum[])this.enumType.getEnumConstants()) {
            String name = enumValue.name();
            String canonicalEquivalent = this.hyphenate(name);
            this.values.put(canonicalEquivalent, enumValue);
        }
    }

    public static <E extends Enum<E>> HyphenateEnumConverter<E> of(Class<E> enumType) {
        return new HyphenateEnumConverter<E>(enumType);
    }

    public E convert(String value) {
        if ((value = value.trim()).isEmpty()) {
            return null;
        }
        String hyphenatedValue = this.hyphenate(value);
        Enum enumValue = (Enum)this.values.get(hyphenatedValue);
        if (enumValue != null) {
            return (E)((Enum)this.enumType.cast(enumValue));
        }
        throw new IllegalArgumentException(String.format("Cannot convert %s to enum %s", value, this.enumType));
    }

    private String hyphenate(String value) {
        StringBuffer target = new StringBuffer();
        String hyphenate = StringUtil.hyphenate(value);
        Matcher matcher = PATTERN.matcher(hyphenate);
        while (matcher.find()) {
            matcher.appendReplacement(target, HYPHEN);
        }
        matcher.appendTail(target);
        return target.toString();
    }
}

