/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.factory;

import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.connection.AliasedConnection;
import de.rub.nds.tlsattacker.core.connection.InboundConnection;
import de.rub.nds.tlsattacker.core.connection.OutboundConnection;
import de.rub.nds.tlsattacker.core.constants.AlgorithmResolver;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.constants.ExtensionType;
import de.rub.nds.tlsattacker.core.constants.KeyExchangeAlgorithm;
import de.rub.nds.tlsattacker.core.constants.RunningModeType;
import de.rub.nds.tlsattacker.core.constants.StarttlsMessage;
import de.rub.nds.tlsattacker.core.constants.StarttlsType;
import de.rub.nds.tlsattacker.core.exceptions.ConfigurationException;
import de.rub.nds.tlsattacker.core.https.HttpsRequestMessage;
import de.rub.nds.tlsattacker.core.https.HttpsResponseMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ApplicationMessage;
import de.rub.nds.tlsattacker.core.protocol.message.CertificateMessage;
import de.rub.nds.tlsattacker.core.protocol.message.CertificateRequestMessage;
import de.rub.nds.tlsattacker.core.protocol.message.CertificateVerifyMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ChangeCipherSpecMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ClientHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.DHClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.DHEServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ECDHClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ECDHEServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.EncryptedExtensionsMessage;
import de.rub.nds.tlsattacker.core.protocol.message.EndOfEarlyDataMessage;
import de.rub.nds.tlsattacker.core.protocol.message.FinishedMessage;
import de.rub.nds.tlsattacker.core.protocol.message.GOSTClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.HandshakeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.HeartbeatMessage;
import de.rub.nds.tlsattacker.core.protocol.message.HelloRequestMessage;
import de.rub.nds.tlsattacker.core.protocol.message.HelloVerifyRequestMessage;
import de.rub.nds.tlsattacker.core.protocol.message.NewSessionTicketMessage;
import de.rub.nds.tlsattacker.core.protocol.message.PWDClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.PWDServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ProtocolMessage;
import de.rub.nds.tlsattacker.core.protocol.message.PskClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.PskDhClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.PskDheServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.PskEcDhClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.PskEcDheServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.PskRsaClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.PskServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.RSAClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.SSL2ClientHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.message.SSL2ServerHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ServerHelloDoneMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ServerHelloMessage;
import de.rub.nds.tlsattacker.core.protocol.message.ServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.SrpClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.SrpServerKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.EarlyDataExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.PreSharedKeyExtensionMessage;
import de.rub.nds.tlsattacker.core.record.BlobRecord;
import de.rub.nds.tlsattacker.core.workflow.WorkflowTrace;
import de.rub.nds.tlsattacker.core.workflow.action.BufferedGenericReceiveAction;
import de.rub.nds.tlsattacker.core.workflow.action.BufferedSendAction;
import de.rub.nds.tlsattacker.core.workflow.action.ClearBuffersAction;
import de.rub.nds.tlsattacker.core.workflow.action.CopyBuffersAction;
import de.rub.nds.tlsattacker.core.workflow.action.CopyPreMasterSecretAction;
import de.rub.nds.tlsattacker.core.workflow.action.EsniKeyDnsRequestAction;
import de.rub.nds.tlsattacker.core.workflow.action.FlushSessionCacheAction;
import de.rub.nds.tlsattacker.core.workflow.action.ForwardMessagesAction;
import de.rub.nds.tlsattacker.core.workflow.action.ForwardRecordsAction;
import de.rub.nds.tlsattacker.core.workflow.action.MessageAction;
import de.rub.nds.tlsattacker.core.workflow.action.MessageActionFactory;
import de.rub.nds.tlsattacker.core.workflow.action.PopAndSendAction;
import de.rub.nds.tlsattacker.core.workflow.action.PopBufferedMessageAction;
import de.rub.nds.tlsattacker.core.workflow.action.PopBufferedRecordAction;
import de.rub.nds.tlsattacker.core.workflow.action.PopBuffersAction;
import de.rub.nds.tlsattacker.core.workflow.action.PrintLastHandledApplicationDataAction;
import de.rub.nds.tlsattacker.core.workflow.action.PrintSecretsAction;
import de.rub.nds.tlsattacker.core.workflow.action.ReceiveAction;
import de.rub.nds.tlsattacker.core.workflow.action.ReceiveTillAction;
import de.rub.nds.tlsattacker.core.workflow.action.RemBufferedChCiphersAction;
import de.rub.nds.tlsattacker.core.workflow.action.RemBufferedChExtensionsAction;
import de.rub.nds.tlsattacker.core.workflow.action.RenegotiationAction;
import de.rub.nds.tlsattacker.core.workflow.action.ResetConnectionAction;
import de.rub.nds.tlsattacker.core.workflow.action.SendAction;
import de.rub.nds.tlsattacker.core.workflow.action.SendDynamicClientKeyExchangeAction;
import de.rub.nds.tlsattacker.core.workflow.action.SendDynamicServerCertificateAction;
import de.rub.nds.tlsattacker.core.workflow.action.SendDynamicServerKeyExchangeAction;
import de.rub.nds.tlsattacker.core.workflow.action.TlsAction;
import de.rub.nds.tlsattacker.core.workflow.factory.WorkflowTraceType;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorkflowConfigurationFactory {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final Config config;
    private RunningModeType mode;

    public WorkflowConfigurationFactory(Config config) {
        this.config = config;
    }

    public WorkflowTrace createWorkflowTrace(WorkflowTraceType type, RunningModeType mode) {
        this.mode = mode;
        switch (type) {
            case HELLO: {
                return this.createHelloWorkflow();
            }
            case FULL: {
                return this.createFullWorkflow();
            }
            case HANDSHAKE: {
                return this.createHandshakeWorkflow();
            }
            case SHORT_HELLO: {
                return this.createShortHelloWorkflow();
            }
            case SSL2_HELLO: {
                return this.createSsl2HelloWorkflow();
            }
            case CLIENT_RENEGOTIATION_WITHOUT_RESUMPTION: {
                return this.createClientRenegotiationWorkflow();
            }
            case CLIENT_RENEGOTIATION: {
                return this.createClientRenegotiationWithResumptionWorkflow();
            }
            case SERVER_RENEGOTIATION: {
                return this.createServerRenegotiationWorkflow();
            }
            case HTTPS: {
                return this.createHttpsWorkflow();
            }
            case RESUMPTION: {
                return this.createResumptionWorkflow();
            }
            case FULL_RESUMPTION: {
                return this.createFullResumptionWorkflow();
            }
            case SIMPLE_MITM_PROXY: {
                return this.createSimpleMitmProxyWorkflow();
            }
            case ZERO_RTT: {
                return this.createZeroRttWorkflow();
            }
            case FULL_ZERO_RTT: {
                return this.createFullZeroRttWorkflow();
            }
            case FALSE_START: {
                return this.createFalseStartWorkflow();
            }
            case RSA_SYNC_PROXY: {
                return this.createSyncProxyWorkflow();
            }
            case DYNAMIC_HANDSHAKE: {
                return this.createDynamicHandshakeWorkflow();
            }
            case DYNAMIC_HELLO: {
                return this.createDynamicHelloWorkflow();
            }
        }
        throw new ConfigurationException("Unknown WorkflowTraceType " + type.name());
    }

    private AliasedConnection getConnection() {
        AliasedConnection con = null;
        if (this.mode == null) {
            throw new ConfigurationException("Running mode not set, can't configure workflow");
        }
        switch (this.mode) {
            case CLIENT: {
                con = this.config.getDefaultClientConnection();
                break;
            }
            case SERVER: {
                con = this.config.getDefaultServerConnection();
                break;
            }
            default: {
                throw new ConfigurationException("This workflow can only be configured for modes CLIENT and SERVER, but actual mode was " + (Object)((Object)this.mode));
            }
        }
        return con;
    }

    public WorkflowTrace createTlsEntryWorkflowtrace(AliasedConnection connection) {
        WorkflowTrace workflowTrace = new WorkflowTrace();
        if (this.config.getStarttlsType() != StarttlsType.NONE) {
            this.addStartTlsActions(connection, this.config.getStarttlsType(), workflowTrace);
        }
        return workflowTrace;
    }

    private WorkflowTrace createHelloWorkflow() {
        return this.createHelloWorkflow(this.getConnection());
    }

    public WorkflowTrace createHelloWorkflow(AliasedConnection connection) {
        WorkflowTrace workflowTrace = this.createTlsEntryWorkflowtrace(connection);
        if (this.config.isAddEncryptedServerNameIndicationExtension().booleanValue() && connection.getLocalConnectionEndType() == ConnectionEndType.CLIENT) {
            workflowTrace.addTlsAction(new EsniKeyDnsRequestAction());
        }
        workflowTrace.addTlsAction(MessageActionFactory.createAction(connection, ConnectionEndType.CLIENT, new ClientHelloMessage(this.config)));
        if (this.config.getHighestProtocolVersion().isDTLS()) {
            workflowTrace.addTlsAction(MessageActionFactory.createAction(connection, ConnectionEndType.SERVER, new HelloVerifyRequestMessage(this.config)));
            workflowTrace.addTlsAction(MessageActionFactory.createAction(connection, ConnectionEndType.CLIENT, new ClientHelloMessage(this.config)));
        }
        LinkedList<ProtocolMessage> messages = new LinkedList<ProtocolMessage>();
        messages.add(new ServerHelloMessage(this.config));
        if (this.config.getHighestProtocolVersion().isTLS13()) {
            CipherSuite selectedCipherSuite;
            if (Objects.equals(this.config.getTls13BackwardsCompatibilityMode(), Boolean.TRUE) || connection.getLocalConnectionEndType() == ConnectionEndType.CLIENT) {
                ChangeCipherSpecMessage ccs = new ChangeCipherSpecMessage();
                ccs.setRequired(false);
                messages.add(ccs);
            }
            messages.add(new EncryptedExtensionsMessage(this.config));
            if (this.config.isClientAuthentication().booleanValue()) {
                messages.add(new CertificateRequestMessage(this.config));
            }
            if (!(selectedCipherSuite = this.config.getDefaultSelectedCipherSuite()).isPWD()) {
                if (connection.getLocalConnectionEndType() == ConnectionEndType.CLIENT) {
                    messages.add(new CertificateMessage());
                } else {
                    messages.add(new CertificateMessage(this.config));
                }
                messages.add(new CertificateVerifyMessage(this.config));
            }
            messages.add(new FinishedMessage(this.config));
        } else {
            CipherSuite selectedCipherSuite = this.config.getDefaultSelectedCipherSuite();
            if (this.shouldServerSendACertificate(selectedCipherSuite)) {
                if (connection.getLocalConnectionEndType() == ConnectionEndType.CLIENT) {
                    messages.add(new CertificateMessage());
                } else {
                    messages.add(new CertificateMessage(this.config));
                }
            }
            if (selectedCipherSuite.isEphemeral() || selectedCipherSuite.isSrp()) {
                this.addServerKeyExchangeMessage(messages);
            }
            if (this.config.isClientAuthentication().booleanValue()) {
                messages.add(new CertificateRequestMessage(this.config));
            }
            messages.add(new ServerHelloDoneMessage(this.config));
        }
        workflowTrace.addTlsAction(MessageActionFactory.createAction(connection, ConnectionEndType.SERVER, messages));
        return workflowTrace;
    }

    public boolean shouldServerSendACertificate(CipherSuite suite) {
        return !suite.isSrpSha() && !suite.isPskOrDhPsk() && !suite.isAnon() && !suite.isPWD();
    }

    private WorkflowTrace createHandshakeWorkflow() {
        return this.createHandshakeWorkflow(this.getConnection());
    }

    private WorkflowTrace createHandshakeWorkflow(AliasedConnection connection) {
        WorkflowTrace workflowTrace = this.createHelloWorkflow(connection);
        LinkedList<ProtocolMessage> messages = new LinkedList<ProtocolMessage>();
        if (this.config.getHighestProtocolVersion().isTLS13()) {
            if (Objects.equals(this.config.getTls13BackwardsCompatibilityMode(), Boolean.TRUE) || connection.getLocalConnectionEndType() == ConnectionEndType.SERVER) {
                ChangeCipherSpecMessage ccs = new ChangeCipherSpecMessage();
                ccs.setRequired(false);
                messages.add(ccs);
            }
            if (this.config.isClientAuthentication().booleanValue()) {
                messages.add(new CertificateMessage(this.config));
                messages.add(new CertificateVerifyMessage(this.config));
            }
        } else {
            if (this.config.isClientAuthentication().booleanValue()) {
                messages.add(new CertificateMessage(this.config));
                this.addClientKeyExchangeMessage(messages);
                messages.add(new CertificateVerifyMessage(this.config));
            } else {
                this.addClientKeyExchangeMessage(messages);
            }
            messages.add(new ChangeCipherSpecMessage(this.config));
        }
        messages.add(new FinishedMessage(this.config));
        workflowTrace.addTlsAction(MessageActionFactory.createAction(connection, ConnectionEndType.CLIENT, messages));
        if (!this.config.getHighestProtocolVersion().isTLS13()) {
            workflowTrace.addTlsAction(MessageActionFactory.createAction(connection, ConnectionEndType.SERVER, new ChangeCipherSpecMessage(this.config), new FinishedMessage(this.config)));
        }
        return workflowTrace;
    }

    private WorkflowTrace createFullWorkflow() {
        AliasedConnection connection = this.getConnection();
        WorkflowTrace workflowTrace = this.createHandshakeWorkflow(connection);
        if (this.config.isServerSendsApplicationData().booleanValue()) {
            workflowTrace.addTlsAction(MessageActionFactory.createAction(connection, ConnectionEndType.SERVER, new ApplicationMessage(this.config)));
        }
        if (this.config.isAddHeartbeatExtension().booleanValue()) {
            workflowTrace.addTlsAction(MessageActionFactory.createAction(connection, ConnectionEndType.CLIENT, new ApplicationMessage(this.config), new HeartbeatMessage(this.config)));
            workflowTrace.addTlsAction(MessageActionFactory.createAction(connection, ConnectionEndType.SERVER, new HeartbeatMessage(this.config)));
        } else {
            workflowTrace.addTlsAction(MessageActionFactory.createAction(connection, ConnectionEndType.CLIENT, new ApplicationMessage(this.config)));
        }
        return workflowTrace;
    }

    private WorkflowTrace createShortHelloWorkflow() {
        AliasedConnection connection = this.getConnection();
        WorkflowConfigurationFactory factory = new WorkflowConfigurationFactory(this.config);
        WorkflowTrace trace = factory.createTlsEntryWorkflowtrace(this.config.getDefaultClientConnection());
        trace.addTlsAction(MessageActionFactory.createAction(connection, ConnectionEndType.CLIENT, new ClientHelloMessage(this.config)));
        trace.addTlsAction(MessageActionFactory.createAction(connection, ConnectionEndType.SERVER, new ServerHelloMessage(this.config)));
        return trace;
    }

    private WorkflowTrace createFalseStartWorkflow() {
        return this.createFalseStartWorkflow(this.getConnection());
    }

    private WorkflowTrace createFalseStartWorkflow(AliasedConnection connection) {
        if (this.config.getHighestProtocolVersion().isTLS13()) {
            throw new ConfigurationException("The false start workflow is not implemented for TLS 1.3");
        }
        WorkflowTrace workflowTrace = this.createHandshakeWorkflow(connection);
        MessageAction appData = MessageActionFactory.createAction(connection, ConnectionEndType.CLIENT, new ApplicationMessage(this.config));
        TlsAction lastClientAction = connection.getLocalConnectionEndType() == ConnectionEndType.CLIENT ? (TlsAction)((Object)workflowTrace.getLastSendingAction()) : (TlsAction)((Object)workflowTrace.getLastReceivingAction());
        int i = workflowTrace.getTlsActions().indexOf(lastClientAction);
        workflowTrace.addTlsAction(i + 1, appData);
        return workflowTrace;
    }

    private WorkflowTrace createSsl2HelloWorkflow() {
        AliasedConnection connection = this.getConnection();
        WorkflowConfigurationFactory factory = new WorkflowConfigurationFactory(this.config);
        WorkflowTrace trace = factory.createTlsEntryWorkflowtrace(this.config.getDefaultClientConnection());
        MessageAction action = MessageActionFactory.createAction(connection, ConnectionEndType.CLIENT, new SSL2ClientHelloMessage(this.config));
        action.setRecords(new BlobRecord());
        trace.addTlsAction(action);
        action = MessageActionFactory.createAction(connection, ConnectionEndType.SERVER, new SSL2ServerHelloMessage(this.config));
        action.setRecords(new BlobRecord());
        trace.addTlsAction(action);
        return trace;
    }

    private WorkflowTrace createFullResumptionWorkflow() {
        AliasedConnection conEnd = this.getConnection();
        WorkflowTrace trace = this.createHandshakeWorkflow(conEnd);
        trace.addTlsAction(new ResetConnectionAction());
        WorkflowTrace tempTrace = this.createResumptionWorkflow();
        for (TlsAction resumption : tempTrace.getTlsActions()) {
            trace.addTlsAction(resumption);
        }
        return trace;
    }

    private WorkflowTrace createResumptionWorkflow() {
        AliasedConnection connection = this.getConnection();
        WorkflowConfigurationFactory factory = new WorkflowConfigurationFactory(this.config);
        WorkflowTrace trace = factory.createTlsEntryWorkflowtrace(this.config.getDefaultClientConnection());
        MessageAction action = MessageActionFactory.createAction(connection, ConnectionEndType.CLIENT, new ClientHelloMessage(this.config));
        trace.addTlsAction(action);
        if (this.config.getHighestProtocolVersion().isDTLS()) {
            action = MessageActionFactory.createAction(connection, ConnectionEndType.SERVER, new HelloVerifyRequestMessage(this.config));
            trace.addTlsAction(action);
            action = MessageActionFactory.createAction(connection, ConnectionEndType.CLIENT, new ClientHelloMessage(this.config));
            trace.addTlsAction(action);
        }
        action = MessageActionFactory.createAction(connection, ConnectionEndType.SERVER, new ServerHelloMessage(this.config), new ChangeCipherSpecMessage(this.config), new FinishedMessage(this.config));
        trace.addTlsAction(action);
        action = MessageActionFactory.createAction(connection, ConnectionEndType.CLIENT, new ChangeCipherSpecMessage(this.config), new FinishedMessage(this.config));
        trace.addTlsAction(action);
        return trace;
    }

    private WorkflowTrace createClientRenegotiationWithResumptionWorkflow() {
        AliasedConnection conEnd = this.getConnection();
        WorkflowTrace trace = this.createHandshakeWorkflow(conEnd);
        trace.addTlsAction(new RenegotiationAction());
        WorkflowTrace renegotiationTrace = this.createResumptionWorkflow();
        for (TlsAction reneAction : renegotiationTrace.getTlsActions()) {
            trace.addTlsAction(reneAction);
        }
        return trace;
    }

    private WorkflowTrace createClientRenegotiationWorkflow() {
        AliasedConnection conEnd = this.getConnection();
        WorkflowTrace trace = this.createHandshakeWorkflow(conEnd);
        trace.addTlsAction(new RenegotiationAction());
        trace.addTlsAction(new FlushSessionCacheAction());
        WorkflowTrace renegotiationTrace = this.createHandshakeWorkflow(conEnd);
        for (TlsAction reneAction : renegotiationTrace.getTlsActions()) {
            trace.addTlsAction(reneAction);
        }
        return trace;
    }

    private WorkflowTrace createServerRenegotiationWorkflow() {
        AliasedConnection connection = this.getConnection();
        WorkflowTrace trace = this.createHandshakeWorkflow(connection);
        WorkflowTrace renegotiationTrace = this.createHandshakeWorkflow(connection);
        trace.addTlsAction(new RenegotiationAction());
        MessageAction action = MessageActionFactory.createAction(connection, ConnectionEndType.SERVER, new HelloRequestMessage(this.config));
        trace.addTlsAction(action);
        for (TlsAction reneAction : renegotiationTrace.getTlsActions()) {
            trace.addTlsAction(reneAction);
        }
        return trace;
    }

    private WorkflowTrace createHttpsWorkflow() {
        AliasedConnection connection = this.getConnection();
        WorkflowTrace trace = this.createHandshakeWorkflow(connection);
        MessageAction action = MessageActionFactory.createAction(connection, ConnectionEndType.CLIENT, new HttpsRequestMessage(this.config));
        trace.addTlsAction(action);
        action = MessageActionFactory.createAction(connection, ConnectionEndType.SERVER, new HttpsResponseMessage(this.config));
        trace.addTlsAction(action);
        return trace;
    }

    private WorkflowTrace createSimpleMitmProxyWorkflow() {
        if (this.mode != RunningModeType.MITM) {
            throw new ConfigurationException("This workflow trace can only be created when running in MITM mode. Actual mode: " + (Object)((Object)this.mode));
        }
        InboundConnection inboundConnection = this.config.getDefaultServerConnection();
        OutboundConnection outboundConnection = this.config.getDefaultClientConnection();
        if (outboundConnection == null || inboundConnection == null) {
            throw new ConfigurationException("Could not find both necesary connection ends");
        }
        String clientToMitmAlias = inboundConnection.getAlias();
        String mitmToServerAlias = outboundConnection.getAlias();
        LOGGER.debug("Building mitm trace for: " + inboundConnection + ", " + outboundConnection);
        WorkflowTrace clientToMitmHandshake = this.createHandshakeWorkflow(inboundConnection);
        WorkflowTrace mitmToServerHandshake = this.createHandshakeWorkflow(outboundConnection);
        WorkflowConfigurationFactory factory = new WorkflowConfigurationFactory(this.config);
        WorkflowTrace trace = factory.createTlsEntryWorkflowtrace(this.config.getDefaultClientConnection());
        trace.addConnection(inboundConnection);
        trace.addConnection(outboundConnection);
        trace.addTlsActions(clientToMitmHandshake.getTlsActions());
        trace.addTlsActions(mitmToServerHandshake.getTlsActions());
        ForwardMessagesAction f = new ForwardMessagesAction(clientToMitmAlias, mitmToServerAlias, new ApplicationMessage(this.config));
        trace.addTlsAction(f);
        PrintLastHandledApplicationDataAction p = new PrintLastHandledApplicationDataAction(clientToMitmAlias);
        p.setStringEncoding("US-ASCII");
        trace.addTlsAction(p);
        f = new ForwardMessagesAction(mitmToServerAlias, clientToMitmAlias, new ApplicationMessage(this.config));
        trace.addTlsAction(f);
        p = new PrintLastHandledApplicationDataAction(mitmToServerAlias);
        p.setStringEncoding("US-ASCII");
        trace.addTlsAction(p);
        return trace;
    }

    private WorkflowTrace createZeroRttWorkflow() {
        EncryptedExtensionsMessage encExtMsg;
        ServerHelloMessage serverHello;
        ApplicationMessage earlyDataMsg;
        ClientHelloMessage clientHello;
        AliasedConnection connection = this.getConnection();
        WorkflowConfigurationFactory factory = new WorkflowConfigurationFactory(this.config);
        WorkflowTrace trace = factory.createTlsEntryWorkflowtrace(this.config.getDefaultClientConnection());
        LinkedList<ProtocolMessage> clientHelloMessages = new LinkedList<ProtocolMessage>();
        LinkedList<ProtocolMessage> serverMessages = new LinkedList<ProtocolMessage>();
        LinkedList<ProtocolMessage> clientMessages = new LinkedList<ProtocolMessage>();
        if (connection.getLocalConnectionEndType() == ConnectionEndType.CLIENT) {
            clientHello = new ClientHelloMessage(this.config);
            earlyDataMsg = new ApplicationMessage(this.config);
            earlyDataMsg.setDataConfig(this.config.getEarlyData());
        } else {
            clientHello = new ClientHelloMessage();
            earlyDataMsg = new ApplicationMessage();
        }
        clientHelloMessages.add(clientHello);
        clientHelloMessages.add(earlyDataMsg);
        trace.addTlsAction(MessageActionFactory.createAction(connection, ConnectionEndType.CLIENT, clientHelloMessages));
        FinishedMessage serverFin = new FinishedMessage(this.config);
        if (connection.getLocalConnectionEndType() == ConnectionEndType.CLIENT) {
            serverHello = new ServerHelloMessage();
            encExtMsg = new EncryptedExtensionsMessage();
            encExtMsg.addExtension(new EarlyDataExtensionMessage());
        } else {
            serverHello = new ServerHelloMessage(this.config);
            encExtMsg = new EncryptedExtensionsMessage(this.config);
            encExtMsg.addExtension(new EarlyDataExtensionMessage());
        }
        serverMessages.add(serverHello);
        serverMessages.add(encExtMsg);
        serverMessages.add(serverFin);
        trace.addTlsAction(MessageActionFactory.createAction(connection, ConnectionEndType.SERVER, serverMessages));
        clientMessages.add(new EndOfEarlyDataMessage());
        clientMessages.add(new FinishedMessage(this.config));
        clientMessages.add(new ApplicationMessage(this.config));
        trace.addTlsAction(MessageActionFactory.createAction(connection, ConnectionEndType.CLIENT, clientMessages));
        return trace;
    }

    private WorkflowTrace createFullZeroRttWorkflow() {
        AliasedConnection ourConnection = this.getConnection();
        WorkflowTrace trace = this.createHandshakeWorkflow();
        for (TlsAction action : trace.getTlsActions()) {
            if (!action.isMessageAction()) continue;
            for (ProtocolMessage msg : ((MessageAction)action).getMessages()) {
                List<ExtensionMessage> extensions;
                if (!(msg instanceof ClientHelloMessage) || (extensions = ((HandshakeMessage)msg).getExtensions()) == null) continue;
                for (int x = 0; x < extensions.size(); ++x) {
                    if (!(extensions.get(x) instanceof PreSharedKeyExtensionMessage) && !(extensions.get(x) instanceof EarlyDataExtensionMessage)) continue;
                    ((HandshakeMessage)msg).getExtensions().remove(extensions.get(x));
                    --x;
                }
            }
        }
        trace.addTlsAction(MessageActionFactory.createAction(ourConnection, ConnectionEndType.SERVER, new NewSessionTicketMessage(false)));
        trace.addTlsAction(new ResetConnectionAction());
        WorkflowTrace zeroRttTrace = this.createZeroRttWorkflow();
        for (TlsAction zeroRttAction : zeroRttTrace.getTlsActions()) {
            trace.addTlsAction(zeroRttAction);
        }
        return trace;
    }

    private WorkflowTrace createSyncProxyWorkflow() {
        if (this.mode != RunningModeType.MITM) {
            throw new ConfigurationException("This workflow trace can only be created when running in MITM mode. Actual mode: " + (Object)((Object)this.mode));
        }
        InboundConnection inboundConnection = this.config.getDefaultServerConnection();
        String clientToMitmAlias = inboundConnection.getAlias();
        OutboundConnection outboundConnection = this.config.getDefaultClientConnection();
        String mitmToServerAlias = outboundConnection.getAlias();
        if (outboundConnection == null || inboundConnection == null) {
            throw new ConfigurationException("Could not find both necesary connection ends");
        }
        LOGGER.info("Building synchronizing proxy trace for:\n" + ((AliasedConnection)inboundConnection).toCompactString() + ", " + ((AliasedConnection)outboundConnection).toCompactString());
        WorkflowConfigurationFactory factory = new WorkflowConfigurationFactory(this.config);
        WorkflowTrace trace = factory.createTlsEntryWorkflowtrace(this.config.getDefaultClientConnection());
        trace.addConnection(inboundConnection);
        trace.addConnection(outboundConnection);
        List<CipherSuite> removeCiphers = CipherSuite.getImplemented();
        removeCiphers.addAll(CipherSuite.getNotImplemented());
        ArrayList<CipherSuite> keepCiphers = new ArrayList<CipherSuite>();
        for (CipherSuite cs : removeCiphers) {
            if (!cs.name().startsWith("TLS_RSA")) continue;
            keepCiphers.add(cs);
        }
        removeCiphers.removeAll(keepCiphers);
        List<ExtensionType> removeExtensions = ExtensionType.getReceivable();
        ArrayList keepExtensions = new ArrayList();
        removeExtensions.removeAll(keepExtensions);
        trace.addTlsActions(new BufferedGenericReceiveAction(clientToMitmAlias), new CopyBuffersAction(clientToMitmAlias, mitmToServerAlias), new RemBufferedChCiphersAction(mitmToServerAlias, removeCiphers), new RemBufferedChExtensionsAction(mitmToServerAlias, removeExtensions), new BufferedSendAction(mitmToServerAlias), new ClearBuffersAction(clientToMitmAlias), new BufferedGenericReceiveAction(mitmToServerAlias), new CopyBuffersAction(mitmToServerAlias, clientToMitmAlias), new PopAndSendAction(clientToMitmAlias), new PrintSecretsAction(clientToMitmAlias), new PrintSecretsAction(mitmToServerAlias), new PopBufferedMessageAction(clientToMitmAlias), new PopBufferedRecordAction(clientToMitmAlias), new SendAction(clientToMitmAlias, new CertificateMessage(this.config)), new PopAndSendAction(clientToMitmAlias), new ClearBuffersAction(mitmToServerAlias), new BufferedGenericReceiveAction(clientToMitmAlias), new CopyBuffersAction(clientToMitmAlias, mitmToServerAlias), new PopBuffersAction(mitmToServerAlias), new CopyPreMasterSecretAction(clientToMitmAlias, mitmToServerAlias), new SendAction(mitmToServerAlias, new RSAClientKeyExchangeMessage()), new PopAndSendAction(mitmToServerAlias), new ClearBuffersAction(mitmToServerAlias), new ClearBuffersAction(clientToMitmAlias), new SendAction(mitmToServerAlias, new FinishedMessage()), new PrintSecretsAction(clientToMitmAlias), new PrintSecretsAction(mitmToServerAlias), new ReceiveAction(mitmToServerAlias, new ChangeCipherSpecMessage(), new FinishedMessage()), new PrintSecretsAction(clientToMitmAlias), new PrintSecretsAction(mitmToServerAlias), new SendAction(clientToMitmAlias, new ChangeCipherSpecMessage(), new FinishedMessage()), new ForwardRecordsAction(clientToMitmAlias, mitmToServerAlias), new ForwardRecordsAction(mitmToServerAlias, clientToMitmAlias));
        return trace;
    }

    public ClientKeyExchangeMessage createClientKeyExchangeMessage(KeyExchangeAlgorithm algorithm) {
        if (algorithm != null) {
            switch (algorithm) {
                case RSA: {
                    return new RSAClientKeyExchangeMessage(this.config);
                }
                case ECDHE_ECDSA: 
                case ECDH_ECDSA: 
                case ECDH_RSA: 
                case ECDHE_RSA: 
                case ECDH_ANON: {
                    return new ECDHClientKeyExchangeMessage(this.config);
                }
                case DHE_DSS: 
                case DHE_RSA: 
                case DH_ANON: 
                case DH_DSS: 
                case DH_RSA: {
                    return new DHClientKeyExchangeMessage(this.config);
                }
                case PSK: {
                    return new PskClientKeyExchangeMessage(this.config);
                }
                case DHE_PSK: {
                    return new PskDhClientKeyExchangeMessage(this.config);
                }
                case ECDHE_PSK: {
                    return new PskEcDhClientKeyExchangeMessage(this.config);
                }
                case PSK_RSA: {
                    return new PskRsaClientKeyExchangeMessage(this.config);
                }
                case SRP_SHA_DSS: 
                case SRP_SHA_RSA: 
                case SRP_SHA: {
                    return new SrpClientKeyExchangeMessage(this.config);
                }
                case VKO_GOST01: 
                case VKO_GOST12: {
                    return new GOSTClientKeyExchangeMessage(this.config);
                }
                case ECCPWD: {
                    return new PWDClientKeyExchangeMessage(this.config);
                }
            }
            LOGGER.warn("Unsupported key exchange algorithm: " + (Object)((Object)algorithm) + ", not creating ClientKeyExchange Message");
        } else {
            LOGGER.warn("Unsupported key exchange algorithm: " + (Object)((Object)algorithm) + ", not creating ClientKeyExchange Message");
        }
        return null;
    }

    public ServerKeyExchangeMessage createServerKeyExchangeMessage(KeyExchangeAlgorithm algorithm) {
        if (algorithm != null) {
            switch (algorithm) {
                case RSA: 
                case DH_DSS: 
                case DH_RSA: {
                    return null;
                }
                case ECDHE_ECDSA: 
                case ECDHE_RSA: 
                case ECDH_ANON: {
                    return new ECDHEServerKeyExchangeMessage(this.config);
                }
                case DHE_DSS: 
                case DHE_RSA: 
                case DH_ANON: {
                    return new DHEServerKeyExchangeMessage(this.config);
                }
                case PSK: {
                    return new PskServerKeyExchangeMessage(this.config);
                }
                case DHE_PSK: {
                    return new PskDheServerKeyExchangeMessage(this.config);
                }
                case ECDHE_PSK: {
                    return new PskEcDheServerKeyExchangeMessage(this.config);
                }
                case SRP_SHA_DSS: 
                case SRP_SHA_RSA: 
                case SRP_SHA: {
                    return new SrpServerKeyExchangeMessage(this.config);
                }
                case ECCPWD: {
                    return new PWDServerKeyExchangeMessage(this.config);
                }
            }
            LOGGER.warn("Unsupported key exchange algorithm: " + (Object)((Object)algorithm) + ", not creating ServerKeyExchange Message");
        } else {
            LOGGER.warn("Unsupported key exchange algorithm: " + (Object)((Object)algorithm) + ", not creating ServerKeyExchange Message");
        }
        return null;
    }

    public void addClientKeyExchangeMessage(List<ProtocolMessage> messages) {
        CipherSuite cs = this.config.getDefaultSelectedCipherSuite();
        ClientKeyExchangeMessage message = this.createClientKeyExchangeMessage(AlgorithmResolver.getKeyExchangeAlgorithm(cs));
        if (message != null) {
            messages.add(message);
        }
    }

    public void addServerKeyExchangeMessage(List<ProtocolMessage> messages) {
        CipherSuite cs = this.config.getDefaultSelectedCipherSuite();
        ServerKeyExchangeMessage message = this.createServerKeyExchangeMessage(AlgorithmResolver.getKeyExchangeAlgorithm(cs));
        if (message != null) {
            messages.add(message);
        }
    }

    public WorkflowTrace addStartTlsActions(AliasedConnection connection, StarttlsType type, WorkflowTrace workflowTrace) {
        switch (type) {
            case FTP: {
                workflowTrace.addTlsAction(MessageActionFactory.createAsciiAction(connection, ConnectionEndType.SERVER, StarttlsMessage.FTP_S_CONNECTED.getStarttlsMessage(), "US-ASCII"));
                workflowTrace.addTlsAction(MessageActionFactory.createAsciiAction(connection, ConnectionEndType.CLIENT, StarttlsMessage.FTP_TLS.getStarttlsMessage(), "US-ASCII"));
                workflowTrace.addTlsAction(MessageActionFactory.createAsciiAction(connection, ConnectionEndType.SERVER, StarttlsMessage.FTP_S_READY.getStarttlsMessage(), "US-ASCII"));
                return workflowTrace;
            }
            case IMAP: {
                workflowTrace.addTlsAction(MessageActionFactory.createAsciiAction(connection, ConnectionEndType.SERVER, StarttlsMessage.IMAP_S_CONNECTED.getStarttlsMessage(), "US-ASCII"));
                workflowTrace.addTlsAction(MessageActionFactory.createAsciiAction(connection, ConnectionEndType.CLIENT, StarttlsMessage.IMAP_TLS.getStarttlsMessage(), "US-ASCII"));
                workflowTrace.addTlsAction(MessageActionFactory.createAsciiAction(connection, ConnectionEndType.SERVER, StarttlsMessage.IMAP_S_READY.getStarttlsMessage(), "US-ASCII"));
                return workflowTrace;
            }
            case POP3: {
                workflowTrace.addTlsAction(MessageActionFactory.createAsciiAction(connection, ConnectionEndType.SERVER, StarttlsMessage.POP3_S_CONNECTED.getStarttlsMessage(), "US-ASCII"));
                workflowTrace.addTlsAction(MessageActionFactory.createAsciiAction(connection, ConnectionEndType.CLIENT, StarttlsMessage.POP3_TLS.getStarttlsMessage(), "US-ASCII"));
                workflowTrace.addTlsAction(MessageActionFactory.createAsciiAction(connection, ConnectionEndType.SERVER, StarttlsMessage.POP3_S_READY.getStarttlsMessage(), "US-ASCII"));
                return workflowTrace;
            }
            case SMTP: {
                workflowTrace.addTlsAction(MessageActionFactory.createAsciiAction(connection, ConnectionEndType.SERVER, StarttlsMessage.SMTP_S_CONNECTED.getStarttlsMessage(), "US-ASCII"));
                workflowTrace.addTlsAction(MessageActionFactory.createAsciiAction(connection, ConnectionEndType.CLIENT, StarttlsMessage.SMTP_C_CONNECTED.getStarttlsMessage(), "US-ASCII"));
                workflowTrace.addTlsAction(MessageActionFactory.createAsciiAction(connection, ConnectionEndType.SERVER, StarttlsMessage.SMTP_S_OK.getStarttlsMessage(), "US-ASCII"));
                workflowTrace.addTlsAction(MessageActionFactory.createAsciiAction(connection, ConnectionEndType.CLIENT, StarttlsMessage.SMTP_TLS.getStarttlsMessage(), "US-ASCII"));
                workflowTrace.addTlsAction(MessageActionFactory.createAsciiAction(connection, ConnectionEndType.SERVER, StarttlsMessage.SMTP_S_READY.getStarttlsMessage(), "US-ASCII"));
                return workflowTrace;
            }
        }
        return workflowTrace;
    }

    private WorkflowTrace createDynamicHandshakeWorkflow() {
        AliasedConnection connection = this.getConnection();
        WorkflowTrace trace = new WorkflowTrace();
        if (this.config.getStarttlsType() != StarttlsType.NONE) {
            this.addStartTlsActions(connection, this.config.getStarttlsType(), trace);
        }
        trace.addTlsAction(MessageActionFactory.createAction(connection, ConnectionEndType.CLIENT, new ClientHelloMessage(this.config)));
        if (connection.getLocalConnectionEndType() == ConnectionEndType.CLIENT) {
            if (this.config.getHighestProtocolVersion().isTLS13()) {
                trace.addTlsAction(new ReceiveTillAction((ProtocolMessage)new FinishedMessage()));
            } else {
                trace.addTlsAction(new ReceiveTillAction((ProtocolMessage)new ServerHelloDoneMessage()));
            }
            trace.addTlsAction(new SendDynamicClientKeyExchangeAction());
            trace.addTlsAction(new SendAction(new ChangeCipherSpecMessage(this.config), new FinishedMessage(this.config)));
            trace.addTlsAction(new ReceiveAction(new ChangeCipherSpecMessage(this.config), new FinishedMessage(this.config)));
        } else {
            LinkedList<ProtocolMessage> messages = new LinkedList<ProtocolMessage>();
            messages.add(new ServerHelloMessage(this.config));
            if (this.config.getHighestProtocolVersion().isTLS13()) {
                if (Objects.equals(this.config.getTls13BackwardsCompatibilityMode(), Boolean.TRUE)) {
                    ChangeCipherSpecMessage ccs = new ChangeCipherSpecMessage();
                    ccs.setRequired(false);
                    messages.add(ccs);
                }
                messages.add(new EncryptedExtensionsMessage(this.config));
                if (this.config.isClientAuthentication().booleanValue()) {
                    CertificateRequestMessage certRequest = new CertificateRequestMessage(this.config);
                    messages.add(certRequest);
                }
                messages.add(new CertificateMessage(this.config));
                messages.add(new CertificateVerifyMessage(this.config));
                messages.add(new FinishedMessage(this.config));
                trace.addTlsAction(MessageActionFactory.createAction(connection, ConnectionEndType.SERVER, messages));
            } else {
                trace.addTlsAction(MessageActionFactory.createAction(connection, ConnectionEndType.SERVER, messages));
                trace.addTlsAction(new SendDynamicServerCertificateAction());
                trace.addTlsAction(new SendDynamicServerKeyExchangeAction());
                messages = new LinkedList();
                if (this.config.isClientAuthentication().booleanValue()) {
                    CertificateRequestMessage certRequest = new CertificateRequestMessage(this.config);
                    messages.add(certRequest);
                }
                messages.add(new ServerHelloDoneMessage(this.config));
                trace.addTlsAction(MessageActionFactory.createAction(connection, ConnectionEndType.SERVER, messages));
                trace.addTlsAction(new ReceiveTillAction((ProtocolMessage)new FinishedMessage()));
                trace.addTlsAction(new SendAction(new ChangeCipherSpecMessage(this.config), new FinishedMessage(this.config)));
            }
        }
        return trace;
    }

    private WorkflowTrace createDynamicHelloWorkflow() {
        AliasedConnection connection = this.getConnection();
        WorkflowTrace trace = new WorkflowTrace();
        if (this.config.getStarttlsType() != StarttlsType.NONE) {
            this.addStartTlsActions(connection, this.config.getStarttlsType(), trace);
        }
        trace.addTlsAction(MessageActionFactory.createAction(connection, ConnectionEndType.CLIENT, new ClientHelloMessage(this.config)));
        if (connection.getLocalConnectionEndType() == ConnectionEndType.CLIENT) {
            if (this.config.getHighestProtocolVersion().isTLS13()) {
                trace.addTlsAction(new ReceiveTillAction((ProtocolMessage)new FinishedMessage()));
            } else {
                trace.addTlsAction(new ReceiveTillAction((ProtocolMessage)new ServerHelloDoneMessage()));
            }
        } else {
            LOGGER.error("Not implemented for ConnectionEndType.SERVER");
        }
        return trace;
    }
}

