# GNU Typist - improved typing tutor program for UNIX systems
#
# Copyright (C) 2001, 2002, 2003 Simon Baldwin (simonb@sco.com)
# Copyright (C) 2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010, 2011,
#               2012, 2013, 2014, 2016, 2017, 2018, 2019, 2020
#               Michael Opdenacker, Felix Natter, Hynek Hanke,
#               Rob Leslie, Paul Goins
# Copyright (C) 2021, 2022, 2023 Felix Natter, Mihai Gătejescu
#
# GNU Typist is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# GNU Typist is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with GNU Typist.  If not, see <http://www.gnu.org/licenses/>.
#

T:
 :Vítáme vás v programu GNU Typist určeném k výuce správného
 :psaní na klávesnici všemi deseti prsty.
 :
 :Program je určen k výuce klávesnice QWERTY, ačkoliv jej lze
 :použít i pro QWERTZ. Podrobnosti najdete v nápovědě (stisk
 :F11 v hlavním menu).
 :
 :Pokud jste ještě nikdy žádný kurz neabsolvovali, doporučujeme
 :začít se sérií T, která vám vše důkladně vysvětlí, předvede
 :a procvičí. Je dost pravděpodobné, že se vám budou jednotlivá
 :písmenka ze začátku plést a v takovém případě můžete sérii
 :T doplňovat cvičeními ze série U. Pokročilejší lekce ze série
 :U vám také mohou pomoci s tréningem rychlosti a přesnosti.
 :Když již budete ovládat techniku psaní, doporučujeme vám
 :sérii procvičovacích testů M a rychlostních testů S.
 :Úplně nezávisle na předchozím jsme pro vás také připravili
 :lekce ovládání numerické klávesnice, které najdete
 :pod písmenem N.
 :	Přejeme hodně úspěchů.
#==============================================================================
# Combined series file
#==============================================================================
G:__SERIESMENU
*:__NO_SERIESMENU
#==============================================================================
*:__S_Q_SERIES
# Start of file q.typ
# Typist v2.2 - improved typing tutor program for UNIX systems
# Copyright (C) 1998 Simon Baldwin (simonb@sco.com)
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

#------------------------------------------------------------------------------
# Series Q
#------------------------------------------------------------------------------
G:_Q_MENU
*:_Q_NO_MENU
#------------------------------------------------------------------------------
# Lekce Q1
#------------------------------------------------------------------------------
*:Q1
*:_Q_S_Q1
*:_Q_R_L0
#                                                             ../orig/q.typ:21
T:			Welcome to lesson Q1.
 :
 :In the Q series of lessons, we will be learning to touch-type on the standard
 :keyboard. I will introduce you to each letter on the keyboard, one at a time.
 :By the time you have completed this series, you will be able to type the entire
 :alphabet, the numbers, and most of the punctuation keys by touch.
 :
 :If you have never taken any lessons in typing before, please be patient. Typing
 :is not difficult but it does take a lot of practice. Avoid the tendency to
 :look down at your fingers while typing. This is a very bad habit and is hard
 :to break later. If you hit the wrong key, I will let you know.  (But, I won't
 :tell anyone else, so don't worry about it.)
 :
 :If you have always used the hunt-and-peck method, you will have an even harder
 :time keeping yourself from looking. Don't be surprised if you find touch
 :typing slower than your old ways. It may be slower when you first start.
 :But, touch typing is far faster once you get the hang of it.
 :
 :If you can already touch type, you should be able to go through these lessons
 :fairly quickly. Or, you may want to go directly to the S series.

*:_Q_R_L1
#                                                             ../orig/q.typ:42
T:
 :			The HOME Keys.
 :
 :In order to hit the correct keys by touch alone, you must always know where your
 :fingers are. The way to do this is to have a special place for each finger.
 :This key is called the HOME position.
 :
 :Place the first finger of your right hand on the J-key. Now, place your second
 :finger on the K-key, your third finger on the L-key, and your fourth-finger on
 :the ;-key (the one with the : and ; on it).
 :
 :Similarly place the four fingers of your left hand on the F, D, S, and A-keys.
 :Place your right thumb over the SPACE bar. (Henceforth, always hit the SPACE
 :bar with this thumb.) Now, lift all your fingers slightly so that they are
 :poised just over the keys. Each finger should be just barely touching its home
 :key. This is an electronic keyboard and does not take much pressure to ac-
 :cidentally press the key down.
 :
 :Above the D-key is the E-key. Above the K-key is the I-key.  Learn these
 :positions well. Whenever you are about to type a line, look at your fingers and
 :make sure they are in the HOME position. Then don't look at them again.

*:_Q_R_L2
#                                                             ../orig/q.typ:63
T:
 :			DRILL PATTERNS
 :
 :For the rest of this lesson, I will display a line of text in the middle of the
 :screen and instructions at the top of the screen.
 :
 :All you have to do is type in the characters that you see in the middle of
 :the screen. If you hit the correct key, I will not do anything.  If you make
 :a mistake, I will display a large X under the letter that you got wrong and
 :beep the terminal. In either event, just keep going by typing the next letter.
 :
 :When you have finished typing the line, hit the RETURN key. To do this, extend
 :the little finger of your right hand over to the RETURN key. Hit the key and
 :zip the finger back to its home position. Be careful not to let your other
 :fingers move far from their home positions in the process. Also, be careful
 :not to type an extra space at the end of the line.
 :
 :If you made no mistakes on the line, I will display the next drill pattern. If
 :you did make a mistake, I will beep at you and make you do the line again. If
 :on the second try you made more than two mistakes, I will beep again and make
 :you try again, etc. Don't forget to use your right thumb for the SPACE bar.

#                                                             ../orig/q.typ:64
I:(1) Try this:
*:_Q_R_L3
#                                                             ../orig/q.typ:65
D:asdf ;lkj asdf ;lkj asdf ;lkj asdf ;lkj asdf ;lkj asdf ;lkj

#                                                             ../orig/q.typ:66
I:Now this:
*:_Q_R_L4
#                                                             ../orig/q.typ:67
D:asdef ;lkij asdef ;lkij asdef ;lkij asdef ;lkij asdef ;lkij

#                                                             ../orig/q.typ:68
I:(2) Some more:
*:_Q_R_L5
#                                                             ../orig/q.typ:71
D:as al ad ak af aj fa ka da la sa ja sl sd sk sf ls ds ks fs
 :de le ae ke se je fe ed el ea ek es ej ef ed lf dk dl fl kl
 :ki ai li si di ji fi ia il is ik id ij if dd ee ss ff ll ei

#                                                             ../orig/q.typ:72
I:(3) Hang in there; let's do some sentences...
*:_Q_R_L6
#                                                             ../orig/q.typ:73
D:Dad adds a salad A lad asks  Salad falls as a lad asks Dad

#                                                             ../orig/q.typ:74
I:(4)
*:_Q_R_L7
#                                                             ../orig/q.typ:76
D:Lease a desk Add a safe deal  Ask less fees  Add a lease
 :Lease a lake Add lake sales  Add deeds  Flee false deals

#                                                             ../orig/q.typ:77
I:(5)
*:_Q_R_L8
#                                                             ../orig/q.typ:80
D:Feel a dead faded leaf Seeds fall as a faded leaf falls
 :A lad sells seeds Dad feels a seed  Dad adds a seed deal
 :A deaf lad sells a false jade Dad sells a deaf lad a sled

#                                                             ../orig/q.typ:81
I:(6)
*:_Q_R_L9
#                                                             ../orig/q.typ:85
D:Idle Sid seeks a salad Sis aids Sid  A salad is laid aside
 :Sid seeks a lake Sis is all silks Sid likes silks
 :A lad asks if Dad likes lilies Dad is ill  Dad feels life dies as lilies fade
 :Dad slides all lilies aside Dad is jaded

#                                                             ../orig/q.typ:86
I:(7)
*:_Q_R_L10
#                                                             ../orig/q.typ:91
D:Sails fill as Sis sails a safe lake Skill aids Sis  Dad
 :likes a safe sail Sis seeks a lee isle  All sail is
 :laid aside Sis feels life is ideal  Idle fields lead as
 :Sis seeks lilies Sis falls  Lilies fade as Sis falls
 :Faded sails fill Idle isles slide aside as Sis sails

#                                                             ../orig/q.typ:92
I:(8)
*:_Q_R_L11
#                                                             ../orig/q.typ:93
D:Sid adds all sail as Dad sees a safe sea as idle as a lake

G:_Q_E_Q1
#------------------------------------------------------------------------------
# Lekce Q2
#------------------------------------------------------------------------------
*:Q2
*:_Q_S_Q2
*:_Q_R_L12
#                                                            ../orig/q.typ:104
T:
 :			 (h g o u n . t)
 :
 :In this lesson you learn six new letters (H, G, O, U, N, T) and the period. (.).
 :Be sure that the F-finger does not linger on the G-key or the J-finger on the
 :H-key.
 :
 :Note that you always follow a period with two spaces.

#                                                            ../orig/q.typ:105
I:(1) Rhythm Drill
*:_Q_R_L13
#                                                            ../orig/q.typ:108
D:a;sldkfjgh a;sldkfjgh a;sldkfjgh a;sldkfjgh a;sldkfjgh
 :asdefghk lokijujhjn asdefghk lokijujhjn asdefghk
 :l. a.  l.  s.  l.  d.  l.  e.  l.  n.  l.  t.  l.  o.

#                                                            ../orig/q.typ:109
I:(2) Balanced Keyboard Drill
*:_Q_R_L14
#                                                            ../orig/q.typ:112
D:as os es us is an on en un in at ot et ut it ad od ed ud id
 :sa so se su si na no ne nu ni ta to te tu ti ha ho he hu hi
 :da do de du di au st oi sh oi ts ht oe nk ou nd ue ns ui th

#                                                            ../orig/q.typ:113
I:(3) Continuous Copy
*:_Q_R_L15
#                                                            ../orig/q.typ:116
D:Ed had a shed.  His shed had dishes.  He had shade.
 :Ed had his ease. Sis liked a safe shed.  Sis had shade.
 :His shed is ashes. Ed hides his head.  He heeds Sis.

#                                                            ../orig/q.typ:117
I:(4)
*:_Q_R_L16
#                                                            ../orig/q.typ:120
D:Odd ideas are like odd seeds. Odd seeds die as do odd deeds.
 :Dad has odd ideas. Dad sees a soda as a sad dose.  A soda
 :aids Sis. So I see a soda is added.  Sis does like a soda.

#                                                            ../orig/q.typ:121
I:(5)
*:_Q_R_L17
#                                                            ../orig/q.typ:124
D:Sid used us. Sid sued us.  Ada used us as aid.  I did aid.
 :I added ease. I issued added deeds.  Ada said adieu.  Ada
 :used dead deeds as issues. Sid said I used deeds due Ada.

#                                                            ../orig/q.typ:125
I:(6)
*:_Q_R_L18
#                                                            ../orig/q.typ:128
D:Ed is staid. Ed uses tested data as assets.  Sis is a
 :tease. Sis sets a tea date.  As Ed tastes tea I state tea
 :data. Sis teases Ed at tea.  As Ed eats I state diet data.

#                                                            ../orig/q.typ:129
I:(7)
*:_Q_R_L19
#                                                            ../orig/q.typ:132
D:Sis said Dean is dense as sand. Dean needs an idea and Sis
 :needs a sedan. Dad sends a sedan.  Dean is indeed sad as
 :he sees Sis and Ed inside. At nine he sees Sis and Ed dine.

#                                                            ../orig/q.typ:133
I:(8) Rhythmic Review
*:_Q_R_L20
#                                                            ../orig/q.typ:134
D:He sees that in a test he has to state and use a sane idea.

G:_Q_E_Q2
#------------------------------------------------------------------------------
# Lekce Q3
#------------------------------------------------------------------------------
*:Q3
*:_Q_S_Q3
*:_Q_R_L21
#                                                            ../orig/q.typ:147
T:
 :			 (y r c , ? : p)
 :
 :You learned first the letters that are most frequently used in the English
 :language. They are repeated over and over again.
 :
 :One space always follows a comma. Don't forget there are two spaces between
 :sentences, no matter what punctuation mark closes the sentence.
 :
 :The colon (:) introduces a list and is followed by two spaces.

#                                                            ../orig/q.typ:148
I:(1) Rhythm Drill
*:_Q_R_L22
#                                                            ../orig/q.typ:150
D:deki frju dck, dcl. frju ftjy deki frju dck, dcl. frju ftjy
 :fgjh ;p;? jujy dedc lol. kik, fgju ;:;: frfk jujy dedc kik,

#                                                            ../orig/q.typ:151
I:(2) Balanced Keyboard Drill
*:_Q_R_L23
#                                                            ../orig/q.typ:157
D:ag ac ar al ap at ay af ug uc ur ul up ut eg ec er el ep et
 :ey ef og or ol op ot of ig ic ir il ip if ga ca ra la pa fa
 :gu cu ru lu pu fu ge ce re le pe ye fe go co ro lo po yo fo
 :gi ci ri li fi gn pl gh ld sy rd ty ct ft ch nc dy dr ph ng
 :s? d?  e?  f?  r?  f?  t?  j?  n?  s:  d:  e:  r:  t:  n:
 :k, i, d, e, f, r, k, u, f, t, k, y, d, c, k, n, k, h, l, o,

#                                                            ../orig/q.typ:158
I:(3) Continuous Copy
*:_Q_R_L24
#                                                            ../orig/q.typ:160
D:Chance can aid a nice choice. It can teach one to count his
 :costs too. In each such case a chance cause can hit costs.

#                                                            ../orig/q.typ:161
I:(4)
*:_Q_R_L25
#                                                            ../orig/q.typ:163
D:At his age a good song is the thing as he gets his dog and
 :gun. He is going to hunt again.  As night ends he sets out.

#                                                            ../orig/q.typ:164
I:(5)
*:_Q_R_L26
#                                                            ../orig/q.typ:166
D:As soon as papa is deep in a nap Pat happens to pound in his
 :shop and the phone sounds. Pat is to paint and pass up noise.

#                                                            ../orig/q.typ:167
I:(6)
*:_Q_R_L27
#                                                            ../orig/q.typ:169
D:I hear there is an error in her other order. The store sent
 :her red dress to our door. She is sure that it is too dear.

#                                                            ../orig/q.typ:170
I:(7)
*:_Q_R_L28
#                                                            ../orig/q.typ:172
D:I shall hold those ideal hotel lots at least until all land
 :is sold. Late sales still total less than the one old deal.

#                                                            ../orig/q.typ:173
I:(8)
*:_Q_R_L29
#                                                            ../orig/q.typ:175
D:Sunday is too soon. It is not easy to stay and study this
 :dandy day. I need to study.  It is not easy on the eyes.

#                                                            ../orig/q.typ:176
I:(9)
*:_Q_R_L30
#                                                            ../orig/q.typ:178
D:One needs to use faith if one fishes often. It is fun to sit
 :on soft sod and fish. It is fun to feel a fish dash out fast.

#                                                            ../orig/q.typ:179
I:(9A)
*:_Q_R_L31
#                                                            ../orig/q.typ:183
D:Hello, is this Dan? Hello, Dan, this is Ann.  No, Ann.  Did
 :you see Ted? Is Nan at the house?  Then dash to the house.
 :Is he at the house? Has he his auto?  Did he tie on those
 :odds and ends: used suits, sun hats, shoes, and side tent?

#                                                            ../orig/q.typ:184
I:(10) Rhythmic Review
*:_Q_R_L32
#                                                            ../orig/q.typ:185
D:Papa can not plan to get us all there in such a car as this.

G:_Q_E_Q3
#------------------------------------------------------------------------------
# Lekce Q4
#------------------------------------------------------------------------------
*:Q4
*:_Q_S_Q4
*:_Q_R_L33
#                                                            ../orig/q.typ:196
T:
 :			(m w v z x b q ' -)
 :
 :Self control is important in learning to type. Concentrate on using the
 :correct finger for each key. In this lesson you learn the seven remaining
 :letters of the alphabet.
 :
 :The semicolon (;), like the comma, is followed by one space in a sentence.

#                                                            ../orig/q.typ:197
I:(1) Rhythm Drill
*:_Q_R_L34
#                                                            ../orig/q.typ:199
D:dedc kik, frfv jujm swsx lol. aqaz ;p;p frfv jujm ftfb jyjn
 :aqsw az;p sxl. fvjm fvjn fbjn aqsw az;p sxl. fvjm fvjn fbjn

#                                                            ../orig/q.typ:200
I:(2) Balanced Keyboard Drill
*:_Q_R_L35
#                                                            ../orig/q.typ:204
D:am aw av az ak ax ab um ub em ew ev ez ek eq ex om ow ov oz
 :ok ob im iv iz ix ib ma wa va za ka ja xa ba mu ju qu bu me
 :we ve ze ke je xe be mo wo vo zo ko jo bo mi wi vi zi ki xi
 :bi xt sm sk sw kn ms nk wh tw ks wn dv s; o; n; d; l; e; t;

#                                                            ../orig/q.typ:205
I:(3) Continuous Copy
*:_Q_R_L36
#                                                            ../orig/q.typ:207
D:Iowa was white with snow when we two went down town and saw
 :a show. We wanted to see news and not the widow who was wed.

#                                                            ../orig/q.typ:208
I:(4)
*:_Q_R_L37
#                                                            ../orig/q.typ:210
D:John has to use a tan and jet auto. He joined Jane in its
 :joint use. Jane just intends to use it in June on a jaunt.

#                                                            ../orig/q.typ:211
I:(5)
*:_Q_R_L38
#                                                            ../orig/q.typ:213
D:Smith is his name. He is on some Maine team.  I am to meet
 :him and Miss Smith. I must see them some time this month.

#                                                            ../orig/q.typ:214
I:(6)
*:_Q_R_L39
#                                                            ../orig/q.typ:216
D:Kate uses ink to send a note south to Kansas kin. She asks
 :to use a kodak to take along on these keen skates and skis.

#                                                            ../orig/q.typ:217
I:(7)
*:_Q_R_L40
#                                                            ../orig/q.typ:219
D:I advise Eva in vain to avoid an auto visit in seven states.
 :Nevada is so vivid that Eva votes to have this visit saved.

#                                                            ../orig/q.typ:220
I:(8)
*:_Q_R_L41
#                                                            ../orig/q.typ:222
D:She has questions and unique ideas to quote us. So she is
 :quite the queen in this quiet set and sets us quaint quotas.

#                                                            ../orig/q.typ:223
I:(9)
*:_Q_R_L42
#                                                            ../orig/q.typ:225
D:The zoo is shut. His zest is dashed.  Dan dozes.  One sneeze
 :and then a dozen seize Dan. In a daze he sees the zoo seized.

#                                                            ../orig/q.typ:226
I:(9A)
*:_Q_R_L43
#                                                            ../orig/q.typ:228
D:The boat has been best to Boston. On this basis no doubt one
 :is bound to be a bit behind but boats beat both dust and heat.

#                                                            ../orig/q.typ:229
I:(9B)
*:_Q_R_L44
#                                                            ../orig/q.typ:231
D:Nan is in Texas. She is anxious to dine at six.  She sees a
 :taxi stand next to the sixth exit. Taxis exist to aid one.

#                                                            ../orig/q.typ:232
I:(10) Rhythmic Review
*:_Q_R_L45
#                                                            ../orig/q.typ:233
D:Ask them to let us have the car if they both go to the show.

G:_Q_E_Q4
#------------------------------------------------------------------------------
# Lekce Q5
#------------------------------------------------------------------------------
*:Q5
*:_Q_S_Q5
*:_Q_R_L46
#                                                            ../orig/q.typ:239
T:
 :Now you know all of the alphabet. In this lesson we add the hyphen (-) and
 :the apostrophe (').

#                                                            ../orig/q.typ:240
I:(1) Rhythm Drill
*:_Q_R_L47
#                                                            ../orig/q.typ:242
D:dedc kik, frfv jujm swsx lol. aqaz ;p;p frfv jujm ftfb jyjn
 :frfk fvfb jujy jmjn aqsw azsw azsx ;plo ;p;- kik, ;p;-

#                                                            ../orig/q.typ:243
I:(2) Balanced Keyboard Drill
*:_Q_R_L48
#                                                            ../orig/q.typ:246
D:ad ar an al am ab ee st ed er en el es em ex om on or un up
 :id ic ir in im se sy le ly re ry ec fy ty de be my by bi di
 :l-t o-d s-c p-t o-d n-y r-o g-d r-h d-g n't t's l's y's I'l

#                                                            ../orig/q.typ:247
I:(3) Continuous Copy -- Review
*:_Q_R_L49
#                                                            ../orig/q.typ:249
D:It is a good thing papa has gone. Pat gets up a deep song.
 :Yet Ann says an easy song any day is a sign to guess again.

#                                                            ../orig/q.typ:250
I:(4)
*:_Q_R_L50
#                                                            ../orig/q.typ:252
D:They often need funds but don't think it is any fun to study.
 :Ann is keen to ask him to use his kodak at the same time.

#                                                            ../orig/q.typ:253
I:(5)
*:_Q_R_L51
#                                                            ../orig/q.typ:255
D:Ted notes an odd noise. Dan is in the seas and needs aid.
 :He sheds his suit and shoes on the sand and is out in haste.

#                                                            ../orig/q.typ:256
I:(6)
*:_Q_R_L52
#                                                            ../orig/q.typ:258
D:A good visit East is Ann's next quest. Ann seems to seize
 :on this idea with zest. She has set seven visits as a quota.

#                                                            ../orig/q.typ:259
I:(7)
*:_Q_R_L53
#                                                            ../orig/q.typ:261
D:She is to adjust her six visits to have a snow-white Maine
 :Christmas. An Iowa aunt asks Ann to take in that state, too.

#                                                            ../orig/q.typ:262
I:(8)
*:_Q_R_L54
#                                                            ../orig/q.typ:264
D:It's a tax on time, but it's quite a new zone to Ann who is
 :in just the mood to end her quota of visits in sixteen weeks.

#                                                            ../orig/q.typ:265
I:(9) Rhythmic Review
*:_Q_R_L55
#                                                            ../orig/q.typ:266
D:Two of the boys are to do it today and two of them next week.

G:_Q_E_Q5
#------------------------------------------------------------------------------
# Lekce series Q jump tables
#------------------------------------------------------------------------------
*:_Q_E_Q1
Q:Do you want to continue to lesson Q2 [Y/N] ?
N:_Q_MENU
G:_Q_M_Q2
*:_Q_E_Q2
Q:Do you want to continue to lesson Q3 [Y/N] ?
N:_Q_MENU
G:_Q_M_Q3
*:_Q_E_Q3
Q:Do you want to continue to lesson Q4 [Y/N] ?
N:_Q_MENU
G:_Q_M_Q4
*:_Q_E_Q4
Q:Do you want to continue to lesson Q5 [Y/N] ?
N:_Q_MENU
G:_Q_M_Q5
*:_Q_E_Q5
G:_Q_MENU

*:_Q_M_Q1
B:                            Lekce Q1
G:_Q_S_Q1
*:_Q_M_Q2
B:                            Lekce Q2
G:_Q_S_Q2
*:_Q_M_Q3
B:                            Lekce Q3
G:_Q_S_Q3
*:_Q_M_Q4
B:                            Lekce Q4
G:_Q_S_Q4
*:_Q_M_Q5
B:                            Lekce Q5
G:_Q_S_Q5
#------------------------------------------------------------------------------
# Lekce series Q menu
#------------------------------------------------------------------------------
*:_Q_MENU
M: UP=__SERIESMENU "Série Q obsahuje těchto 5 lekcí"
 :_Q_M_Q1 "Lekce Q1     a s d f g h j k l ;"
 :_Q_M_Q2 "Lekce Q2     h g o u n . t"
 :_Q_M_Q3 "Lekce Q3     y r c , ? : p"
 :_Q_M_Q4 "Lekce Q4     m w v z x b q"
 :_Q_M_Q5 "Lekce Q5     ' -"
*:_Q_EXIT

#------------------------------------------------------------------------------
# End of file q.typ
G:__SERIESMENU
#==============================================================================
#==============================================================================
*:__S_R_SERIES
# Typist v2.2 - improved typing tutor program for UNIX systems
# Copyright (C) 1998 Simon Baldwin (simonb@sco.com)
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

#------------------------------------------------------------------------------
# Series R
#
# Thanks to Richard Susta <r@susta.cz> for these lessons (series R)
# (exported from his program Psaci stroj (Typewriter)).
#
#------------------------------------------------------------------------------
G:_R_MENU
*:_R_NO_MENU
#------------------------------------------------------------------------------
# Lekce R1
#------------------------------------------------------------------------------
*:R1
*:_R_S_R1
*:_R_R_L0
#                                                              ../orig/r.typ:4
T:
 :V této sérii lekcí si zopakujeme kurz správného psaní,
 :budeme postupně přidávat písmena a zaměříme se na rychlost
 :a přesnost.

#                                                              ../orig/r.typ:5
I:F, J - levým a pravým ukazováčkem
 :D, K - levý a pravý prostředník.
*:_R_R_L1
#                                                              ../orig/r.typ:6
D:f f f f f f f f f f f f f f f f f f f f f f f
 :j j j j j j j j j j j j j j j j j j j j j j j
 :f j f j f j f j f j f j f j f j f j f j f j f
 :d d d d d d d d d d d d d d d d d d d d d d d
 :k k k k k k k k k k k k k k k k k k k k k k k
 :d k d k d k d k d k d k d k d k d k d k d k d
 :f j d k f j d k f j d k f j d k f j d k f j d
 :fj fj fj fj fj fj fj fj fj fj fj fj fj fj fj

#                                                              ../orig/r.typ:7
I:F, J - levým a pravým ukazováčkem
 :D, K - levý a pravý prostředník.
*:_R_R_L2
#                                                              ../orig/r.typ:8
D:dk dk dk dk dk dk dk dk dk dk dk dk dk dk dk
 :jf jf jf jf jf jf jf jf jf jf jf jf jf jf jf
 :kd kd kd kd kd kd kd kd kd kd kd kd kd kd kd
 :dk kd dk kd dk kd dk kd dk kd dk kd dk kd dk
 :dj jd dj jd dj jd dj jd dj jd dj jd dj jd dj
 :df fd df fd df fd df fd df fd df fd df fd df
 :fj jf fj jf fj jf fj jf fj jf fj jf fj jf fj
 :jk kj jk kj jk kj jk kj jk kj jk kj jk kj jk

#                                                              ../orig/r.typ:9
I:Snažte se psát rytmicky i za cenu nižší rychlosti.
*:_R_R_L3
#                                                             ../orig/r.typ:10
D:fk kf fk kf fk kf fk kf fk kf fk kf fk kf fk kf
 :fkj jkf fkj jkf fkj jkf fkj jkf fkj jkf fkj jkf
 :fjk kjf fjk kjf fjk kjf fjk kjf fjk kjf fjk kjf
 :dfj jfd dfj jfd dfj jfd dfj jfd dfj jfd dfj jfd
 :djf fjd djf fjd djf fjd djf fjd djf fjd djf fjd
 :kdf fdk kdf fdk kdf fdk kdf fdk kdf fdk kdf fdk
 :jdf fdj jdf fdj jdf fdj jdf fdj jdf fdj jdf fdj
 :kfj jfk kfj jfk kfj jfk kfj jfk kfj jfk kfj jfk
 :dkf kfd dkf kfd dkf kfd dkf kfd dkf kfd dkf kfd

#                                                             ../orig/r.typ:11
I:Ještě čtyřpísmenné kombinace
*:_R_R_L4
#                                                             ../orig/r.typ:13
D:jfd kjf jfd kjf jfd kjf jfd kjf jfd kjf jfd kjf
 :fjf fjd fjf fjd fjf fjd fjf fjd fjf fjd fjf fjd
 :kjk kjd kjk kjd kjk kjd kjk kjd kjk kjd kjk kjd
 :dfjk kjfd dfjk kjfd dfjk kjfd dfjk kjfd dfjk kj
 :fjdk jfkd fjdk jfkd fjdk jfkd fjdk jfkd fjdk jf
 :dfjk kjdf dfjk kjdf dfjk kjdf dfjk kjdf dfjk kj
 :fjdk jfdk fjdk jfdk fjdk jfdk fjdk jfdk fjdk jf

#                                                             ../orig/r.typ:14
I:Písmeno S píšeme levým prsteníkem,
 :písmeno L prsteníkem pravým.
*:_R_R_L5
#                                                             ../orig/r.typ:17
D:f j d k f j d k f j d k f j d k f j d k f j d kf
 :fj jf dk kd fj jf dk kd fj jf dk kd fj jf dk kd
 :fjk kjf dfj jfd fjk kjf dfj jfd fjk kjf dfj jfd
 :s l s l s l s l s l s l s l s l s l s l s l s l
 :f j d k s l f j d k s l f j d k s l f j d k s l
 :sl ls sl ls sl ls sl ls sl ls sl ls sl ls sl ls
 :sd ds sd ds sd ds sd ds sd ds sd ds sd ds sd ds
 :lk kl lk kl lk kl lk kl lk kl lk kl lk kl lk kl
 :sf fs sf fs sf fs sf fs sf fs sf fs sf fs sf fs

#                                                             ../orig/r.typ:18
I:Opět klademe důraz na pravidelnost úhozů.
*:_R_R_L6
#                                                             ../orig/r.typ:22
D:lf fl lf fl lf fl lf fl lf fl lf fl lf fl lf fl
 :sk ks sk ks sk ks sk ks sk ks sk ks sk ks sk ks
 :sdf fds sdf fds sdf fds sdf fds sdf fds sdf fds
 :lkj jkl lkj jkl lkj jkl lkj jkl lkj jkl lkj jkl
 :sfj jfs sfj jfs sfj jfs sfj jfs sfj jfs sfj jfs
 :ljk fjl ljk fjl ljk fjl ljk fjl ljk fjl ljk fjl
 :sdj jds sdj jds sdj jds sdj jds sdj jds sdj jds
 :lkf fkl lkf fkl lkf fkl lkf fkl lkf fkl lkf fkl
 :sdf jkl sdf jkl sdf jkl sdf jkl sdf jkl sdf jkl


#                                                             ../orig/r.typ:23
I:Máte správně pokrčené prsty?
*:_R_R_L7
#                                                             ../orig/r.typ:28
D:lkj fds lkj fds lkj fds lkj fds lkj fds lkj fds lkj
 :fds lkj fds lkj fsd jlk fsd jlk fsd jlk fsd jlk fsd
 :jlk fsd jlk fsd jlk fsd jlk fsd dfs kjl dfs kjl dfs
 :kjl dfs kjl dfs kjl dfs kjl dfs kjl dfs kjl dfs dsf
 :klj dsf klj dsf klj dsf klj dsf klj dsf klj dsf klj
 :dsf klj dsf sfj ljk sfj ljk sfj ljk sfj ljk sfj ljk
 :sfj ljk sfj ljk sfj ljk sfj

I:Písmeno A píšeme levým malíčkem,
 :písmeno Ů malíčkem pravým.
*:_R_R_L8
#                                                             ../orig/r.typ:43
D:f j d k s l f j d k s l f j d k s l f j d k s l f
 :fj jf dk kd sl ls fj jf dk kd sl ls fj jf dk kd sl
 :fds jkl sdf lkj fds jkl sdf lkj fds jkl sdf lkj fds
 :fsd jlk sfd ljk fsd jlk sfd ljk fsd jlk sfd ljk fsd
 :a ů a ů a ů a ů a ů a ů a ů a ů a ů a ů a ů a ů a ů
 :f j d k s l a ů f j d k s l a ů f j d k s l a ů f j
 :fa jů fa jů fa jů fa jů fa jů fa jů fa jů fa jů fa
 :da ků da ků da ků da ků da ků da ků da ků da ků da


#                                                             ../orig/r.typ:44
I:Nezvedejte ostatní prsty z jejich základní polohy.
*:_R_R_L9
#                                                             ../orig/r.typ:49
D:sa lů sa lů sa lů sa lů sa lů sa lů sa lů sa lů
 :ja ka la ja ka la ja ka la ja ka la ja ka la ja
 :fů dů sů fů dů sů fů dů sů fů dů sů fů dů sů fů
 :fa da sa fa da sa fa da sa fa da sa fa da sa fa
 :jů ků lů jů ků lů jů ků lů jů ků lů jů ků lů jů
 :as ad af as ad af as ad af as ad af as ad af as
 :ůl ůk ůj ůl ůk ůj ůl ůk ůj ůl ůk ůj ůl ůk ůj ůl
 :jas sad jas sad jas sad jas sad jas sad jas sad

#                                                             ../orig/r.typ:50
I:Pokračujte v procvičování.
*:_R_R_L10
#                                                             ../orig/r.typ:56
D:jak jsa jak jsa jak jsa jak jsa jak jsa jak jsa
 :kůl lůj kůl lůj kůl lůj kůl lůj kůl lůj kůl lůj
 :jal sak jal sak jal sak jal sak jal sak jal sak
 :dal lak dal lak dal lak dal lak dal lak dal lak
 :sladů klasů sladů klasů sladů klasů sladů klasů
 :sklad kajak sklad kajak sklad kajak sklad kajak
 :kladů kladl kladů kladl kladů kladl kladů kladl
 :jas kůl jak lůj jal důl sak lak sůl dal klů jas
 :kladů sladů klasů sklad kajak kladl sladů klasů

#                                                             ../orig/r.typ:57
I:Písmena G a H píšeme ukazováčky vychýlením
 :ze základní polohy.
*:_R_R_L11
#                                                             ../orig/r.typ:58
D:f j d k s l a ů f j d k s l a ů f j d k s l a ů
 :fa jů da ků sa lů fa jů da ků sa lů fa jů da ků
 :ja ka la fů dů sů ja ka la fů dů sů ja ka la fů
 :as ad af ůl ůk ůj as ad af ůl ůk ůj as ad af ůl
 :jas kůl jak lůj sak důl lak jas kůl jak lůj sak
 :kladů sladů klasů sklad kajak kladů sladů klasů
 :g h g h g h g h g h g h g h g h g h g h g h g h
 :f j d k s l a ů g h f j d k s l a ů g h f j d k

G:_R_E_R1
#------------------------------------------------------------------------------
# Lekce R2
#------------------------------------------------------------------------------
*:R2
*:_R_S_R2
#                                                             ../orig/r.typ:62
I:Pokračujeme s písmeny G a H.
*:_R_R_L12
#                                                             ../orig/r.typ:63
D:fgf jhj fgf jhj fgf jhj fgf jhj fgf jhj fgf
 :dgf khj dgf khj dgf khj dgf khj dgf khj dgf
 :sgf lhj sgf lhj sgf lhj sgf lhj sgf lhj sgf
 :agf ůhj agf ůhj agf ůhj agf ůhj agf ůhj agf
 :kg ha kg ha kg ha kg ha kg ha kg ha kg ha
 :ag hl ag hl ag hl ag hl ag hl ag hl ag hl

#                                                             ../orig/r.typ:64
I:Zkusíme slova.
*:_R_R_L13
#                                                             ../orig/r.typ:65
D:gag hala gag hala gag hala gag hala gag hala
 :haf has haf has haf has haf has haf has haf
 :halas hůlka halas hůlka halas hůlka halas
 :halda hlasů halda hlasů halda hlasů halda
 :jahůdka lahůdka jahůdka lahůdka jahůdka
 :jas has jak gag jal hal kůl gal lůj aga
 :kladů halas sladů halda klasů hůlka kajak
 :kladů halas skladů jahůdka klasů hůlka aga

#                                                             ../orig/r.typ:66
I:Písmena R a L píšeme oběma ukazováčky vychylováním
 :vlevo nahoru.
*:_R_R_L14
#                                                             ../orig/r.typ:67
D:hlas klasů hůlka sklad hlasů halas klasů hůlka
 :jahůdka lahůdka jahůdka lahůdka jahůdka lahůdka
 :frf juj frf juj frf juj frf juj frf juj frf juj
 :fgr jhu fgr jhu fgr jhu fgr jhu fgr jhu fgr jhu
 :grf huj grf huj grf huj grf huj grf huj grf huj
 :frg juh frg juh frg juh frg juh frg juh frg juh
 :arf ůuj arf ůuj arf ůuj arf ůuj arf ůuj arf ůuj

#                                                             ../orig/r.typ:68
I:(2) Písmena R a L píšeme oběma ukazováčky vychylováním
 :vlevo nahoru.
*:_R_R_L15
#                                                             ../orig/r.typ:70
D:drf kuj drf kuj drf kuj drf kuj drf kuj drf kuj
 :rfa ujů rfa ujů rfa ujů rfa ujů rfa ujů rfa ujů
 :kra hra kra hra kra hra kra hra kra hra kra hra
 :duj kuj duj kuj duj kuj duj kuj duj kuj duj kuj
 :rud dur rud dur rud dur rud dur rud dur rud dur
 :rad rak rad rak rad rak rad rak rad rak rad rak
 :suk kus suk kus suk kus suk kus suk kus suk kus

#                                                             ../orig/r.typ:71
I:A slova...
*:_R_R_L16
#                                                             ../orig/r.typ:74
D:klasu krasu klasu krasu klasu krasu klasu krasu
 :druhu grafu druhu grafu druhu grafu druhu grafu
 :kursu hradu kursu hradu kursu hradu kursu hradu
 :krajů kladu krajů kladu krajů kladu krajů kladu
 :radar kruhu radar kruhu radar kruhu radar kruhu
 :lusku grafů lusku grafů lusku grafů lusku grafů
 :agaru kufrů agaru kufrů agaru kufrů agaru kufrů
 :jas has kra hra suk kus důl sůl rud dur jar luk

#                                                             ../orig/r.typ:75
I:Písmena E a I píšeme prostředníky.
*:_R_R_L17
#                                                             ../orig/r.typ:79

D:klasů sladů halas druhu klasů sladů halas druhu
 :hlasů radar kruhu grafu hlasů radar kruhu grafu
 :ded kik ded kik ded kik ded kik ded kik ded kik
 :frf juj ded kik frf juj ded kik frf juj ded kik
 :asi kde asi kde asi kde asi kde asi kde asi kde
 :led lid led lid led lid led lid led lid led lid
 :les lis les lis les lis les lis les lis les lis
 :jde jdi jde jdi jde jdi jde jdi jde jdi jde jdi

Q:Pro pokračování stitkněte Y, N opakovat, nebo F12 konec.
N:_R_R_L17

#                                                             ../orig/r.typ:80
I:Rytmus!
*:_R_R_L18
#                                                             ../orig/r.typ:85

D:jedla jedli jedla jedli jedla jedli jedla jedli
 :kdesi jaksi kdesi jaksi kdesi jaksi kdesi jaksi
 :ledek lilek ledek lilek ledek lilek ledek lilek
 :deska klika deska klika deska klika deska klika
 :hraje hraji hraje hraji hraje hraji hraje hraji
 :usedl udali usedl udali usedl udali usedl udali
 :kraje kraji kraje kraji kraje kraji kraje kraji
 :dlela dleli dlela dleli dlela dleli dlela dleli
 :aleje ideje aleje ideje aleje ideje aleje ideje

#
I:Čárku píšeme prostředníkem pravým.
*:_R_R_L19
#                                                             ../orig/r.typ:92
D:ulili sliji ulili sliji ulili sliji ulili sliji
 :ki, ji, ki, ji, ki, ji, ki, ji, ki, ji, ki, ji,
 :si, li, si, li, si, li, si, li, si, li, si, li,
 :ke, je, ke, je, ke, je, ke, je, ke, je, ke, je,
 :fe, re, fe, re, fe, re, fe, re, fe, re, fe, re,
 :duji, duje, duji, duje, duji, duje, duji, duje,
 :kuji, kuje, kuji, kuje, kuji, kuje, kuji, kuje,
 :ledu, lidu, ledu, lidu, ledu, lidu, ledu, lidu,
 :lesu, lisu, lesu, lisu, lesu, lisu, lesu, lisu,

#                                                             ../orig/r.typ:93
I:Opakování
*:_R_R_L20
#                                                             ../orig/r.typ:99
D:l a ů g h r u e i f j d k s l a ů g h r u e
 :ah la si ke hl se kg ar ku dr ji je re gr hr
 :aga luk rak lůj drh hůl rej kur ara kus ala
 :fiala jehla důlek khaki shluk lelek alias
 :krajka, freska, figura, hrudka, rekurs, kladka,
 :diskuse, galerie, figurka, klasika, galerka,
 :daru, darů, kusu, kusů, rada, radu, kůra,
 :laku, laků, ledu, ledů, lisu, lisů, krku,
 :dres, dresu dresů dluh, dluhu dluhů druh,
 :hrad, hlad, hlas, hles, hled, hluk, kruh,
#                                                           ../orig/r.typ:100
I:(10) Rytmické opakování.
*:_R_R_L21
#                                                            ../orig/r.typ:101
D:grafika led kde jahůdka lis jej agrafa, les
 :figurka lid jel klasiků hle dia galuska sil
 :důsledek as si kaligraf je ji sladidla ku
 :hlediska hůrka ra el sleduji, kůrka rg eg

G:_R_E_R2
#------------------------------------------------------------------------------
# Lekce R3
#------------------------------------------------------------------------------
*:R3
*:_R_S_R3
#                                                            ../orig/r.typ:105
I:Krátká rozcvička
*:_R_R_L22
#                                                            ../orig/r.typ:106
D:frf juj ded kik frf juj ded kik frf juj ded kik
 :jde jdi sel sil jde jdi sel sil jde jdi sel sil
 :led lid dle jsi led lid dle jsi led lid dle jsi
 :ki, ji, di, fi, ki, ji, di, fi, ki, ji, di, fi,
 :disk, duel, lira, idea, disk, duel, lira, idea,
 :skif, esej, lila, hele, skif, esej, lila, hele,

#                                                            ../orig/r.typ:107
I:Písmeno O a interpunkční znaménko tečku (.)
 :píšeme pravým prsteníkem.
*:_R_R_L23
#                                                            ../orig/r.typ:108
D:rok rod rok rod rok rod rok rod rok rod rok rod
 :kdo kol kdo kol kdo kol kdo kol kdo kol kdo kol
 :sok kos sok kos sok kos sok kos sok kos sok kos
 :sos roj sos roj sos roj sos roj sos roj sos roj
 :osa eso osa eso osa eso osa eso osa eso osa eso
 :hor hod hor hod hor hod hor hod hor hod hor hod
 :lo. ki, lo. ki, lo. ki, lo. ki, lo. ki, lo. ki,
 :ul. ks, ul. ks, ul. ks, ul. ks, ul. ks, ul. ks,

#                                                            ../orig/r.typ:109
I:(2) Písmeno O a interpunkční znaménko tečku (.)
 :píšeme pravým prsteníkem.

*:_R_R_L24
#                                                            ../orig/r.typ:110
D:jako. kdos. jako. kdos. jako. kdos. jako. kdos.
 :sklo. soda. sklo. soda. sklo. soda. sklo. soda.
 :rodu. dolu. rodu. dolu. rodu. dolu. rodu. dolu.
 :soud. kola. soud. kola. soud. kola. soud. kola.
 :hora. hold. hora. hold. hora. hold. hora. hold.
 :golf. krok. golf. krok. golf. krok. golf. krok.
 :orel. osud. orel. osud. orel. osud. orel. osud.

#                                                            ../orig/r.typ:111
I:Opakujeme o a tečku.
*:_R_R_L25
#                                                            ../orig/r.typ:113
D:osa rok kdo sok roj eso los roh hod rod oko sos
 :akord hrdlo draho jakou dohra korek fluor losos
 :alkohol odkudsi dohodou ideolog doskoku hroudou
 :soudruh. filolog. souhlas. odeslal. sedadlo.
 :do dolu. do sadu. do sudu. do rohu. do lesa.

#                                                            ../orig/r.typ:114
I:Písmeno P píšeme vychýlením pravého malíčku
 :na horní písmennou řadu.

*:_R_R_L26
#                                                            ../orig/r.typ:117

D:frf juj ded kik lol ki, lo. frf juj ded kik lol
 :rod kdo sok los roh osa hor rod kdo sok los roh
 :golf. kosa. horu. kord. laso. kdos. krok. golf.
 :ůpů lol ůpů lol ůpů lol ůpů lol ůpů lol ůpů lol
 :frf juj ded kik lol ůpů frf juj ded kik lol ůpů
 :pak pal pak pal pak pal pak pal pak pal pak pal
 :per pes per pes per pes per pes per pes per pes
 :pra pro pra pro pra pro pra pro pra pro pra pro

#                                                            ../orig/r.typ:118
I:Zkuste opsat odstavec co nejrychleji
*:_R_R_L27
#                                                            ../orig/r.typ:122
D:hop půl hop půl hop půl hop půl hop půl hop půl
 :parku perla parku perla parku perla parku perla
 :kapka kapsa kapka kapsa kapka kapsa kapka kapsa
 :dopad dopis dopad dopis dopad dopis dopad dopis
 :odpis odpad odpis odpad odpis odpad odpis odpad
 :sklep spoje sklep spoje sklep spoje sklep spoje
 :upadl uspal upadl uspal upadl uspal upadl uspal
 :opera ples. opera ples. opera ples. opera ples.


#                                                            ../orig/r.typ:123
I:Opakovat, opakovat, opakovat...
*:_R_R_L28
#                                                            ../orig/r.typ:128
D:fiasko, housle, souhra, dokola, soulad, soused,
 :holduj, holduji holduje soudil, soudili horuji,
 :pokora. poloha. porada. posila. dokola. dohola.
 :daleko. dlouho. rekord. rekordu ledakdo ledakde
 :podhled průhled podklad podpora doposud lepidlo
 :filolog sleduje dialog, diskusi o podporu klasiků.

#                                                            ../orig/r.typ:129
I:Písmeno T píšeme vychýlením levého ukazováčku
 :na horní písmennou řadu
*:_R_R_L29
#                                                            ../orig/r.typ:146
D:pedagog, sloupek, paprsek, kapelou, pedagog,
 :reprodukuji spolupodpis pedagogikou reprodukuji
 :frf ftf frf ftf frf ftf frf ftf frf ftf frf ftf
 :rak tak rak tak rak tak rak tak rak tak rak tak
 :gor got gor got gor got gor got gor got gor got
 :aro ato aro ato aro ato aro ato aro ato aro ato
 :tip tep tip tep tip tep tip tep tip tep tip tep

#                                                            ../orig/r.typ:147
I:Pokračujte...
*:_R_R_L30
#                                                            ../orig/r.typ:154

D:ret let ret let ret let ret let ret let ret let ret
 :taj dat taj dat taj dat taj dat taj dat taj dat taj
 :sta tas sta tas sta tas sta tas sta tas sta tas sta
 :trakt patro trakt patro trakt patro trakt patro trakt
 :pasta dosti pasta dosti pasta dosti pasta dosti pasta
 :strhl stroj strhl stroj strhl stroj strhl stroj strhl
 :fakta efekt fakta efekt fakta efekt fakta efekt fakta
 :drtit kartu drtit kartu drtit kartu drtit kartu drtit

#                                                            ../orig/r.typ:155
I:Zkusíme dlouhá slova.
*:_R_R_L31
#                                                            ../orig/r.typ:156
D:osladit setkali osladit setkali osladit setkali osladit
 :katalog opereta katalog opereta katalog opereta katalog
 :oplatka lopatou oplatka lopatou oplatka lopatou oplatka
 :tuk let sta pat trh jet sto tak ret fit akt tah pot tis
 :trafika spousta pstruhů reaktor potlesk karotka loterie
 :trhat prstu strop oktet krtek pultu tlaku autor titul
 :trofeje, starost, registr, projekt, praskat, splatit
 :elektrodou. statistika. katastrofa. dialektika.


G:_R_E_R3
#------------------------------------------------------------------------------
# Lekce R4
#------------------------------------------------------------------------------
*:R4
*:_R_S_R4
#                                                            ../orig/r.typ:160
I:Rozcvička
*:_R_R_L32
#                                                            ../orig/r.typ:161
D:frf ftf kta tra lta str tla rta tka frf ftf kta tra
 :trh stu tep akt ret tah set fit trs trh stu tep akt ret
 :tlukot, kostka, sektor, dorost, trojka, tlukot, kostka,
 :trest stisk takto sport tlupa datel trest stisk takto
 :prefekt. despekt. respekt. dialekt. prefekt. despekt.

#                                                            ../orig/r.typ:162
I:Písmeno Y píšeme vychýlením pravého ukazováčku
 :směrem vlevo vzhůru.
*:_R_R_L33
#                                                            ../orig/r.typ:163
D:literaturou, statistika, popularita, literaturou,
 :juj jyj juj jyj juj jyj juj jyj juj jyj juj jyj
 :frf ftf juj jyj frf ftf juj jyj frf ftf juj jyj
 :kdy jdu kdy jdu kdy jdu kdy jdu kdy jdu kdy jdu
 :rty rtu rty rtu rty rtu rty rtu rty rtu rty rtu
 :ledy rohy ledy rohy ledy rohy ledy rohy ledy rohy
 :jasy kusy jasy kusy jasy kusy jasy kusy jasy kusy

#                                                            ../orig/r.typ:164
I:Opět Y.
*:_R_R_L34
#                                                            ../orig/r.typ:166
D:tahy spady tahy spady tahy spady tahy spady
 :kydat haldy kydat haldy kydat haldy kydat
 :odkdy dokdy odkdy dokdy odkdy dokdy odkdy
 :pytel pasy pytel pasy pytel pasy pytel pasy
 :rysu hydru rysu hydru rysu hydru rysu hydru
 :tuhy hroty tuhy hroty tuhy hroty tuhy hroty
 :hory yoga hory yoga hory yoga hory yoga hory
 :rady krytu rady krytu rady krytu rady krytu
 :strigy s otrapy strigy s otrapy strigy s

#                                                            ../orig/r.typ:167
I:Sedíte rovně? To vám může psaní hodně usnadnit.
*:_R_R_L35
#                                                            ../orig/r.typ:170
D:sypaly pruhy letadly. sypaly pruhy letadly. sypaly
 :tady jsou ty dodatky ke spisu, tady jsou ty dodatky
 :kdy se koupaly. kdy se koupaly. kdy se koupaly.
 :ladily housle. okusily to. ladily housle. okusily to.
 :typy a tipy pro statistiky. typy a tipy pro statistiky.
 :tady tudy do porady. tady tudy do porady. tady tudy

#                                                            ../orig/r.typ:171
I:Písmena Ú a Q píšeme malíčky vychýlením nahoru
 :(vpravo a vlevo)
*:_R_R_L36
#                                                            ../orig/r.typ:175
D:klady dupaly ustoupil oprostily klady dupaly
 :dostoupily popularity. dostoupily popularity.
 :aqa ůpů ůúů aqa ůpů ůúů aqa ůpů ůúů aqa ůpů ůúů
 :qui túr qui túr qui túr qui túr qui túr qui túr
 :quo kúr quo kúr quo kúr quo kúr quo kúr quo kúr
 :qua yaú qua yaú qua yaú qua yaú qua yaú qua yaú
 :aqua, túra, aqua, túra, aqua, túra, aqua, túra,

#                                                            ../orig/r.typ:176
I:(2) Písmena Ú a Q píšeme malíčky vychýlením nahoru
*:_R_R_L37
#                                                            ../orig/r.typ:185
D:quasi kúrou quasi kúrou quasi kúrou quasi kúrou
 :ústup ústrk ústup ústrk ústup ústrk ústup ústrk
 :túra úhradou túra úhradou túra úhradou túra úhradou
 :útlaku, útlost, útlaku, útlost, útlaku, útlost,
 :úhel, úsudek, úhel, úsudek, úhel, úsudek, úhel,
 :úklady, úpadek, úkoly, úpadek, úkoly, úpadek,
 :úseku úderů úkolu úroků úhoru úhory úly úlek,
 :ústupek túra úplata, úhel, útrata, quarta, skútru,


#                                                            ../orig/r.typ:186
I:Opakování
*:_R_R_L38
#                                                            ../orig/r.typ:193

D:ty jsi dostala spoustu dopisů. ty jsi dostala
 :autor ty tu porto úl topoly ta úd dary ty ti
 :úhel quasi ti ty kapitalista kúrou qa at úkrok
 :jdu suk jdi ges lis rok sol sto půl tah kdy sil
 :diskuse jakosti úsporou sleduje studuje podklad
 :dopis adres grafů úkolů desek stroj hesel okres
 :fotograf jistily tiskopis průklepů dokladů,

#                                                            ../orig/r.typ:194
I:Další opakování.
*:_R_R_L39
#                                                            ../orig/r.typ:201
D:je to úkol. dostatek produktů se tu pokukuje
 :dosud je dostatek traktorů dosud je dostatek
 :je tu úkol postarat se o úrodu a pojistit dostatek
 :o dary hoduje spousta faktorů, poloha pole
 :dary se pokukuje podle disky od hektaru a dostatku
 :podtrhuje se úloha strojů a traktorů, ale jde
 :úloha strojů roste, stroj pro lidi, je tu

#                                                            ../orig/r.typ:202
I:Rytmické cvičení.
*:_R_R_L40
#                                                            ../orig/r.typ:203
D:se stroji tys orat pole o holografie sta hektarů
 :s úsporou sil. pak lyrik pojistit dostatek
 :produktů pro trh okresu a kraje.

G:_R_E_R4
#------------------------------------------------------------------------------
# Lekce R5
#------------------------------------------------------------------------------
*:R5
*:_R_S_R5
#                                                            ../orig/r.typ:207
I:Rozcvička
*:_R_R_L41
#                                                            ../orig/r.typ:208
D:frf ftf juj jyj ůpů ůúů aqa frf ftf juj jyj ůpů ůúů
 :tak kdy qui túr sto lyrik úlu tak kdy qui túr sto
 :lehkost episody autokar lehkost episody autokar
 :elektroakustika elektrostatika, elektroakustika


#                                                            ../orig/r.typ:209
I:Písmeno V píšeme ukazováčkem levé ruky, vychýleným
 :vpravo dolů
*:_R_R_L42
#                                                            ../orig/r.typ:210
D:dalekohledu filatelista prstokladu, dalekohledu
 :fvf fvr fvt fvf fvr fvt fvf fvr fvt fvf fvr fvt
 :var vat var vat var vat var vat var vat var vat
 :div dav div dav div dav div dav div dav div dav
 :ves vek ves vek ves vek ves vek ves vek ves vek
 :kov jev kov jev kov jev kov jev kov jev kov jev
 :vis vid vis vid vis vid vis vid vis vid vis vid

#                                                            ../orig/r.typ:211
I:Opět V.
*:_R_R_L43
#
D:vrata vstup vrata vstup vrata vstup vrata vstup
 :vraty divit vraty divit vraty divit vraty divit
 :vyla vidle vyla vidle vyla vidle vyla vidle vyla
 :koval tavil koval tavil koval tavil koval tavil
 :vysypaly do krovu vysypaly do krovu vysypaly do
 :úvaha slova úvaha slova úvaha slova úvaha slova
 :vrtal otvor vrtal otvor vrtal otvor vrtal otvor
 :servi útvar servi útvar servi útvar servi útvar

#                                                            ../orig/r.typ:213
I:Cvičení.
*:_R_R_L44
#                                                            ../orig/r.typ:215
D:sleva poplatku, doslov autora, verva vylodily,
 :tvoje odvaha, povolal lidi, tvoje odvaha, povolal
 :tvar letadla, uhodil vedle, vhled, vada, tvar
 :spisovatel veseloher, spolky spisovatelů, spisovatel
 :dal kolektivu slovo, dal kolektivu slovo, dal
 :dopadlo to podle jeho slov, dopadlo to podle
 :diktoval dopis do stroje, diktoval dopis
 :kvalita je jakost, oprava a úprava, kvalita

#                                                            ../orig/r.typ:216
I:Písmeno M píšeme pravým ukazováčkem vychylováním
 :vpravo šikmo dolů.
*:_R_R_L45
#                                                            ../orig/r.typ:219
D:redaktorky odhlasovaly redaktorky odhlasovaly
 :jmj jmu jmy jmj jmu jmy jmj jmu jmy jmj jmu jmy
 :jim jam jim jam jim jam jim jam jim jam jim jam
 :ohm lom ohm lom ohm lom ohm lom ohm lom ohm lom
 :myl mat myl mat myl mat myl mat myl mat myl mat
 :tam tom tam tom tam tom tam tom tam tom tam tom
 :můj dům můj dům můj dům můj dům můj dům můj dům

#                                                            ../orig/r.typ:220
I:Rytmika!
*:_R_R_L46
#                                                            ../orig/r.typ:224
D:hmat, sedm, hmat, sedm, hmat, sedm, hmat, sedm,
 :moje, myla, moje, myla, moje, myla, moje, myla,
 :domů, mysl, domů, mysl, domů, mysl, domů, mysl,
 :klam, kmih, klam, kmih, klam, kmih, klam, kmih,
 :vyjmuta, vyjmuto, vyjmuta, vyjmuto, vyjmuta, vyjmuto,
 :reklama komedie reklama komedie reklama komedie
 :smaragd mramoru smaragd mramoru smaragd mramoru
 :mladost lidumil mladost lidumil mladost lidumil

#                                                            ../orig/r.typ:225
I:Opakovací cvičení je zaměřeno na rytmus
 :a obtížná spojení.
*:_R_R_L47
#                                                            ../orig/r.typ:230
D:gram, klam, jilm, kmet, kmit, kmih, mrak, mrav,
 :vlak, vlas, vrak, vlek, vjet, vkus, vrut, vtip,
 :darovat dolovat hmatali hmitali lakovat letovat
 :lisoval litoval maloval mapoval upravil ustavil
 :filmoval formoval sletoval slevoval slepoval
 :spalovat spilovat spojovat stahovat stolovat
 :akumulovala dopravovala prokoumala doprovodila
 :vymordovala kompletovat komplikovat kormidlovat


#                                                            ../orig/r.typ:231
I:Písmeno C pište vychylováním levého prostředníku
 :vpravo dolů.
*:_R_R_L48
#                                                            ../orig/r.typ:249
D:poloautomatika, aktuality, poloautomatika, hospody,
 :dcd dce dec dcd dce dec dcd dce dec dcd dce dec dcd
 :cis ces cis ces cis ces cis ces cis ces cis ces cis
 :cit cti cit cti cit cti cit cti cit cti cit cti cit
 :cep pec cep pec cep pec cep pec cep pec cep pec cep
 :clo moc clo moc clo moc clo moc clo moc clo moc clo
 :agitace úschova agitace úschova agitace úschova

#                                                            ../orig/r.typ:250
I:Delší slova.
*:_R_R_L49
#                                                            ../orig/r.typ:256

D:průvodce vegetace průvodce vegetace průvodce
 :pochovat doslechl pochovat doslechl pochovat
 :veselice pravomoc veselice pravomoc veselice
 :vytlouci plachtit vytlouci plachtit vytlouci
 :pec cos moc ces sic cha cik cak cif cup doc
 :couvat, tlouci, chodit, vracet, sladce, lecjak,
 :charaktery komerce, spolupracovali, socialistickou.


#                                                            ../orig/r.typ:257
I:Opakování.
*:_R_R_L50
#                                                            ../orig/r.typ:258
D:pocit tepla srdce ulice pocit tepla srdce ulice
 :hledisko vcelku po ruce, hledisko vcelku po ruce,
 :poslali pro chlapce i dcerku. poslali pro chlapce
 :autor cestopisů, odchod do důchodu.

G:_R_E_R5
#------------------------------------------------------------------------------
# Lekce R6
#------------------------------------------------------------------------------
*:R6
*:_R_S_R6
#                                                            ../orig/r.typ:262
I:Rozcvička
*:_R_R_L51
#                                                            ../orig/r.typ:263
D:fvf fvr fvt jmj jmu jmy dcd dce dec fvf fvr fvt
 :cit cop cep cos clo cla clu cel cis ces cit cop
 :ctitel, dalece, chopit, kocour, svrchu, scelit,
 :chasa chata chlad chlap chlum chlup chrup chaos

#                                                            ../orig/r.typ:264
I:Písmena X a W píšeme levým prsteníkem,
 :pomlčku pravým malíčkem.
*:_R_R_L52
#                                                            ../orig/r.typ:266
D:civilista, komplikace, demokracie, motorista,
 :sxs sws sxs sws sxs sws sxs sws sxs sws sxs
 :lux lex lux lex lux lex lux lex lux lex lux
 :ů-ů ů-p ů-ú ů-ů ů-p ů-ú ů-ů ů-p ů-ú ů-ů ů-p
 :fix tix fix tix fix tix fix tix fix tix fix
 :tax tex tax tex tax tex tax tex tax tex tax
 :mix max mix max mix max mix max mix max mix

#                                                            ../orig/r.typ:267
I:Pokrčte správně prsty.
*:_R_R_L53
#                                                            ../orig/r.typ:268
D:extra kodex extra kodex extra kodex extra kodex
 :export, expert, export, expert, export, expert,
 :wolfram komplex wolfram komplex wolfram komplex
 :dostala-li, poslala-li, dostala-li, poslala-li,
 :expres, textil, expres, textil, expres, textil,
 :exekuce exhumace exekuce exhumace exekuce exhumace
 :maximum reflex, maximum reflex, maximum reflex,
 :kilowatt expedice kilowatt expedice kilowatt

#                                                            ../orig/r.typ:269
I:Procvičíme pomlčku.
*:_R_R_L54
#                                                            ../orig/r.typ:271
D:dostala-li, poslala-li, dostala-li, poslala-li,
 :xperti uvedli, jak charaktery komplex hal
 :maximum textilu jde i pro export - maximum
 :exhumace v divadle - exhumace v divadle - exhumace
 :poslali exekuci - poslali exekuci - poslali

#                                                            ../orig/r.typ:272
I:Z píšeme levým malíčkem posunutím ze základní
 :polohy vpravo dolů
*:_R_R_L55
#                                                            ../orig/r.typ:275
D:exporty, wolframitu, xerografie, exhumace.
 :aza aqz aza aqz aza aqz aza aqz aza aqz aza
 :vůz zem zad vůz zem zad vůz zem zad vůz zem
 :rzi zas zet rzi zas zet rzi zas zet rzi zas
 :kyz zel koz zdi zel koz zdi zel koz zdi zel
 :zas raz zas raz zas raz zas raz zas raz zas
 :zda zde zda zde zda zde zda zde zda zde zda

#                                                            ../orig/r.typ:276
I:(2) Z píšeme levým malíčkem posunutím ze základní
 :polohy vpravo dolů

*:_R_R_L56
#                                                            ../orig/r.typ:280
D:mrz tzv. rzi mrz tzv. rzi mrz tzv. rzi mrz tzv.
 :rozpadal vzrostl rozpadal vzrostl rozpadal vzrostl
 :porazil mezihry porazil mezihry porazil mezihry
 :rozkradl mezisklad rozkradl mezisklad rozkradl
 :zastala, zatahala, zastala, zatahala, zastala,
 :pozor, tady kazy. pozor, tady kazy. pozor,
 :teze, dotaz, teze, dotaz, teze, dotaz, teze,
 :zkraty vzadu zkraty vzadu zkraty vzadu zkraty
 :mosaz meze mosaz meze mosaz meze mosaz meze

#                                                            ../orig/r.typ:281
I:Pocvičíme méně zdatné prsty.
*:_R_R_L57
#                                                            ../orig/r.typ:286
D:chytili myl cos průmysl kly ces situace max pec
 :jde i o mzdovou charakteristiku jde i o mzdovou
 :chodu se ji latex je to waltz as po chaty co ex
 :vydavatelem kytic vy za socialismus cyklu ix ax
 :rozhodl o exkurzi rozhodl o exkurzi rozhodl
 :horoval pro chalupu horoval pro chalupu horoval
 :průzkum situace s chatami průzkum situace
 :komplex hal s dvorkem komplex hal s dvorkem


#                                                            ../orig/r.typ:287
I:Písmeno B píšeme levým ukazováčkem, vychýleným
 :hodně doprava a dolů.
*:_R_R_L58
#                                                            ../orig/r.typ:293
D:vymyslel zvyklost typograf rychlost cyklista
 :systematika vychovateli sympatizuje dramaticky,
 :fvf fbf fbr fvf fbf fbr fvf fbf fbr fvf fbf
 :boj bor bod boj bor bod boj bor bod boj bor
 :bez bar byt bez bar byt bez bar byt bez bar
 :byl brk bok byl brk bok byl brk bok byl brk
 :aby box bys aby box bys aby box bys aby box

#                                                            ../orig/r.typ:294
I:Opakujeme B.
*:_R_R_L59
#                                                            ../orig/r.typ:302
D:hloubka chloubu hloubka chloubu hloubka chloubu
 :obsah obvod obsah obvod obsah obvod obsah obvod
 :stavby volby tavby volby tavby volby stavby volby
 :dobou rybou dobou rybou dobou rybou dobou rybou
 :chyby obuvi chyby obuvi chyby obuvi chyby obuvi
 :barva brzdy barva brzdy barva brzdy barva brzdy
 :zabrzdil způsobil zabrzdil způsobil zabrzdil

#                                                            ../orig/r.typ:303
I:Dejte si pozor na rytmus.
*:_R_R_L60
#                                                            ../orig/r.typ:304
D:dobarvil vybarvil odbarvil vybalili zabalili
 :obohacovali prohloubili vybavovali, vzbuzovali,
 :i s obalem. i s ozdobou i s obchody i s rozbory
 :bez odbytu. bez obvazu. bez obvodu. bez obruby.
 :pracuje i v sobotu. pracuje i v sobotu. pracuje
 :brzdili rozvoj. brzdili rozvoj. brzdili rozvoj.

G:_R_E_R6
#------------------------------------------------------------------------------
# Lekce R7
#------------------------------------------------------------------------------
*:R7
*:_R_S_R7
#                                                            ../orig/r.typ:308
I:Rozcvička
*:_R_R_L61
#                                                            ../orig/r.typ:309
D:fvf fbf fbr fbt fvf fbf fbr fbt fvf fbf fbr fbt fvf
 :a a bal a o bod a y byl a u bus a e bez a i bit a a
 :arborka republik vyrobili dobropis způsobem barometr
 :barbarismus vybagrovali blahobytem, fotbalista.

#                                                            ../orig/r.typ:310
I:Písmeno N píšeme pravým ukazováčkem vychýleným
 :vlevo dolů.
*:_R_R_L62
#                                                            ../orig/r.typ:311
D:jmj jnj jmn jmj jnj jmn jmj jnj jmn jmj jnj jmn jmj
 :nad neb nic nad neb nic nad neb nic nad neb nic nad
 :noc nit nos noc nit nos noc nit nos noc nit nos noc
 :oni ony ona oni ony ona oni ony ona oni ony ona oni
 :inu ano mne inu ano mne inu ano mne inu ano mne inu
 :snadno, funkce, snadno, funkce, snadno, funkce, snadno,

#                                                            ../orig/r.typ:312
I:Jako vždy nějaká slova.
*:_R_R_L63
#                                                            ../orig/r.typ:313
D:nutno nemoc nutno nemoc nutno nemoc nutno nemoc nutno
 :vznik novin vznik novin vznik novin vznik novin vznik
 :telefony okolnost telefony okolnost telefony okolnost
 :znamenat stanovit znamenat stanovit znamenat stanovit
 :vhodnost minulost vhodnost minulost vhodnost minulost
 :prosinec techniky prosinec techniky prosinec techniky

#                                                            ../orig/r.typ:314
I:Souvislý text.
*:_R_R_L64
#                                                            ../orig/r.typ:316
D:chceme zajistit rozvoj obchodu dobrou reklamou. s tou se se
 :sejdeme v tisku i v televizi. reklama propaguje, co se vy-
 :robilo a vzbuzuje tak mezi obyvatelstvem obdiv pro bohatou
 :tvorbu průmyslu. reklamou se prohlubuje vkus obyvatelstva.
 :chceme, aby vzhled obchodů vedl k propagaci prodeje, aby se
 :dbalo i o kulturu prodeje. o obratu velmi rozhoduje i způ-
 :sob obsluhy. ochota a vztah k lidem jsou pro obchod pravou
 :reklamou.

#                                                            ../orig/r.typ:317
I:Velká písmena Z,U,I,O,P,H,J,K,L,N,M -- stiskneme
 :levý Shift + klávesu.

*:_R_R_L65
#                                                            ../orig/r.typ:320
D:investovali kompletnost bezcennosti navrhovatel
 :Ja Ja Ka Ka La La Ha Ha Za Za Ua Ua Ja Ja Ka Ka
 :Ia Ia Oa Oa Pa Pa Na Na Ma Ma Ia Ia Oa Oa Pa Pa
 :Jakub, Karel, Jakub, Karel, Jakub, Karel, Jakub,
 :Lucie, Hanka, Lucie, Hanka, Lucie, Hanka, Lucie,
 :Zlata, Urban, Ivana, Oskar, Zlata, Urban, Ivana,

#                                                            ../orig/r.typ:321
I:Konečně věty.
*:_R_R_L66
#                                                            ../orig/r.typ:325
D:Nemohl zavolat z podniku pro poruchu kabelů. Nemohl zavolat
 :Iniciativa ekonomů. Povinnosti dodavatelů. Iniciativa ekonomů.
 :Mezi lidmi se najde mnoho fandů divadla. Mezi lidmi se najde
 :Program veletrhu je letos velmi obsazen. Program veletrhu je

#                                                            ../orig/r.typ:326
I:Písmeno Ř píšeme ukazováčkem levé ruky vychýleným
 :kolmo vzhůru.
*:_R_R_L67
#                                                            ../orig/r.typ:331
D:Florencie, Bulharsko, Venezuela, Stockholm, Guatemala,
 :frř fřf frř fřf frř fřf frř fřf frř fřf frř fřf frř fřf
 :fvř fbř fvř fbř fvř fbř fvř fbř fvř fbř fvř fbř fvř fbř
 :jař keř jař keř jař keř jař keř jař keř jař keř jař keř
 :zři vře zři vře zři vře zři vře zři vře zři vře zři vře

#                                                            ../orig/r.typ:332
I:Opistujte text.
*:_R_R_L68
#                                                            ../orig/r.typ:338
D:přenesl chřipku přenesl chřipku přenesl chřipku
 :řemeslo tesaře, řemeslo tesaře, řemeslo tesaře
 :spatřil hřeben, spatřil hřeben, spatřil hřeben
 :tvořili třetinu tvořili třetinu tvořili třetinu
 :sevřeli přitom, sevřeli přitom, sevřeli přitom
 :jař tři keř řez zři řad miř řek vře řev pře zře


#                                                            ../orig/r.typ:339
I:Pokračujte v opisování.
*:_R_R_L69
#                                                            ../orig/r.typ:347

D:Za bouřky. Ve střehu. Od řepaře. Po pekaři. Ke středu.
 :spotřeba paliv spotřeba energie, spotřeba paliv
 :ochořeli chřipkou ochořeli chřipkou ochořeli chřipkou
 :dveře se otevřely dveře se otevřely dveře se otevřely
 :modernizace přepravy modernizace přepravy modernizace
 :vyřezali ze dřeva figurky, vyřezali ze dřeva figurky,
 :S elektřinou. S předmluvou. V kultuře. Z řady.

#                                                            ../orig/r.typ:348
I:Písmeno Á píšeme pravým ukazováčkem,
 :vychýleným mírně vpravo nahoru.
*:_R_R_L70
#                                                            ../orig/r.typ:349
D:chmelaři břitvou, podpořil křeslem, dřevina,
 :připomenout zařizovali, dřevořezba, střediskem,
 :juá jáj juá jáj juá jáj juá jáj juá jáj juá jáj
 :háj dál háj dál háj dál háj dál háj dál háj dál
 :máj sál máj sál máj sál máj sál máj sál máj sál
 :nám rád nám rád nám rád nám rád nám rád nám rád
 :vás bát vás bát vás bát vás bát vás bát vás bát


G:_R_E_R7
#------------------------------------------------------------------------------
# Lekce R8
#------------------------------------------------------------------------------
*:R8
*:_R_S_R8
#                                                            ../orig/r.typ:353
I:Opakování
*:_R_R_L71
#                                                            ../orig/r.typ:354
D:S elektřinou. S předmluvou. V kultuře. Z řady.
 :S naftou je třeba dobře hospodařit. S naftou
 :Bylo nutno vytvořit předpoklady pro malou spotřebu.

#                                                            ../orig/r.typ:355
I:Opakujeme Á.
*:_R_R_L72
#                                                            ../orig/r.typ:357
D:dodávku nemáme, dodávku nemáme, dodávku nemáme,
 :ukázali celofán ukázali celofán ukázali celofán
 :dostává zprávy, dostává zprávy, dostává zprávy,
 :sázenku dáváme, sázenku dáváme, sázenku dáváme,
 :třikrát diváci, třikrát diváci, třikrát diváci,
 :morálka brigády morálka brigády morálka brigády
 :mám - vám - rám - báj - lán - gáz - háv - kár


#                                                            ../orig/r.typ:358
I:Dlouhá slova.
*:_R_R_L73
#                                                            ../orig/r.typ:359
D:hospodářská spolupráce, hospodářská spolupráce,
 :předcházeli katastrofám předcházeli katastrofám
 :sekretářkám procházkám, sekretářkám procházkám,
 :zpracováván nástrojařem zpracováván nástrojařem
 :sestavovány objednávky, sestavovány objednávky,


#                                                            ../orig/r.typ:360
I:Opakování.
*:_R_R_L74
#                                                            ../orig/r.typ:362
D:řád nám ukázali národohospodáři politickoorganizátorská
 :zářil ař oř jeřáb eř ář hořák řa řá vřelá ře ři okřál
 :hospodářská řádná má dá hospodářská řádná má dá hospodářská
 :mateřská dovolená mateřská dovolená mateřská dovolená
 :hospodářská soustava hospodářská soustava hospodářská
 :přeprava nákladů, přeprava nákladů, přeprava nákladů


#                                                            ../orig/r.typ:363
I:Písmeno Č píšeme levým prostředníkem vychýleným
 :kolmo vzhůru.
*:_R_R_L75
#                                                            ../orig/r.typ:366
D:uspořili přepravu nákladu, nahrávka recitálu
 :předpokládá hospodářská sekretářská předpokládá
 :deč dčd deč dčd deč dčd deč dčd deč dčd deč dčd
 :čas meč čas meč čas meč čas meč čas meč čas meč
 :nač řeč nač řeč nač řeč nač řeč nač řeč nač řeč
 :čin tyč čin tyč čin tyč čin tyč čin tyč čin tyč
 :leč čáp leč čáp leč čáp leč čáp leč čáp leč čáp

#                                                            ../orig/r.typ:367
I:Kláves se dotýkáme jen lehce.
*:_R_R_L76
#                                                            ../orig/r.typ:372

D:časopis učiteli časopis učiteli časopis učiteli
 :účinná, hračka, účinná, hračka, účinná, hračka,
 :ačkoliv načisto ačkoliv načisto ačkoliv načisto
 :počkali vybočil počkali vybočil počkali vybočil
 :náčrtek chladič náčrtek chladič náčrtek chladič


#                                                            ../orig/r.typ:373
I:Pokračujeme v procvičování.
*:_R_R_L77
#                                                            ../orig/r.typ:379
D:členy čluny členy čluny členy čluny členy čluny členy
 :včera večer včera večer včera večer včera večer včera
 :kočár účel, kočár účel, kočár účel, kočár účel, kočár
 :čokoláda chemička čokoláda chemička čokoláda chemička
 :babička, babočka, babička, babočka, babička, babočka
 :započatá činnost, započatá činnost, započatá činnost

#                                                            ../orig/r.typ:380
I:A ještě...
*:_R_R_L78
#                                                            ../orig/r.typ:387
D:občanská vybavenost, občanská vybavenost, občanská
 :označkovali turistickou cestu červenou značkou
 :odbočili ze silnice, roztočil kolečka, nepřekročil
 :nahrávač se smečařem ve čtyřhře, nečekaná událost
 :do počtu ve čtyři do čtverce, občerstvili se
 :Počátek lhůty je od čtvrtka. Počátek lhůty


#                                                            ../orig/r.typ:388
I:Písmeno Í píšeme vychýlením pravého prostředníku
 :mírně vpravo vzhůru.
*:_R_R_L79
#                                                            ../orig/r.typ:396

D:dokončil rozpočet hraničář lednička čerpadlo činitelů
 :náročnosti, nespočetná, sloučeninám odpočinkem, bezúčinnost
 :kií kík kií kík kií kík kií kík kií kík kií kík kií
 :dík cíl dík cíl dík cíl dík cíl dík cíl dík cíl dík
 :jíl fík jíl fík jíl fík jíl fík jíl fík jíl fík jíl

#                                                            ../orig/r.typ:397
I:Nezoufejte :)
*:_R_R_L80
D:díl - mít - víc - jíl - sít - dlí - ctí - sní - bdí
 :získali vlastní moderní obydlí, cítíme, hlavní
 :administrativní nenahraditelní, kvalitativního
 :dílem písmo dílem písmo dílem písmo dílem písmo
 :bílá, musí, bílá, musí, bílá, musí, bílá, musí, bílá
 :Pořádá se proto řada seminářů.

#                                                            ../orig/r.typ:398
G:_R_E_R8
#------------------------------------------------------------------------------
# Lekce R9
#------------------------------------------------------------------------------
*:R9
*:_R_S_R9
#                                                            ../orig/r.typ:402
I:Rozcvička.
*:_R_R_L81
#                                                            ../orig/r.typ:403
D:akční řídí stačí ač či učení zí čí čtení če ní líček tč jí
 :vedoucí činitel dílčích operací vedoucí činitel dílčích operací
 :vlastní strojní činnost i s racionalizačním úsilím, vlastní
 :Organizátorská činnost energetiků. Organizátorská činnost

#                                                            ../orig/r.typ:404
I:Nacvičujte zrychlování a zpomalování psaní.
*:_R_R_L82
#                                                            ../orig/r.typ:405
D:Hlavní příčina závady. Hlavní příčina závady.
 :sociální zabezpečení sociální zabezpečení
 :často se říká tradiční názor často se říká tradiční
 :pracovní úrazy pracovní časy, pracovní úrazy pracovní časy,
 :tvůrčích činů, sluneční energie, tvůrčích činů
 :existenčním minimem, kooperačním seskupením


#                                                            ../orig/r.typ:406
I:Písmeno Š píšeme levým prsteníkem vychýleným
 :kolmo vzhůru.
*:_R_R_L83
#                                                            ../orig/r.typ:407
D:redakčním poučení večerník redukční čistírna příčinná
 :rekreačního maličkostí, kooperačním seskupením
 :swš sšs swš sšs swš sšs swš sšs swš sšs swš sšs swš
 :náš šek náš šek náš šek náš šek náš šek náš šek náš
 :vše řeš vše řeš vše řeš vše řeš vše řeš vše řeš vše
 :váš šíp váš šíp váš šíp váš šíp váš šíp váš šíp váš

#                                                            ../orig/r.typ:408
I:Opakování Š.
*:_R_R_L84
#                                                            ../orig/r.typ:410
D:omšelá, příliš, omšelá, příliš, omšelá, příliš, omšelá
 :rozkoš, dnešek, rozkoš, dnešek, rozkoš, dnešek, rozkoš
 :duševní dalších duševní dalších duševní dalších duševní
 :štítek, mladší, štítek, mladší, štítek, mladší, štítek
 :šum koš šál vše máš šek dáš šat piš šla číš šít náš


#                                                            ../orig/r.typ:411
I:A znovu.
*:_R_R_L85
#                                                           ../orig/r.typ:414
D:všude škoda všude škoda všude škoda všude škoda všude
 :spíše rušil spíše rušil spíše rušil spíše rušil spíše
 :vyšší školy vyšší školy vyšší školy vyšší školy vyšší
 :avšak našim avšak našim avšak našim avšak našim avšak
 :zvláštní narušení zvláštní narušení zvláštní narušení
 :čeština, řešením, čeština, řešením, čeština, řešením.

#                                                            ../orig/r.typ:415
I:Rychleji, pomaleji, rychleji, pomaleji...
*:_R_R_L86
#                                                            ../orig/r.typ:419
D:V letošním roce. V letošním roce. V letošním roce.
 :Zlepšovací návrh je podán přihláškou. Zlepšovací návrh
 :Písmeno É píšeme vychýlením pravého prsteníku vpravo
 :nahoru.

#                                                            ../orig/r.typ:420
I:Písmeno É píšeme vychýlením pravého prsteníku
 :vpravo nahoru.
*:_R_R_L87
#                                                            ../orig/r.typ:425
D:nepřišli vyšlapal zhoršili vyšetřil zkoušeli rozšířil
 :vznešenost, navštívili, šlechetnost příslušnost
 :loé lél loé lél loé lél loé lél loé lél loé lél loé
 :lék léč lék léč lék léč lék léč lék léč lék léč lék
 :své tvé své tvé své tvé své tvé své tvé své tvé své
 :šéf zlé šéf zlé šéf zlé šéf zlé šéf zlé šéf zlé šéf

#                                                            ../orig/r.typ:426
I:Pokud příliš chybujete, raději zpomalte.
*:_R_R_L88
#                                                            ../orig/r.typ:433
D:zejména problém zejména problém zejména problém
 :tématem povinné tématem povinné tématem povinné
 :široké, takové, široké, takové, široké, takové,
 :nejlépe trénuje nejlépe trénuje nejlépe trénuje
 :veškeré prémie, veškeré prémie, veškeré prémie,
 :své - lék - tvé - zlé - šéf - léč - fér - véb

#                                                            ../orig/r.typ:434
I:Opakování.
*:_R_R_L89
#                                                            ../orig/r.typ:440
D:potřebné občanské potřebné občanské potřebné občanské
 :šoférům, plynové, šoférům, plynové, šoférům, plynové
 :zahlédli vzájemné zahlédli vzájemné zahlédli vzájemné
 :hospodářské společenské hospodářské společenské
 :průmyslové, elektrické, průmyslové, elektrické
 :jednotlivé, samozřejmé, jednotlivé, samozřejmé
 :energetické jednorázové energetické jednorázové

#                                                            ../orig/r.typ:441
I:Otestujte si svou rychlost.
*:_R_R_L90
#                                                            ../orig/r.typ:451
D:rodné jméno mateřské školy rodné jméno mateřské
 :roční nájemné, české sklo, roční nájemné, české
 :nahodilé setkání, spravedlivé rozhodnutí, nahodilé
 :ve vzájemné spolupráci, chráníme dobré jméno svého
 :tenké jemné hedvábí, mixování potravin mixérem
 :jedlé houby jedovaté houby jedlé houby jedovaté
 :stálé sídlo cizojazyčné knihy stálé sídlo cizojazyčné
 :úkoly obcím na úseku oprav dosavadního bytového

#                                                            ../orig/r.typ:452
I:Opakování zaměřené na rytmus.
*:_R_R_L91
#                                                            ../orig/r.typ:453
D:léčebna startér kariéra schéma, zelené. léčebna
 :smést snést uvést plést kvést slézt svézt smést
 :příznivé kapesné, upravené kudrnaté praménky vlasové

G:_R_E_R9
#------------------------------------------------------------------------------
# Lekce R10
#------------------------------------------------------------------------------
*:R10
*:_R_S_R10
#                                                            ../orig/r.typ:457
I:Rozcvička.
*:_R_R_L92
#                                                            ../orig/r.typ:458
D:Sekce vzájemné hospodářské pomoci.
 :Sekce vzájemné hospodářské pomoci.

#                                                            ../orig/r.typ:459
I:Písmeno Ě píšeme levým malíčkem, který vychylujeme
 :přímo nahoru.

*:_R_R_L93
#                                                            ../orig/r.typ:461
D:prohloubené cizojazyčné nedokonalé, lékařstvím.
 :aqě aěa aqě aěa aqě aěa aqě aěa aqě aěa aqě aěa
 :měl věk měl věk měl věk měl věk měl věk měl věk
 :obě dvě obě dvě obě dvě obě dvě obě dvě obě dvě
 :děl těl děl těl děl těl děl těl děl těl děl těl

#                                                            ../orig/r.typ:462
I:Slova.
*:_R_R_L94
#                                                            ../orig/r.typ:463
D:obecně, reálně, obecně, reálně, obecně, reálně
 :zvláště úspěšní zvláště úspěšní zvláště úspěšní
 :změněn, bělouš, změněn, bělouš, změněn, bělouš
 :měl věk mně běh něj děl obě děj věř měj těš měř
 :několik pěstoun sdělili liknavě záměnou vyběhli
 :zaměstnaneckého nejkvalitnějším nepravděpodobně

#                                                            ../orig/r.typ:464
I:Procvičení.
*:_R_R_L95
#                                                            ../orig/r.typ:466
D:Na vědomí. Na vrcholu štěstí. Na vědomí. Na vrcholu
 :dovoz nebyl zajištěn ve vnějších vztazích dovoz
 :mezinárodní dělba práce mezinárodní dělba práce
 :má zajištěn pracovní poměr dřívější zaměstnání
 :řídil se směrnicemi, sběratel věcí, řídil se

#                                                            ../orig/r.typ:467
I:Písmeno Ž píšeme levým ukazováčkem,
 :který vychylujeme vpravo nahoru.
*:_R_R_L96
#                                                            ../orig/r.typ:470
D:přesvědčené nadprůměrně zajištěného zkvalitněné
 :ftž fžf fřf ftž fžf fřf ftž fžf fřf ftž fžf fřf
 :jež již jež již jež již jež již jež již jež již
 :táž též táž též táž též táž též táž též táž též
 :běž věž běž věž běž věž běž věž běž věž běž věž
 :což žil což žil což žil což žil což žil což žil

#                                                            ../orig/r.typ:471
I:Opakujeme Ž.
*:_R_R_L97
#                                                            ../orig/r.typ:475
D:režisér soutěží režisér soutěží režisér soutěží
 :odvážel stožár, odvážel stožár, odvážel stožár
 :tržiště knížek, tržiště knížek, tržiště knížek
 :obtížná montáž, obtížná montáž, obtížná montáž
 :oběžník kroužku oběžník kroužku oběžník kroužku
 :dodržet zadržet vydržet obdržet podržet udržet
 :složil, vložil, uložil, naložil vyložil založil


#                                                            ../orig/r.typ:476
I:Zrychlujte a zpomalujte.
*:_R_R_L98
#                                                            ../orig/r.typ:481
D:družstevním stížnostem, družstevním stížnostem
 :dosažitelná kožešnictví dosažitelná kožešnictví
 :arbitrážním požadavkům, arbitrážním požadavkům
 :žurnalistům soutěžících žurnalistům soutěžících
 :režie jakož vážně běžel lžíce takže svěží zúžil
 :jestliže vyžádali nejnižší přirážku umožnili
 :každoročně, železniční, vymoženost, považovali


#                                                            ../orig/r.typ:482
I:Písmeno Ý píšeme ukazováčkem pravé ruky vychýlením
 :vpravo vzhůru.

*:_R_R_L99
#                                                            ../orig/r.typ:488
D:údržbáři vyžadují množství podložek údržbáři
 :železářství peněžnictví složitější, soutěžením.
 :juý jýj jáj juý jýj jáj juý jýj jáj juý jýj jáj
 :být dým být dým být dým být dým být dým být dým
 :kýl rým kýl rým kýl rým kýl rým kýl rým kýl rým
 :sýr zlý sýr zlý sýr zlý sýr zlý sýr zlý sýr zlý
 :rýč kým rýč kým rýč kým rýč kým rýč kým rýč kým

#                                                            ../orig/r.typ:489
I:Slova.
*:_R_R_L100
#                                                            ../orig/r.typ:495
D:slýchal otýpkou slýchal otýpkou slýchal otýpkou
 :blondýn inženýr blondýn inženýr blondýn inženýr
 :ohýbaný dýchací ohýbaný dýchací ohýbaný dýchací
 :divokým pomýšlí divokým pomýšlí divokým pomýšlí
 :dým nýt rýh výr hýl týt prý rýt zlý rým týž mýt
 :výmysly kostýmy výkonný pionýři mlýnice sýkorka
 :ženský, řadová, žíznivý řečená, žulový, říjnová

#                                                            ../orig/r.typ:496
I:Cvičení.
*:_R_R_L101
#                                                            ../orig/r.typ:504
D:hospodářský hospodárný, hospodářský hospodárný,
 :průmyslovým technickými průmyslovým technickými
 :polovičatým sebejistých polovičatým sebejistých
 :ostýchavými pokrývačský ostýchavými pokrývačský
 :francouzský klopýtnutím francouzský klopýtnutím
 :dýha, dýka, dýmka pýcha mýdla rýma, rýha, výhra


#                                                            ../orig/r.typ:505
I:Opakování.
*:_R_R_L102
#                                                            ../orig/r.typ:506
D:průmyslovým technickými průmyslovým technickými
 :polovičatým sebejistých polovičatým sebejistých
 :ostýchavými pokrývačský ostýchavými pokrývačský

G:_R_E_R10
#------------------------------------------------------------------------------
# Lekce R11
#------------------------------------------------------------------------------
*:R11
*:_R_S_R11
*:_R_R_L103
#                                                            ../orig/r.typ:514
T:
 :  Již jsme téměř u konce, vydržte!

#                                                            ../orig/r.typ:515
I:Rozcvička.
*:_R_R_L104
#                                                            ../orig/r.typ:516
D:Opožděnými dodávkovými příkazy. Opožděnými dodávkovými
 :Překročení stanovených úkolů ve výrobním odvětví.

#                                                            ../orig/r.typ:517
I:Ď, Ť, Ň: levý Shift+háček, písmeno.
 :Ó - čárka (klávesa háčku), O.

*:_R_R_L105
#                                                            ../orig/r.typ:519
D:ďa, ťa, ňa, ďa, ťa, ňa, ďa, ťa, ňa, ďa, ťa, ňa, ďa,
 :loď nať báň loď nať báň loď nať báň loď nať báň loď
 :seď byť laň seď byť laň seď byť laň seď byť laň seď
 :buď huť kůň buď huť kůň buď huť kůň buď huť kůň buď
 :káď drť míň káď drť míň káď drť míň káď drť míň káď

#                                                            ../orig/r.typ:520
I:Toto je obtížná část, budeme muset hodně cvičit.
*:_R_R_L106
#                                                            ../orig/r.typ:521
D:lóže móda lóže móda lóže móda lóže móda lóže móda
 :hněď, čtvrť bázeň příď, tříšť náplň žerď, laťka
 :zajišťuje pojišťuje zjišťuje, uplatňuje zmocňuje
 :milión bonbón fazóna glóbus citrón pódium kvóta
 :báňský inženýr, báňský inženýr, báňský inženýr
 :begónie a pelargónie, begónie a pelargónie

#                                                            ../orig/r.typ:522
I:Věty.
*:_R_R_L107
#                                                            ../orig/r.typ:524
D:Madloň je růžově kvetoucí strom, jehož semeny jsou mandle.
 :Bóje je plovoucí těleso označující nebezpečné místo ve vodě.
 :Objížďka znamená náhradní cestu za uzavřenou komunikaci.
 :Rtuť je tekutý, jedovatý, stříbřitě kovový prvek.
 :Skóre je poměr bodů ve sportovním utkání.

#                                                            ../orig/r.typ:525
I:Š,Ď... - shift-háček, shift-písmeno.
*:_R_R_L108
#                                                            ../orig/r.typ:528
D:Ža, Ža, Ňa, Ňa, Ťa, Ťa, Ža, Ža, Ňa, Ňa, Ťa, Ťa, Ža
 :Řa, Ša, Řa, Ša, Řa, Ša, Řa, Ša, Řa, Ša, Řa, Ša, Řa
 :Ďa, Ča, Ďa, Ča, Ďa, Ča, Ďa, Ča, Ďa, Ča, Ďa, Ča, Ďa
 :Úa, Óa, Éů, Áů, Úa, Óa, Éů, Áů, Úa, Óa, Éů, Áů, Úa
 :Železniční stavitesltví, Železniční opravny a strojírny,


#                                                            ../orig/r.typ:529
I:A znovu...
*:_R_R_L109
#                                                            ../orig/r.typ:533
D:Řempo, oborový podnik, Ředitelství dálnic
 :Škoda, koncernový podnik, Šumavské vápenice, Šohaj
 :Čokoládovny, oborový podnik, Česká státní spořitelna
 :Ďumbier, výrobní družstvo, Ďáblice, Ďumbier, výrobní
 :Ústřední rada odborů, Ústav národního zdraví, Úpavan
 :Železárny Bílá Cerkev, Šroubárna Žatec

#                                                            ../orig/r.typ:534
I:Nepodvádějte s CAPS LOCKem!
*:_R_R_L110
#                                                            ../orig/r.typ:539
D:PLZEŇ, DOMAŽLICE, HORAŽĎOVICE, PIEŠŤANY, PŘEROV
 :ČSSR, ČSR, ČNR, ČSAV, VŠE, SEŠ, ČKD, VŽKG, ČSAD
 :JESENÍKY, TÁBOR, PÍSEK, BLATNÁ, NÁCHOD, PÚCHOV
 :KÚNZ, OÚNZ, ÚV KSČ, ÚV ČSTV, ÚV NF, ÚRO, ÚV SSM

#                                                            ../orig/r.typ:540
I:pravý ukazováček: ?, pravý prsteníček: :,
 :pravý malíček: !,/,(,).
*:_R_R_L111
#                                                            ../orig/r.typ:546
D:k? k? ů! ů! k? k? ů! ů! k? k? ů! ů! k? k? ů! ů! k?
 :Máte zájem o spolupráci? Můžete nám vyhovět? Splníte?
 :Kam letos na dovolenou? Jaké bude počasí? Učíte se?
 :Dávejte pozor! Sledujte pozorně výklad!
 :Míru zdar! Pětiletce zdar! Za trvalý mír! Světu mír!

#                                                            ../orig/r.typ:547
I:Opakování
*:_R_R_L112
#                                                            ../orig/r.typ:548
D:l: l: l; l; l: l: l; l; l: l: l; l; l: l: l; l; l: l:
 :Klávesnice obsahuje: písmennou řadu střední, dolní,
 :číselnou.
 :Způsob doručení písemností označujeme takto: Doporučeně
 :Otevřená listovní zásilka Letecky Par Avion Air mail

G:_R_E_R11
#------------------------------------------------------------------------------
# Lekce R12
#------------------------------------------------------------------------------
*:R12
*:_R_S_R12
#                                                            ../orig/r.typ:552
I:Toto je poslední lekce. Půjdeme na čísla.
*:_R_R_L113
#                                                            ../orig/r.typ:553
D:A1A A2A A1A A2A A1A A2A A1A A2A A1A A2A A1A A2A A1A A2A
 :S3S S3S S3S S3S S3S S3S S3S S3S S3S S3S S3S S3S S3S S3S
 :D4D D4D D4D D4D D4D D4D D4D D4D D4D D4D D4D D4D D4D D4D
 :F5F F6F F5F F6F F5F F6F F5F F6F F5F F6F F5F F6F F5F F6F
 :J7J J8J J7J J8J J7J J8J J7J J8J J7J J8J J7J J8J J7J J8J
 :K9K K9K K9K K9K K9K K9K K9K K9K K9K K9K K9K K9K K9K K9K

#                                                            ../orig/r.typ:554
I:Pokračujeme. Nepodvádějte na numerické klávesnici!
*:_R_R_L114
#                                                            ../orig/r.typ:556
D:J7J J8J J7J J8J J7J J8J J7J J8J J7J J8J J7J J8J J7J
 :K9K K9K K9K K9K K9K K9K K9K K9K K9K K9K K9K K9K K9K
 :L0L L0L L0L L0L L0L L0L L0L L0L L0L L0L L0L L0L L0L
 :1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20
 :21 22 23 24 25 26 27 28 29 30 12 23 34 45 56 67 78
 :123 345 567 789 901 710 629 538 450 817 3 92 604 6

#                                                            ../orig/r.typ:557
I:Opakování.
*:_R_R_L115
#                                                            ../orig/r.typ:558
D:123 345 567 789 901 710 629 538 450 817 3 92 604
 :98,2; 2 115,70; Kčs 78 900,--; 1 264 603, 520 71
 :Jednota, LSD Rokycany, č. tel. 25 55; prodejna
 :čp 542, č. tel. 91 53 50
 :KÚNZ - Fakultní nemocnice, Plzeň, Lenonova 13
 :číslo telefonu 21 62 nebo 27 33 36, linka 350


#                                                            ../orig/r.typ:559
I:Zkuste si i další symboly, použijte vždy nejbližší prst.
*:_R_R_L116
#                                                            ../orig/r.typ:561
D:I = 1, V = 5, X = 10, L = 50, C = 100, D = 500
 :I II IV V VI IX X XI XIX XX XXI XL L LI LX LXX
 :CD DX DC DL CM M MC; MMMDCLXVI (3 666)
 :150 + 65 = 215; 344 - 44 = 300; 32,5 x 26,8 = 871;

#                                                            ../orig/r.typ:562
I:Jsme u konce.
*:_R_R_L117
#                                                            ../orig/r.typ:565
D:Možná budete chtít zkusit i jiné série lekcí
 :a dále se zdokonalovat. Můžete se ale zdokonalovat
 :i praxí. Přesto vaší rychlosti velmi pomůže, pokud
 :se třeba za rok ke kurzu vrátíte a ačkoliv již
 :budete umět správně psát, projdete si jej ještě
 :jednou. Uvidíte, že zlepšení v rychlosti se určitě
 :dostaví. Hlavně mějte na paměti, že je třeba
 :psát plynule, rychlost se dostaví časem. Gratuluji!

G:_R_E_R12
#------------------------------------------------------------------------------
# Lekce series R jump tables
#------------------------------------------------------------------------------
*:_R_E_R1
Q:Chcete pokračovat do lekce R2 [Y(ano)/N(ne)]?
N:_R_MENU
G:_R_M_R2
*:_R_E_R2
Q:Chcete pokračovat do lekce R3 [Y(ano)/N(ne)]?
N:_R_MENU
G:_R_M_R3
*:_R_E_R3
Q:Chcete pokračovat do lekce R4 [Y(ano)/N(ne)]?
G:_R_M_R4
*:_R_E_R4
Q:Chcete pokračovat do lekce R5 [Y(ano)/N(ne)]?
N:_R_MENU
G:_R_M_R5
*:_R_E_R5
Q:Chcete pokračovat do lekce R6 [Y(ano)/N(ne)]?
N:_R_MENU
G:_R_M_R6
*:_R_E_R6
Q:Chcete pokračovat do lekce R7 [Y(ano)/N(ne)]?
N:_R_MENU
G:_R_M_R7
*:_R_E_R7
Q:Chcete pokračovat do lekce R8 [Y(ano)/N(ne)]?
N:_R_MENU
G:_R_M_R8
*:_R_E_R8
Q:Chcete pokračovat do lekce R9 [Y(ano)/N(ne)]?
N:_R_MENU
G:_R_M_R9
*:_R_E_R9
Q:Chcete pokračovat do lekce R10 [Y(ano)/N(ne)]?
N:_R_MENU
G:_R_M_R10
*:_R_E_R10
Q:Chcete pokračovat do lekce R11 [Y(ano)/N(ne)]?
N:_R_MENU
G:_R_M_R11
*:_R_E_R11
Q:Chcete pokračovat do lekce R12 [Y(ano)/N(ne)]?
N:_R_MENU
G:_R_M_R12
*:_R_E_R12
G:_R_MENU

*:_R_M_R1
B:                            Lekce R1
G:_R_S_R1
*:_R_M_R2
B:                            Lekce R2
G:_R_S_R2
*:_R_M_R3
B:                            Lekce R3
G:_R_S_R3
*:_R_M_R4
B:                            Lekce R4
G:_R_S_R4
*:_R_M_R5
B:                            Lekce R5
G:_R_S_R5
*:_R_M_R6
B:                            Lekce R6
G:_R_S_R6
*:_R_M_R7
B:                            Lekce R7
G:_R_S_R7
*:_R_M_R8
B:                            Lekce R8
G:_R_S_R8
*:_R_M_R9
B:                            Lekce R9
G:_R_S_R9
*:_R_M_R10
B:                           Lekce R10
G:_R_S_R10
*:_R_M_R11
B:                           Lekce R11
G:_R_S_R11
*:_R_M_R12
B:                           Lekce R12
G:_R_S_R12
*:_R_M_R13
B:                           Lekce R13
G:_R_S_R13
*:_R_M_R14
B:                           Lekce R14
G:_R_S_R14
#------------------------------------------------------------------------------
# Lekce series R menu
#------------------------------------------------------------------------------
*:_R_MENU
M: UP=__SERIESMENU "Série lekcí R obsahuje těchto 12 lekcí"
 :_R_M_R1  "Lekce R1     f,j,d,k,s,l,a,ů,g,h"
 :_R_M_R2  "Lekce R2     r,l,e,i,y,n"
 :_R_M_R3  "Lekce R3     o,.,p,t"
 :_R_M_R4  "Lekce R4     y,ú,q"
 :_R_M_R5  "Lekce R5     v,m,c"
 :_R_M_R6  "Lekce R6     x,w,-,z,b"
 :_R_M_R7  "Lekce R7     n, velká písmena, ř, á"
 :_R_M_R8  "Lekce R8     č, í"
 :_R_M_R9  "Lekce R9     š, é"
 :_R_M_R10 "Lekce R10    ě, ž, ý"
 :_R_M_R11 "Lekce R11    ď,ť,ň,ó, velká diakritická,..."
 :_R_M_R12 "Lekce R12    čísla,=,-,+"
*:_R_EXIT

#------------------------------------------------------------------------------
# End of file r.typ
G:__SERIESMENU
#==============================================================================
#==============================================================================
*:__S_T_SERIES
# Start of file t.typ
# Typist v2.2 - improved typing tutor program for UNIX systems
# Copyright (C) 1998 Simon Baldwin (simonb@sco.com)
#
# Copyright (C) 2001 Hynek Hanke (hanke@volny.cz), Gnumaniacs.Org
#
# This was translated and modified to Czech by Hynek "0A4h" Hanke
# hanke@volny.cz / Gnumaniacs.Org
# Please report bugs to hanke@volny.cz, *not* to Simon!
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
#
#------------------------------------------------------------------------------
# Series T
#------------------------------------------------------------------------------
G:_T_MENU
*:_T_NO_MENU
#------------------------------------------------------------------------------
# Lekce T1
#------------------------------------------------------------------------------
*:T1
*:_T_S_T1
*:_T_R_L0
#                                                             ../orig/t.typ:21
T:			Vítejte v lekci T1.
 :
 : V sérii lekcí T se budeme učit psát na standardní klávesnici.
 : Představím vám všechna písmena. Budu postupovat vždy po jednom.
 : Až dokončíte tuto sérii, budete ovládat psaní celé abecedy,
 : všech čísel a většiny interpunkčních znamének.
 :
 : Pokud jste úplní nováčci a ještě jste se nikdy psaní na klávesnici
 : všemi deseti prsty neučili, prosím buďte trpěliví. Psaní není
 : složité, ale je třeba hodně cviku. Prosím vyhněte se pokušení
 : dívat se dolů na prsty, když píšete. To je velmi špatný zvyk
 : a těžko se ho potom zbavuje. Když zmáčknete špatnou klávesu,
 : dám vám vědět. (Nikomu to ale neřeknu, takže žádný strach.)
 :
 : Pokud jste byli zvyklí psát metodou ulov-a-klovni, bude pro vás
 : těžké zříci se dívání. Nebuďte překvapení, že vám psaní všemi
 : deseti prsty půjde pomaleji, než váš starý způsob. Asi bude
 : v začátcích pomalejší. Když do toho ale konečně proniknete,
 : bude to podstatně rychlejší. Ušetří vám mnoho času.
 :
 : Pokud již psát všemi deseti umíte, projdete lekcemi velmi rychle.
 : Možná byste mohli spíše zkusit rovnou sérii S.
*:_T_R_L1
#                                                             ../orig/t.typ:42
T:
 :			Domovské klávesy
 :
 : Abyste mohli stisknout správnou klávesu, musíte vždy vědět, kde se
 : přesně vaše prsty nacházejí. To zajistíte tak, že budete mít pro
 : každý prst speciální místo. Takové klávesy se nazývají ,,základní
 : pozice.''
 :
 : Položte si pravý ukazováček na klávesu J. Nyní dejte pravý prostředníček
 : na klávesu K, prsteníček na L a malíček na ů.
 :
 : Stejně tak umístěte i prsty vaší levé ruky na klávesy F, D, S a A.
 : Pravý ukazováček na F, prostředníček na D, prsteníček na S a malíček
 : na A. Pravý i levý palec si položte na SPACE (dlouhá klávesa) úplně
 : dole, kterou píšeme mezeru. K jejímu stisku budeme vždy používat
 : prst, který se nám hodí lépe. Nyní všechny prsty lehce nadzvedněte,
 : aby se vznášely přesně nad klávesami. Každý prst by se měl své
 : domovské klávesy dotýkat jen velmi jemně. Toto je elektronická
 : klávesnice a k náhodnému stisku klávesy není třeba moc tlaku.
 :
 : Dobře se tuto pozici naučte. Kdykoliv se budete chystat na psaní
 : nové řádky textu, zkontrolujte, zda jsou prsty v základní pozici.
 : Poté se již na prsty nekoukejte.

*:_T_R_L2
T:
 :
 : Téměř všechny klávesnice mají na klávesách F a J malé výstupky,
 : které vám umožní lehce po hmatu základní pozici poznat.
 :
 : Snažte se sedět v rovně, hodně vám to ulehčí psaní. Lokty by měly
 : být pokrčené v pravém úhlu a měly by být minimálně v úrovni klávesnice.
 : Nikdy ne níže, spíše o trošku výše.
 :
 : Zápěstí by měla být položena na stole. Neměla by levitovat ve vzduchu
 : ani viset přes okraj stolku. Opět může pomoci jejich zvýšení pomocí
 : speciální podložky.
 :
 : Dbejte na to, abyste měli prsty pokrčeny a dotýkali se kláves směrem
 : zeshora. Oba palce musí stále být na klávese SPACE. Dotýkají se jí
 : nikoliv bříšky, ale vnějším bokem prvního článku. Prsty v základní
 : řadě musí dopadat na střed kláves.
 :
*:_T_R_L3
#                                                             ../orig/t.typ:63
T:
 :			PROCVIČOVÁNÍ
 :
 : Po zbytek lekce budu vždy na v horní části zobrazovat instrukce
 : a pod nimi řádku textu.
 :
 : Vy musíte pouze opsat text, který vidíte. Když stisknete správnou
 : klávesu, nebudu dělat nic. Kdykoliv uděláte chybu, tak pod písmenem,
 : které jste zadali špatně, udělám velké X a zapípám.
 : Jednoduše pokračujte dalším písmenem. Nesnažte se opravovat, prostě
 : jděte dál.
 :
 : Když se dostanete na konec řádky, stiskněte ENTER. To uděláte
 : vychýlením pravého malíčku. Stiskněte klávesu a vraťte malíček
 : zpět do původní pozice. Dávejte si pozor, aby se vaše ostatní prsty
 : nehnuly za základní pozice. Dávejte si také pozor, abyste na konci
 : řádky nedělali navíc ještě mezery.
 :
 : Když neuděláte na řádce žádnou chybu, zobrazím další řádku k procvičení.
 : Pokud uděláte chybu, pípnu a po stisku klávesy ENTER budete řádku opisovat
 : znovu. Když opět uděláte chyby, opět pípnu a nechám vás cvičení zopakovat
 : a tak dále. Nezapomeňte psát mezery jedním z palců.

#                                                             ../orig/t.typ:64
#I: Stiskněte čtyřikrát klávesu F levým ukazováčkem.
*:_T_R_L4
#                                                             ../orig/t.typ:65
D:ffff

#                                                             ../orig/t.typ:66
I: Střídavě mačkejte klávesu F a mezerník.
*:_T_R_L5
#                                                             ../orig/t.typ:67
D:fff fff fff ff ff ff f f f

#                                                             ../orig/t.typ:68
I: Nedívejte se na prsty!
#                                                             ../orig/t.typ:69
 : Pro psaní J používejte pravý ukazováček.
*:_T_R_L6
#                                                             ../orig/t.typ:70
D:jjj jjj jjj jj jj jj j j j

#                                                             ../orig/t.typ:71
I: Levou rukou pište F a pravou J. Pouze ukazováčky.
*:_T_R_L7
#                                                             ../orig/t.typ:72
D:fff jjj fff jj ff jj f j f j

#                                                             ../orig/t.typ:73
I: Teď je promícháme. Enter pravým malíčkem.
*:_T_R_L8
#                                                             ../orig/t.typ:74
D:ffjj jjff fjf fjf jfj jfj f
 :fjf fjf fjf jfj jfj jfj jfj

#                                                             ../orig/t.typ:75
I: Prostředníčkem levé ruky píšeme D.
*:_T_R_L9
#                                                             ../orig/t.typ:76
D:ddd ddd ddd dd dd dd d d d

#                                                             ../orig/t.typ:77
I: Prostředníček pravé ruky slouží pro klávesu K.
*:_T_R_L10
#                                                             ../orig/t.typ:78
D:kkk kkk kkk kk kk kk k k k

#                                                             ../orig/t.typ:80
I: Nyní oba.
*:_T_R_L11
#                                                             ../orig/t.typ:81
D:ddd kkk dd  dkd dkd kdk ddd kkk
 :dkd dkd dkd dkd dkd dkd dkd dkd
 :dd kk kd dk dd kk kd dk kk dd d

#                                                             ../orig/t.typ:82
I: Prsteníčky obou rukou píšeme S (levá) a L (pravá).
*:_T_R_L12
#                                                             ../orig/t.typ:83
D:sss lll sss lll sss ss ll ss ll s l
 :sl sl sl sl sl sl ls ls ls ls ls ls
 :sls lsl sls lsl ssl lls slsl lsls

#                                                             ../orig/t.typ:84
I: Malíčky slouží pro A (levá ruka) a ů (pravá).
*:_T_R_L13
#                                                             ../orig/t.typ:85
D:aaa ůůů aaa ůůů aa ůů aa ůů a ů
 :aa ůů aa ůů aůa aůa aůa aůa aůa
 :ůaů aůa ůaů aůa ůůa ůůa aaů ůaů

#                                                             ../orig/t.typ:86
I:To je pro teď všechno. Zkusíme si je procvičit.
*:_T_R_L14
#                                                             ../orig/t.typ:87
D:fff jjj ddd kkk sss lll aaa ůůů
 :fff jjj ddd kkk sss lll aaa ůůů

#                                                             ../orig/t.typ:88
I:Znovu. Pokud se vám pletou, nevadí. To je normální.
*:_T_R_L15
#                                                             ../orig/t.typ:89
D:fff jjj ddd kkk sss lll aaa ůůů
 :fff jjj ddd kkk sss lll aaa ůůů

#                                                             ../orig/t.typ:90
I:Zkusíme je teď promíchat.
*:_T_R_L16
#                                                             ../orig/t.typ:91
D:asdf jklů asdf jklů asdf jklů
 :fdsa ůlkj fdsa ůlkj asdf jklů

#                                                             ../orig/t.typ:92
I:A znova. Neztrácejte trpělivost.
*:_T_R_L17
#                                                             ../orig/t.typ:93
D:fjf kdk sls ůaů aůa aja aka ala aůa
 :fj jf dk kd sl ls aů ůa fj dk sl aů
 :fj dk sl aů fů dl sk aj jf dk ls ůa

#                                                             ../orig/t.typ:94
I:Než skončíme, zkuste si nějaká slova.
*:_T_R_L18
#                                                             ../orig/t.typ:95
D:sad kůl klas sůl důl jas
 :klas sůl jas důl kůl sad

#                                                             ../orig/t.typ:96
I:Co takhle slovní spojení?
*:_T_R_L19
#                                                             ../orig/t.typ:97
D:klas a jas
 :klas a jas
 :fajfka a kajak

#                                                             ../orig/t.typ:98
I:Znovu pár slov (a pseudoslov :)
*:_T_R_L20
#                                                             ../orig/t.typ:99
D:das fůl klas kůl jak kajak fůj
 :kajak fajfka sůl klas důl jak

#                                                             ../orig/t.typ:98
I:Procvičování není nikdy dost.
*:_T_R_L21
#                                                             ../orig/t.typ:99
D:asdf jklů fdsa ůlkj fjdk slaů klas slak fjůs

#                                                             ../orig/t.typ:98
I:Poslední cvičení. Dejte si záležet.
*:_T_R_L22
#                                                             ../orig/t.typ:99
D:dk sl ůa sas dl ja klas fl fk ls dů das
 :sas fj dk sl ůf dů sk ja sl dk jf klas

G:_T_E_T1
#------------------------------------------------------------------------------
# Lekce T2
#------------------------------------------------------------------------------
*:T2
*:_T_S_T2
*:_T_R_L23
#                                                            ../orig/t.typ:114
T:
 :
 : Lekce T2
 :
 : V této lekci si zopakujeme, co jste se již naučili, a přidáme další
 : písmena E, G, H a znak tečky. Pokud jste v minulých cvičeních ještě
 : stále dělali chyby, nic se neděje. Jednou naučené budete odteď již
 : stále procvičovat.
 :
 : Kdykoliv vychýlíte prst ke stisku některé z těchto kláves, nezapomeňte
 : jej ihned vrátit zpět do základní pozice. Například pro stisk klávesy
 : H zvedněte pravý ukazováček a posuňte ho mírně vlevo. Stiskněte klávesu
 : a okamžitě jej vraťte zpět na J.
 :
 : Když se ztratíte a neuvědomíte si, kde jsou vaše prsty, zkuste to uhodnout.
 : Nedívejte se! Pomohou vám i výstupky na klávesách J a F. Ujistěte se vždy,
 : že ukazováčky cítíte tyto výstupky a ostatní prsty máte v řadě. Opravdu se
 : nedívejte.
 :
 : Snažte se dodat psaní plynulost. Mačkejte klávesy v pravidelných
 : intervalech. Rychlejší prsty budou na pomalejší čekat, ale to je
 : v pořádku. V této fázi kurzu není rozhodující rychlost. Nespěchejte
 : a zaměřte se hlavně na rytmus.

#                                                            ../orig/t.typ:115
I:Nejprve zkusíme trošku procvičovat.
*:_T_R_L24
#                                                            ../orig/t.typ:116
D:fff jjj ddd kkk sss lll aaa ůůů aaa
 :fj fj fj dk dk dk sl sl sl aů aů aů

*:_T_R_L25
#                                                            ../orig/t.typ:120
D:asdf jklů fdsa ůlkj
 :fjf jfj dkd kdk sls lsl aůa ůaů
 :jkj jlj jůj fdf fsf faf
 :a sad lassů ask dadů

#                                                            ../orig/t.typ:121
I:Ke stisknutí H vychylte vlevo váš prst na J
*:_T_R_L26
#                                                            ../orig/t.typ:122
D:jjj jhj jjj jhj jjj jhj
 :jjj hhh jjj hhh jjj hhh

I:Nedívejte se na klávesnici. Cítíte výstupky na J?
*:_T_R_L27
#                                                            ../orig/t.typ:125
D:jjj hhh jjj hhh jj hh j h j h
 :jjj had jjj ash jjj has jjj
 :jjj sash jjj hash jjj hall jjj

#                                                            ../orig/t.typ:126
I:Klávesu G mačkejte vychýlením prstu na F doprava.
*:_T_R_L28
#                                                            ../orig/t.typ:127
D:fff fgf fff fgf fff fgf
 :fff ggg fff ggg fff ggg

I: Snažte se mačkat klávesy v pravidelných intervalech.
*:_T_R_L29
#                                                            ../orig/t.typ:130
D:fff ggg fff ggg fff ggg
 :fff gag fff lag fff flag fff
 :fff sag fff slag fff hag fff

#                                                            ../orig/t.typ:131
I:Vychýlením prstu D nahoru mačkáme E.
*:_T_R_L30
#                                                            ../orig/t.typ:132
D:ddd ded ddd ded ddd ded ddd
 :ddd eee ddd eee ddd eee ddd

*:_T_R_L31
#                                                            ../orig/t.typ:135
D:ddd eee ddd eee dd ee dd ee d e
 :ddd fee ddd see ddd elf ddd
 :lake asked fake gale egg

#                                                            ../orig/t.typ:136
I:Prstem K vychýleným dolů mačkáme čárku.
*:_T_R_L32
#                                                            ../orig/t.typ:137
D:kkk k,k kkk k,k kkk k,k

I:Pamatujte na dostatečné ohnutí prstů, to vám psaní čárky usnadní.
*:_T_R_L33
#                                                            ../orig/t.typ:138
D:kkk ,,, kkk ,,, kkk ,,, kkk

#                                                            ../orig/t.typ:139
I:Procvičujeme
*:_T_R_L34
#                                                            ../orig/t.typ:140
D:klas sedl, ale kůl je, hlad
 :lůk fas hlas gek lůsa sůl kůl
 :has dj ks ls gf hj jh fg gl gj sj sh

I:Dodržujete rovnoměrný rytmus?
*:_T_R_L35
#                                                            ../orig/t.typ:141
D:hed, glk, sad, jas, jed, keks, lesk
 :had, lesk, sad, kajak, keks gal, dal
 :kasa leh jed hle gala glk kajak das

I:Umíte anglicky?
*:_T_R_L36
#                                                            ../orig/t.typ:141
D:she had a fake egg, he had a salad
 :he had a salad, she had a fake egg


G:_T_E_T2
#------------------------------------------------------------------------------
# Lekce T3
#------------------------------------------------------------------------------
*:T3
*:_T_S_T3
#                                                            ../orig/t.typ:145
I: Opět budeme procvičovat.
*:_T_R_L37
#                                                            ../orig/t.typ:146
D:fff jjj ddd kkk sss lll aaa ůůů
 :fj fj fj fj dk dk dk dk sl sl sl aů aů aů
 :fjf dkd sls aůa jf dk ls aů fj kd sl ůa
 :fs kl ůj adů gal hlad klas las had klad

I: Ještě tyto dva řádky, pak půjdeme na I.
*:_T_R_L38
#                                                            ../orig/t.typ:147
D:fgf jhj ded k,k fgf jhj ded k,k
 :keks, deska, had je jas, kůl, gal

#                                                            ../orig/t.typ:149
I:Pro stisknutí klávesy I vychylte prst na K nahoru.
*:_T_R_L39
#                                                            ../orig/t.typ:150
D:kkk kik kkk kik kkk iii kkk

I:Opisujte. Máte lokty v pravém úhlu, zápěstí na stole a prsty pokrčeny?
*:_T_R_L40
#                                                            ../orig/t.typ:154
D:kkk iii kkk iii kk ii kk ii
 :kkk lid kkk klika kkk jid kkk
 :kkk keks kkk kid kkk kil kkk
 :kkk klika kkk lih kkk sill kkk

#                                                            ../orig/t.typ:155
I:Klávesu R stlačte vychýlením prstu na F nahoru.
*:_T_R_L42
#                                                            ../orig/t.typ:156
D:fff frf fff frf fff frf

I: Teď to promícháme. Upřednostňujte rytmus před rychlostí.
*:_T_R_L43
#                                                            ../orig/t.typ:160
D:fff rrr fff rrr ff rr ff rr
 :fff rak fff hrad fff drak fff
 :fff red fff read fff rada fff
 :fff lara fff frak fff jar fff

I: Jde vám to dobře, pokračujte.
*:_T_R_L44
#                                                            ../orig/t.typ:161
D:fff rak fff kras fff rasa fff

I: Soustřeďte se na rytmus.
*:_T_R_L45
#                                                            ../orig/t.typ:162
D:fjf dkd sls aůa fj ls dk ůf aj ks
 :fff fůra fff ria fff sirka fff
 :sklad klas lůka rs kůl kras
 :dal fůra klasů, kůl je frak

#                                                            ../orig/t.typ:163
I:Prstem na L vychýleným dolů píšeme tečku.
*:_T_R_L46
#                                                            ../orig/t.typ:164
D:lll l.l lll l.l lll l.l lll
 :l.l l.l l.l .. l.l ll l.l l..

I:Opět vám pomůže dostatečné pokrčení prstů.
*:_T_R_L47
#                                                            ../orig/t.typ:167
D:lll ... lll ... ll .. ll .. l .
 :lll adj. lll id. lll
 :lll eg. lll i.e. lll
 :lak. sklad. rak. sůl. kůl. les.

*:_T_R_L48
#                                                            ../orig/t.typ:179
T:Nyní se pokusíme zapojit klávesu SHIFT.
 :
 :Kdykoliv chcete napsat nějaké velké písmeno na levé
 :straně klávesnice, stiskněte pravý SHIFT
 :a odpovídající klávesu. Řiďte se těmito radami:
 :
 :	a.) Přehoupněte pravý malíček na klávesu SHIFT a stiskněte ji.
 :          Nesmíte při tom pohnout ukazováčkem z klávesy J. Pohnout
 :          byste neměli ani ostatními prsty.
 :
 :	b.) Stiskněte levou rukou klávesu, ze které chcete mít velké písmeno.
 :
 :	c.) Okamžitě vraťte pravý malíček zpět na základní pozici (klávesa ů)

#                                                            ../orig/t.typ:180
I:Nekoukejte se na prsty!
*:_T_R_L49
#                                                            ../orig/t.typ:181
D:ůůů ůAů ůůů ůSů ůůů ůDů ůůů ůFů
 :S F G S A F F S D A F A D S F S

I:Nezapomeňte malíček okamžitě vracet.
*:_T_R_L50
#                                                            ../orig/t.typ:182
D:ůůů Důl ůůů Sůl ůůů
 :ůůů Fred ůůů Gail ůůů Alf ůůů Dale ůůů

*:_T_R_L51
#                                                            ../orig/t.typ:185
D:ůůů Ada ůůů Al ůůů Greg ůůů
 :jjj Dr. jjj Sr. jjj Fr. jjj

#                                                            ../orig/t.typ:186
I:Věta (i naše podivná pseudověta) začíná velkým písmenem a končí tečkou.
*:_T_R_L52
#                                                            ../orig/t.typ:187
D:Sire, raků je jak hadů.

*:_T_R_L53
#                                                            ../orig/t.typ:191
D:Rak seje sůl.
 :Sill dal hlas.
 :Dik hledal důl.
 :Rak seje sůl.

#                                                            ../orig/t.typ:192
I:Za tečkou vždy následuje mezera. Zkuste tento anglický text.
*:_T_R_L54
#                                                            ../orig/t.typ:193
D:A free red jade is fake. Girls like silk.

I:Vytvářet české věty je bez diakritiky zatím těžké,
 :snad vám angličtina nevadí.
*:_T_R_L55
#                                                            ../orig/t.typ:195
D:She seeks a safe reef, if she sails. A gale is rare.
 :Alf fed her egg salad. Gail likes hash.

G:_T_E_T3
#------------------------------------------------------------------------------
# Lekce T4
#------------------------------------------------------------------------------
*:T4
*:_T_S_T4
#                                                            ../orig/t.typ:199
I:Nejprve rychlé procvičení:
*:_T_R_L56
#                                                            ../orig/t.typ:200
D:jklů fdsa ded fgf jhj k,k kik frf l.l
 :lů l. le es kd ls ůa fj lů l,k kasa hlas

#                                                            ../orig/t.typ:202
I:Prst na L vychýlíme nahoru a píšeme O.
*:_T_R_L57
#                                                            ../orig/t.typ:203
D:lll lol lll ooo lll lol
 :lll ooo lll ooo lll ooo

I:Zkuste psát rytmicky.
*:_T_R_L58
#                                                            ../orig/t.typ:206
D:lll log lll kol lll aol lll
 :lll kolo lll ohrada lll loj lll
 :hůl dolů deska role sklo klof los
 :sol los klof folk lok dok oko

#
I:Vychýlením prstu na ů nahoru píšeme P.
*:_T_R_L59
#                                                            ../orig/t.typ:207
D:ůůů ůpů ůůů ppp ůůů ůpů ůůů
 :ůpů ůpů ppp ůůů ůpů ppp ůůů

*:_T_R_L60
#                                                            ../orig/t.typ:210
D:ůůů půl ůůů pes ůůů pas ůůů
 :ůůů pda ůůů phdr ůůů pisek ůůů
 :ůůů poklop ůůů pepik ůůů krpa ůůů

*:_T_R_L61
#                                                            ../orig/t.typ:219
T:			Levý SHIFT.
 :
 :K napsání velkého písmena na pravé straně klávesnici použijeme levý SHIFT.
 :
 :	1.) Přesuňte svůj levý prst na SHIFT a stiskněte jej.
 :          Ostatní prsty by se neměly pohnout. Minimálně prst na F
 :          musí zůstat na své pozici.
 :
 :	2.) Pravou rukou stiskněte písmeno, které chcete napsat velké.
 :
 :	3.) Okamžitě vraťte prst zpět na A.

I: Mačkáme levý SHIFT, protože píšeme písmena pravou rukou.
*:_T_R_L62
#                                                            ../orig/t.typ:220
D:aaa Pi aaa Lord aaa Jim aaa

#                                                            ../orig/t.typ:221
I:Nyní zkusíme napsat velké všechny zatím naučené klávesy vpravo.
*:_T_R_L63
#                                                            ../orig/t.typ:222
D:Joe Kim Lada Pako Olaf Ira Heidi

#                                                            ../orig/t.typ:223
I:Nezapomínejte používat PRAVÝ SHIFT pro písmena vlevo:
*:_T_R_L64
#                                                            ../orig/t.typ:224
D:aůa P.S. aůa I.R.A. aůa

#                                                            ../orig/t.typ:225
I:Vychýlením prstu na k dolů se stiskem levého SHIFTu píšeme otazník.
*:_T_R_L65
#                                                            ../orig/t.typ:226
D:ůůů ů?ů ůůů ??? ůůů ů?ů ůůů

I:Ještě jednou: otazník = levý SHIFT a k-prst dolů.
*:_T_R_L66
#                                                            ../orig/t.typ:227
D:ůůů Kdo? ůůů Kolik? ůůů Sůl? ůůů

#                                                            ../orig/t.typ:228
I:Zkusíme věty.
*:_T_R_L67
#                                                            ../orig/t.typ:229
D:Kolik je? Je rak ok?

#                                                            ../orig/t.typ:230
I:Za znakem otazníku vždy vynecháváme mezeru.
*:_T_R_L68
#                                                            ../orig/t.typ:231
D:Kde je sok? Sok je dole.

I:Poslední.
*:_T_R_L69
#                                                            ../orig/t.typ:233
D:Did she see his fall? Jake heard he is OK.
 :I hope people keep off high ladders.

G:_T_E_T4
#------------------------------------------------------------------------------
# Lekce T5
#------------------------------------------------------------------------------
*:T5
*:_T_S_T5
#                                                            ../orig/t.typ:237
I:Opět začneme opakováním.
*:_T_R_L70
#                                                            ../orig/t.typ:238
D:ade fgh ijk lop rsů ?.,

#                                                            ../orig/t.typ:239
I:Znovu.
*:_T_R_L71
#                                                            ../orig/t.typ:240
D:ade fgh ijk lop rsů ?.,

#                                                            ../orig/t.typ:242
I:Prstem z klávesy F vychýlením vpravo nahoru stisknete T.
*:_T_R_L72
#                                                            ../orig/t.typ:243
D:fff ftf fff ttt fff ftf fff
 :fff ttt fff ttt ft tf ft tf

I:Tato klávesa se vám zřejmě bude plést s R. Dávejte si na to pozor.
*:_T_R_L73
#                                                            ../orig/t.typ:244
D:ftf ta ftf test ftf tolik ftf

I:Mezi písmeny T a R jdoucími za sebou se prst nevrací na F, ale jde rovnou.
*:_T_R_L74
#                                                            ../orig/t.typ:245
D:trasa ftf testik ftf terasa ftf kolt

I:Ještě trošku procvičování. Sedíte rovně?
*:_T_R_L75
#                                                            ../orig/t.typ:246
D:Tolik k tragedii, Rogere.

#                                                            ../orig/t.typ:247
I:Vychýlením prstu z J dolů mačkáme N.
*:_T_R_L76
#                                                            ../orig/t.typ:248
D:jjj jnj jjj nnn jjj jnj jjj
 :jjj nnn jjj nnn jn jn nj nj

I:Stále dbejte na rytmus.
*:_T_R_L77
#                                                             ../orig/t.typ:251
D:jnj ne jnj ton jnj nej jnj
 :jnj Nero jnj ona jnj nasolit jnj
 :Nikdo to nejedl.sdfsdf
I:Zkusíme nějaké věty.
*:_T_R_L78
#                                                            ../orig/t.typ:251
D:Kolik je to roků?
 :jde, foka, pole, rak, kriket, rek. fidlat.
 :Nikdo to nejedl.
 :TotO JsoU TrNy.
 :Ted neni diakritika a nejde psat poradne.

I: V příští lekci zkusíme diakritiku. Musíme tedy důkladně vše procvičit.
*:_T_R_L79
#                                                            ../orig/t.typ:251
D:jde, pole, rak, kriket, rek. fidlat.
 :Kus kere je s trny.
 :Hned dostala hlad. Neji salat, nesnasi ani jidla na soji.
 :Google.Org je na Internet.

G:_T_E_T5
#------------------------------------------------------------------------------
# Lekce T6
#------------------------------------------------------------------------------
*:T6
*:_T_S_T6
#                                                            ../orig/t.typ:289
T: Lekce 6
 :
 : V této lekci se naučíme psát diakritická písmena.
 :
 : Budete muset sahat přes celou jednu řadu, ale opět se jedná
 : pouze o vychýlení jednoho prstu a ty ostatní by měly zůstat
 : pokud možno na místě. Snažte se na místě udržet minimálně
 : prsty F a J (ukazováčky).
I:Nejprve opakování.
*:_T_R_L80
D:Kolik je hodin? Jak to jde? Je to ok.
 :Stane se to, ale je to hloupost.
 :Nesnasi posadku lodi Kesta.

I:ř píšeme vychýlením prstu na F prudce nahoru.
*:_T_R_L81
D:fff řřř fřf fřf řfř ffřř řřff fřffřffřf ffřffřřřfřf
 :siř řik řil poř řepa ařs pře dře tře
 :řeka hřeje los přeje tře rř rř r

I:ý píšeme vychýlením prstu na klávese J prudce nahoru.
*:_T_R_L82
D:jjj ýýý jjj ýýý jýj jýj jjýý ýýjj jýj ýjý
 :j ý rýha sýr dýr kýr dýka týkat se

I:Promícháme to. Nedíváte se doufám na klávesnici! ř F-prst a ý J-prst.
*:_T_R_L83
D:fř jý fř jý fý jř fj řý ýř jf
 :rýha ýý řeka řý tře ýý slaný ř kalný

I:ě píšeme výrazným vychýlením A-prstu nahoru.
*:_T_R_L84
D:a ě a ě a ě a ě a aě aě aě dě fě aě
 :a ě pěst několik těsno aě oě lě jě
 :těsto stolek gěpoi eěrě přesto sě
 :aě sě dě fě jě kě lě ůě gě hě těsto

I:í píšeme prstem na K.
*:_T_R_L85
D:k í k í k í kí kík kík íkí íkí kkíí íkí
 :líto lípa díkes fík píka pika snílek

I:Teď vše dohromady. Prsty se musejí vždy vracet do základní polohy.
*:_T_R_L86
D:í ě ř ý ř ě í ř ý ě í ě
 :dítě, říkat, přít se, těsto, příchod někoho.

I:Zkusíme věty. Vychylování prstů do diakritické řady vám velmi
 :ulehčí správné pokrčení prstů v pozici základního postavení.
*:_T_R_L87
D:Je ti to líto? To dílo je pěkně krutý. Není to tak.

I:Ještě budeme procvičovat. Bez toho to nejde.
*:_T_R_L88
D:Ukrojit ostudu. Nýtovat. Děti sedí.
 :Sýpka pěkně ... Přesypala, ale neodsypala.

I:á píšeme vychýlením J-prstu mírně vpravo nahoru.
*:_T_R_L89
D:j á j á j á jáj jáj jáj ájá jáj ájá
 :jára rákos Lára párá sát hrát si Jára

I:Opisujte...
*:_T_R_L90
D:pýr párat tápat, klást klíny.
 :rýt pýřit poklop Sára projektor protektorát

I:... a nepropadejte panice :)
*:_T_R_L91
D:přísada, náhoda, pět říkanek, kánoe, dálka
 :psát hnít tě řeka hýkat pře látka práskat

I:č píšeme vychýlením prstu na D. Prsty S a F musí zůstat.
*:_T_R_L92
D:ddd dčd dčd ddd ččč dčd fčf sčs ača čč ff čj čl čů
 :čača číča fíča točit spáč strýček Kačka čas český

I:é píšeme vychýlením prstu na L mírně vpravo nahoru.
*:_T_R_L93
D:lll ééé lll é l lél lél lél ll éé ll
 :lé jé sé lé ké té lýko péro stékat réka

I:é píšeme L prstem a č D prstem
*:_T_R_L94
D:čert hadé klika kleč čelké jépane fér čičinka
 :čé éč péčko pýří se éčko řada béčko

I:Zkusíme větu.
*:_T_R_L95
D:Tahle číča dnes nebude papat mlíčko.
 :Policisté říkají, to není tak snadné.

I:Dáme test na rychlost.
*:_T_R_L96
S:Národ český není neinteligentní. Je dost inteligentní.
 :Psaní je dost lehké. Jen potřebuje hbitost.

I:Posledním písmenem v této lekci je š. Píšeme jej S-prstem.
*:_T_R_L97
D:sss ššš sšs sšs sšs ss šš šsš ššš sšsš
 :šiška čéška prášek řešeto přešlap paša

I:Dejte si pozor, abyste při vychylování S-prstu nemačkali jiné klávesy.
*:_T_R_L98
D:kalný hloupá šik čača pěšky brečet
 :Náš šik si to štrapádil přes řečiště.


G:_T_E_T6
#------------------------------------------------------------------------------
# Lekce T7
#------------------------------------------------------------------------------
I: Lekce 7
 :
 : Podíváme se na zbývající diakritiku a zkusíme si rychlostní testy.
 :
 : Lokty v pravém úhlu, zápěstí na stole, prsty dostatečně
 : pokrčené. Nedívat se na klávesnici; ukazováčky cítíme výstupky.
 :
 : A jedem!
*:T7
*:_T_S_T7
#                                                            ../orig/t.typ:289

I:Nejprve opakování.
*:_T_R_L99
D:fff jjj ůjů dklů kladů kel les resk
 :český přesný šišlat přeškrtni

I:Nejprve opakování.
*:_T_R_L100
D:Kolik je hodin? Jak to jde? Je to ok.
 :Stane se to, ale to jen někde.
 :Nesnáší posádku lodi Kěsta.

I:ž mačkáme prstem na F vychýleným prudce vpravo nahoru.
*:_T_R_L101
D:fff žžž fff žžž fžf fžf žfž žfž fžf hžh jžh
 :žižlat, žižlat žížnit řeža pžalk, žížala, plži

I:Je to úplně nejdelší přehmat na klávesnici.
*:_T_R_L102
D:až sž dž fž gž hž jž kž lž ůž
 :čížek, žhnout, požár, ožužlal

#                                                            ../orig/t.typ:252
I:Dvojtečku mačkáme L-prstem vychýleným dolů za stisku levého SHIFTU.
*:_T_R_L103
#                                                            ../orig/t.typ:253
D:lll l:l lll ::: lll l:l lll

#                                                            ../orig/t.typ:254
I:Za dvojtečkou vždy následuje dvojitá mezera.
*:_T_R_L104
#                                                            ../orig/t.typ:255
D:Test:  Drahá Petro:  Drahý Jane:

*:_T_R_L105
#                                                            ../orig/t.typ:256
D:Drahý Dr. Stone:  K Hilbertu:

*:_T_R_L106
#                                                            ../orig/t.typ:271
T:			Rychlostní zkoušky
 :
 :Odteď budu do lekcí míchat také rychlostní zkoušky. V drilových
 :testech, které jste dělali až dosud, jsem zobrazoval text dokud
 :jste ho nezadali správně. V rychlostních cvičeních zobrazím text
 :pouze jednou.
 :
 :Změna bude v tom, že vás budu měřit. Od okamžiku, kdy zadáte první
 :písmeno řádky až do okamžiku, kdy stisknete ukončující ENTER,
 :poběží moje stopky. Až skončíte, spočítám vaši rychlost a převedu
 :ji na slova za minutu (words per minute -- WPM). Sečtu také
 :všechny chyby a zobrazím vám jejich počet.
 :
 :Kdykoliv uděláte chybu, zapípám a rozsvítím písmeno, které jste měli
 :zadat, v obrácených barvách (černé písmeno na bílém pozadí).
 :Jen pokračujte dál a snažte se udělat co nejméně chyb.

#                                                            ../orig/t.typ:272
I:Zkuste tuto větu:
*:_T_R_L107
#                                                            ../orig/t.typ:273
S:Sarah psala test.

#                                                            ../orig/t.typ:274
I:Tato věta je trošku delší.
*:_T_R_L108
#                                                            ../orig/t.typ:275
S:Není to ani troška snadné, ale snad to není ani tak těžké.

#                                                            ../orig/t.typ:277
I:Při opisování víceřádkového odstavce musíte každý řádek
 :ukončit stiskem klávesy ENTER.
*:_T_R_L109
#                                                            ../orig/t.typ:280
S:Tihle lidé snad nemohli pokročit ani trošku.
 :Pokaždé to bylo špatně, zda dělali to či ono.
 :Je to dost náhoda, ale bylo to tak.

I:Chcete si zkusit anglický odstavec? Nebudete muset používat
 :diakritiku. Je to snazší.
*:_T_R_L110
#                                                            ../orig/t.typ:285
S:One fine afternoon the king had an idea. He
 :sent a letter to all the lords and ladies of
 :his land. He asked for a great feast. His
 :people prepared roasts. His jester did a jig.
 :All the people left hoping to do it again.

G:_T_E_T7
#------------------------------------------------------------------------------
# Lekce T8
#------------------------------------------------------------------------------
*:T8
*:_T_S_T8
#                                                            ../orig/t.typ:289
I:Zopakujeme si, co jsme se již naučili.
*:_T_R_L110A
#                                                            ../orig/t.typ:290
D:jkj fdf jlj fsf jůj faf kik ded frf
 :fřf jýj fčf kák sšs líl aěa ůéů fžj

*:_T_R_L111
#                                                            ../orig/t.typ:293
D:fgf jhj k,k l.l AůA FůF EůE
 :lol ůpů JaJ :a: ftf jnj ů:ů
 :teda nekalý kalný čilá šila pění

#                                                            ../orig/t.typ:295
I:Písmeno B píšeme vychýlením prstu na F hodně doprava dolů.
*:_T_R_L112
#                                                            ../orig/t.typ:296
D:fff fbf fff bbb fff fbf fff

#                                                            ../orig/t.typ:297
I:Pojďme to zkusit znova.
*:_T_R_L113
#                                                            ../orig/t.typ:298
D:fff fbf fff bbb fff fbf fff

*:_T_R_L114
#                                                            ../orig/t.typ:301
D:frf bar frf byt frf bál frf
 :frf balík frf frf bratr frf

#
I:U píšeme vychýlením J-prstu.
*:_T_R_L115
#                                                            ../orig/t.typ:302
D:jjj juj jjj uuu jjj juj jjj

*:_T_R_L116
#                                                            ../orig/t.typ:305
D:juj jug juj use juj hug juj
 :juj tulip juj turn juj upsat juj
 :Hugo prosí o podání kuřete.

#                                                            ../orig/t.typ:306
I:/ píšeme prstem na klávese ů, který si přehmátne vpravo nahoru.
 :Je nutné použít levý SHIFT.

*:_T_R_L116A
#                                                            ../orig/t.typ:307
D:ůůů ů/ů ůůů /// ůůů ů/ů ůůů

*:_T_R_L117
#                                                            ../orig/t.typ:311
D:ů/ů n/a ů/ů a/nebo ů/ů zde/jinde
 :V této éře E.R.A. snad on/ona najde hledané.
 :On/ona potřebuje jeho/její pomoc.

#                                                            ../orig/t.typ:312
I:Na pár odstavcích si teď vyzkoušíme rychlost:
*:_T_R_L118
#                                                            ../orig/t.typ:315
S:All bills are to be paid in full. If
 :there is no fee to be paid, return the
 :bill and put n/a in the total due part.

#                                                            ../orig/t.typ:316
I:Měli byste získat rychlost aspoň 15 slov/m. (Pokud budete rychlejší, pracujte
 :na přesnosti.)
*:_T_R_L119
#                                                            ../orig/t.typ:319
S:In baseball, bunting is a kind of hit. But, bunting also
 :refers to a kind of bird and the stuff that is used in
 :flags. English sure is a strange language.

G:_T_E_T8
#------------------------------------------------------------------------------
# Lekce T9
#------------------------------------------------------------------------------
*:T9
*:_T_S_T9
#                                                            ../orig/t.typ:323
I:Nejprve si prozkoušíme písmena, která již umíme.
*:_T_R_L120
#                                                            ../orig/t.typ:324
D:juj ded kik frf lol fgf ůpů jhj

*:_T_R_L121
#                                                            ../orig/t.typ:325
D:ftf jnj ftf jnj fbf juj ů?ů l.l k,k

#                                                            ../orig/t.typ:327
I:Prstem na D píšeme C. Dolů mírně vpravo.
*:_T_R_L122
#                                                            ../orig/t.typ:328
D:ddd dcd ddd ccc ddd dcd

*:_T_R_L123
#                                                            ../orig/t.typ:331
D:ddd cat ddd cup ddd can
 :dcd duck dcd card dcd pack dcd
 :dcd crate dcd scrap dcd trick dcd

#                                                            ../orig/t.typ:332
I:Prstem na J píšeme M. Opět dolů vpravo.
*:_T_R_L124
#                                                            ../orig/t.typ:333
D:jjj jmj jjj mmm jjj jmj jjj

*:_T_R_L125
#                                                            ../orig/t.typ:337
D:jjj mít jjj řím jjj mimika jjj
 :jmj manuál jmj men jmj ham jjj
 :jmj Mr. jmj Mrs. jmj Ms. jmj
 :jmj malík jmj místo jmj manumise jmj

#                                                            ../orig/t.typ:338
I:Další klávesou pro prst ů je pomlčka. Vychýlení vpravo dolů.
*:_T_R_L126
#                                                            ../orig/t.typ:339
D:ůůů ů-ů ůůů --- ůůů ů-ů ůůů ů-ů

I:V angličtině píšeme zlomky s pomlčkou.
*:_T_R_L127
#                                                            ../orig/t.typ:341
D:ůůů one-third ůůů one-half ůůů three-fifths ůůů
 :ůůů taky-programátor ůůů anti-komunista ůůů

#                                                            ../orig/t.typ:342
I:Zkusíme nějaké věty
*:_T_R_L128
#                                                            ../orig/t.typ:343
D:Marie ráda dělá omáčky. Tenhle mega-bomba-super
 :stroj by se ani neodlepil od země. Kolik je to
 :už let?

*:_T_R_L129
#                                                            ../orig/t.typ:345
D:Tento program je součástí projektu GNU.

#                                                            ../orig/t.typ:346
I:Existují tři různá použití pomlčky. Jedním z nich je kombinace slov.
*:_T_R_L130
#                                                            ../orig/t.typ:347
D:Měla na sobě modro-černý dres. Nikoho to ale nebralo.

#                                                            ../orig/t.typ:348
I:K rozdělení slov:
*:_T_R_L131
#                                                            ../orig/t.typ:350
D:Minulý pátek se stala příhoda, na kterou nemohu nepo-
 :myslet. Je to tak, ale nikdo mi to nebaští.

#                                                            ../orig/t.typ:351
I:Dlouhá pomlčka se používá k oddělení vsuvky ve větě:
*:_T_R_L132
#                                                            ../orig/t.typ:352
D:Není to tak snadné -- chtěl jsem říci, mohlo to být horší -- ale jde to.

#                                                            ../orig/t.typ:353
I:Zkusíme si na takových větách cvičení na rychlost.
*:_T_R_L133
#                                                            ../orig/t.typ:355
S:Ještě není tak tma, aby nebylo možné dojít domů.
 :Kolik je let tomuhle pořekadlu, to nikdo nespočítá.

I:Opět na rychlost.
*:_T_R_L134
#                                                            ../orig/t.typ:364
S:Muselo to tak být, jinak by se to nepovedlo.
 :Co bylo, bylo, nyní musíme přemýšlet
 :o budoucnosti, jinak bychom se pomátli.
 :Tenhle malý černý brouk je už pryč a tak
 :je lepší na něj nemyslet.

#                                                            ../orig/t.typ:365
I:Prázdné řádky píšeme dvojitým stiskem klávesy ENTER:
*:_T_R_L135
#                                                            ../orig/t.typ:374
S:Dear Mr. Mandrake:
 :
 :All of us appreciated the fine performance of those magic
 :tricks. Please arrange to come to another of our meet-
 :ings, if possible. Perhaps our Christmas meeting?
 :
 :Thanks,
 :
 :Mrs. Carmichael

G:_T_E_T9
#------------------------------------------------------------------------------
# Lekce T10
#------------------------------------------------------------------------------
*:T10
*:_T_S_T10
#                                                            ../orig/t.typ:378
I:Jako vždy, začneme krátkým opakováním
*:_T_R_L136
#                                                            ../orig/t.typ:379
D:jfj dkd lsl aůa dcd jmj ů-ů fbf juj
 :trn masa kilo hůrka lopata řeka pěšky
 :žili pán dítko stéblo řešeto had gloglo

#                                                            ../orig/t.typ:381
I:Zkusíme nějaká delší slova
*:_T_R_L137
#                                                            ../orig/t.typ:382
D:maličký kamera foton tričko, fosfát, hádě

#                                                            ../orig/t.typ:383
I:W píšeme prstem na S vychýleným nahoru.
*:_T_R_L138
#                                                            ../orig/t.typ:384
D:sss sws sss www sss sws sss

I:Nehýbejte ostatními prsty ze základní pozice.
*:_T_R_L139
#                                                            ../orig/t.typ:385
D:sss war sss who sss was sss

I:Čeština w moc nepoužívá, zato angličtina ano.
*:_T_R_L140
#                                                            ../orig/t.typ:387
D:sws who sws what sws when sws where sws
 :knowledge whatever Wimbledon know-it-all

I:Zkuste ještě tohle.
*:_T_R_L140A
#                                                            ../orig/t.typ:391
S:How much wood could a woodchuck chuck if a
 :woodchuck could chuck wood? A woodchuck
 :would chuck all the wood that a woodchuck
 :could chuck, if a woodchuck could chuck wood.

#                                                            ../orig/t.typ:392
I:Tvrdé Y píšeme J-prstem vychýleným vlevo nahoru.
*:_T_R_L141
#                                                            ../orig/t.typ:393
D:jjj jyj jjj yyy jjj jyj jjj

I: Nepleťte si Y a U! Y je více vlevo.
*:_T_R_L142
#                                                            ../orig/t.typ:396
D:jjj why jjj you jjj try jjj rye jjj
 :jjj ryk jjj šly jjj měly jjj daly jjj

#                                                            ../orig/t.typ:397
I:Zkuste si vaši rychlost:
*:_T_R_L143
#                                                            ../orig/t.typ:398
S:Vy dámy jste psaly pomalu.

#                                                            ../orig/t.typ:399
I:V mačkáme prstem na F.
*:_T_R_L144
#                                                            ../orig/t.typ:400
D:fff fvf fff vvv fff fvf fff

*:_T_R_L145
#                                                            ../orig/t.typ:401
D:fff vosa fff eva fff vow fff

*:_T_R_L146
#                                                            ../orig/t.typ:402
D:fvf voda fvf kovář fvf víno fvf válec fvf

*:_T_R_L147
#                                                            ../orig/t.typ:405
D:vodovod vřava převod návod
 :Víno je velmi dobré.
 :Však víte, že vám věřím?

*:_T_R_L148
#                                                            ../orig/t.typ:419
T:		         BACKSPACE
 :
 :Většina programů, které budete používat, vám dovolí opravovat
 :chyby s použitím kláves BACKSPACE a/nebo DELETE. Tyto klávesy
 :vám dovolí vymazat znak, který jste již jednou zadali. To je
 :jednou z největších výhod počítače nad klasickým psacím strojem.
 :
 :V průběhu drilových cvičení odmítám tyto klávesy akceptovat.
 :(Měli byste cvičit dokud se vám nepovede opsat text správně!)
 :Dovolím vám ale používat tyto klávesy v rychlostních testech.
 :Umažu sice bílé značky špatně zadaných písmen, ale stále je
 :budu do výsledků počítat jako chyby.
 :
 :Klávesu BACKSPACE stiskněte vaším ů-prstem a okamžitě vraťte
 :všechny prsty do základní pozice.
#                                                            ../orig/t.typ:420
I:Zkuste si vaši rychlost na těchto rýmech!
*:_T_R_L149
#                                                            ../orig/t.typ:424
S:Mary had a little lamb
 :Its fleece was white as snow
 :And every where that Mary went
 :The lamb was sure to go.

*:_T_R_L150
#                                                            ../orig/t.typ:426
S:Používání BACKSPACE je jednoduché a svádí k tomu,
 :abychom psali s chybami a naučili se je rychle opravovat.
 :To je velmi špatný zlozvyk.

*:_T_R_L151
#                                                            ../orig/t.typ:431
S:Jaké je dnes počasí?
 :Slunce putuje po jasně modré obloze.
 :A jaké má být počasí zítra?
 :Z tmavé oblohy mají padat trakaře.

*:_T_R_L152
#                                                            ../orig/t.typ:436
S:V jednom počítačovém časopise jsem četl o tom,
 :že je dobré naučit se používat myš levou
 :rukou, abychom měli pravou volnou k psaní na klávesnici.
 :To je nesmysl. Klidně si někdy vyzkoušejte, že psát
 :všemi pěti prsty pravé ruky je výrazně pomalejší a těžší,
 :než psát pouze dvěma ukazováčky obou rukou.
G:_T_E_T10
#------------------------------------------------------------------------------
# Lekce T11
#------------------------------------------------------------------------------
*:T11
*:_T_S_T11
#                                                            ../orig/t.typ:440
I:Nejprve opakování.
*:_T_R_L153
#                                                            ../orig/t.typ:441
D:aůa sls dkd fjf sws jyj fvf dcd jmj ů-ů
 :jýj fřf dčd kák sšs líl aěa ůéů jžh

#                                                            ../orig/t.typ:443
I:Všimněte si, že už nám zbývá pouze Q, X, Z a klávesa háčku!
*:_T_R_L154
#                                                            ../orig/t.typ:444
D:aábcčdeěéfghchiíjklmnoprřsštuúůvwy

#                                                            ../orig/t.typ:445
I:Q mačkáme vychýlením prstu na A nahoru.
*:_T_R_L155
#                                                            ../orig/t.typ:446
D:aaa aqa aaa qqq aaa aqa aaa

*:_T_R_L156
#                                                            ../orig/t.typ:450
D:aaa quit aaa quad aaa quip aaa
 :lacquer inquiry squirt quart
 :quail quiver inquest marquis

#
I:Klávesu mačkáme S-prstem vychýleným dolů.
*:_T_R_L157
#                                                            ../orig/t.typ:451
D:sss sxs sss xxx sss sxs sss

*:_T_R_L158
#                                                            ../orig/t.typ:455
D:sss ax sss ox sss vex sss wax xxx
 :examine ex-wife excellent boxer sixteen
 :exactly sphinx oxygen except thorax

#
I:Prstem A mačkáme klávesu Z.
*:_T_R_L159
#                                                            ../orig/t.typ:456
D:aaa aza aaa zzz aaa aza aaa

*:_T_R_L160
#                                                            ../orig/t.typ:459
D:aaa adz aaa azo aaa coz aaa
 :quiz jazz quartz zinc dozen
 :oxidize squeeze azimuth zoology

T:Blížíme se do finále.
 :Jistě jste si všimli, že ó nemá vlastní klávesu.
 :Musíme jej proto skládat ze stisku klávesy prodloužení a poté
 :daného písmene. Nejedná se o stejný princip jako s klávesou
 :SHIFT. Prodloužení nemusíme/nesmíme držet celou dobu, ale zmáčkneme
 :jej první, vrátíme prsty do základní pozice a poté zmáčkneme
 :o.
 :
 :Prodloužení píšeme vychýlením pravého malíčku prudce doprava nahoru.
 :
 :Pro napsání ó tedy vychýlíme pravý malíček doprava nahoru
 :a stiskneme klávesu s háčkem.
*:_T_R_L161
#                                                            ../orig/t.typ:459
D:ůůů ó ó ó ů ó ů ó aó só dó
 :mód dóza gól hůl král móda próza


T:Obdobně píšeme i ď, ň a ť. Klávesa měkčení je ale až nad
 :klávesou prodlužování a proto musíme navíc ještě zmáčknout
 :SHIFT.
 :
 :Pro napsání š tedy stiskneme levý SHIFT a držíme. Pravý malíček
 :vychýlíme na klávesu prodlužování a stiskneme. Vrátíme všechny
 :prsty do základní pozice. Stiskneme klávesu S.
*:_T_R_L162
#                                                            ../orig/t.typ:456
D:ůůů aaa aůťůa aůňůa aůďůa
 :ď ť ň š ň č ž ě ť ň ě ů ú ď

#                                                            ../orig/t.typ:460
I:Pozor, dnes je velký den!
*:_T_R_L163
#                                                            ../orig/t.typ:461
D:aábcčdďeéěfghiíjklmnňoópqrřsštťuúůvwxyýzž

*:_T_R_L164
#                                                            ../orig/t.typ:463
D:žzýyxwvůúuťtšsřrqpóoňnmlkjíihgfěéedcba

#
I:Zkusíme si nějaké věty.
*:_T_R_L165
#                                                            ../orig/t.typ:464
D:Určitě teď děláte chyby, každý jsme dělali chyby,
 :ale to se brzy zlepší, uvidíte.

I:Nepropadejte panice, odteď to již bude snadné.
*:_T_R_L166
#                                                            ../orig/t.typ:465
D:Za pár lekcí již budu umět psát velmi dobře a rychle,
 :nejhorší již mám za sebou.

*:_T_R_L167
#                                                            ../orig/t.typ:466
D:V českém počítačovém slangu se používá slovo squělý.
 :Tedy: jde mi to squěle.

*:_T_R_L168
#                                                            ../orig/t.typ:467
D:Písmena jako x, q a w se v češtině moc nepoužívají.

*:_T_R_L169
#                                                            ../orig/t.typ:469
D:V našem jazyce je ale velmi složitá diakritika.
 :Třeba napsat velké diakritické písmeno není legrace.

#                                                            ../orig/t.typ:470
T:Pro napsání velkého diakritického písmena musíme použít
 :pomocné diakritické klávesy. Nejprve stiskneme klávesu
 :měkčení či prodloužení a poté se SHIFTem dané písmeno.
*:_T_R_L170
#                                                            ../orig/t.typ:471
D:Že to není tak snadné, o tom se mohli přesvědčit již mnozí.
 :Ále, nebudeme naříkat, již jsme zvládli i těžší věci.

#                                                            ../orig/t.typ:472
I:Cvičíme dál.
*:_T_R_L171
#                                                            ../orig/t.typ:473
D:Špičkový atlet se zúčastnil letních olympijských her.

#                                                            ../orig/t.typ:474
I:Zkusíme si nyní rychlostní cvičení, co říkáte:
*:_T_R_L172
#                                                            ../orig/t.typ:475
S:Špičkový atlet se zúčastnil letních olympijských her.

#                                                            ../orig/t.typ:476
I:Znovu.
*:_T_R_L173
#                                                            ../orig/t.typ:477
S:Špičkový atlet se zúčastnil letních olympijských her.

G:_T_E_T11
#------------------------------------------------------------------------------
# Lekce T11
#------------------------------------------------------------------------------
*:T12
*:_T_S_T12
#                                                            ../orig/t.typ:481
I:Než začneme pracovat s čísly, procvičíme si celou abecedu.
*:_T_R_L174
#                                                            ../orig/t.typ:482
D:abcd efg hijk lmnop qrs tuv wx yz
 :čďšřžýíťéá

#                                                            ../orig/t.typ:484
I:Přidáme velká písmena
*:_T_R_L175
#                                                            ../orig/t.typ:485
D:abcdefghijklmnopqrstuvwxyz
 :Ť Á Č Ž Ý Ř É Ú Ě Ň Ď
#                                                            ../orig/t.typ:486
I:Použijte pro každé písmeno SHIFT. Nepoužívejte CAPS-LOCK!
*:_T_R_L176
#                                                            ../orig/t.typ:487
D:ABCDEFGHIJKLMNOPQRSTUVWXYZ

#                                                            ../orig/t.typ:488
I:Procvičíme i interpunkční znaménka, která zatím známe.
*:_T_R_L177
#                                                            ../orig/t.typ:489
D:l.l l:l k,k l.l ů/ů .?. -?, ů-,

*:_T_R_L178
#                                                            ../orig/t.typ:509
T:
 :			NUMERICKÉ KLÁVESY
 :
 :Klávesnice má 2 sady numerických kláves. Jedna z nich se
 :nalézá přímo nad písmeny a ta je standardizovaná pro všechny
 :klávesnice psacích strojů. Druhá, která napodobuje klávesnici
 :kalkulačky, je po vaší pravici. V těchto lekcích nás budou zajímat
 :pouze standardní numerické klávesy na hlavní klávesnici.
 :(Pokud byste se chtěli naučit používat numerickou klávesnici,
 :projděte si radši sérii lekcí N)
 :
 :Poznámka: ne všechny klávesnice mají numerické klávesy
 :v odděleném bloku.
 :
 :Některé klávesnice nemají číslo 1. V takovém případě musíte použít
 :klávesu L. Kdykoliv ale můžete napsat korektní 1 jako číslo,
 :nikdy jej nepište jako písmeno L!
 :
 :V české klávesnici jsou umístěny čísla nad diakritickými znaky.
 :Budete tedy k jejich napsání muset používat SHIFT. To je také
 :důvod, proč nemůžeme velká diakritická písmena psát stiskem dané
 :klávesy se SHIFTem, ale musíme používat opisný postup.

#                                                            ../orig/t.typ:510
I:Vy téměř určitě jedničku máte. Stiskněte ji A-prstem. ů-prst drží SHIFT.
*:_T_R_L179
#                                                            ../orig/t.typ:511
D:aaa a1a aaa 111 aaa a1a

*:_T_R_L180
#                                                            ../orig/t.typ:514
D:a1q qa1 qz1 az1 aq1 a1z
 :111 ano 111 jakost 111 ahoj 111
 :Když 11 mužů chytí každý po 11 rybách v průběhu 11 dnů,
 :Kolik ryb chytili celkem? 11.

#                                                            ../orig/t.typ:515
I:2ku píšeme opět prstem z A. ů-prstem opět mačkáme pravý SHIFT.
*:_T_R_L181
#                                                            ../orig/t.typ:516
D:sss s2s sss s2s sss s2s

I:Nezapomínejte, že se musí všechny prsty vracet do původní pozice.
*:_T_R_L182
#                                                            ../orig/t.typ:520
D:sss s2w sss 2xw sss w2x sss
 :222 saw 222 was 222 wet 222
 :The 2 men were 2 late 2 catch the 2 PM train.

#
I:3ku mačkáme prstem z S. Samozřejmě opět s pravým SHIFTem.
*:_T_R_L183
#                                                            ../orig/t.typ:521
D:ddd d3d ddd d3d ddd d3d ddd

*:_T_R_L184
#                                                            ../orig/t.typ:524
D:ddd d3e ddd d3c ddd e3c ddd
 :333 dan 333 koček 333 kolik 333
 :1 plus 2 je 3. 11 plus 22 je 33. 111 plus 222 je 333.

#                                                            ../orig/t.typ:525
I:Poslední, co budeme dnes procvičovat, je číslo 4. (Použijte D-prst.)
*:_T_R_L185
#                                                            ../orig/t.typ:526
D:fff f4f fff f4f fff f4f

*:_T_R_L186
#                                                            ../orig/t.typ:531
D:fff f4r fff 4vr fff 4vr fff
 :444 pro fff krysa 444 test 444
 :Let 423 odlétá od brány 42 ve 4:24.
 :Jak řekli 3 mušketýři: 1 za všechny a všichni za 1.
 :Když 1/4 plus 2/3 je 11/12, kolik je 1/2 plus 1/3?

#                                                            ../orig/t.typ:532
I:Zkuste si vaši rychlost na této řádce:
*:_T_R_L197
#                                                            ../orig/t.typ:533
S:Náš tým vyhrál 1., 2. a 3. místo na 12. každoročním srazu.

#                                                            ../orig/t.typ:535
I:Již jsme říkali, že některé klávesnice nemají číslo 1. Pojďme
 :si nacvičit používání klávesy L, abyste mohli používat i jakýkoliv
 :typ psacího stroje.
*:_T_R_L188
#                                                            ../orig/t.typ:536
D:Tucet je l2. Veletucet je l2 tuctů, neboli l44.

*:_T_R_L189
#                                                            ../orig/t.typ:538
D:Jak v osmičkové tak desítkové soustavě je ll krát ll l2l.
 :A 3 mínus 4 je -l. V osmičkové, je ale l2 dělitelné 3.

G:_T_E_T12
#------------------------------------------------------------------------------
# Lekce T13
#------------------------------------------------------------------------------
*:T13
*:_T_S_T13
#                                                            ../orig/t.typ:542
I:Zopakujeme si čísla, která již umíme.
*:_T_R_L190
#                                                            ../orig/t.typ:543
D:a1a s2s d3d f4f 234 413

*:_T_R_L191
#                                                            ../orig/t.typ:544
D:f4r d3e s2w a1q az1 sx2 dc3 fv4

#                                                            ../orig/t.typ:546
I:7 píšeme prstem z J za současného stisku levého SHIFTu.
*:_T_R_L192
#                                                            ../orig/t.typ:547
D:jjj j7j jjj j7j jjj j7j jjj

*:_T_R_L193
#                                                            ../orig/t.typ:551
D:jjj j7u jjj 7um jjj u7m jjj
 :777 mapa 777 jug 777 rum 777
 :Je let 377 na Floridu stroj typu 707, 727 nebo 747?
 :Je to 727 a má 4 zastávky. Se všemi těmi zastávkami to zabere
 :skoro 7 hodin.

#                                                            ../orig/t.typ:552
I:8ku píšeme opět prstem z klávesy J.
*:_T_R_L194
#                                                            ../orig/t.typ:553
D:kkk k8k kkk k8k kkk k8k kkk

*:_T_R_L195
#                                                            ../orig/t.typ:557
D:kkk k8i kkk 8,i kkk ,i8 kkk
 :888 kus 888 mák 888 tikat 888
 :Agent 88 měl dorazit v 8:14. Má 38 minut zpoždění.
 :Její tým měl mít na starost zónu 8 kvadrantu 828.
 :Pošli 8 dalších agentů.

#                                                            ../orig/t.typ:558
I:9ku píšeme prstem z K.
*:_T_R_L196
#                                                            ../orig/t.typ:559
D:lll l9l lll l9l lll l9l lll

*:_T_R_L197A
#                                                            ../orig/t.typ:563
D:lll 9.o lll o9. lll l9. lll
 :999 Jr. 999 log 999 oko 999
 :99 lahví piva na stole, 99 lahví vína na druhém stole.
 :Když vedle sebe napíšeme čísla 9 a 9, dostaneme 99.

#                                                            ../orig/t.typ:564
I:Číslo 0 píšeme prstem na L. Nikdy nezaměňujte nulu s písmenem o.
*:_T_R_L198
#                                                            ../orig/t.typ:565
D:ůůů ů0ů ůůů ů0ů ůůů ů0ů ůůů

I:Používáte doufám levý SHIFT.
*:_T_R_L199
#                                                            ../orig/t.typ:570
D:ůůů ů0p ůůů /0p ůůů 0/p ůůů
 :000 a/c 000 pup 000 já? 000
 :Pánové: Schůzka v 10:00 10 října byla odložena na 10:30.
 :Schůzka v 10:30 byla přesunuta na 11:00 do místnosti 302.
 :Místnost 302 pojme ale pouze 10 lidí. Budeme potřebovat
 :konferenční sál 20.

#                                                            ../orig/t.typ:571
I:Zkusíme si nějaké odstavce.
*:_T_R_L200
#                                                            ../orig/t.typ:580
S:Zda-li víte, že o čísle 0 existuje několik celých knih.
 :Stejně tak o čísle 1. Obě jsou něčím zvláštní a jaksi
 :důležitější než ostatní čísla. Existují i soustavy,
 :kde jsou 1 a 0 vším, třeba 2-ková soustava. Mimo
 :to se ale využívají i soustavy se základem 8,
 :16 nebo dokonce 60.

*:_T_R_L201
#                                                            ../orig/t.typ:587
S:Není snadné odhadnout, kolik peněz jsme mohli
 :transakcí z 14.8. ztratit. Ten den v 13:00
 :se pokazilo snad skoro všechno. Bylo to sotva
 :2 hodiny po uzavření obchodu a již se ukázalo,
 :že konkurence o všem věděla dopředu a teď nás
 :utopí. Akcie okamžitě klesly na 2800 bodů.
 :To je propad o více jak 37 procent.

G:_T_E_T13
#------------------------------------------------------------------------------
# Lekce T14
#------------------------------------------------------------------------------
*:T14
*:_T_S_T14
#                                                            ../orig/t.typ:591
I:Zopakujeme si čísla, která jsme se již naučili.
*:_T_R_L202
#                                                            ../orig/t.typ:592
D:j7j f4f k8k d3d l9l s2s ů0ů a1a

*:_T_R_L203
#                                                            ../orig/t.typ:593
D:4f4 7j7 3d3 8k8 2s2 9l9 1a1 0ů0

#                                                            ../orig/t.typ:595
I:5ku píšeme prstem z F. SHIFT mačkáme vpravo.
*:_T_R_L204
#                                                            ../orig/t.typ:596
D:fff f5f fff 555 fff f5f fff

*:_T_R_L205
#                                                            ../orig/t.typ:599
D:f5f f54 f5f t5g f5f t5r f5f
 :f5f fór f5f dva f5f baf f5f
 :f5f 453 f5f 585 f5f 475 f5f

I:Nezapomínejte na pravý SHIFT.
*:_T_R_L206
#                                                            ../orig/t.typ:600
S:5 z nás neslo ty 20ti kilové ruksaky celých 45 kilometrů.

#                                                            ../orig/t.typ:601
I:Prstem z F píšeme i 6ku. Používáme levý SHIFT.
*:_T_R_L207
#                                                            ../orig/t.typ:602
D:jjj j6j jjj 666 jjj j6j jjj

I:Již z písmena ž víme, že toto je úplně nejdelší přehmat na klávesnici.
 :Teď k němu ještě druhou rukou mačkáme SHIFT. Dejte si záležet.
*:_T_R_L208
#                                                            ../orig/t.typ:605
D:j6j január j6j mnoho j6j hum j6j
 :j6j y6n j6j u6m j6j h76 j6j
 :j6j 4567 j6j 7654 j6j 6754 j6j

#                                                            ../orig/t.typ:606
I:Otevírací závorku píšeme ů-prstem vychýleným hodně vlevo za stisku
 :levého SHIFTu.
*:_T_R_L209
#                                                            ../orig/t.typ:607
D:ů(ů ů(ů ůů (( ůů (( ů(ů (ů(

*:_T_R_L210
#                                                            ../orig/t.typ:608
D:ů(ů ů.l ů(ů ú(p ů(ů

*:_T_R_L211
#                                                            ../orig/t.typ:609
D:ů(ů lopuch ů(ů olej ů(ů jenom ů(ů

#                                                            ../orig/t.typ:610
I:Uzavírací závorku píšeme tím samým způsobem, ale bez SHIFTu.
*:_T_R_L212
#                                                            ../orig/t.typ:611
D:ůůů ů)ů ůůů ů)ů ůůů ů)ů

*:_T_R_L213
#                                                            ../orig/t.typ:613
D:ůůů (.) úúú (.) ůůů (,) úúú
 :ů)ů pů ů)ů úl ů)ů stůl ů)ů

*:_T_R_L214
#                                                            ../orig/t.typ:614
D:Vy (kupující) byste se ho (prodávajícího) měl zeptat na cenu (zboží).

*:_T_R_L215
#                                                            ../orig/t.typ:615
D:Když (X-5) / (X-6) je 56, tak kolik je (X/5) - (X/6)?

*:_T_R_L216
#                                                            ../orig/t.typ:616
D:1 2 3 4 5 6 7 8 9 10

#                                                            ../orig/t.typ:617
I:Zkuste si rychlost na této anglické písničce.
*:_T_R_L217
#                                                            ../orig/t.typ:621
S:1 little, 2 little, 3 little Indians,
 :4 little, 5 little, 6 little Indians,
 :7 little, 8 little, 9 little Indians,
 :10 little Indian boys.

I:Co nejrychleji (ale bez chyb) přepište tento odstavec.
*:_T_R_L218
#                                                            ../orig/t.typ:625
S:Jestli chceme chytit let v 6:15 do Phoenixu (ten co letí
 :non-stop), budeme muset odejít nejpozději v 5:00 (vyhneme
 :se dopravní špičce). Jinak budeme muset letět tím v 6:15,
 :(ale ten má dvě zastávky).

#                                                            ../orig/t.typ:626
I:Používejte klávesy hlavní klávesnice! Nepodvádějte na numerické klávesnici.
#                                                            ../orig/t.typ:627
*:_T_R_L219
#                                                            ../orig/t.typ:628
D:423 475 925 235 295 175 650

*:_T_R_L220
#                                                            ../orig/t.typ:630
D:598 693 602 672 315 604 587 307

*:_T_R_L221
#                                                            ../orig/t.typ:631
D:12,00 67,50 99,95 38,75 19,99

#                                                            ../orig/t.typ:632
I:Zkuste si rychlost.
*:_T_R_L222
#                                                            ../orig/t.typ:633
S:353 648 604 592 468 501 296

*:_T_R_L223
#                                                            ../orig/t.typ:641
S:3574
 :1937
 :2586
 :1904
 :1837
 :9003
 :7283
 :6745

G:_T_E_T14
#------------------------------------------------------------------------------
# Lekce T15
#------------------------------------------------------------------------------
*:T15
*:_T_S_T15
*:_T_R_L224
#                                                            ../orig/t.typ:657
T:
 :Pokud jste již prošli lekcemi od T1 do T14, můžete o sobě
 :prohlašovat, že umíte psát všemi deseti prsty. Naučili jste se
 :totiž psát již všechny standardizované klávesy. Pokud chcete,
 :můžete nyní začít s lekcemi ze série S, zaměřenými na rychlost.
 :(Když se setkáte s nějakým interpunkčním znaménkem, které
 :jste se ještě neučili, prostě se podívejte.)
 :
 :Ve zbylých lekcích se podíváme na další znaménka.

G:_T_E_T15
#------------------------------------------------------------------------------
# Lekce T16
#------------------------------------------------------------------------------
*:T16
*:_T_S_T16
#                                                            ../orig/t.typ:661
I:Vykřičník píšeme vychýlením ů-prstu doprava za stisku levého SHIFTu.
*:_T_R_L225
#                                                            ../orig/t.typ:675
D:ůůů ů!ů ůůů !!! ůůů ů!ů ůůů

*:_T_R_L226
#                                                            ../orig/t.typ:676
D:ů!ů Ah! ů!ů Co! ů!ů Ach! ů!ů

#                                                            ../orig/t.typ:677
I:Za vykřičníkem následuje vždy mezera.
*:_T_R_L227
#                                                            ../orig/t.typ:678
D:Toť otázka! Co když nás chytí? Zavřou nás!

*:_T_R_L228
#                                                            ../orig/t.typ:679
D:Nikdy by to neudělal! Nevěřil bych mu ani slovo.

T:
 :V této lekci si procvičíme ještě některé speciální symboly.
 :
 :[V české verzi tutoriálu jsem tuto sekci výrazně zredukoval,
 :protože v našem jazyce bohužel poloha těchto kláves není
 :vůbec standardizovaná. Budete se muset naučit sami na vaše
 :rozložení kláves.]

#                                                            ../orig/t.typ:690
I:Rovnítko píšeme vychýlením prstu z ů nahoru.
*:_T_R_L229
#                                                            ../orig/t.typ:691
D:ůůů ů=ů ůůů ů=ů ůůů ů=ů ůůů

*:_T_R_L230
#                                                            ../orig/t.typ:693
D:ů=ů -=- ů=ů ?=? ů=ů :=: ů=ů
 :ů=ů X=2 ů=ů Y=3 ů=ů Z=0 ů=ů

#                                                            ../orig/t.typ:702
I:Znak % píšeme vychýlením ů-prstu nahoru se stiskem levého SHIFTU.
*:_T_R_L231
#                                                            ../orig/t.typ:703
D:ůůů ů%ů ůůů ů%ů ůůů ů%ů ůůů

*:_T_R_L232
#                                                            ../orig/t.typ:705
D:89% 93% 27% 03% 12% 62% 15%
 :85% z 200 jablek = 170 jablek

*:_T_R_L233
#                                                            ../orig/t.typ:801
T:				Závěr
 :
 :Nyní jste dokončili sérii lekcí T. Pokud jste to ještě neudělali,
 :měli byste začít lekce N nebo S.
 :
 :Ještě stále zůstává několik kláves, které jsme se neučili. Pokud
 :se rozhodnete psát tyto klávesy s použitím všech deseti prstů,
 :použijte vždy ten nejbližší. Pro ESC, TAB, CAPS LOCK tedy používejte
 :A-prst. Klávesy na pravé straně jako BACKSPACE, DELETE, ENTER a další
 :byste zase měli psát s použitím prstu na ů. Horní klávesy jako je
 :F1, F2 atd. se většinou tímto způsobem nepíší, protože jsou příliš
 :daleko. Pokud tam dosáhnete, super.


G:_T_E_T16
#------------------------------------------------------------------------------
# Lekce series T jump tables
#------------------------------------------------------------------------------
*:_T_E_T1
Q:Chcete pokračovat do lekce T2 [Y(ano)/N(ne)] ?
N:_T_MENU
G:_T_M_T2
*:_T_E_T2
Q:Chcete pokračovat do lekce T3 [Y(ano)/N(ne)] ?
N:_T_MENU
G:_T_M_T3
*:_T_E_T3
Q:Chcete pokračovat do lekce T4 [Y(ano)/N(ne)] ?
N:_T_MENU
G:_T_M_T4
*:_T_E_T4
Q:Chcete pokračovat do lekce T5 [Y(ano)/N(ne)] ?
N:_T_MENU
G:_T_M_T5
*:_T_E_T5
Q:Chcete pokračovat do lekce T6 [Y(ano)/N(ne)] ?
N:_T_MENU
G:_T_M_T6
*:_T_E_T6
Q:Chcete pokračovat do lekce T7 [Y(ano)/N(ne)] ?
N:_T_MENU
G:_T_M_T7
*:_T_E_T7
Q:Chcete pokračovat do lekce T8 [Y(ano)/N(ne)] ?
N:_T_MENU
G:_T_M_T8
*:_T_E_T8
Q:Chcete pokračovat do lekce T9 [Y(ano)/N(ne)] ?
N:_T_MENU
G:_T_M_T9
*:_T_E_T9
Q:Chcete pokračovat do lekce T10 [Y(ano)/N(ne)] ?
N:_T_MENU
G:_T_M_T10
*:_T_E_T10
Q:Chcete pokračovat do lekce T11 [Y(ano)/N(ne)] ?
N:_T_MENU
G:_T_M_T11
*:_T_E_T11
Q:Chcete pokračovat do lekce T12 [Y(ano)/N(ne)] ?
N:_T_MENU
G:_T_M_T12
*:_T_E_T12
Q:Chcete pokračovat do lekce T13 [Y(ano)/N(ne)] ?
N:_T_MENU
G:_T_M_T13
*:_T_E_T13
Q:Chcete pokračovat do lekce T14 [Y(ano)/N(ne)] ?
N:_T_MENU
G:_T_M_T14
*:_T_E_T14
Q:Chcete pokračovat do lekce T15 [Y(ano)/N(ne)] ?
N:_T_MENU
G:_T_M_T15
*:_T_E_T15
Q:Chcete pokračovat do lekce T16 [Y(ano)/N(ne)] ?
N:_T_MENU
G:_T_M_T16
*:_T_E_T16
G:_T_MENU

*:_T_M_T1
B:                            Lekce T1
G:_T_S_T1
*:_T_M_T2
B:                            Lekce T2
G:_T_S_T2
*:_T_M_T3
B:                            Lekce T3
G:_T_S_T3
*:_T_M_T4
B:                            Lekce T4
G:_T_S_T4
*:_T_M_T5
B:                            Lekce T5
G:_T_S_T5
*:_T_M_T6
B:                            Lekce T6
G:_T_S_T6
*:_T_M_T7
B:                            Lekce T7
G:_T_S_T7
*:_T_M_T8
B:                            Lekce T8
G:_T_S_T8
*:_T_M_T9
B:                            Lekce T9
G:_T_S_T9
*:_T_M_T10
B:                           Lekce T10
G:_T_S_T10
*:_T_M_T11
B:                           Lekce T11
G:_T_S_T11
*:_T_M_T12
B:                           Lekce T12
G:_T_S_T12
*:_T_M_T13
B:                           Lekce T13
G:_T_S_T13
*:_T_M_T14
B:                           Lekce T14
G:_T_S_T14
*:_T_M_T15
B:                           Lekce T15
G:_T_S_T15
*:_T_M_T16
B:                           Lekce T16
G:_T_S_T16
#------------------------------------------------------------------------------
# Lekce series T menu
#------------------------------------------------------------------------------
*:_T_MENU
M: UP=__SERIESMENU "Série T obsahuje těchto 16 lekcí"
 :_T_M_T1  "Lekce T1     a s d f g h j k l ;"
 :_T_M_T2  "Lekce T2     e g h ,"
 :_T_M_T3  "Lekce T3     i r . shift"
 :_T_M_T4  "Lekce T4     o p shift ?"
 :_T_M_T5  "Lekce T5     t n :"
 :_T_M_T6  "Lekce T6     b u /"
 :_T_M_T7  "Lekce T7     c m -"
 :_T_M_T8  "Lekce T8     w y v backspace"
 :_T_M_T9  "Lekce T9     q x z"
 :_T_M_T10 "Lekce T10    1 2 3 4"
 :_T_M_T11 "Lekce T11    7 8 9 0"
 :_T_M_T12 "Lekce T12    5 6 ( )"
 :_T_M_T13 "Lekce T13"
 :_T_M_T14 "Lekce T14    ' " !"
 :_T_M_T15 "Lekce T15    = * + > < ^"
 :_T_M_T16 "Lekce T16    @ # $ % &"
*:_T_EXIT

#------------------------------------------------------------------------------
# End of file t.typ
G:__SERIESMENU
#==============================================================================
#==============================================================================
*:__S_V_SERIES
# Start of file v.typ
# Typist v2.2 - improved typing tutor program for UNIX systems
# Copyright (C) 1998 Simon Baldwin (simonb@sco.com)
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

#------------------------------------------------------------------------------
# Series V
#------------------------------------------------------------------------------
G:_V_MENU
*:_V_NO_MENU
#------------------------------------------------------------------------------
# Lekce V1
#------------------------------------------------------------------------------
*:V1
*:_V_S_V1
*:_V_R_L0
#                                                              ../orig/v.typ:2
T:			Lekce	V1

#                                                              ../orig/v.typ:3
I:(1)
*:_V_R_L1
#                                                              ../orig/v.typ:5
D:r r r r frf frf frf u u u u juj juj juj juj
 :frf juj frf juj frf juj frf juj frf juj frf juj

#                                                              ../orig/v.typ:6
I:(2)
*:_V_R_L2
#                                                             ../orig/v.typ:14
D:fff jjj fff jjj fff jjj fff jjj fff jjj fff jjj
 :fff jjj fff jjj fff jjj fff jjj fff jjj fff jjj
 :
 :fru fru fru jur jur jur ruj ruj ruj urf urf urf
 :fru fru fru ruf ruf ruf urj urj urj fuj fuj fuj
 :
 :urf urf urf juf juf juf fuj fuj fuj fru fru fru
 :fur fur fur ruf ruf ruf urf urf urf jur jur jur

G:_V_E_V1
#------------------------------------------------------------------------------
# Lekce V2
#------------------------------------------------------------------------------
*:V2
*:_V_S_V2
*:_V_R_L3
#                                                             ../orig/v.typ:19
T:
 :		      (D K E I)

#                                                             ../orig/v.typ:20
I:(1) Warmup
*:_V_R_L4
#                                                             ../orig/v.typ:25
D:fff jjj fff jjj fff jjj fff jjj fff jjj fff jjj
 :frf juj frf juj frf juj frf juj frf juj frf juj
 :
 :fur fur fur ruf ruf ruf jur jur jur ruj ruj ruj
 :urj urj urj juf juf juf fuj fuj fuj fur fur fur

#                                                             ../orig/v.typ:26
I:(2) New Key Control
*:_V_R_L5
#                                                             ../orig/v.typ:28
D:d d d d ddd ddd ddd ddd k k k k kkk kkk kkk kkk
 :ddd kkk ddd kkk ddd kkk ddd kkk ddd kkk ddd kkk

#                                                             ../orig/v.typ:29
I:(3)
*:_V_R_L6
#                                                             ../orig/v.typ:31
D:e e e e ded ded ded ded ded i i i i kik kik kik
 :ded kik ded kik ded kik ded kik ded kik ded kik
Q:Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - exit.
N:_V_R_L6

#                                                             ../orig/v.typ:32
I:(4)
*:_V_R_L7
#                                                             ../orig/v.typ:37
D:did did did ire ire ire rid rid rid eke eke eke
 :rid rid rid eke eke eke ire ire ire did did did
 :
 :dik dik dik ef ef ef dar dar dar rak rak rak
 :fal fal fal sak sak sak fee fee fee dik dik dik

#                                                             ../orig/v.typ:38
I:(5)
*:_V_R_L8
#                                                             ../orig/v.typ:43
D:free free free juke juke juke fire fire fire juke
 :fire fire fire juke juke juke free free free juke
 :
 :deer deer deer rude rude rude dire dire dire ride
 :rude rude rude dire dire dire deer deer deer ride

#                                                             ../orig/v.typ:44
I:(6)
*:_V_R_L9
#                                                             ../orig/v.typ:49
D:fired fired fired rider rider rider freed freed
 :rider rider rider freed freed freed fired fired
 :
 :did red ire fee rid deer rude fire feed juke rider
 :rid fee ire red did juke fire rude juke deed freed

G:_V_E_V2
#------------------------------------------------------------------------------
# Lekce V3
#------------------------------------------------------------------------------
*:V3
*:_V_S_V3
*:_V_R_L10
#                                                             ../orig/v.typ:54
T:
 :			    (T Y G H)

#                                                             ../orig/v.typ:55
I:(1) Warmup
*:_V_R_L11
#                                                             ../orig/v.typ:60
D:fff jjj ddd kkk frf juj ded kik fff jjj ddd kkk
 :frf juj ded kik fur fur kid kid red red ire ire
 :
 :kid kid kid juke juke juke dire dire dire fire
 :rid rid rid rude rude rude ride ride ride feed

*:_V_R_L12
#                                                             ../orig/v.typ:63
D:
 :did red ire fee rid deer rude fire feed juke rider
 :rid fee ire red did juke fire rude juke deed freed

#                                                             ../orig/v.typ:64
I:(2) T and Y
*:_V_R_L13
#                                                             ../orig/v.typ:66
D:t t t t ftf ftf ftf ftf y y y y jyj jyj jyj jyj
 :ftf jyj ftf jyj ftf jyj ftf jyj ftf jyj ftf jyj

#                                                             ../orig/v.typ:67
I:(3) G and H
*:_V_R_L14
#                                                             ../orig/v.typ:69
D:g g g g fgf fgf fgf fgf h h h h jhj jhj jhj jhj
 :fgf jhj fgf jhj fgf jhj fgf jhj fgf jhj fgf jhj

#                                                             ../orig/v.typ:70
I:(4) Word Drill
*:_V_R_L15
#                                                             ../orig/v.typ:72
D:hit hit hit hit hit hit get get get get get get
 :yet yet yet yet yet yet try try try try try try

#                                                             ../orig/v.typ:73
I:(5)
*:_V_R_L16
#                                                             ../orig/v.typ:78
D:the the the try try try get get get yet yet yet
 :try try try the the the yet yet yet get get get
 :
 :key key key jit hit hit tie tie tie kit kit kit
 :tie tie tie kit kit kit key key key hit hit hit

#                                                             ../orig/v.typ:79
I:(6)
*:_V_R_L17
#                                                             ../orig/v.typ:84
D:here here here they they they true true true
 :they they they true true true here here here
 :
 :there there there fruit fruit fruit right right right
 :fruit fruit fruit right right right there there there

#                                                             ../orig/v.typ:85
I:(7)
*:_V_R_L18
#                                                             ../orig/v.typ:90
D:third third third tired tired tired urged urged urged
 :tired tired tired urged urged urged third third third
 :
 :truth truth truth their their their dried dried dried
 :their their their dried dried dried truth truth truth

#                                                             ../orig/v.typ:91
I:(8)
*:_V_R_L19
#                                                             ../orig/v.typ:93
D:did they get the right dried fruit there yet
 :did they get the right dried fruit there yet

G:_V_E_V3
#------------------------------------------------------------------------------
# Lekce V4
#------------------------------------------------------------------------------
*:V4
*:_V_S_V4
*:_V_R_L20
#                                                             ../orig/v.typ:98
T:
 :			(S L W O)

#                                                             ../orig/v.typ:99
I:(1) Warmup
*:_V_R_L21
#                                                            ../orig/v.typ:101
D:frf juj ded kik ftf jyj fgf jhj frf juj ded kik
 :ded kik ftf jyj fgf jhj frf juj ded kik ftf jyj

#                                                            ../orig/v.typ:102
I:(2) S and L
*:_V_R_L22
#                                                            ../orig/v.typ:104
D:s s s s sss sss sss sss l l l l lll lll lll lll
 :sss lll sss lll sss lll sss lll sss lll sss lll

#                                                            ../orig/v.typ:105
I:(3) W and O
*:_V_R_L23
#                                                            ../orig/v.typ:107
D:w w w w sws sws sws sws o o o o lol lol lol lol
 :sws lol sws lol sws lol sws lol sws lol sws lol

#                                                            ../orig/v.typ:108
I:(4) Words Drill
*:_V_R_L24
#                                                            ../orig/v.typ:110
D:sow sow sow sow sow sow low low low low low low
 :row row row row row row how how how how how how

#                                                            ../orig/v.typ:111
I:(5)
*:_V_R_L25
#                                                            ../orig/v.typ:116
D:is is is so so so of of of do do do go go go to to to
 :go go go to to to do do do of of of so so so is is is
 :
 :too too too low low low set set set wit wit wit wit
 :sit sit sit lit lit lit wit wit wit low low low low

#                                                            ../orig/v.typ:117
I:(6)
*:_V_R_L26
#                                                            ../orig/v.typ:125
D:wool wool wool suit suit suit full full full wood wood
 :hole hole hole wool wool wool suit suit suit good good
 :
 :style style style order order order those those
 :loose loose loose style style style order order
 :
 :desire desire desire rulers rulers rulers worker
 :worker worker worker desire desire desire rulers

#                                                            ../orig/v.typ:126
I:(7)
*:_V_R_L27
#                                                            ../orig/v.typ:131
D:hold your wrists low while you strike the keys
 :we desire the right goods for our wool suits
 :if you will go with us you will see the fleet
 :we will try to fill your order for the wool suits
 :if we get the right goods we will fill your order

G:_V_E_V4
#------------------------------------------------------------------------------
# Lekce V5
#------------------------------------------------------------------------------
*:V5
*:_V_S_V5
*:_V_R_L28
#                                                            ../orig/v.typ:136
T:
 :		       (A ; Q P)

#                                                            ../orig/v.typ:137
I:(1) Warmup
*:_V_R_L29
#                                                            ../orig/v.typ:139
D:frf juj ded kik ftf jyj fgf jhj frf juj ftf jyj fgf jhj
 :ded kik sws lol ded kik sws lol frf juj ftf jyj fgf jhj

#                                                            ../orig/v.typ:140
I:(2) A and ;
*:_V_R_L30
#                                                            ../orig/v.typ:142
D:a a a a aaa aaa aaa aaa ; ; ; ; ;;; ;;; ;;; ;;;
 :aaa ;;; aaa ;;; aaa ;;; aaa ;;; aaa ;;; aaa ;;;

#                                                            ../orig/v.typ:143
I:(3) Q and P
*:_V_R_L31
#                                                            ../orig/v.typ:145
D:q q q q aqa aqa aqa aqa p p p p ;p; ;p; ;p; ;p;
 :aqa ;p; aqa ;p; aqa ;p; aqa ;p; aqa ;p; aqa ;p;

#                                                            ../orig/v.typ:146
I:(4) Word Drill
*:_V_R_L32
#                                                            ../orig/v.typ:148
D:pa; pa; pa; pa; pa; pa; up; up; up; up; up; up;
 :pa; pa; pa; pa; pa; pa; up; up; up; up; up; up;

#                                                            ../orig/v.typ:149
I:(5)
*:_V_R_L33
#                                                            ../orig/v.typ:151
D:quay quay quay quay quay quip quip quip quip quip
 :quay quay quay quay quay quip quip quip quip quip

#                                                            ../orig/v.typ:152
I:(6)
*:_V_R_L34
#                                                            ../orig/v.typ:160
D:apt apt apt; put put put; sip sip sip; hip hip hip;
 :sip sip sip; hip hip hip; apt apt apt; put put put;
 :
 :quip quip quip; quit quit quit; aqua aqua aqua;
 :aqua aqua aqua; quip quip quip; quit quit quit;
 :
 :paid paid paid; pair pair pair; pass pass pass;
 :pair pair pair; pass pass pass; paid paid paid;

#                                                            ../orig/v.typ:161
I:(7)
*:_V_R_L35
#                                                            ../orig/v.typ:169
D:quote quote quote; paper paper paper; quite quite;
 :paper paper paper; quite quite quite; quote quote;
 :
 :prefer prefer prefer; prepay prepay prepay; quires;
 :prepay prepay prepay; prefer prefer prefer; quires;
 :
 :postage postage postage; quarter quarter quarter;
 :poultry poultry poultry; quality quality quality;

#                                                            ../orig/v.typ:170
I:(8)
*:_V_R_L35A
#                                                            ../orig/v.typ:179
D:two quires of high quality paper were shipped today;
 :we shall pay you well to prepare the reports for us;
 :we quote a low figure for our high quality paper;
 :we prefer to prepay the postage for the two quires;

G:_V_E_V5
#------------------------------------------------------------------------------
# Lekce V6
#------------------------------------------------------------------------------
*:V6
*:_V_S_V6
*:_V_R_L36
T:
 :		   (Shift Keys for Capitalization)

#                                                            ../orig/v.typ:180
I:(1) Warmup
*:_V_R_L37
#                                                            ../orig/v.typ:184
D:frf juj ftf jyj fgf jhj ded kik sws lol aqa ;p;
 :aqa ;p; sws lol ded kik frf juj ftf jyj fgf jhj
 :
 :he will pay jed squire for the sugar this week;

#                                                            ../orig/v.typ:185
I:(2) Capital Letter Drill
*:_V_R_L38
#                                                            ../orig/v.typ:190
D:F F F F F F Fa Fa Fa Fa Fa Fa Fay Fay Fay Fay Fay Fay
 :J J J J J J Ja Ja Ja Ja Ja Ja Jay Jay Jay Jay Jay Jay
 :
 :R R R R R R Ra Ra Ra Ra Ra Ra Ray Ray Ray Ray Ray Ray
 :H H H H H H Ha Ha Ha Ha Ha Ha Hal Hal Hal Hal Hal Hal

#                                                            ../orig/v.typ:191
I:(3)
*:_V_R_L39
#                                                            ../orig/v.typ:199
D:Kay Kay Kay; Joe Joe Joe; Alf Alf Alf; Lou Lou Lou;
 :Joe Joe Joe; Kay Kay Kay; Lou Lou Lou; Alf Alf Alf;
 :
 :Dora Dora Dora; Ella Ella Ella; Pete Pete Pete;
 :Sara Sara Sara; Lola Lola Lola; Will Will Will;
 :
 :Garry Garry Garry; Harry Harry Harry; Paula Paula;
 :Harry Harry Harry; Taffy Taffy Taffy; Quail Quail;

#                                                            ../orig/v.typ:200
I:(4)
*:_V_R_L40
#                                                            ../orig/v.typ:208
D:Uriah Uriah Uriah; Yetta Yetta Yetta; Ollie Ollie;
 :Yetta Yetta Yetta; Ollie Ollie Ollie; Uriah Uriah;
 :
 :Walter Walter Walter; Esther Esther Esther; Isaiah;
 :Esther Esther Esther; Walter Walter Walter; Isaiah;
 :
 :Arthur Arthur Arthur; Lester Lester Lester; Quezon;
 :Quezon Quezon Quezon; Arthur Arthur Arthur; Philip;

#                                                            ../orig/v.typ:209
I:(5)
*:_V_R_L41
#                                                            ../orig/v.typ:214
D:Joseph likes to study; Joseph likes to study art;
 :Esther will write; Esther will write Larry today;
 :Arthur likes; Arthur likes to play the flute;
 :Kate says; Kate says she will stay till Friday;
 :Paul will take Willa to the Park Sherry Theater;

G:_V_E_V6
#------------------------------------------------------------------------------
# Lekce V7
#------------------------------------------------------------------------------
*:V7
*:_V_S_V7
*:_V_R_L42
#                                                            ../orig/v.typ:219
T:
 :		(Shift Lock and :)

#                                                            ../orig/v.typ:220
I:(1) Warmup
*:_V_R_L43
#                                                            ../orig/v.typ:222
D:frf juj ftf jyj fgf jhj ded kik sws lol aqa ;p;
 :aqa ;p; sws lol ded kik frf juj ftf jyj fgf jhj

#                                                            ../orig/v.typ:223
I:(2) Shift Lock Drill
*:_V_R_L44
#                                                            ../orig/v.typ:225
D:It is GOOD WORK; It is GOOD WORK; It is GOOD WORK;
 :It is GOOD WORK; It is GOOD WORK; It is GOOD WORK;

#                                                            ../orig/v.typ:226
I:(3)
*:_V_R_L45
#                                                            ../orig/v.typ:233
D:frf juj ftf jyj fgf jhj ded kik sws lol aqa ;p;
 :The TITLE of the REPORT is: HOUSES FOR SALE
 :The TITLE of the REPORT is: HOUSES FOR SALE
 :
 :aqa ;p; sws lol ded kik frf juj ftf jyj fgf jhj
 :We quote LOW FIGURES for HIGHEST QUALITY paper;
 :We quote LOW FIGURES for HIGHEST QUALITY paper;

#                                                            ../orig/v.typ:234
I:(4)
*:_V_R_L46
#                                                            ../orig/v.typ:245
D:frf juj ftf jyj fgf jhj ded kik sws lol aqa ;p;
 :The PARK POSTER reads: KEEP OFF THE GRASS
 :The PARK POSTER reads: KEEP OFF THE GRASS
 :
 :aqa ;p; sws lol ded kik frf juj ftf jyj fgf jhj
 :Paul quoted the old adage: THE THRIFTY ARE WISE
 :Paul quoted the old adage: THE THRIFTY ARE WISE

*:_V_R_L46A
#
D:frf juj ftf jyj fgf jhj ded kik sws lol aqa ;p;
 :You should STRIKE ALL THE KEYS with EQUAL POWER;
 :You should STRIKE ALL THE KEYS with EQUAL POWER;

#                                                            ../orig/v.typ:246
I:(5)
*:_V_R_L47
#                                                            ../orig/v.typ:257
D:frf juj ftf jyj fgf jhj ded kik sws lol aqa ;p;
 :GOOD WORK will lead to a HAPPY LIFE for you;
 :GOOD WORK will lead to a HAPPY LIFE for you;
 :aqa ;p; sws lol ded kik frf juj ftf jyj fgf jhj
 :The DAILY DRILLS will HELP YOU type with EASE;
 :The DAILY DRILLS will HELP YOU type with EASE;

*:_V_R_L47A
#
D:frf juj ftf jyj fgf jhj ded kik sws lol aqa ;p;
 :GOOD SALARIES are USUALLY PAID to FAST TYPISTS;
 :GOOD SALARIES are USUALLY PAID to FAST TYPISTS;

G:_V_E_V7
#------------------------------------------------------------------------------
# Lekce V8
#------------------------------------------------------------------------------
*:V8
*:_V_S_V8
*:_V_R_L48
#                                                            ../orig/v.typ:262
T:
 :		 (Introducing the Period)

#                                                            ../orig/v.typ:263
I:(1) Warmup
*:_V_R_L49
#                                                            ../orig/v.typ:267
D:frf juj ftf jyj fgf jhj ded kik sws lol aqa ;p;
 :aqa ;p; sws lol ded kik frf juj ftf jyj fgf jhj
 :
 :He will pay Jed Squire for the sugar this week;

#                                                            ../orig/v.typ:268
I:(2) The Period
*:_V_R_L50
#                                                            ../orig/v.typ:271
D:. . . . . . l.l l.l l.l l.l l.l l.l l.l l.l l.l
 :Hit it lightly. Hit it lightly.  Hit it lightly.
 :Hit it lightly. Hit it lightly.  Hit it lightly.

#                                                            ../orig/v.typ:272
I:(3)
*:_V_R_L51
#                                                            ../orig/v.typ:286
S:Strike all the keys with pep. Strike the keys
 :as though they were red hot. This is just how the
 :fast typist works.
 :
 :Type with thought. Put forth your greatest efforts.
 :Let these two ideas guide you while you type.
 :
 :You should follow the daily drills as you are told.
 :These drills will show you that it is quite easy
 :to type well.
 :
 :Start your daily work without delay. Keep at it
 :regularly. It is steady work that will take you
 :to your goal.

#                                                            ../orig/v.typ:287
I:(4) Keyboard Review
*:_V_R_L52
#                                                            ../orig/v.typ:292
D:for fat few fur foe fit fed fee for fat fir few fro;
 :fro few fir fat for fee fig foe fop fit fur fat fad;
 :
 :jug jig jut jar joy jag jaw jar jet jot jog jug joy;
 :joy jug jog jag jaw jot jig jut jar jig jaw jog jet;

#                                                            ../orig/v.typ:293
I:(5)
*:_V_R_L53
#                                                            ../orig/v.typ:298
D:rye rut row red rip ray rap rug rig rut rye rug rot;
 :rot rye rut row red rip rat rap rug rig rut rye rug;
 :
 :up us use uses urge ugly usage upper uproar upright;
 :us up use urge uses urge urges udder utters upstart;

G:_V_E_V8
#------------------------------------------------------------------------------
# Lekce V9
#------------------------------------------------------------------------------
*:V9
*:_V_S_V9
*:_V_R_L54
#                                                            ../orig/v.typ:303
T:
 :			(V and M)

#                                                            ../orig/v.typ:304
I:(1) Warmup
*:_V_R_L55
#                                                            ../orig/v.typ:308
D:frf juj ftf jyj fgf jhj ded kik sws lol aqa ;p;
 :aqa ;p; sws lol ded kik frf juj ftf jyj fgf jhj
 :
 :I will pay Joe Quig for the sugar today.

#                                                            ../orig/v.typ:309
I:(2) New Keys (V, M)
*:_V_R_L56
#                                                            ../orig/v.typ:311
D:v v v v fvf fvf fvf fvf m m m m jmj jmj jmj jmj
 :fvf jmj fvf jmj fvf jmj fvf jmj fvf jmj fvf jmj

#                                                            ../orig/v.typ:312
I:(3)
*:_V_R_L57
#                                                            ../orig/v.typ:320
D:over over over; gave gave gave; have have have;
 :home home home; seem seem seem; time time time;
 :
 :ever ever ever; more more more; item item item;
 :live live live; vast vast vast; five five five;
 :
 :You must devote more time to your daily work.
 :You should go over every item with more thought.

#                                                            ../orig/v.typ:321
I:(4) Paragraph Practice
*:_V_R_L58
#                                                            ../orig/v.typ:333
S:You will surely make good if you give more time to
 :your daily work here. You must make ever effort
 :to make good.
 :
 :You will improve your skill every day if you
 :devote some thought to your work. You will surely
 :progress if you keep at your work regularly. Just
 :have faith.
 :
 :Skillful typists make very good salaries. All
 :types of firms require them. So try your utmost to
 :develop your skill.

#                                                            ../orig/v.typ:334
I:(5) Exercises on G, H, T, and Y
*:_V_R_L59
#                                                            ../orig/v.typ:345
D:go got get gas gag gap gay gig gray greed great;
 :go gig gay gap gas gag get gas gray great greed;
 :
 :her has had his hit hot hut hat hay hag had his;
 :his had hag hay hat hut hot hit his had has her;

*:_V_R_L59A
#
D:to try tip tap two tag too to try tip tap two;
 :to two tap tip try too try to top tap tag try;
 :
 :you yes yet yap yell year yoke your yowl yore;
 :yap yet yes you yore yowl your yoke year yell;

G:_V_E_V9
#------------------------------------------------------------------------------
# Lekce V10
#------------------------------------------------------------------------------
*:V10
*:_V_S_V10
*:_V_R_L60
#                                                            ../orig/v.typ:350
T:
 :			(B and N)

#                                                            ../orig/v.typ:351
I:(1) Warmup
*:_V_R_L61
#                                                            ../orig/v.typ:355
D:frf juj ftf jyj fgf jhj ded kik sws lol aqa ;p;
 :fgf jhj fvf jmj fgf jhj fvf jmj fgf jhj fvf jmj
 :
 :Paul Quigs will devote more time to his work.

#                                                            ../orig/v.typ:356
I:(2) New Keys
*:_V_R_L62
#                                                            ../orig/v.typ:358
D:b b b b fbf fbf fbf fbf n n n n jnj jnj jnj jnj
 :fbf jnj fbf jnj fbf jnj fbf jnj fbf jnj fbf jnj

#                                                            ../orig/v.typ:359
I:(3) Word Drill
*:_V_R_L63
#                                                            ../orig/v.typ:361
D:bin bin bin bin bin bin nib nib nib nib nib nib
 :big big big big big big now now now now now now

#                                                            ../orig/v.typ:362
I:(4)
*:_V_R_L64
#                                                            ../orig/v.typ:370
D:bun bun bun; nip nip nip; fib fib fib; win win win;
 :fib fib fib; win win win; bun bun bun; nip nip nip;
 :
 :bent bent bent; nine nine nine; vent vent vent;
 :mend mend mend; vine vine vine; blow blow blow;
 :
 :We require more time to turn out a very good job.
 :Be prompt. Never shirk.  Make promptness a habit.

#                                                            ../orig/v.typ:371
I:(5) Practice Paragraph
*:_V_R_L65
#                                                            ../orig/v.typ:384
S:Never put off until tomorrow any job you should
 :finish today. Try to be prompt at all times.  No one
 :likes to be kept waiting.
 :
 :Keep on working just as diligently as you have
 :been doing up to this point. You will soon be a
 :master of the keyboard. You will have a valuable
 :skill that will repay you for your efforts.
 :
 :Remember this: every boy and girl is able to
 :learn typing. All they have to do is to put forth
 :their very best efforts. This means thinking while
 :training every finger to strike the right key.

#                                                            ../orig/v.typ:385
I:(6) Words with D, E, K, and I
*:_V_R_L66
#                                                            ../orig/v.typ:390
D:do dot due dye day dew dab den dim dog die dig dry dip
 :do dig dry dip die dog dim dab den dew day dye due dot
 :
 :ebb eke err eve end egg ever even edge earn east evil
 :err eke eve end ebb eel evil east earn edge envy easy

#                                                            ../orig/v.typ:391
I:(7)
*:_V_R_L67
#                                                            ../orig/v.typ:396
D:kid kin kit keg key king kind know knee knot knew
 :key keg kid kit kin knew knot knee knob king kind
 :
 :it is in if ire ill ink inn imp idle item isle iron
 :if in is it imp inn ill ire ink item idle iron isle

G:_V_E_V10
#------------------------------------------------------------------------------
# Lekce V11
#------------------------------------------------------------------------------
*:V11
*:_V_S_V11
*:_V_R_L68
#                                                            ../orig/v.typ:401
T:
 :		     (C and Comma)

#                                                            ../orig/v.typ:402
I:(1) Warmup
*:_V_R_L69
#                                                            ../orig/v.typ:406
D:frf juj ftf jyj fgf jhj ded kik sws lol aqa ;p;
 :fvf jmj fbf jnj fvf jmj fbf jnj fvf jmj fbf jnj
 :
 :The Ben Mavis firm submitted the lowest quotation.

#                                                            ../orig/v.typ:407
I:(2) New Key Review
*:_V_R_L70
#                                                            ../orig/v.typ:409
D:c c c c dcd dcd dcd dcd , , , , k,k k,k k,k k,k
 :dcd k,k dcd k,k dcd k,k dcd k,k dcd k,k dcd k,k

#                                                            ../orig/v.typ:410
I:(3) Word Drill
*:_V_R_L71
#                                                            ../orig/v.typ:412
D:can, can, can, can, can, cue, cue, cue, cue, cue,
 :can, can, can, can, can, cue, cue, cue, cue, cue,

#                                                            ../orig/v.typ:413
I:(4)
*:_V_R_L72
#                                                            ../orig/v.typ:418
D:cash, cash, cash, lack, lack, lack, lace, lace, lace,
 :lack, lack, lack, lace, lace, lace, cash, cash, cash,
 :
 :could, could, could, clerk, clerk, clerk, camp, camp,
 :clerk, clerk, clerk, could, could, could, cane, cane,

#                                                            ../orig/v.typ:419
I:(5)
*:_V_R_L73
#                                                            ../orig/v.typ:422
D:If you call before five, the bank will cash your check.
 :Charles Condon, sales manager, was in complete charge.
 :He may, if convenient, have it charged to his account.

#                                                            ../orig/v.typ:423
I:(6)
*:_V_R_L74
#                                                            ../orig/v.typ:436
S:Space once after a comma. Space once after a
 :semicolon. Space twice after a period that ends a
 :sentence. Strike each key with the same force.
 :
 :The tabulator is a device which helps you to type faster.
 :It enables you to skip across the page to any point you
 :desire.
 :
 :First, set a tab stop at the point to which you
 :wish the carriage to jump. Second, move the carriage
 :back to the left margin. Third, hold the tabulator
 :bar or the tabulator key down until the carriage has
 :stopped.

#                                                            ../orig/v.typ:437
I:(7)
*:_V_R_L75
#                                                            ../orig/v.typ:442
D:sub sum see sun set sit sin sip she ship shall shame
 :sit sin sip set sub sum see sod sob slip sweep super
 :
 :won win who why wet was weak wear west well what when
 :was wet why who win won what well wear west when what

#                                                            ../orig/v.typ:443
I:(8)
*:_V_R_L76
#                                                            ../orig/v.typ:448
D:lad lid lot let log lie lag lug lip last sate sawn
 :lip lag lug lie log let lot lid lad land lane last
 :
 :own out owl old one oak out oil off over oven open
 :off oil out oak one old owl our own open ours over

G:_V_E_V11
#------------------------------------------------------------------------------
# Lekce V12
#------------------------------------------------------------------------------
*:V12
*:_V_S_V12
*:_V_R_L77
#                                                            ../orig/v.typ:453
T:
 :			(X and .)

#                                                            ../orig/v.typ:454
I:(1) Warmup
*:_V_R_L78
#                                                            ../orig/v.typ:456
D:frf juj ftf jyj fgf jhj fvf jmj fbf jnj fvf jmj
 :ded kik sws lol aqa ;p; dcd k,k dcd k,k fvf jmj

#                                                            ../orig/v.typ:457
I:(2)
*:_V_R_L79
#                                                            ../orig/v.typ:460
D:touch...learn...above...typing...talent...
 :average...special...that is...You do......
 :You do not

#                                                            ../orig/v.typ:461
I:(3) Timed Drill:
*:_V_R_L80
#                                                            ../orig/v.typ:464
S:Touch typing is easy to learn. You do not need
 :a mind that is above the average. You do not
 :even need a special talent for typing.

#                                                            ../orig/v.typ:465
I:(4) New Key Tryout
*:_V_R_L81
#                                                            ../orig/v.typ:467
D:x x x x sxs sxs sxs sxs . . . . l.l l.l l.l l.l
 :sxs l.l sxs l.l sxs l.l sxs l.l sxs l.l sxs l.l

#                                                            ../orig/v.typ:468
I:(5) Word Drill
*:_V_R_L82
#                                                            ../orig/v.typ:470
D:six six six six six six etc. etc. etc. etc. etc.
 :six six six six six six etc. etc. etc. etc. etc.

#                                                            ../orig/v.typ:471
I:(6)
*:_V_R_L83
#                                                            ../orig/v.typ:479
D:fixes fixes fixes; mixes mixes mixes; taxes taxes;
 :mixes mixes mixes; fixes fixes fixes; boxes boxes;
 :
 :expert expert expert; expect expect expect; excels;
 :exceed exceed exceed; excuse excuse excuse; excels;
 :
 :Dr. Lux, tax expert, will examine the tax returns.
 :Mr. Cox examined the mixture with extreme care.

#                                                            ../orig/v.typ:480
I:(7) Practice Paragraph
*:_V_R_L84
#                                                            ../orig/v.typ:493
S:Mr. Roxbury and Mr. Saxton will examine the six
 :boxes of wax with extreme care. These boxes were
 :returned by Prof. Maxton of Knoxville College.
 :
 :The Government tax experts were exceedingly
 :careful in examining the current tax receipts. The
 :amount showed an excess of six million dollars over
 :the previous year.
 :
 :Sixteen boxes of explosives were packed with the
 :most extreme care and shipped by Fox Express Company.
 :These explosives are to be used in secret experiments
 :for the U. S. Government.

#                                                            ../orig/v.typ:494
I:(8) Drill on A, Q, ;, P
*:_V_R_L85
#                                                            ../orig/v.typ:502
D:act ant and ask apt any art all age anle acid aged
 :age all art any ask act add axe ant aged able acid
 :
 :quit quip quote quite queer queen quack quaint quorum
 :quip quit quite quote queen queer quail quorum quaint
 :
 :pin pup put; pull palm pant; pint pile push; punch;
 :put pin pup; pant pull palm; push pick pile; paper;

G:_V_E_V12
#------------------------------------------------------------------------------
# Lekce V13
#------------------------------------------------------------------------------
*:V13
*:_V_S_V13
*:_V_R_L86
#                                                            ../orig/v.typ:507
T:
 :			(Z and /)
Q:Pro pokračování stiskněte Y, F12 pro konec.
N:_V_R_L86

#                                                            ../orig/v.typ:508
I:(1) Warmup
*:_V_R_L87
#                                                            ../orig/v.typ:510
D:frf juj ftf jyj fgf jhj ded kik sws lol aqa ;p;
 :fvf jmj fbf jnj dcd k,k sxs l.l dcd k,k sxs l.l

#                                                            ../orig/v.typ:511
I:(2)
*:_V_R_L88
#                                                            ../orig/v.typ:514
D:touch...learn...above...typing...talent...average
 :special...lessons...you do...for you...is the
 :do the...of the...in this

#                                                            ../orig/v.typ:515
I:(3)
*:_V_R_L89
#                                                            ../orig/v.typ:522
S:Touch typing is easy to learn. You do not need a
 :mind that is above the average. You do not even
 :need a special talent for typing.
 :
 :All you need is the will to learn. The lessons in
 :this book do the rest of the job for you; they
 :make touch typing easy for you to learn.

#                                                            ../orig/v.typ:523
I:(4) New Key Tryout
*:_V_R_L90
#                                                            ../orig/v.typ:525
D:z z z z aza aza aza aza / / / / ;/; ;/; ;/; ;/;
 :aza ;/; aza ;/; aza ;/; aza ;/; aza ;/; aza ;/;

#                                                            ../orig/v.typ:526
I:(5) Word Drill
*:_V_R_L91
#                                                            ../orig/v.typ:528
D:zip zip zip zip zip c/o c/o c/o c/o c/o c/o
 :zip zip zip zip zip c/o c/o c/o c/o c/o c/o

#                                                            ../orig/v.typ:529
I:(6)
*:_V_R_L92
#                                                            ../orig/v.typ:537
S:zest zest zest; lazy lazy lazy; size size size; zeal;
 :zero zero zero; zest zest zest; lazy lazy lazy; zeal;
 :
 :blaze blaze blaze; amaze amaze amaze; zebra zebra;
 :dizzy dizzy dizzy; blaze blaze blaze; amaze amaze;
 :
 :The lazy zebra at the zoo quickly drank the mixture.
 :Ship five dozen boxes of zinc trays by Zale Express.

#                                                            ../orig/v.typ:538
I:(7)
*:_V_R_L93
#                                                            ../orig/v.typ:553
S:The slant is controlled by the semicolon finger.
 :It is used in such abbreviations as n/c, which means
 :NO CHARGE; and c/o, which means CARE OF.
 :
 :If you work with zeal and zest, you will soon be a
 :competent typist. The ability to type well is a
 :very valuable asset.
 :
 :You can develop your typing skill quickly by the proper
 :habits of work. You should realize that poor work is a
 :mere waste of time. Try to be exact.
 :
 :Every business firm is dependent on the services of
 :competent typists. You are now equipping yourself with
 :a skill for which there is a constant demand.

#                                                            ../orig/v.typ:554
I:(8)
*:_V_R_L94
#                                                            ../orig/v.typ:559
D:bag big bug bit bud bed bid bun bale bend bank bask
 :but bid bed bun bid big bag bud bask bale band bank
 :
 :not now nut nor note nose none nude noun nine nest
 :now not nor nut nose note nude none nine nest next

#                                                            ../orig/v.typ:560
I:(9)
*:_V_R_L95
#                                                            ../orig/v.typ:565
D:vim vet van vex vet vast vote veto vase vine vial
 :van vex vet vim vex vial vine vase veto vote vast
 :
 :man mix mat mad made mail main make mark mask mine
 :mad met mix men mask mark made main male made mint

G:_V_E_V13
#------------------------------------------------------------------------------
# Lekce V14
#------------------------------------------------------------------------------
*:V14
*:_V_S_V14
*:_V_R_L96
#                                                            ../orig/v.typ:570
T:
 :		  (The Question Mark)

#                                                            ../orig/v.typ:571
I:(1) Warmup
*:_V_R_L97
#                                                            ../orig/v.typ:575
D:frf juj ftf jyj fgf jhj ded kik sws lol aqa ;p;
 :fvf jmj fbf jnj dcd k,k sxs l.l aza ;/; aza ;/;
 :
 :Liza quickly mixed the very big jar of new soap.

#                                                            ../orig/v.typ:576
I:(2)
*:_V_R_L98
#                                                            ../orig/v.typ:581
D:touch...learn...above...aside...typing
 :talent...amount...average...special...
 :lessons...definite...is the...of the
 :for you...you do...that is...in this
 :you do not

#                                                            ../orig/v.typ:582
I:(3)
*:_V_R_L99
#                                                            ../orig/v.typ:592
S:Touch typing is easy to learn. You do not need a mind
 :that is above the average. You do not even need a
 :special talent for typing.
 :
 :All you need is the will to learn. The lessons in this
 :book do the rest of the job for you; they make touch
 :typing easy for you to learn.
 :
 :Try to set aside each day a definite amount of time for
 :each lesson.

#                                                            ../orig/v.typ:593
I:(4) New Key Tryout
*:_V_R_L100
#                                                            ../orig/v.typ:595
D:? ? ? ? ? ? Who? Who?  Who?  Who?  Who?  Who?
 :? ? ? ? ? ? Why? Why?  Why?  Why?  Why?  Why?

#                                                            ../orig/v.typ:596
I:(5)
*:_V_R_L101
#                                                            ../orig/v.typ:604
D:How much? How many?  How soon?  How early?  How fast?
 :How many? How much?  How fast?  How large?  How soon?
 :
 :Where is Max? Where is Mary?  What is Cora sewing?
 :Where is Sam? Where is Paul?  What is Zeke fixing?
 :
 :Can Max swim? Can he dance?  Can he play tennis?
 :Can he dance? Deos he swim?  Do you like tennis?

#                                                            ../orig/v.typ:605
I:(6)
*:_V_R_L102
#                                                            ../orig/v.typ:610
D:Did you open the mail? Did you read the note?
 :Did you read the note? Did you open the mail?
 :
 :Can Van do the work? Will he require aid?  Who knows?
 :Can Jim complete it? Is he quite capable?  Who knows?

#                                                            ../orig/v.typ:611
I:(7) Practice Paragraph
*:_V_R_L103
#                                                            ../orig/v.typ:626
S:Do you set aside a definite amount of time each
 :day for practice? Do you start work promptly?  Can
 :you make the various machine adjustments quickly?
 :
 :Do you keep your fingers curved? Do you strike each key
 :sharply with the tip of the finger? Do you keep your eyes
 :on the copy?
 :
 :Do you throw the carriage without looking up? Do you keep
 :your right hand on the home keys when you throw the carriage?
 :Do you use the paper release to remove your paper?
 :
 :Do you practice the words in which you made errors? Do you
 :practice them as explained in this book? Do you follow the
 :instructions exactly as given?

#                                                            ../orig/v.typ:627
I:(8)
*:_V_R_L104
#                                                            ../orig/v.typ:632
D:lax vex six tax fix taxed fixing mixing taxing vexing
 :fix tax vex lax six fixed vexing taxing fixing mixing
 :
 :zip zoo zest zeal zinc zero lazy zone zoom zinc zealot
 :zoo zip zoom zone lazy zinc zeal zest zero zone zealot

G:_V_E_V14
#------------------------------------------------------------------------------
# Lekce V15
#------------------------------------------------------------------------------
*:V15
*:_V_S_V15
*:_V_R_L105
#                                                            ../orig/v.typ:637
T:
 :			(1, 4, 5, 6, 7)

#                                                            ../orig/v.typ:638
I:(1) Warmup
*:_V_R_L106
#                                                            ../orig/v.typ:640
D:frf juj ftf jyj fgf jhj ded kik sws lol aqa ;p;
 :fvf jmj fbf jnj dcd k,k sxs l.l aza ;/; aza ;/;

#                                                            ../orig/v.typ:641
I:(2)
*:_V_R_L107
#                                                            ../orig/v.typ:647
D:touch...learn...above...aside...typing
 :talent...amount...follow...easily...become
 :typist...average...special...lessons...definite
 :exactly...quickly...surprised...is the...
 :of the...in the...in this...for you...
 :you will...you will be

#                                                            ../orig/v.typ:648
I:(3)
*:_V_R_L108
#                                                            ../orig/v.typ:651
S:Touch typing is easy to learn. You do not need a
 :mind that is above the average. You do not even need
 :a special talent for typing.

#                                                            ../orig/v.typ:652
I:(4)
*:_V_R_L109
#                                                            ../orig/v.typ:664
S:Touch typing is easy to learn. You do not need a
 :mind that is above the average. You do not even need
 :a special talent for typing.
 :
 :All you need is the will to learn. The lessons in this
 :book do the rest of the job for you; they make touch
 :typing easy for you to learn.
 :
 :Try to set aside each day a definite amount of time for
 :each lesson. Follow each step in the lesson exactly as
 :given. You will be surprised how easily and quickly
 :you will become a touch typist.

#                                                            ../orig/v.typ:665
I:(5) 4 and 7
*:_V_R_L110
#                                                            ../orig/v.typ:670
D:f4f f4f f4f f4f f4f f4f j7j j7j j7j j7j j7j j7j
 :f4f j7j f4f j7j f4f j7j f4f j7j f4f j7j f4f j7j
 :
 :or 4 or 4 or 4 ru 7 ru 7 ru 7 or 4 ru 7 or 4 ru 7
 :or 4 ru 7 or 4 ru 7 or 4 ru 7 or 4 ru 7 or 4 ru 7

#                                                            ../orig/v.typ:671
I:(6)
*:_V_R_L111
#                                                            ../orig/v.typ:676
D:June 1; July 4; April 7; January 4; March 17, 1741
 :July 4; June 1; March 4; October 7; April 14, 1471
 :
 :What is the sum of 11 and 7 and 4 and 1 and 714?
 :What is the sum of 17 and 4 and 7 and 1 and 174?

#                                                            ../orig/v.typ:677
I:(7)
*:_V_R_L112
#                                                            ../orig/v.typ:685
D:Florence is 7 years 14 months and 17 days old today.
 :Veronica is 4 years 11 months and 14 days old today.
 :
 :Your order of November 14 was shipped on December 17.
 :Your order of December 11 was shipped on February 14.
 :
 :Policy No. 141174 will expire on Monday, November 14.
 :Policy No. 471714 will expire on Friday, December 17.

#                                                            ../orig/v.typ:686
I:(8) Practice Paragraph
*:_V_R_L113
#                                                            ../orig/v.typ:700
S:Henry Clay, American statesman and orator, was
 :born in Hanover County, Virginia, in 1777.
 :
 :On June 14, 1777, John Paul Jones became commander
 :of the American warship, THE RANGER.
 :
 :In April 1777, Lafayette landed at night on the
 :shore of South Carolina to help the colonies. In
 :July 1777, Congress made Lafayette a general.
 :
 :June 14 is now observed as Flag Day because the
 :flag was adopted by Congress on June 14, 1777. The
 :house where Betsy Ross, designer of the flag, lived
 :is now preserved as a shrine.

#                                                            ../orig/v.typ:701
I:(9)
*:_V_R_L114
#                                                            ../orig/v.typ:713
S:Do not erase. Do not cross out.  Do not strike
 :one letter over another. Let your errors stand.
 :Finish every line you start.
 :
 :You correct your typing errors by practicing the
 :words in which you made errors. You have been doing
 :this in the previous lessons. Keep right on doing so.
 :That is the best practice for training your fingers
 :to strike the right keys.
 :
 :Try your utmost to turn out attractive work.
 :Take pride in your typing product.

#                                                            ../orig/v.typ:714
I:(10) 5 and 6
*:_V_R_L115
#                                                            ../orig/v.typ:719
D:f5f f5f f5f f5f f5f f5f j6j j6j j6j j6j j6j j6j
 :f5f j6j f5f j6j f5f j6j f5f j6j f5f j6j f5f j6j
 :
 :if 5 by 6 if 5 by 6 if 6 by 6 if 5 by 6 if 5 by 6
 :if 5 by 6 if 5 by 6 if 6 by 6 if 5 by 6 if 5 by 6

#                                                            ../orig/v.typ:720
I:(11)
*:_V_R_L116
#                                                            ../orig/v.typ:727
D:f4f j7j f5f j6j f4f j7j f5f j6j f4f j7j f5f j6j
 :15 lbs. coffee; 16 doz. eggs; 56 boxes oranges;
 :65 lbs. coffee; 14 doz. eggs; 75 boxes oranges;
 :
 :or 4 ru 7 it 5 my 6 or 4 ru 7 it 5 my 6 147 156
 :The Barton Market is at 516 West 147th Street.
 :The Baxter Market is at 165 East 165th Street.

#                                                            ../orig/v.typ:728
I:(12)
*:_V_R_L117
#                                                            ../orig/v.typ:735
D:fr4 ju7 ft5 jy6 f4f j7j f5f j6j f4f j7j f5f j6j
 :Robert Fulton was born in Pennsylvania in 1765.
 :William Penn, English Quaker, was born in 1644.
 :
 :or 4 ru 7 it 5 by 6 or 4 ru 7 it 5 by 6 174 516
 :The sum of 15 and 51 and 65 and 41 and 475 is 647.
 :The sum of 51 and 15 and 56 and 14 and 475 is 611.

#                                                            ../orig/v.typ:736
I:(13)
*:_V_R_L118
#                                                            ../orig/v.typ:749
S:On June 15, 1775, George Washington was elected
 :by Congress the Chief Commander of the American forces.
 :He scored a brilliant victory at Trenton on Christmas
 :night, 1776.
 :
 :The Declaration of Independence, a famous state
 :paper, was issued by the American Continental Congress
 :on July 4w 1776. It was drawn up by Thomas Jefferson.
 :
 :The invasion fleet consisted of 4 battleships, 15 light
 :cruisers, 6 aircraft carriers, 17 troopships, six submarines,
 :and 2 Dr. Strangeloves. Air protection consisted of 14
 :bombers, 175 fighters, 6 helicopters, and 75 paratroop planes.

G:_V_E_V15
#------------------------------------------------------------------------------
# Lekce V16
#------------------------------------------------------------------------------
*:V16
*:_V_S_V16
*:_V_R_L119
#                                                            ../orig/v.typ:754
T:
 :			(3 and 8)

#                                                            ../orig/v.typ:755
I:(1) Warmup
*:_V_R_L120
#                                                            ../orig/v.typ:757
D:f4f j7j f5f j6j f4f j7j f5f j6j f4f j7j f5f j6j
 :417 147 517 157 617 167 617 171 714 471 651 174

#                                                            ../orig/v.typ:758
I:(2)
*:_V_R_L121
#                                                            ../orig/v.typ:763
D:never...typing...office...become...getting...
 :acquire...efforts...valuable...personal...
 :possible...business...shorthand...it is...
 :it can...to it...in the...to use...to have
 :if you...from you...why not

#                                                            ../orig/v.typ:764
I:(3)
*:_V_R_L122
#                                                            ../orig/v.typ:767
S:Typing is a very valuable skill to acquire. It is
 :valuable for personal use and as a means of getting
 :an office job.

#                                                            ../orig/v.typ:768
I:(4)
*:_V_R_L123
#                                                            ../orig/v.typ:781
S:Typing is a very valuable skill to acquire. It is
 :valuable for personal use and as a means of getting
 :an office job. This skill is yours to use; it can
 :never be taken from you.
 :
 :So why not put forth your best efforts to become a
 :good typist? You can become a good typist if you
 :put your mind to it. You should also, if possible,
 :learn shorthand. Typing and shorthand are two very
 :valuable skills to have.
 :
 :These two skills will help you get a good start
 :in the business world.

#                                                            ../orig/v.typ:782
I:(5) New Key Tryout
*:_V_R_L124
#                                                            ../orig/v.typ:787
D:d3d k8k d3d k8k d3d k8k d3d k8k d3d k8k d3d k8k
 :131 313 311 181 818 381 381 381 183 138 318 813
 :
 :bid 3 bid 3 bid 3 bid 3 oak 8 oak 8 oak 8 oak 8
 :bid 3 bid 3 bid 3 bid 3 oak 8 oak 8 oak 8 oak 8

#                                                            ../orig/v.typ:788
I:(6)
*:_V_R_L125
#                                                            ../orig/v.typ:795
D:d3d k8k d3d k8k d3d k8k d3d k8k 318 813 138 813 381
 :13 lbs. lamb roast; 38 lbs. lamb chops; 8 lbs. bananas;
 :31 lbs. lamb chops; 83 lbs. lamb roast; 3 lbs. peaches;
 :
 :lie 3 dye 3 pie 3 dye 3 Fiji 8 Fiji 8 Fiji 8
 :18 cans grape juice; 138 cans prune juice; 4 lbs. coffee;
 :47 cans prune juice; 143 cans grape juice; 8 lbs. onions;

#                                                            ../orig/v.typ:796
I:(7)
*:_V_R_L126
#                                                            ../orig/v.typ:803
D:d3d k8k d3d k8k d3d k8k 183 381 813 318 138 381
 :8 lbs. Swiss Cheese; 13 lbs. Kraft Cheese; 4 lbs. pears;
 :5 lbs. Kraft Cheese; 17 lbs. Swiss Cheese; 6 lbs. beans;
 :
 :pie 3 dye 3 pie 3 dye 3 Fiji 8 Fiji 8 Fiji 8 Fiji 8
 :The sum of 13 and 83 and 153 and 75 and 47 is 371.
 :The sum of 47 and 75 and 153 and 83 and 13 is 371.

#                                                            ../orig/v.typ:804
I:(8) Practice Paragraph
*:_V_R_L127
#                                                            ../orig/v.typ:824
S:John Jacob Astor was born in 1763 and died in
 :1848. He came to America from England in 1784 and
 :set up a prosperous fur trade. In 1811 he founded
 :the settlement of Astoria near the mouth of the
 :Columbia River.
 :
 :Alexander Graham Bell was born in Scotland on
 :March 3, 1847. He invented the telephone in 1876.
 :The Bell Telephone Company was organized in 1877.
 :Mr. Bell also invented the gramophone in 1887.
 :
 :John Quincy Adams, sixth President of the
 :United States, was born in Massachusetts on July 11,
 :1767. In 1817 he was appointed Secretary of State.
 :He died in 1848.
 :
 :Oliver Wendell Holmes, American jurist, was born
 :in Massachusetts on March 8, 1841; graduated from
 :Harvard in 1861; from Harvard Law School in 1866;
 :admitted to the Massachusetts Bar in 1867.

G:_V_E_V16
#------------------------------------------------------------------------------
# Lekce V17
#------------------------------------------------------------------------------
*:V17
*:_V_S_V17
*:_V_R_L128
#                                                            ../orig/v.typ:829
T:
 :			(2 and 9)

#                                                            ../orig/v.typ:830
I:(1) Warmup
*:_V_R_L129
#                                                            ../orig/v.typ:834
D:f4f j7j f5f j6j d3d k8k f4f j7j f5f j6j d3d k8k
 :or4 ru7 it5 by6 ie3 ok8 or4 ru7 it5 by6 ie3 ok8
 :
 :The sum of 14 and 16 and 53 and 58 and 174 is 315.

#                                                            ../orig/v.typ:835
I:(2)
*:_V_R_L130
#                                                            ../orig/v.typ:841
D:strike...center...finger...spring...though...
 :expert...sharply...release...quickly...develop...
 :letting...squarely...practice...familiar...
 :fingertip...important...technique...releasing...
 :instantly...it is...do it...do this...with the...
 :you get.

#                                                            ../orig/v.typ:842
I:(3)
*:_V_R_L131
#                                                            ../orig/v.typ:845
S:Strike each key sharply with the fingertip and squarely
 :in the center. Strike the key quickly, letting the
 :finger spring back as though the key were red hot.

#                                                            ../orig/v.typ:846
I:(4)
*:_V_R_L132
#                                                            ../orig/v.typ:849
S:Strike each key sharply with the fingertip and squarely
 :in the center. Strike the key quickly, letting the
 :finger spring back as though the key were red hot.

*:_V_R_L133
#                                                            ../orig/v.typ:858
S:
 :To type fast, it is just as important to release the
 :key quickly as it is to strike it quickly. Expert
 :typists do this; you too, can do it, with practice.
 :
 :One good way to develop this technique is to practice
 :familiar words and phrases. Type them over and over
 :again until you get the knack of hitting the keys quickly
 :and releasing the fingers instantly.

#                                                            ../orig/v.typ:859
I:(5) New Key Tryout
*:_V_R_L134
#                                                            ../orig/v.typ:864
D:s2s s2s s2s s2s s2s s2s l9l l9l l9l l9l l9l l9l
 :s2s l9l s2s l9l s2s l9l s2s l9l s2s l9l s2s l9l
 :
 :bow 2 bow 2 bow 2 bow 2 two 9 two 9 two 9 two 9
 :bow 2 two 9 bow 2 two 9 bow 2 two 9 bow 2 two 9

#                                                            ../orig/v.typ:865
I:(6)
*:_V_R_L135
#                                                            ../orig/v.typ:872
D:s2s l9l s2s l9l s2s l9l s2s l9l s2s l9l s2s l9l s2s l9l
 :12 lbs. coffee; 19 lbs. Cottage Cheese; 9 lbs. peaches;
 :19 lbs. apples; 29 lbs. Cheddar Cheese; 2 lbs. bananas;
 :
 :low 2 fro 9 low 2 fro 9 low 2 fro 9 low 2 fro 9 29 192;
 :9 lbs. Smoked Tongue; 2 lbs. tomatoes; 9 lbs. avocados;
 :2 lbs. Cooked Tongue; 9 lbs. avocados; 2 lbs. tomatoes;

#                                                            ../orig/v.typ:873
I:(7)
*:_V_R_L136
#                                                            ../orig/v.typ:880
D:s2s l9l s2s l9l 219 921 192 s2s l9l s2s 191 291 129
 :The sum of 29 and 86 and 33 and 92 and 52 is 292.
 :The sum of 52 and 92 and 86 and 33 and 29 is 292.
 :
 :ow 2 to 9 ow 2 to 9 we 23 ok 98 we 23 ok 98 s2s l9l
 :George Washington was born on February 22, 1732.
 :Horatio Alger was born in 1834 and died in 1899.

#                                                            ../orig/v.typ:881
I:(8)
*:_V_R_L137
#                                                            ../orig/v.typ:898
S:Christopher Latham Sholes was the inventor of the first practical
 :typewriter. He was born in Columbia County, Pennsylvania,
 :February 14, 1819.
 :
 :James Monroe, fifth President of The United States, was born on
 :April 28, 1758. In 1782 he entered politics.  In 1799 he was appointed
 :Governor of Virginia. In 1811 he became Secretary of State; in 1814,
 :Secretary of War; in 1816, President of The United States.
 :
 :On September 1, 1939, Germany launched undeclared war on Poland.
 :On September 3, 1939, Great Britain declared war on Germany. On
 :December 8, 1941, The United States declared war against the Axis.
 :
 :Samuel F. B. Morse, inventor and artist, was born in 1791 and died in
 :1872. In 1829 he went to Europe for three years.  For 12 years he
 :worked on perfecting the electrical telegraph, which was exhibited at New
 :York University in 1837.

G:_V_E_V17
#------------------------------------------------------------------------------
# Lekce V18
#------------------------------------------------------------------------------
*:V18
*:_V_S_V18
*:_V_R_L138
#                                                            ../orig/v.typ:903
T:
 :		   (0 and the Hyphen)

#                                                            ../orig/v.typ:904
I:(1) Warmup
*:_V_R_L139
#                                                            ../orig/v.typ:908
D:f4f j7j f5f j6j d3d k8k s2s l9l f4f j7j f5f j6j
 :s2s l9l d3d k8k f4f j7j f5f j6j f4f j7j f5f j6j
 :
 :The sum of 47 and 65 and 38 and 92 and 16 equals 258.

#                                                            ../orig/v.typ:909
I:(2)
*:_V_R_L140
#                                                            ../orig/v.typ:913
D:expert...typing...margin...always...before...
 :permits...others...reached...equipped...machines...
 :carriage...typewriter...approaching...you are...
 :of the...for the...on the...you may...before the

#                                                            ../orig/v.typ:914
I:(3)
*:_V_R_L141
#                                                            ../orig/v.typ:917
S:Your typewriter is equipped with a bell which
 :rings to warn you that you are approaching the end
 :of the line

#                                                            ../orig/v.typ:918
I:(4)
*:_V_R_L142
#                                                            ../orig/v.typ:934
S:Your typewriter is equipped with a bell which rings
 :to warn you that you are approaching the end of the
 :line.
 :
 :On some machines, the bell rings five spaces before
 :the margin stop is reached; on other machines, it
 :rings when there are six or seven spaces left.
 :
 :The ring of the bell permits you to keep your eyes
 :on the copy. When you hear the bell, finish the
 :word you are typing and throw the carriage for the
 :next line.
 :
 :Do not look up to watch for the end of the line; you
 :may lose your place in the copy. Always keep your
 :eyes on the copy like the expert typist.

#                                                            ../orig/v.typ:935
I:(5) New Key Tryout
*:_V_R_L143
#                                                            ../orig/v.typ:941
D:;0; ;0; ;0; ;0; ;0; ;0; ;-; ;-; ;-; ;-; ;-; ;-;
 :;0; ;-; ;0; ;-; ;0; ;-; ;0; ;-; ;0; ;-; ;0; ;-;
 :
 :10-room; 10-room; 10-room; 10-room; 10-room;
 :20-room; 20-room; 20-room; 20-room; 20-room;

#                                                            ../orig/v.typ:942
I:(6)
*:_V_R_L144
#                                                            ../orig/v.typ:949
D:f4f j7j f5f j6j d3d k8k s2s l9l ;0; ;-; ;0; ;-;
 :one-half; one-fourth; one-eighth; three-quarters;
 :one-half; two-thirds; one-fourth; three-sevenths;
 :
 :f4f j7j f5f j6j d3d k8k s2s l9l ;0; ;-; ;0; ;-;
 :20-room house; 30-room house; 40-room house;
 :50-room house; 60-room house; 70-room house;

#                                                            ../orig/v.typ:950
I:(7)
*:_V_R_L145
#                                                            ../orig/v.typ:957
D:f4f j7j f5f j6j d3d k8k s2s l9l ;0; ;-; ;0; ;-;
 :One-fourth may be typewritten like this: 1/4.
 :One-eighth may be typewritten like this: 1/8.
 :
 :f4f j7j f5f j6j d3d k8k s2s l9l ;0; ;-; ;0; ;-;
 :Every expert was once a beginner--with ambition.
 :Every expert was once a beginner--with ambition.

#                                                            ../orig/v.typ:958
I:(8)
*:_V_R_L146
#                                                            ../orig/v.typ:972
S:As you have seen in the above sentence practice, the hyphen is used
 :for typing compound words. Here are a few more examples:  up-to-date,
 :first-class, by-product.
 :
 :The hyphen is used also to divide words between syllables at the end
 :of a line. When the bell rings, finish the word if it is short--less
 :than six letters. If the word is longer, divide it at the end of a syllable.
 :
 :The hyphens in the following words show where they could be divided
 :at the end of a line: after-noon, state-ment, hesi-tate, cer-ti-fi-
 :cate, exami-na-tion.
 :
 :The sum of 10 and 20 and 30 and 40 and 50 and 60 and 70 and 80 and 90
 :and 100 and 105 and 106 and 107 and 108 and 109 and 110 equals 1,195.

#                                                            ../orig/v.typ:973
I:(9)
*:_V_R_L147
#                                                            ../orig/v.typ:978
S:Have you seen the new 7-room house at 175 West
 :239th Street? It is equipped with every up-to-date,
 :labor-saving device for the home. You may inspect
 :it free of charge any day except Sunday between
 :10 a.m. and 4 p.m.

G:_V_E_V18
#------------------------------------------------------------------------------
# Lekce V19
#------------------------------------------------------------------------------
*:V19
*:_V_S_V19

#                                                            ../orig/v.typ:982
I:(1) Warmup
*:_V_R_L149
#                                                            ../orig/v.typ:986
D:f4f j7j f5f j6j d3d k8k s2s l9l ;0; ;-; ;0; ;-;
 :s2s l9l ;-; ;=; d3d k8k f4f j7j ;0; ;-; ;0; ;-;
 :
 :Max Zale made a long-distance flight of 2,590 miles.

#                                                            ../orig/v.typ:987
I:(2)
*:_V_R_L150
#                                                            ../orig/v.typ:991
D:called...fourth...typing...letter...always...
 :capital...holding...depress...fingers...release...
 :touching...slightly...position...right-hand...of the
 :for the...all the...with the...you have

#                                                            ../orig/v.typ:992
I:(3)
*:_V_R_L151
#                                                            ../orig/v.typ:994
S:You type capital letters by holding down a key
 :called the shift key while you strike the letter key.

#                                                            ../orig/v.typ:995
I:(4)
*:_V_R_L152
#                                                           ../orig/v.typ:1010
S:You type capital letters by holding down a key
 :called the shift key while you strike the letter key.
 :
 :There are two shift keys. Hold down the left
 :shift key for typing right-hand capitals; hold down
 :the right shift key for typing left-hand capitals.
 :Always use the fourth finger for the shift key.
 :
 :Keep your wrists low but not touching the frame
 :of the machine. Raise the other fingers slightly as
 :you depress the shift key with the fourth finger.
 :
 :Be sure that you hold the shift key all the way
 :down until you have struck the letter key; then re-
 :lease the shift key and return finger to home base.

#                                                           ../orig/v.typ:1011
I:(5)
*:_V_R_L153
#                                                           ../orig/v.typ:1028
S:Prepare a bill for the following items: 29 lbs. butter
 :@ $0.895; 36 doz. eggs @ $0.695; 28 doz. oranges
 :@ $0.575; 15 bu. potatoes @ $0.795.
 :
 :Our company ordered 15 Ajax Pencil Sharpeners at
 :$0.98; 6 doz. Circular Rubber Erasers at $.43; 24 No. 68
 :Spiral Stenographic Notebooks at $.075.
 :
 :Deliver the following order to Mrs. Beverly
 :Vinson at 390 West 135th Street, New York City: 2 lbs.
 :Temple Oranges at $.135; 3 lbs. Red Circle Coffee at
 :$.91; 2 lbs. Lima Beans at $.29.
 :
 :The Johnston Hardware Company, Toledo, Ohio has
 :ordered the following supplies: 15 Pruning Shears,
 :10-inch, at $.795; 24 Steel Rakes, 14-inch, at $.815;
 :16 Steel Spades, D-Handle, at $.935.

#                                                           ../orig/v.typ:1029
I:(6)
*:_V_R_L154
#                                                           ../orig/v.typ:1042
S:The backspace key is one of the most useful time-
 :saving devices on your typewriter. You use it to back
 :up a space, to darken a light impression, or to pivot.
 :To pivot means to type a line so that the last letter
 :is at the right margin or other chosen point.
 :
 :For example, if you want a date line to end at the
 :right margin, place the carriage with the printing point
 :indicator at the right margin and backspace once for
 :each stroke in the date line.
 :
 :The most important use of the backspace key is in
 :centering words or lines.

G:_V_E_V19
#------------------------------------------------------------------------------
# Lekce series V jump tables
#------------------------------------------------------------------------------
*:_V_E_V1
Q:Do you want to continue to lesson V2 [Y/N] ?
N:_V_MENU
G:_V_M_V2
*:_V_E_V2
Q:Do you want to continue to lesson V3 [Y/N] ?
N:_V_MENU
G:_V_M_V3
*:_V_E_V3
Q:Do you want to continue to lesson V4 [Y/N] ?
N:_V_MENU
G:_V_M_V4
*:_V_E_V4
Q:Do you want to continue to lesson V5 [Y/N] ?
N:_V_MENU
G:_V_M_V5
*:_V_E_V5
Q:Do you want to continue to lesson V6 [Y/N] ?
N:_V_MENU
G:_V_M_V6
*:_V_E_V6
Q:Do you want to continue to lesson V7 [Y/N] ?
N:_V_MENU
G:_V_M_V7
*:_V_E_V7
Q:Do you want to continue to lesson V8 [Y/N] ?
N:_V_MENU
G:_V_M_V8
*:_V_E_V8
Q:Do you want to continue to lesson V9 [Y/N] ?
N:_V_MENU
G:_V_M_V9
*:_V_E_V9
Q:Do you want to continue to lesson V10 [Y/N] ?
N:_V_MENU
G:_V_M_V10
*:_V_E_V10
Q:Do you want to continue to lesson V11 [Y/N] ?
N:_V_MENU
G:_V_M_V11
*:_V_E_V11
Q:Do you want to continue to lesson V12 [Y/N] ?
N:_V_MENU
G:_V_M_V12
*:_V_E_V12
Q:Do you want to continue to lesson V13 [Y/N] ?
N:_V_MENU
G:_V_M_V13
*:_V_E_V13
Q:Do you want to continue to lesson V14 [Y/N] ?
N:_V_MENU
G:_V_M_V14
*:_V_E_V14
Q:Do you want to continue to lesson V15 [Y/N] ?
N:_V_MENU
G:_V_M_V15
*:_V_E_V15
Q:Do you want to continue to lesson V16 [Y/N] ?
N:_V_MENU
G:_V_M_V16
*:_V_E_V16
Q:Do you want to continue to lesson V17 [Y/N] ?
N:_V_MENU
G:_V_M_V17
*:_V_E_V17
Q:Do you want to continue to lesson V18 [Y/N] ?
N:_V_MENU
G:_V_M_V18
*:_V_E_V18
Q:Do you want to continue to lesson V19 [Y/N] ?
N:_V_MENU
G:_V_M_V19
*:_V_E_V19
G:_V_MENU

*:_V_M_V1
B:                            Lekce V1
G:_V_S_V1
*:_V_M_V2
B:                            Lekce V2
G:_V_S_V2
*:_V_M_V3
B:                            Lekce V3
G:_V_S_V3
*:_V_M_V4
B:                            Lekce V4
G:_V_S_V4
*:_V_M_V5
B:                            Lekce V5
G:_V_S_V5
*:_V_M_V6
B:                            Lekce V6
G:_V_S_V6
*:_V_M_V7
B:                            Lekce V7
G:_V_S_V7
*:_V_M_V8
B:                            Lekce V8
G:_V_S_V8
*:_V_M_V9
B:                            Lekce V9
G:_V_S_V9
*:_V_M_V10
B:                           Lekce V10
G:_V_S_V10
*:_V_M_V11
B:                           Lekce V11
G:_V_S_V11
*:_V_M_V12
B:                           Lekce V12
G:_V_S_V12
*:_V_M_V13
B:                           Lekce V13
G:_V_S_V13
*:_V_M_V14
B:                           Lekce V14
G:_V_S_V14
*:_V_M_V15
B:                           Lekce V15
G:_V_S_V15
*:_V_M_V16
B:                           Lekce V16
G:_V_S_V16
*:_V_M_V17
B:                           Lekce V17
G:_V_S_V17
*:_V_M_V18
B:                           Lekce V18
G:_V_S_V18
*:_V_M_V19
B:                           Lekce V19
G:_V_S_V19
#------------------------------------------------------------------------------
# Lekce series V menu
#------------------------------------------------------------------------------
*:_V_MENU
M: UP=__SERIESMENU "Série lekcí V obsahuje těchto 19 lekcí"
 :_V_M_V1  "Lekce V1     R F U J"
 :_V_M_V2  "Lekce V2     D K E I"
 :_V_M_V3  "Lekce V3     T Y G H"
 :_V_M_V4  "Lekce V4     S L W O"
 :_V_M_V5  "Lekce V5     A ; Q P"
 :_V_M_V6  "Lekce V6     Shift Keys for Capitalization"
 :_V_M_V7  "Lekce V7     Shift Lock and :"
 :_V_M_V8  "Lekce V8     Introducing the Period"
 :_V_M_V9  "Lekce V9     V and M"
 :_V_M_V10 "Lekce V10    B and N"
 :_V_M_V11 "Lekce V11    C and Comma"
 :_V_M_V12 "Lekce V12    X and ."
 :_V_M_V13 "Lekce V13    Z and /"
 :_V_M_V14 "Lekce V14    The Question Mark"
 :_V_M_V15 "Lekce V15    1, 4, 5, 6, 7"
 :_V_M_V16 "Lekce V16    3 and 8"
 :_V_M_V17 "Lekce V17    2 and 9"
 :_V_M_V18 "Lekce V18    0 and the Hyphen"
 :_V_M_V19 "Lekce V19    Practise"
G:_V_EXIT
*:_V_EXIT
#------------------------------------------------------------------------------
# End of file v.typ
G:__SERIESMENU
#==============================================================================
#==============================================================================
*:__S_U_SERIES
# Start of file u.typ
# Typist v2.2 - improved typing tutor program for UNIX systems
# Copyright (C) 1998 Simon Baldwin (simonb@sco.com)
#
# Copyright (C) 2001 Hynek Hanke (hanke@volny.cz), Gnumaniacs.Org
#
# This was translated and modified to Czech by Hynek "0A4h" Hanke
# hanke@volny.cz / Gnumaniacs.Org
# Please report bugs to hanke@volny.cz, *not* to Simon!
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

#------------------------------------------------------------------------------
# Series U
#------------------------------------------------------------------------------
G:_U_MENU
*:_U_NO_MENU
#------------------------------------------------------------------------------
# Lekce U1
#------------------------------------------------------------------------------
*:U1
*:_U_S_U1
*:_U_R_L0
#                                                              ../orig/u.typ:5
T:			Vítejte v lekci U1
 :
 :Stále nevíte jak psát všemi deseti? Začneme od začátku procvičováním
 :základní řady

#                                                              ../orig/u.typ:6
I:(1) Zkuste si toto:
*:_U_R_L1
#                                                              ../orig/u.typ:8
D:lada kasa jak gasů gash sadů klad asa had klas jak
 :dala had kajak klas hlad gůgl slad kajak lakal lůka

G:_U_E_U1
#------------------------------------------------------------------------------
# Lekce U2
#------------------------------------------------------------------------------
*:U2
*:_U_S_U2

#                                                             ../orig/u.typ:13
I:(1) Teď zkusíme zapojit horní řadu:
*:_U_R_L3
#                                                             ../orig/u.typ:15
D:juj kik lol ůpů jyj
 :frf ded sws aqa ftf

#                                                             ../orig/u.typ:16
I:(2) Nějaká slova:
*:_U_R_L4
#                                                             ../orig/u.typ:20
D:kolik past juk suk dohad plod kolo hadu kilo
 :dali kos půda hup daly pik kajak popud dupat
 :duh gafas safik hugo podsada lihu fouk dup
 :neduh klasik tůhle ruka quasi wolf trepka
 :hasit kajak sekat drogy stopka udes sas
#                                                             ../orig/u.typ:21
I:(3) Nyní druhá ruka dolní řada:
*:_U_R_L5
#                                                             ../orig/u.typ:23
D:jmj k,k l.l ů-ů jnj
 :fvf dcd sxs aza fbf

I:(4) Nějaká slova:
*:_U_R_L6
D:test kuna polykat byt vykat xavier puzzle
 :rachot proboha, makat-narazit, vynikat, dost.
 :cinkat, spinkat tatar, wolf cimbal nikdo, mykat
 :kastovat mykolog trepka zavrhnout povlak.
 :ukazovat, ubylo, leknout se, původ-důvod
G:_U_E_U2

#------------------------------------------------------------------------------
# Lekce U3
#------------------------------------------------------------------------------
*:U3
*:_U_S_U3

#                                                             ../orig/u.typ:32
I:(1) Velká písmena píšeme stiskem opačného SHIFTU, než jakou
 :rukou tiskneme klávesu písmena.
*:_U_R_L8
#                                                             ../orig/u.typ:33
D:Kolik je zrovna dnes hodin?

#                                                             ../orig/u.typ:34
I:(2)
*:_U_R_L9
#                                                             ../orig/u.typ:35
D:Marie a Edward se rozhodli zůstat na statku.

#                                                             ../orig/u.typ:36
I:(3)
*:_U_R_L10
#                                                             ../orig/u.typ:37
D:Violeta, Helena, Dora, Jennie a Elsie zůstanou v Hotelu Commodore.

#                                                             ../orig/u.typ:38
I:(4)
*:_U_R_L11
#                                                             ../orig/u.typ:40
D:Bydlel jsem v Los Angeles, San Franciscu, Portlandu, Chicagu, St. Louis a
 :Denveru. Robert bydlel v Bostonu, Philadelphii, Jersey a v Utice.

#                                                             ../orig/u.typ:41
I:(5) Nyní diakritika.
*:_U_R_L12
#                                                             ../orig/u.typ:43
D:jýj kák líl ůéů jžj
 :fčf dšd sěs a+a fřf

#                                                             ../orig/u.typ:44
I:(6)Čísla a závorky
*:_U_R_L13
#                                                             ../orig/u.typ:46
D:j7j k8k l9l ů0ů j6j ů)ů
 :f4f d3d s2s a1a f5f ů(ů

#                                                             ../orig/u.typ:47
I:(7)
*:_U_R_L14
#                                                             ../orig/u.typ:52
S:Prosím zašlete mi pět kilo (přesně) té výbušniny.
 :Nezabývejte se tím (stejně byste to do 12 hodin nestihli).
 :Tenhle dům mě stál přesně 7,567,942 korun -- ale máme kde bydlet.
 :V této chvílí možná máte pouhých 10 slov za minutu nebo možná ještě
 :méně, ale jistě se brzy dostanete až ke 30ti, možná 40ti slov/m.

#                                                             ../orig/u.typ:53
I:(8)
*:_U_R_L15
#                                                             ../orig/u.typ:55
D:první 3tí 4tý 5tý
 :6tý 7mý 8mý 9tý 10tý

G:_U_E_U3
#------------------------------------------------------------------------------
# Lekce U4
#------------------------------------------------------------------------------
*:U4
*:_U_S_U4

#                                                             ../orig/u.typ:59
I:(1)
*:_U_R_L15A
#                                                             ../orig/u.typ:60
D:ůúů ů!ů ů/ů ůúů ů/ů ů!ů ů/ů ůúů ůpů ů.ů ů-ů

#                                                             ../orig/u.typ:61
I:(2) Anglická věta obsahující celou abecedu.
*:_U_R_L17
#                                                             ../orig/u.typ:62
D:The quick brown fox jumps over the lazy dog.

#                                                             ../orig/u.typ:63
I:(3)
*:_U_R_L18
#                                                             ../orig/u.typ:64
D:Předchozí úvodní věta ale neobsahovala diakritické
 :klávesy, byť je v češtině hojně používáme.

#                                                             ../orig/u.typ:65
I:(4)
*:_U_R_L19
#                                                             ../orig/u.typ:66
D:Ovidius: Nejméně zná člověk sám sebe.

#                                                             ../orig/u.typ:67
I:(5)
*:_U_R_L20
#                                                             ../orig/u.typ:69
D:1 2 3 4 5 6 7 8 9 10
 :2 pytlíky bonbonů stojí 40,00Kč, kolik stojí 15 pytlíků?

G:_U_E_U4
#------------------------------------------------------------------------------
# Lekce U5
#------------------------------------------------------------------------------
*:U5
*:_U_S_U5
*:_U_R_L21
#                                                             ../orig/u.typ:74
T:
 :		  (Cvičení na kombinace se s)

#                                                             ../orig/u.typ:75
I:(1)
*:_U_R_L22
#                                                             ../orig/u.typ:76
D:sas ses sis sos sus sc scr sh sk sl sm sn sp spl spr st str sw

#                                                             ../orig/u.typ:77
I:(2)
*:_U_R_L23
#                                                             ../orig/u.typ:80
D:socha sasko spíž samota sport soukolí spěch starý
 :sanita sisao sesadit systém suse stop sabotáž srocení
 :september savo stopa skončit stát sedět sesunout se

#                                                             ../orig/u.typ:81
I:(3)
*:_U_R_L24
#                                                             ../orig/u.typ:86
S:Sára se sama snaží systematicky studovat.
 :Sportem se posilníš a zesílíš.
 :Sestra Simony se správně rozhodla vyhnout se sobotnímu výletu.

#                                                             ../orig/u.typ:87
I:(4) Zkusíme anglický text. Nebudete potřebovat diakritickou řadu.
*:_U_R_L25
#                                                             ../orig/u.typ:91
S:    Safety first.  This slogan is well known.  Yet many care-
 :less people disregard it and so we have accidents. It is pos-
 :sible to avoid many types of accidents by a little forethought.
 :Don't be careless. Do your share to avoid mishaps.

G:_U_E_U5
#------------------------------------------------------------------------------
# Lekce U6
#------------------------------------------------------------------------------
*:U6
*:_U_S_U6
*:_U_R_L26
#                                                             ../orig/u.typ:96
T:
 :		(Procvičování kombinací s R)

#                                                             ../orig/u.typ:97
I:(1)
*:_U_R_L27
#                                                             ../orig/u.typ:98
D:rar rer rir ror rur br cr dr fr gr pr shr tr thr

#                                                             ../orig/u.typ:99
I:(2)
*:_U_R_L28
#                                                            ../orig/u.typ:102
D:rosa ráno rachot roura rámus rychtář rotoped
 :rotačák ropucha horor rumba rozmetat ráfek
 :triko práskač krpál mráz právě strkat hrad
 :grál, brko, krká, krákorat, navrčet se, prst.
 :vrána propast kráva rarášek tráva orat

#                                                            ../orig/u.typ:103
I:(3)
*:_U_R_L29
#                                                            ../orig/u.typ:108
S:Riskovat na rychlostních silnicích rychlou jízdou není rozumné.
 :Právo na vlastní rozhodnutí by měl obdržet každý normální občan
 :republiky. Prostor není pro vesmír determinující. Ranní rachot
 :budíku nás provází celým životem.

#                                                            ../orig/u.typ:109
I:(4)
*:_U_R_L30
#                                                            ../orig/u.typ:114
S:Provozovat krámek není jednoduché. V první řadě je nutné
 :rozmyslet si vše pečlivě dopředu: jak se bude prodávat,
 :kdy se bude prodávat, kdo bude rozvážet zboží, kdo bude
 :kromě vás ještě pracovat a na jaký úvazek. Po tak
 :podrobném promýšlení často dojdete k závěru, že existuje
 :miliarda snazších možností, jak si vydělávat. Asi
 :tak jako u čehokoliv jiného.

G:_U_E_U6
#------------------------------------------------------------------------------
# Lekce U7
#------------------------------------------------------------------------------
*:U7
*:_U_S_U7
*:_U_R_L31
#                                                            ../orig/u.typ:119
T:
 :		(Cvičení na kombinace s L)


#                                                            ../orig/u.typ:120
I:(1)
*:_U_R_L32
#                                                            ../orig/u.typ:121
D:lal lel lil lol lul ly bl cl fl gl pl sl

#                                                            ../orig/u.typ:122
I:(2)
*:_U_R_L33
#                                                            ../orig/u.typ:125
D:lol rofl klokan láska léno lávka lpět loskuták
 :laso lano larva lež labuť lavor láva lúka louže
 :pléno klání bolest polstr lustr mléko bláhový

#                                                            ../orig/u.typ:126
I:(3)
*:_U_R_L34
#                                                            ../orig/u.typ:131
S:Lada maloval pěkné a líbivé malby.
 :Loskutáka asi v lese nenalezneme.
 :Lára ležela na lavičce a na slunci se opalovala.
 :Leze leze po železe, nedá pokoj, až tam vleze.

#                                                            ../orig/u.typ:132
I:(4) Zkuste si opsat tento text:
*:_U_R_L35
#                                                            ../orig/u.typ:138
S:    Play is most important to a child.  All of us must play
 :a little. All work and no play makes Jack a dull boy, the
 :old saying goes. Play affords relaxation.  Some people claim
 :their work is so enthralling that they do not need to play.
 :Psychologists say that the stress of modern life demands that
 :all adults have some hobby away from their daily pursuit.

G:_U_E_U7
#------------------------------------------------------------------------------
# Lekce U8
#------------------------------------------------------------------------------
*:U8
*:_U_S_U8
*:_U_R_L36
#                                                            ../orig/u.typ:143
T:
 :		(Cvičení na kombinace s D a T )

#                                                            ../orig/u.typ:144
I:(1)
*:_U_R_L37
#                                                            ../orig/u.typ:146
D:dad ded did dod dud dr ld nd rd
 :tat tet tit tot tut th tr ct ft lt nt pt st

#                                                            ../orig/u.typ:147
I:(2)
*:_U_R_L38
#                                                            ../orig/u.typ:151
D:dost dieta test dar debata tamtam touha
 :zadostiučinění trest databanka dotovat
 :teda dorůstat dabovat oddenek dok téma
 :přírůstek nedopatření přístavek dostatek

#                                                            ../orig/u.typ:152
I:(3)
*:_U_R_L39
#                                                            ../orig/u.typ:157
S:Dal Daliborovi dostatečnou dávku žita.
 :Tetování je takové zvláštní umění.
 :Táborníci se dostavili na každodenní rozcvičku.
 :Touha otestovat život závodníka formule 1 drží
 :v mládí snad každého chlapce.

#                                                            ../orig/u.typ:158
I:(4)
*:_U_R_L40
#                                                            ../orig/u.typ:164
D:Takové tahání taháku při písemce z dějepisu je docela
 :dobrý test odvahy. Mnoho nešťastníků bývá odhaleno
 :a podrobeno nemilosrdnému trestu ve formě odevzdání
 :nedokončené práce. Většinou to končí velmi zlou známkou.

G:_U_E_U8
#------------------------------------------------------------------------------
# Lekce U9
#------------------------------------------------------------------------------
*:U9
*:_U_S_U9
*:_U_R_L41
#                                                            ../orig/u.typ:169
T:
 :		(Cvičení na M-N kombinace)

#                                                            ../orig/u.typ:170
I:(1)
*:_U_R_L42
#                                                            ../orig/u.typ:172
D:am em im om um mb mp cement
 :an en in on un ng nk

#                                                            ../orig/u.typ:173
I:(2)
*:_U_R_L43
#                                                            ../orig/u.typ:178
D:mistr nitrát nano nitroglicerin major miss
 :málo nic mříže místo nános mnoho milý rameno
 :milost manufaktura čmuchat usnadnit množit
 :nečas nános mňoukat nával něco mísa mamut

#                                                            ../orig/u.typ:179
I:(3)
*:_U_R_L44
#                                                            ../orig/u.typ:184
S:Není mnoho mamutů, kteří by se dožili naší doby.
 :Přesto tací monstrózní tvorové ještě po zemi
 :běhají. Nevěříte? Například můj dědeček. Má
 :téměř několik set kilogramů a při chůzi vydává
 :dunivý dupot. Ani jediný člověk z náměstí se
 :neubrání bázlivému pohledu.

G:_U_E_U9
#------------------------------------------------------------------------------
# Lekce U10
#------------------------------------------------------------------------------
*:U10
*:_U_S_U10
*:_U_R_L46
#                                                            ../orig/u.typ:195
T:
 :		(Kombinace s diakritickými písmeny)

#                                                            ../orig/u.typ:196
I:(1)
*:_U_R_L47
#                                                            ../orig/u.typ:198
D:ě š č ř ž ý á í é
 :é í á ý ž ř č š ě
 :má ří žá éš čí ké hý
 :eě sš cč rř zž yý aá ií eé
 :ď ť ň ó Ď Ť Ň Ó Ú Í É Ž


#                                                            ../orig/u.typ:199
I:(2)
*:_U_R_L48
#                                                            ../orig/u.typ:204
D:šišlat číča řeřavý být stát pískat sémě
 :žížala čača řád mýdlo čpavek žižinka
 :tětiva příšlap pojď výšiny týrat mávat
 :zpěv pusť můra úval tónický bázeň

#                                                            ../orig/u.typ:205
I:(3)
*:_U_R_L49
#                                                            ../orig/u.typ:210
S:Žížala pošeptala šnekovi žhavé novinky ze světa.
 :Býval bych to byl dokázal, ale zákony přitažlivosti mě přemohly.
 :Žvýkačka nepatří ve škole do úst.
 :Nad městem se začalo smrákat a všichni již mířili domů.

G:_U_E_U10
#------------------------------------------------------------------------------
# Lekce U11
#------------------------------------------------------------------------------
*:U11
*:_U_S_U11
*:_U_R_L51
#                                                            ../orig/u.typ:221
T:
 :		(Procvičování na čísla)

#                                                            ../orig/u.typ:222
I:(1) Nepodvádějte s numerickou klávesnicí!
*:_U_R_L52
#                                                            ../orig/u.typ:224
D:73 jablek, 25 hrušek, 1 kilo mouky, 4 lžičky cukru
 :v 15:20 87,50 Kč 27.září 2007 1492 1512 1989

#                                                            ../orig/u.typ:225
I:(2)
*:_U_R_L53
#                                                            ../orig/u.typ:229
D:Pošlete balík na adresu: Ke Komořanům 2438/5-1.
 :Nezlobte se, ale v 14:30 mám důležitou schůzi,
 :nešlo by to třeba v pátek 25. v 13:00?
 :Roku 3457 byla v oblasti bývalé Evropy nalezena pravá tištěná
 :kniha, která se uchovala po událostech 2471 pouze
 :zázrakem.

#                                                            ../orig/u.typ:230
I:(3)
*:_U_R_L54
#                                                            ../orig/u.typ:235
S:Tomovi je 17 let a Markétě 26. Markéta je tedy
 :o 9 let starší. Markéta svého bráchu Toma vozí
 :v autě do sousedního města do školy
 :od svých 18ti, kdy získala řidičák, tedy již 8 let.
 :Tom si plánuje pořídit řidičák co nejdříve, ale neví
 :kde sehnat 500 000 na nové auto. Možná by si
 :mohl půjčit, ale při úroku 7% by to pro něj nebylo
 :výhodné.

G:_U_E_U11
#------------------------------------------------------------------------------
# Lekce series U jump tables
#------------------------------------------------------------------------------
*:_U_E_U1
Q:Chcete pokračovat do lekce U2 [Y(ano)/N(ne)] ?
N:_U_MENU
G:_U_M_U2
*:_U_E_U2
Q:Chcete pokračovat do lekce U3 [Y(ano)/N(ne)] ?
N:_U_MENU
G:_U_M_U3
*:_U_E_U3
Q:Chcete pokračovat do lekce U4 [Y(ano)/N(ne)] ?
N:_U_MENU
G:_U_M_U4
*:_U_E_U4
Q:Chcete pokračovat do lekce U5 [Y(ano)/N(ne)] ?
N:_U_MENU
G:_U_M_U5
*:_U_E_U5
Q:Chcete pokračovat do lekce U6 [Y(ano)/N(ne)] ?
N:_U_MENU
G:_U_M_U6
*:_U_E_U6
Q:Chcete pokračovat do lekce U7 [Y(ano)/N(ne)] ?
N:_U_MENU
G:_U_M_U7
*:_U_E_U7
Q:Chcete pokračovat do lekce U8 [Y(ano)/N(ne)] ?
N:_U_MENU
G:_U_M_U8
*:_U_E_U8
Q:Chcete pokračovat do lekce U9 [Y(ano)/N(ne)] ?
N:_U_MENU
G:_U_M_U9
*:_U_E_U9
Q:Chcete pokračovat do lekce U10 [Y(ano)/N(ne)] ?
N:_U_MENU
G:_U_M_U10
*:_U_E_U10
Q:Chcete pokračovat do lekce U11 [Y(ano)/N(ne)] ?
N:_U_MENU
G:_U_M_U11
*:_U_E_U11

*:_U_M_U1
B:                            Lekce U1
G:_U_S_U1
*:_U_M_U2
B:                            Lekce U2
G:_U_S_U2
*:_U_M_U3
B:                            Lekce U3
G:_U_S_U3
*:_U_M_U4
B:                            Lekce U4
G:_U_S_U4
*:_U_M_U5
B:                            Lekce U5
G:_U_S_U5
*:_U_M_U6
B:                            Lekce U6
G:_U_S_U6
*:_U_M_U7
B:                            Lekce U7
G:_U_S_U7
*:_U_M_U8
B:                            Lekce U8
G:_U_S_U8
*:_U_M_U9
B:                            Lekce U9
G:_U_S_U9
*:_U_M_U10
B:                           Lekce U10
G:_U_S_U10
*:_U_M_U11
B:                           Lekce U11
G:_U_S_U11
#------------------------------------------------------------------------------
# Lekce series U menu
#------------------------------------------------------------------------------
*:_U_MENU
M: UP=__SERIESMENU "Série U obsahuje těchto 11 lekcí"
 :_U_M_U1  "Lekce U1     Základní řada"
 :_U_M_U2  "Lekce U2     Ostatní písmena"
 :_U_M_U3  "Lekce U3     Diakritika a čísla"
 :_U_M_U4  "Lekce U4     Procvičování"
 :_U_M_U5  "Lekce U5     Cvičení na kombinace s S"
 :_U_M_U6  "Lekce U6     Cvičení na kombinace s R"
 :_U_M_U7  "Lekce U7     Cvičení na kombinace s L"
 :_U_M_U8  "Lekce U8     Cvičení na kombinace s D-T"
 :_U_M_U9  "Lekce U9     Cvičení na kombinace s M-N"
 :_U_M_U10 "Lekce U10    Cvičení na diakritiku"
 :_U_M_U11 "Lekce U11    Cvičení na čísla"
*:_U_EXIT
#------------------------------------------------------------------------------
# End of file u.typ
G:__SERIESMENU
#==============================================================================
#==============================================================================
*:__S_D_SERIES
# Start of file d.typ
# Typist v2.2 - improved typing tutor program for UNIX systems
# Copyright (C) 1998 Simon Baldwin (simonb@sco.com)
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

#------------------------------------------------------------------------------
# Series D
#------------------------------------------------------------------------------
G:_D_MENU
*:_D_NO_MENU
#------------------------------------------------------------------------------
# Lekce D1
#------------------------------------------------------------------------------
*:D1
*:_D_S_D1
*:_D_R_L0
#                                                             ../orig/d.typ:20
T:			Welcome to the Dvorak Course
 :
 :This course has been planned for beginners as well as experienced typists.
 :If you are a beginner learning to type on the American Simplified Keyboard
 :(the Dvorak keyboard), you will find this keyboard easier to learn than
 :the QWERTY (Sholes) keyboard.
 :
 :This is because the ASK has been scientifically designed to minimize cumulative
 :finger motion while typing English. The ten letters on the Home Row
 :(A, O, E, U, I, D, H, T, N, and S) make up about 70% of all keystrokes.
 :These ten letters alone can form over 3000 words. Needless to say, having
 :these keys in the home row facilitates both speed and accuracy.
 :
 :If you are already an experienced typist on the Sholes keyboard, don't despair:
 :you won't have to unlearn everything you know. Your basic typing dexterity
 :remains with you, regardless of the keyboard layout. Learning the Dvorak
 :keyboard is like learning to "play on a new surface", as a tennis player must
 :learn to adjust to grass court or hard court when she has been accustomed to
 :playing on a clay court.
Q: Pro pokračování stiskněte Y, F12 pro konec.
N:_D_R_L0

*:_D_R_L1
#                                                             ../orig/d.typ:25
T:			General Instructions
 :
 :The fingers of the left hand should be placed over the A-key, the O-key,
 :the E-key, and the U-key. Similarly, the fingers of the right hand should be
 :placed over the H-key, the T-key, the N-key, and the S-key.
Q: Pro pokračování stiskněte Y, F12 pro konec.
N:_D_R_L1

#                                                             ../orig/d.typ:26
I:(1) Home Row Exercises
*:_D_R_L2
#                                                             ../orig/d.typ:28
D:aoeu ueoa aoeui snth htns snthd uihd uihd
 :asonetuhid asonetuhid dihutenosa dihutenosa
Q:Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L2

#                                                             ../orig/d.typ:29
I:(2)
*:_D_R_L3
#                                                             ../orig/d.typ:30
D:a s o n e t u h i d a s o n e t u h i d
Q:Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L3

#                                                             ../orig/d.typ:31
I:(3)
*:_D_R_L4
#                                                             ../orig/d.typ:32
D:d i h u t e n o s a d i h u t e n o s a
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L4

#                                                             ../orig/d.typ:33
I:(4)
*:_D_R_L5
#                                                             ../orig/d.typ:35
D:as an at ah ad aa ao ae au ai os on ot oh od oi ou oe oo oa
 :es en et eh ed ea eo ee eu ei us un ut uh ud ui uu ue uo ua
Q:Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L5

#                                                             ../orig/d.typ:36
I:(5)
*:_D_R_L6
#                                                             ../orig/d.typ:38
D:his hat is an aid in the hot sun
 :in his sad sod hut he sat on his hen
Q:Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L6

#                                                             ../orig/d.typ:39
I:(6)
*:_D_R_L7
#                                                             ../orig/d.typ:41
D:sue did not use his hoe and tin hat
 :dan did not see the dot on his tie as he hid his tan hat
Q:Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L7

#                                                             ../orig/d.typ:42
I:(7)
*:_D_R_L8
#                                                             ../orig/d.typ:46
D:ada add ado aha aid ann dad dan dee den did die din don dot dud
 :due dun duo eda end had has hat hen hid his hit hod hoe hot hue
 :hut ian ida inn ion its nat ned net nod not nun nut odd ode out
 :sat sit sod son sot sun tan tat tee ten tho tit toe ton too tot
Q:Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L8

#                                                             ../orig/d.typ:47
I:(8)
*:_D_R_L9
#                                                             ../orig/d.typ:48
D:i do as i do and the end is not as sad as the one sid had
Q:Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L9

G:_D_E_D1
#------------------------------------------------------------------------------
# Lekce D2
#------------------------------------------------------------------------------
*:D2
*:_D_S_D2
*:_D_R_L10
#                                                             ../orig/d.typ:55
T:                   Learning the Shift Key
 :
 :To integrate the shift key rhythmically in your practice, a capital letter
 :should take three beats: 1--press the shift key opposite the hand to press
 :the letter; 2--press the letter; 3--release the shift key.
Q:Pro pokračování stiskněte Y, F12 pro konec.
N:_D_R_L10

#                                                             ../orig/d.typ:56
I:(1) Review
*:_D_R_L11
#                                                             ../orig/d.typ:57
D:een ent est ett hin hou ith ion oth sen tha thi tio tte thu
Q:Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L11

#                                                             ../orig/d.typ:58
I:(2)
*:_D_R_L12
#                                                             ../orig/d.typ:60
D:Ada An Ana Ann Dad Dan Dee Ed Eta
 :Dan Nan Nat Ned Sid Sue Tad Ted Tod
Q:Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L12

#                                                             ../orig/d.typ:61
I:(3)
*:_D_R_L13
#                                                             ../orig/d.typ:63
D:The sad tots sat on a tan seat in his neat tent and ate ten nuts
 :On his date Otis had a thin suit and no tint on his shoes
Q:Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L13

#                                                             ../orig/d.typ:64
I:(4)
*:_D_R_L14
#                                                             ../orig/d.typ:66
D:Enos eats a thin hash diet in a hued dish as he sits on an odd seat
 :Dad does not eat suet  He had seen Sue dent his auto
Q:Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L14

#                                                             ../orig/d.typ:67
I:(5)
*:_D_R_L15
#                                                             ../orig/d.typ:70
D:ad an de di ed en es ie in ne un ate dis ess eat ied ine
 :ist ite nee nes non nus ses tes tis usi ante anti ates
 :eous eats ines ions ious ists itas itis ness sion tion
Q:Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L15

#                                                             ../orig/d.typ:71
I:(6)
*:_D_R_L16
#                                                             ../orig/d.typ:73
D:Adna Anna Anne Dana Dead Edie Edna Enid Etta Heda
 :Nate Nina Neta Nona Odie Ohio Otto Stan Tess Thad Theo
Q:Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L16

#                                                             ../orig/d.typ:74
I:(7)
*:_D_R_L17
#                                                             ../orig/d.typ:79
D:adds aids ante ants aunt dead deed dens died dies dine dins dodo
 :heed hens hied hind hint hiss hist hits hods hoed hoes hone hood
 :none noon noun nuns oats odds odes ones sane sash sate seas seed
 :sees sent sets shad shed shin shot side sine sins sons sued suns
 :tide tine tins toad tone toss tote tout tune undo unit used uses
Q:Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L17

G:_D_E_D2
#------------------------------------------------------------------------------
# Lekce D3
#------------------------------------------------------------------------------
*:D3
*:_D_S_D3
#                                                             ../orig/d.typ:89
T:                   Home Row and the Period
 :
 :The period is above the E-finger. Note that the end of a sentence is
 :always followed by two spaces; in abbreviations, it is followed by one
 :space.
Q: Pro pokračování stiskněte Y, F12 pro konec.
#
I:(1)
*:_D_R_L18
#                                                             ../orig/d.typ:91
D:e. e.  e.  e.  a.  s.  o.  n.  e.  t.  u.  h.  i.  d.  a.  a.
 :h. u.  a.  i.  o.  n.  s.  d.  t.  e.  h.  o.  u.  i.  s.  a.
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L18

#                                                             ../orig/d.typ:92
I:(2)
*:_D_R_L19
#                                                             ../orig/d.typ:96
D:anno athe atio atte ause diti enon esen enti este
 :ethe esti ette hese hous hout iate iend ines inst
 :ith itio into ndin ness nnot noth ntio onth osed
 :thei thes tion tten nest nude unti usin tand tate
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L19

#                                                             ../orig/d.typ:97
I:(3)
*:_D_R_L20
#                                                            ../orig/d.typ:100
D:Adana Andie Annie Aonia Audie Denis Diana Dinah
 :Donna Duane Edith Ethan India Susan Susie Thane
 :Adana. Andie.  Annie.  Aonia.  Audie.  Denis.  Diana.  Dinah.
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L20

#                                                            ../orig/d.typ:101
I:(4)
*:_D_R_L21
#                                                            ../orig/d.typ:105
D:In the house Adana dined in haste on toast and dates.
 :Sated as she had eaten she noted the sheen on the dunes
 :and the shade in the sheds. She hates to see an idiot
 :stand and shoot his tenth doe in the dense heath.
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L21

#                                                            ../orig/d.typ:106
I:(5)
*:_D_R_L22
#                                                            ../orig/d.typ:108
D:An onion heats and stuns stout noses and sends hands
 :to douse teeth and hoist suede hoods onto heads.
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L22

#                                                            ../orig/d.typ:109
I:(6)
*:_D_R_L23
#                                                            ../orig/d.typ:111
D:eates eousness eousnesses esses iates iests iness inesses
 :iousness iousnesses iohness iohnesses itions nesses ousness
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L23

G:_D_E_D3
#------------------------------------------------------------------------------
# Lekce D4
#------------------------------------------------------------------------------
*:D4
*:_D_S_D4
*:_D_R_L24
#                                                            ../orig/d.typ:116
T:                   Upper Row and Essential Punctuation
Q: Pro pokračování stiskněte Y, F12 pro konec.
N:_D_R_L24

#                                                            ../orig/d.typ:117
I:(1)
*:_D_R_L25
#                                                            ../orig/d.typ:119
D:tctc upup hghg o,o, nrnr a/a/ slsl a?a? s-s- s--- s---- ----
 :tctc upup hghg, hfhf uyuy, nrnr, slsl, s---, s-s-, a/a/-
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L25

#                                                            ../orig/d.typ:120
I:(2)
*:_D_R_L26
#                                                            ../orig/d.typ:122
D:tctc/ upup/ hghg/ uyuy/ hfhf/ nrnr/ slsl/ tctc/ hfhf/ hghg/
 :tctc? upup? hghg? uyuy? nrnr? slsl? hfhf? upup- hghg- tctc-
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L26

#                                                            ../orig/d.typ:123
I:(3)
*:_D_R_L27
#                                                            ../orig/d.typ:125
D:Al el if of or up Al el if of or up
 :go la lo pa pi ye go la lo pa pi ye
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L27

#                                                            ../orig/d.typ:126
I:(4)
*:_D_R_L28
#                                                            ../orig/d.typ:130
D:Can pa go aft and lie on our old cot?
 :The shy ape put on a red hat and ran off the lot.
 :For a top fee, her act is to hop in, lie on the rug, pat her
 :pet cat, fit a fur on her ear, get her fan, and run off.
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L28

#                                                            ../orig/d.typ:131
I:(5)
*:_D_R_L29
#                                                            ../orig/d.typ:134
D:ago ail ale all apt arc are art cur cut dig dip dop
 :dry dug eel egg ego fag fig fin fir fly fog for fro
 :fry gag gap gas gay gin gip God goo gun hag hay hep
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L29

G:_D_E_D4
#------------------------------------------------------------------------------
# Lekce D5
#------------------------------------------------------------------------------
*:D5
*:_D_S_D5
#                                                            ../orig/d.typ:138
I:(1) Review
*:_D_R_L30
#                                                            ../orig/d.typ:140
D:The left road can lead the lads and lady to good lots near
 :your land. The sale of pure gold is held at your door.
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L30

#                                                            ../orig/d.typ:141
I:(2)
*:_D_R_L31
#                                                            ../orig/d.typ:144
D:You held no fear of loss for a year. On each trip to your
 :shop he paid in cash for the caps, fish, cups, pans, fuel,
 :logs, peas, ales, rice and fats you sold.
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L31

#                                                            ../orig/d.typ:145
I:(3)
*:_D_R_L32
#                                                            ../orig/d.typ:147
D:It is a fact that a slap on the face can hurt. The poor
 :apes feel free to find a sure sort of life in the dale.
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L32

#                                                            ../orig/d.typ:148
I:(4)
*:_D_R_L33
#                                                            ../orig/d.typ:152
D:aces acts ages ails airs also arcs call caps card cold cops
 :else errs eyes face fair fall fare fate feat feel feet fell
 :gate gets gift gigs glad goat goes gone gosh gray grey gull
 :hole hope hops huff hull ills ires last late lest lets lies
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L33

#                                                            ../orig/d.typ:153
I:(5)
*:_D_R_L34
#                                                            ../orig/d.typ:157
D:pear pert pest pets pits plop pops post pots puns puts rate real
 :ride rids ripe rips rope rote rues ruff runs runt rush rust ruts
 :span spat spin spit spot spun step stop tags tall tape taps tars
 :ugly upon ruge user yard year yeas yell yelp yips yoga yule your
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L34

G:_D_E_D5
#------------------------------------------------------------------------------
# Lekce D6
#------------------------------------------------------------------------------
*:D6
*:_D_S_D6
*:_D_R_L35
#                                                            ../orig/d.typ:162
T:		Learning the Lower Row
Q: Pro pokračování stiskněte Y, F12 pro konec.
N:_D_R_L35

#                                                            ../orig/d.typ:163
I:(1)
*:_D_R_L36
#                                                            ../orig/d.typ:164
D:a'sz oqnv ukhm uxhb a"o- oqnv ejtw a'sz uxhb ukkk ukhm a's-
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L36

#                                                            ../orig/d.typ:165
I:(2)
*:_D_R_L37
#                                                            ../orig/d.typ:166
D:uk sz-a' tw nv ej hm uk a" hb oq uk a' nv hm a" oq sz tw ej
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L37

#                                                            ../orig/d.typ:167
I:(3)
*:_D_R_L38
#                                                            ../orig/d.typ:170
D:ale any are ary augh aught ave ay aye ec ece eco el er ere ery ex
 :exa exe far fer fir for ify igh ight il ile ill ily ire aze ize
 :la lly ly my ny ome or ore ough ought ould our re rec sive tive
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L38

#                                                            ../orig/d.typ:171
I:(4)
*:_D_R_L39
#                                                            ../orig/d.typ:174
D:I owe him a bun, a ham, ink, a bed and a job.
 :Sam was mad at his own new ox in the bin.
 :At the zoo, the wee, bad boa in a box bit Tom, Bob and me.
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L39

#                                                            ../orig/d.typ:175
I:(5)
*:_D_R_L40
#                                                            ../orig/d.typ:179
D:am ax be ma me ox oz we adz awe ban but eke eve haw hem
 :hub jab jam jaw jet jib job Joe jot jut kid kin kit man
 :mat Max nab new nub now own quo saw sox sum van vex vie
 :vow wan who win won yen you zax
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L40

G:_D_E_D6
#------------------------------------------------------------------------------
# Lekce D7
#------------------------------------------------------------------------------
*:D7
*:_D_S_D7
#                                                            ../orig/d.typ:183
I:(1)
*:_D_R_L41
#                                                            ../orig/d.typ:184
D:In a daze the band hums the same new tune as they zoom down the exit.
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L41

#                                                            ../orig/d.typ:185
I:(2)
*:_D_R_L42
#                                                            ../orig/d.typ:187
D:Next time, I must have a town home, with a book and a vast tome,
 :bees, oxen, hams in the oven, rows of beans, the wind and a view.
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L42

#                                                            ../orig/d.typ:188
I:(3)
*:_D_R_L43
#                                                            ../orig/d.typ:190
D:I know six men wait to put down their axes. They want to quit
 :their jobs when the job zone size is too wide.
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L43

#                                                            ../orig/d.typ:191
I:(4)
*:_D_R_L44
#                                                            ../orig/d.typ:194
D:ahem aims ajax akin asks atom axis bans bath beak beck been
 :hoax husk inks item jabs jade jamb Java jazz Jean jest jinx
 :knot Knox made maid mail mate mean meet mend mess mind mine
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L44

#                                                            ../orig/d.typ:195
I:(5)
*:_D_R_L45
#                                                            ../orig/d.typ:199
D:miss mist most musk must nabs news next nibs numb owed owes
 :quiz save saws seem sews skat skew skid skin some sums take
 :vend vent vest veto vise void vote wand weed week wend wins
 :whet whit whiz whom wish wont zebu zest zinc Zion zone zulu
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L45

G:_D_E_D7
#------------------------------------------------------------------------------
# Lekce D8
#------------------------------------------------------------------------------
*:D8
*:_D_S_D8
#                                                            ../orig/d.typ:203
I:(1)
*:_D_R_L46
#                                                            ../orig/d.typ:204
D:He asked about those zebra waits in his beans.
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L46

#                                                            ../orig/d.typ:205
I:(2)
*:_D_R_L47
#                                                            ../orig/d.typ:206
D:It seems that in a month taxes on homes have taken all we saved.
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L47

#                                                            ../orig/d.typ:207
I:(3)
*:_D_R_L48
#                                                            ../orig/d.typ:209
D:John Smith makes a quiet visit to the bases in the winds and
 :weeds on the mound.
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L48

#                                                            ../orig/d.typ:210
I:(4)
*:_D_R_L49
#                                                            ../orig/d.typ:214
D:ovals ovoid oxide quake queen quest quite quits quote saves seams
 :skein skink skunk sweat takes taken taxed teams teems thank think
 :thumb times towns ukase vaunt vests vises visit vista vivid vixen
 :waits wands wants wends whine white whose zebus zoned zones zulus
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L49

G:_D_E_D8
#------------------------------------------------------------------------------
# Lekce D9
#------------------------------------------------------------------------------
*:D9
*:_D_S_D9
#                                                            ../orig/d.typ:218
I:(1)
*:_D_R_L50
#                                                            ../orig/d.typ:219
D:hghm hbfb upxp uxyx twcw ej.j nvrv oq,q szlz a'?' a"/"
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L50

#                                                            ../orig/d.typ:220
I:Again...
*:_D_R_L51
#                                                            ../orig/d.typ:221
D:hghm hbfb upxp uxyx twcw ej.j nvrv oq,q szlz a'?' a"/"
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L51

#                                                            ../orig/d.typ:222
I:(2)
*:_D_R_L52
#                                                            ../orig/d.typ:223
D:gm mg fb bf pk kp yx xy cw wc .j j. rv vr ,q q, lz zl
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L52

#                                                            ../orig/d.typ:224
I:(3)
*:_D_R_L53
#                                                            ../orig/d.typ:225
D:My big boy may buy a gem at the labs by the bay.
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L53

#                                                            ../orig/d.typ:226
I:(4)
*:_D_R_L54
#                                                            ../orig/d.typ:228
D:Mort awes boys with the way he can ward off a blow, kill
 :elks and game, row a yawl, or ram awls into bars.
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L54

#                                                            ../orig/d.typ:229
I:(5)
*:_D_R_L55
#                                                            ../orig/d.typ:232
D:ah Al am an as at ax ba be do ed eh el go
 :ha he hi ho if in is it Jo la no ma me no
 :of oh on or ox pa pi Si so to up us we ye
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L55

G:_D_E_D9
#------------------------------------------------------------------------------
# Lekce D10
#------------------------------------------------------------------------------
*:D10
*:_D_S_D10
#                                                            ../orig/d.typ:236
I:(1)
*:_D_R_L56
#                                                            ../orig/d.typ:238
D:In barns on farms chicks, boars, veals, bucks and stock might
 :enjoy and value an extra quart of water daily.
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L56

#                                                            ../orig/d.typ:239
I:(2)
*:_D_R_L57
#                                                            ../orig/d.typ:241
D:Do zebras roam the miles of bleak velds which cover parts of the
 :world while packs of brown bears and wart hogs prowl in the woods?
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L57

#                                                            ../orig/d.typ:242
I:(3)
*:_D_R_L58
#                                                            ../orig/d.typ:246
D:Some folks claim to favor poems and rhyme, others can wring equal
 :cheer and worth from words and quest and seize all books. Still
 :others amply quell their needs with vocal music and seek all
 :works on voice.
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L58

#                                                            ../orig/d.typ:247
I:(4)
*:_D_R_L59
#                                                            ../orig/d.typ:250
D:To begin to use wrong verbs among boors and bores may be
 :a severe error even if the whole group seems to think
 :that exact terms mean less than is normal for them.
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L59

#                                                            ../orig/d.typ:251
I:(5)
*:_D_R_L60
#                                                            ../orig/d.typ:255
D:allow among avail awful Aztec azure backs balls began being belie
 :bells bills black blank bored borne bring can't chalk champ charm
 :check cheek chick chink comes Czech every evict exalt excel exert
 :exile expel exult Felix folks gable gauze gives glaze gleam globe
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L60

#                                                            ../orig/d.typ:256
I:(6)
*:_D_R_L61
#                                                            ../orig/d.typ:260
D:verge verse verve vetch vigil vigor viola virus vital vogue voile
 :vouch vowel vying walks walls wards warts whack whale wharf wheat
 :wheel whelp where which whiff while whirl whole wired wires words
 :world worth would write wrong wrote yards yokes yoks zippy zombie
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L61

G:_D_E_D10
#------------------------------------------------------------------------------
# Lekce D11
#------------------------------------------------------------------------------
*:D11
*:_D_S_D11
#                                                            ../orig/d.typ:264
I:(1)
*:_D_R_L62
#                                                            ../orig/d.typ:266
D:For a meal we lack a room, milk in mugs, warm pork, veal
 :in the oven and cake.
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L62

#                                                            ../orig/d.typ:267
I:(2)
*:_D_R_L63
#                                                            ../orig/d.typ:269
D:Mike and Milt were grim, not calm, when Mort came to warn them that
 :the well worn ramp over to the mill was too wet for our mile walk.
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L63

#                                                            ../orig/d.typ:270
I:(3)
*:_D_R_L64
#                                                            ../orig/d.typ:272
D:Walt may quip and quote with zeal about too much work, but I
 :saw him melt and mourn about his love for his lost wife.
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L64

#                                                            ../orig/d.typ:273
I:(4)
*:_D_R_L65
#                                                            ../orig/d.typ:274
D:The pick of wool from rams can make very soft warm garb.
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L65

#                                                            ../orig/d.typ:275
I:(5)
*:_D_R_L66
#                                                            ../orig/d.typ:277
D:For his meal the busy bird will use his bill or beak in many
 :ways to peck at or ably to pick up a worm.
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L66

#                                                            ../orig/d.typ:278
I:(6)
*:_D_R_L67
#                                                            ../orig/d.typ:280
D:Owls on the wing may move away with limp easy grace or they
 :may sit on a wire and look ever so wise.
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L67

#                                                            ../orig/d.typ:281
I:(7)
*:_D_R_L68
#                                                            ../orig/d.typ:283
D:The word or term--prop, mall, king, mark, romp, lock or link--
 :can vary in what it may mean.
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L68

#                                                            ../orig/d.typ:284
I:(8)
*:_D_R_L69
#                                                            ../orig/d.typ:288
D:helm herb hock holy jeep jeer jell jerk John jolt jump jury
 :kale keel kelp kilt lack laws leak leek levy lick like lime
 :limp link live love luck lump lynx mail many mill more much
 :okra oval pack peak peck peek phew puck ramp rime skip talk
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L69

#                                                            ../orig/d.typ:289
I:(9)
*:_D_R_L70
#                                                            ../orig/d.typ:292
D:puck ramp rime skip talk vail vale vary veal veer veld verb vial vice
 :volk walk ware warm warp wars wart ways weal wear well will tilt wire
 :whey whim whip whir wore work worm worn yawn yolk zany zero zinc zing
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L70

G:_D_E_D11
#------------------------------------------------------------------------------
# Lekce D12
#------------------------------------------------------------------------------
*:D12
*:_D_S_D12
#                                                            ../orig/d.typ:296
I:(1)
*:_D_R_L71
#                                                            ../orig/d.typ:298
D:In barns on farms chicks, bears, veals, bucks and stock might
 :enjoy and value an extra quart of water daily.
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L71

#                                                            ../orig/d.typ:299
I:(2)
*:_D_R_L72
#                                                            ../orig/d.typ:301
D:Quick quips, awful quotes and queer talks never quite solve
 :the wants of a very small child.
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L72

#                                                            ../orig/d.typ:302
I:(3)
*:_D_R_L73
#                                                            ../orig/d.typ:304
D:Do zebras roam the miles of bleak velds which cover parts of the
 :world while packs of brown bears and wart hogs prowl in the woods?
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L73

#                                                            ../orig/d.typ:305
I:(4)
*:_D_R_L74
#                                                            ../orig/d.typ:309
D:Some folks claim to favor poems and rhyme, others can wring equal
 :cheer and worth from words and quest and seize all books. Still
 :others amply quell their needs with vocal music and seek all
 :works on voice.
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L74

#                                                            ../orig/d.typ:310
I:(5)
*:_D_R_L75
#                                                            ../orig/d.typ:312
D:The queen was given a query for which an ample reply would
 :take a quire of paper.
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L75

#                                                            ../orig/d.typ:313
I:(6)
*:_D_R_L76
#                                                            ../orig/d.typ:315
D:Six husky cooks boiled clam broth, shrimp and prawns and broiled
 :liver for seven lucky elves, then made their hasty exits.
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L76

#                                                            ../orig/d.typ:316
I:(7)
*:_D_R_L77
#                                                            ../orig/d.typ:319
D:At the games, Mark was so very badly hurt with many broken bones,
 :lumps on his jaws, and some glands burst. Blood oozed from a crack
 :in his wart where it had oozed for weeks. He was lucky to have lived.
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L77

#                                                            ../orig/d.typ:320
I:(8)
*:_D_R_L78
#                                                            ../orig/d.typ:322
D:To check pomp and pride, sever from all overt vices, belay all
 :forms of muck raking, and limit all hazards, will bring prime joy.
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L78

#                                                            ../orig/d.typ:323
I:(9)
*:_D_R_L79
#                                                            ../orig/d.typ:326
D:To begin to use wrong verbs among boors and bores may be
 :a severe error even if the whole group seems to think
 :that exact terms mean less than is normal for them.
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L79

#                                                            ../orig/d.typ:327
I:(10)
*:_D_R_L80
#                                                            ../orig/d.typ:331
D:allow among avail awful Aztec azure backs balls began being belie
 :bells bills black blank bored borne bring can't chalk champ charm
 :check cheek chick chink comes Czech every evict exalt excel exert
 :exile expel exult Felix folks gable gauze gives glaze gleam globe
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L80

#                                                            ../orig/d.typ:332
I:(11)
*:_D_R_L81
#                                                            ../orig/d.typ:336
D:grams grave graze havoc hazel helix hobby jazzy jelly jerky jewel
 :joker jolly jolts jowls judge junco kapok kayak keels keeps kitty
 :knack kneel knelt knock knurl kopek kraal Krupp leave liver money
 :never Ozark pawns peaks pecks peeks phlox pirks power proms prove
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L81

#                                                            ../orig/d.typ:337
I:(12)
*:_D_R_L82
#                                                            ../orig/d.typ:341
D:quack quaff quail qualm quays quell quill quilt ramps romps rooms
 :rumps salve serve shack shark shawl shirk shock shrew shuck sieve
 :seize skiff skill skimp skirt skulk small spank speak spoke stick
 :stuck threw throw thyme vague valid value valve vapid vault venal
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L82

#                                                            ../orig/d.typ:342
I:(13)
*:_D_R_L83
#                                                            ../orig/d.typ:346
D:verge verse verve vetch vigil vigor viola virus vital vogue voile
 :vouch vowel vying walks walls wards warts whack whale wharf wheat
 :wheel whelp where which whiff while whirl whole wired wires words
 :world worth would write wrong wrote yards yokes yolks zippy zombi
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L83

G:_D_E_D12
#------------------------------------------------------------------------------
# Lekce D13
#------------------------------------------------------------------------------
*:D13
*:_D_S_D13
*:_D_R_L84
#                                                            ../orig/d.typ:353
T:
 :The following 135 words are so frequently used that they comprise 50%
 :of all words normally typed. If you can type the next two exercises without
 :errors, half of your typed words will be correct!
Q: Pro pokračování stiskněte Y, F12 pro konec.
N:_D_R_L84

*:_D_R_L85
#                                                            ../orig/d.typ:358
D:a about after all also an and another any are as at back be because
 :been before being between both but by can could day did do down each
 :even first for from get good had has have he her here him his how I
 :if in into is it its just know last life like little long made make
 :many may me men more most Mr. Ms.  much must my never new no not now
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L85

*:_D_R_L86
#                                                            ../orig/d.typ:363
D:of or on one only or other our out over own people said same see she
 :should so some state still such than that the their them then there
 :these they this those through time to too two under up very was way
 :we well were what when where which while who will with work would
 :years you your
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L86

*:_D_R_L87
#                                                            ../orig/d.typ:364
T:We now concentrate on home row words.
Q: Pro pokračování stiskněte Y, F12 pro konec.
N:_D_R_L87

#                                                            ../orig/d.typ:365
I:(1)
*:_D_R_L88
#                                                            ../orig/d.typ:367
D:The duteous dietitian hesitated at the intense nauseousness inside
 :the dishonest institution.
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L88

#                                                            ../orig/d.typ:368
I:(2)
*:_D_R_L89
#                                                            ../orig/d.typ:370
D:In addition, the unastute assassin had another unsound idea. He
 :intended to assassinate the dishonest attendant at the institute.
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L89

#                                                            ../orig/d.typ:371
I:(3)
*:_D_R_L90
#                                                            ../orig/d.typ:376
D:The unintentioned noisiness and untidiness in the hostess house
 :astonished, astounded and nauseated Antonietta. Undaunted and
 :unassisted, she did not hesitate to initiate a statute at the state
 :house. The statute stated that no attendant in an untenanted haunted
 :hostess house is to attain hostess status.
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L90

G:_D_E_D13
#------------------------------------------------------------------------------
# Lekce D14
#------------------------------------------------------------------------------
*:D14
*:_D_S_D14
*:_D_R_L91
#                                                            ../orig/d.typ:381
T:
 :In this lesson we practice alphabetic sentences.
Q: Pro pokračování stiskněte Y, F12 pro konec.
N:_D_R_L91

#                                                            ../orig/d.typ:382
I:(1)
*:_D_R_L92
#                                                            ../orig/d.typ:383
D:Sixty-five quizzical sheep kept their jaws dry in a farm bungalow.
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L92

#                                                            ../orig/d.typ:384
I:(2)
*:_D_R_L93
#                                                            ../orig/d.typ:385
D:Balky Zulus find they can hoax weary men with quavery jumping.
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L93

#                                                            ../orig/d.typ:386
I:(3)
*:_D_R_L94
#                                                            ../orig/d.typ:387
D:Jerome quickly began to be vexed by the powerful blizzards.
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L94

#                                                            ../orig/d.typ:388
I:(4)
*:_D_R_L95
#                                                            ../orig/d.typ:389
D:Squawking gorillas could vex the brazen nymphs in a jiffy.
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L95

#                                                            ../orig/d.typ:390
I:(5)
*:_D_R_L96
#                                                            ../orig/d.typ:391
D:Can Jerry's equipment file saws, ax, hoe, knives and grind adz?
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L96

#                                                            ../orig/d.typ:392
I:(6)
*:_D_R_L97
#                                                            ../orig/d.typ:393
D:Ben works at squeezing very juicy plums with flexed thumbs.
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L97

#                                                            ../orig/d.typ:394
I:(7)
*:_D_R_L98
#                                                            ../orig/d.typ:395
D:The black wizard quipping jovially flexed his muscles.
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L98

#                                                            ../orig/d.typ:396
I:(8)
*:_D_R_L99
#                                                            ../orig/d.typ:397
D:Will you pack my jugs of liquid veneer in five dozen boxes?
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L99

#                                                            ../orig/d.typ:398
I:(9)
*:_D_R_L100
#                                                            ../orig/d.typ:399
D:Could the wizard jinx quivering folks by magic yelps?
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L100

#                                                            ../orig/d.typ:400
I:(10)
*:_D_R_L101
#                                                            ../orig/d.typ:401
D:Brazen gazelles quickly examined the forward jeep.
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L101

#                                                            ../orig/d.typ:402
I:(11)
*:_D_R_L102
#                                                            ../orig/d.typ:403
D:The brown dog quickly jumped over the lazy fox.
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L102

#                                                            ../orig/d.typ:404
I:(12)
*:_D_R_L103
#                                                            ../orig/d.typ:405
D:Will the kind judge squelch the five or six brazen nymphs?
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L103

#                                                            ../orig/d.typ:406
I:(13)
*:_D_R_L104
#                                                            ../orig/d.typ:407
D:Mix zippy Kadota figs with quivering cranberry jelly.
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L104

#                                                            ../orig/d.typ:408
I:(14)
*:_D_R_L105
#                                                            ../orig/d.typ:409
D:The wives quickly jerked extra big pizzas from the stand.
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L105

#                                                            ../orig/d.typ:410
I:(15)
*:_D_R_L106
#                                                            ../orig/d.typ:411
D:Lisa quickly mixed the very big jar of new soap.
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L106

#                                                            ../orig/d.typ:412
I:(16)
*:_D_R_L107
#                                                            ../orig/d.typ:413
D:The major will fix a quiet cozy nook for the vexed, bad Gypsy.
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L107

#                                                            ../orig/d.typ:414
I:(17)
*:_D_R_L108
#                                                            ../orig/d.typ:415
D:Pairs of lazy knowing oxen came by quietly evading the jam.
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L108

#                                                            ../orig/d.typ:416
I:(18)
#                                                            ../orig/d.typ:417
I:Juvenile zest for excitement whetted interest in parking by the quay.
#                                                            ../orig/d.typ:418
I:(19)
*:_D_R_L109
#                                                            ../orig/d.typ:419
D:Put your big ax, shovel and quartz where Mike's fence joins ours.
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L109

#                                                            ../orig/d.typ:420
I:(20)
*:_D_R_L110
#                                                            ../orig/d.typ:421
D:The brawny jaguar held fast till the quaking Zouave victim expired.
Q: Stisknutím Y můžete pokračovat, N bude cvičení opakovat, F12 - konec.
N:_D_R_L110

G:_D_E_D14
#------------------------------------------------------------------------------
# Lekce series D jump tables
#------------------------------------------------------------------------------
*:_D_E_D1
Q: Do you want to continue to lesson D2 [Y/N] ?
N:_D_MENU
G:_D_M_D2
*:_D_E_D2
Q: Do you want to continue to lesson D3 [Y/N] ?
N:_D_MENU
G:_D_M_D3
*:_D_E_D3
Q: Do you want to continue to lesson D4 [Y/N] ?
N:_D_MENU
G:_D_M_D4
*:_D_E_D4
Q: Do you want to continue to lesson D5 [Y/N] ?
N:_D_MENU
G:_D_M_D5
*:_D_E_D5
Q: Do you want to continue to lesson D6 [Y/N] ?
N:_D_MENU
G:_D_M_D6
*:_D_E_D6
Q: Do you want to continue to lesson D7 [Y/N] ?
N:_D_MENU
G:_D_M_D7
*:_D_E_D7
Q: Do you want to continue to lesson D8 [Y/N] ?
N:_D_MENU
G:_D_M_D8
*:_D_E_D8
Q: Do you want to continue to lesson D9 [Y/N] ?
N:_D_MENU
G:_D_M_D9
*:_D_E_D9
Q: Do you want to continue to lesson D10 [Y/N] ?
N:_D_MENU
G:_D_M_D10
*:_D_E_D10
Q: Do you want to continue to lesson D11 [Y/N] ?
N:_D_MENU
G:_D_M_D11
*:_D_E_D11
Q: Do you want to continue to lesson D12 [Y/N] ?
N:_D_MENU
G:_D_M_D12
*:_D_E_D12
Q: Do you want to continue to lesson D13 [Y/N] ?
N:_D_MENU
G:_D_M_D13
*:_D_E_D13
Q: Do you want to continue to lesson D14 [Y/N] ?
N:_D_MENU
G:_D_M_D14
*:_D_E_D14
G:_D_MENU

*:_D_M_D1
B:                            Lekce D1
G:_D_S_D1
*:_D_M_D2
B:                            Lekce D2
G:_D_S_D2
*:_D_M_D3
B:                            Lekce D3
G:_D_S_D3
*:_D_M_D4
B:                            Lekce D4
G:_D_S_D4
*:_D_M_D5
B:                            Lekce D5
G:_D_S_D5
*:_D_M_D6
B:                            Lekce D6
G:_D_S_D6
*:_D_M_D7
B:                            Lekce D7
G:_D_S_D7
*:_D_M_D8
B:                            Lekce D8
G:_D_S_D8
*:_D_M_D9
B:                            Lekce D9
G:_D_S_D9
*:_D_M_D10
B:                           Lekce D10
G:_D_S_D10
*:_D_M_D11
B:                           Lekce D11
G:_D_S_D11
*:_D_M_D12
B:                           Lekce D12
G:_D_S_D12
*:_D_M_D13
B:                           Lekce D13
G:_D_S_D13
*:_D_M_D14
B:                           Lekce D14
G:_D_S_D14
#------------------------------------------------------------------------------
# Lekce series D menu
#------------------------------------------------------------------------------
*:_D_MENU
M: UP=__SERIESMENU "The D series contains the following 14 lessons"
 :_D_M_D1  "Lekce D1     The home row"
 :_D_M_D2  "Lekce D2     Learning the Shift Key"
 :_D_M_D3  "Lekce D3     Home Row and the Period"
 :_D_M_D4  "Lekce D4     Upper Row and Essential Punctuation"
 :_D_M_D5  "Lekce D5     Review"
 :_D_M_D6  "Lekce D6     Learning the Lower Row"
 :_D_M_D7  "Lekce D7     Practise"
 :_D_M_D8  "Lekce D8     Practise"
 :_D_M_D9  "Lekce D9     Practise"
 :_D_M_D10 "Lekce D10    Practise"
 :_D_M_D11 "Lekce D11    Practise"
 :_D_M_D12 "Lekce D12    Practise"
 :_D_M_D13 "Lekce D13    Frequent words"
 :_D_M_D14 "Lekce D14    Alphabetic sentences"
*:_D_EXIT
#------------------------------------------------------------------------------
# End of file d.typ
G:__SERIESMENU
#==============================================================================
#==============================================================================
*:__S_M_SERIES
# Start of file m.typ
# Typist v2.2 - improved typing tutor program for UNIX systems
# Copyright (C) 1998 Simon Baldwin (simonb@sco.com)
#
# Translated, modified by Hynek Hanke (hanke@volny.cz)
#
# Copyright (C) 2001 Hynek Hanke (hanke@volny.cz), Gnumaniacs.Org
#
# This was translated and modified to Czech by Hynek "0A4h" Hanke
# hanke@volny.cz / Gnumaniacs.Org
# Please report bugs to hanke@volny.cz, *not* to Simon!
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

#------------------------------------------------------------------------------
# Series M
#------------------------------------------------------------------------------
G:_M_MENU
*:_M_NO_MENU
#------------------------------------------------------------------------------
# Lekce M1
#------------------------------------------------------------------------------
*:M1
*:_M_S_M1
#                                                              ../orig/m.typ:3
I:(1) Rozcvička
*:_M_R_L0
#                                                              ../orig/m.typ:4
D:Tato série je zaměřena zejména na procvičování.

#                                                              ../orig/m.typ:5
I:(2) Continuous Copy
*:_M_R_L1
#                                                              ../orig/m.typ:6
D:Moje příjmy byly: 2,309Kč, 5,687Kč, 3,498Kč, 2,408Kč a 3,697Kč.

#                                                              ../orig/m.typ:7
I:(3)
*:_M_R_L2
#                                                              ../orig/m.typ:9
D:Student by se měl zlepšit o jedno slovo
 :za minutu každým rokem věku: např. z 13ti na 14,
 :ze 14ti na 15, na 16, na 17, na 18...

#                                                             ../orig/m.typ:10
I:(4)
*:_M_R_L3
#                                                             ../orig/m.typ:13
D:25% studentů v prvním roce nepřekročí 25 slov za minutu.
 :V druhém roce již většina zvládne 45 slov za minutu.
 :Více jak 50% nedosáhne hranice 50 slov za minutu.

#                                                             ../orig/m.typ:14
I:(5)
*:_M_R_L4
#                                                             ../orig/m.typ:18
D:Proč nás všechny vzrušuje sport? Možná to dělá ta
 :obrovská dovednost vítězů. Zeptejte se ale hráčů.
 :Řeknou vám, že, že dovednost je jen část (50%)
 :z tajemství úspěchu.

#                                                             ../orig/m.typ:19
I:(6)
*:_M_R_L5
#                                                             ../orig/m.typ:24
D:V počítačové branži se nám často stává, že se
 :setkáme s problémem, který jsme ještě nikdy neřešili.
 :Vlastně je pro nás většina problémů úplně nová.
 :Tenhle obor je prostě příliš rychlý na to, aby
 :zde fungovaly klasické modely jako nauč se ve škole
 :a praktikuj v zaměstnání.

#                                                             ../orig/m.typ:25
I:(7)
*:_M_R_L6
#                                                             ../orig/m.typ:29
D:Mnoho lidí špatně interpretuje termín Free ve spojení
 :Free Software (např. tento program je Free Software).
 :Naivně si tak myslí, že to znamená zdarma, a tak jej
 :pokládají za software zdarma. Slovo Free ale ve skutečnosti
 :znamená svobodný a v tom tkví podstata tohohle hnutí.
 :Program je svobodným software, máte svobodu dělat
 :si s ním téměř vše (pouze nesmíte změnit licenci).

#                                                             ../orig/m.typ:30
I:(8)
*:_M_R_L7
#                                                             ../orig/m.typ:36
D:Jednou z velmi zajímavých oblastí nových výpočetních
 :technologií jsou kvantové počítače. Takové stroje
 :dokáží provádět i výpočty o kterých se nám zatím
 :mohlo pouze zdát. Bohužel není jisté, zda vůbec
 :lze takové počítače prakticky realizovat. Teoreticky
 :existuje spousta návrhů, ale existuje i spousta návrhů
 :na moderní mechanické, biologické či optické počítače
 :a jak víme, dosud nic takového v rozumném provozu není.

#                                                             ../orig/m.typ:46
I:(9A) Odstavec zaměřený na procvičování m a b
*:_M_R_L9
#                                                             ../orig/m.typ:53
S:    Men are bound to believe that business is bad in winter
 :months. Maybe Mr. Smith remembers that most building became
 :better in September but both November and December seemed to
 :be much behind. Monday morning my mail box became blocked
 :by urgent requests of many families that small-sized homes
 :be built. Some jobs may begin to come now from the Chamber
 :of Commerce members.

#                                                             ../orig/m.typ:54
I:(10) Rytmické opakování
*:_M_R_L10
#                                                             ../orig/m.typ:55
D:Snažte se opisovat tento text co nejplynuleji.

G:_M_E_M1
#------------------------------------------------------------------------------
# Lekce M2
#------------------------------------------------------------------------------
*:M2
*:_M_S_M2
#                                                             ../orig/m.typ:59
I:(1) Rozcvička
*:_M_R_L11
#                                                             ../orig/m.typ:60
D:Mnoho poznatků nabiflovaných za mlada nám nikdy k ničemu nebude.

#                                                             ../orig/m.typ:61
I:(2) Vyvážený klávesový dril
*:_M_R_L12
#                                                             ../orig/m.typ:63
D:non ana dis dia cle pan ard pur ern eer off age suf ame amb
 :ess ean ist ian cel apo col ary tra neo sur ity sub ele mis

#                                                             ../orig/m.typ:64
I:(3) Slova o čtyřech písmenech (od a do d)
*:_M_R_L13
#                                                             ../orig/m.typ:81
S:Dear Dan,
 :
 :    Yes, I came out of the corn, back to the city, both to
 :draw and to do copy on the new cars. To date I am able to
 :put cash in the bank and bear a bill or two. The new deed
 :has done it.
 :
 :    The city has been busy but cold for two days. Dear baby
 :has been to see her best aunt. A band came by the door.
 :Baby let the bird cage drop down with a blow. The bird died.
 :Boys put its dead body deep in a dark card case. Baby also
 :has a ball and blue book to drop. I put the boat away. Its
 :deck did burn, but I care not as it does not cost a cent.
 :
 :    Come, call on me at the club.
 :
 :Yours sincerely,

#                                                             ../orig/m.typ:82
I:(4) Slova o čtyřech písmenech (od e po g)
*:_M_R_L14
#                                                             ../orig/m.typ:97
S:Dear Bea,
 :
 :    I am glad you feel so for the farm in the East.  Even
 :as a girl of four or five I was ever so glad to find the
 :farm. In my eyes it was all as good as gold.  Even my feet
 :felt good. A girl can gain and grow fast on farm food and
 :the fine free air. Why else did face and form grow full
 :and fair so fast?
 :
 :    On each foot of my farm I felt free from fear.  It
 :gave me my fill of fun. I felt no fear of any fire in the
 :fall. Now the fire is a fact and my farm is gone.  Give me
 :my full life, etc. The game goes on.
 :
 :Yours sincerely,

#                                                             ../orig/m.typ:98
I:(5) Slova o čtyřech písmenech (od h k l)
*:_M_R_L15
#                                                            ../orig/m.typ:119
S:Dear Hal,
 :
 :    Just a line to say I am lost if I cannot fly.  I
 :have to keep on here. I knew it was but a hope last May.
 :It was just my last idea in June. Yet I held my head high
 :and did not lose hope.
 :
 :    Why not fly up in the air a half hour or less and
 :look at my lake and our home on the hill? I left it late
 :last July with one item on my list. Bill gave me half an
 :hour of help. Like the lady of the lake I met the king.
 :Bill was a kind king, too.
 :
 :    To lead off into the air and see all our lake so
 :long and lots of land so low, was to live a high hour. I
 :kept my hand at my ear so as to help hear. In the air my
 :hair was a loss. It did not kill me.  I have to fly to know
 :life can be less hard. I like to hold on and help Bill.  I
 :love to fly.
 :
 :Yours sincerely,

G:_M_E_M2
#------------------------------------------------------------------------------
# Lekce M3
#------------------------------------------------------------------------------
*:M3
*:_M_S_M3
#                                                            ../orig/m.typ:123
I:(1) Rozcvička
*:_M_R_L16
#                                                            ../orig/m.typ:124
D:Lidé netuší, kolik zla se může skrývat ve slovech.

#                                                            ../orig/m.typ:125
I:(2) Vyvážené klávesové cvičení
*:_M_R_L17
#                                                            ../orig/m.typ:127
D:sus ase sis uni suc epi cor ory tri acy fic ify dom isk ism
 :čas than mýt ťít pařát žhnout pět vést číhá pošta méně ťava

#                                                            ../orig/m.typ:128
I:(3) Čtyřpísmenná slova (od m po p)
*:_M_R_L18
#                                                            ../orig/m.typ:145
S:Dear Pie,
 :
 :    I open most of my mail and meet the news.  I note that
 :you say Mrs. Page is a mere name but you met the Miss Page.
 :
 :    You must need the car.  Once the pass is open I can move
 :the car over to you. Do you mind if I make it part of a nice
 :plan to meet Miss Page, too? Mrs. Page was only a mile past
 :us. Her son was my age and I made the mile at noon to play a
 :bit. She paid us for milk.  She did not mean much to me, but
 :her son did.
 :
 :    Next we had more fun up the pass near the poor old No.
 :Nine mine. I can mark many a mile we once ran.  I must mail
 :this note or I may miss the post.
 :
 :Yours sincerely,

#                                                            ../orig/m.typ:146
I:(4) Čtyřpísmenná slova (od r k s)
*:_M_R_L19
#                                                            ../orig/m.typ:166
S:Dear Ross,
 :
 :    It is a real rain.  The road is so soft my car can but
 :roll, stop, and roll on. Are you on the ship?  If I get as
 :far as the ship, can we sail in such a rain? If we try to
 :sail, the ship is sure to rock or ride on one side. If I get
 :sick, it is up to you to stay by and show us how to save the
 :ship. Ann has some sort of song to sing in the rain.  She
 :said she sent it to you.
 :
 :    Did you read of our sale?  We set out a big sign.  Now
 :any sort of suit and any size seem to sell. We are not rich
 :but we can soon step out or be sold out, if any such rate is
 :to rule.
 :
 :    Ann has not seen the ship as yet.  Rain or no rain, Ann
 :says to send her out. All the rest of us say the same.  Can
 :you ring me in my room at the shop?
 :
 :Yours sincerely,

#                                                            ../orig/m.typ:167
I:(5) Cílený odstavec (i a u)
*:_M_R_L20
#                                                            ../orig/m.typ:173
S:    The public is quite unfair about airing quibbles over
 :house furniture and fruit juices for the university crew.
 :The alumni inquiry into the failure of equipment figures in
 :the issue. The alumni attitude is useful but continues to
 :put a premium on a victorious crew. Only genius can guide
 :this outfit uphill and build a suitable crew that won't quit.

#                                                            ../orig/m.typ:174
I:(6) Cílený odstavec (d, s, -)
*:_M_R_L21
#                                                            ../orig/m.typ:182
S:    Students should be assisted in studying seated at their
 :desks; cross-questioned as to their needs and desires; ad-
 :vised to use up-to-date leads based on studies of standards.
 :By-products of student days, well-bred friends, kindness,
 :self-help, with good grades and degrees, are listed as far-
 :sighted aids. In Dad's old-fashioned address to his co-
 :workers, he said sadly that ideas are missed less than first-
 :class friends and good-natured wishers.

G:_M_E_M3
#------------------------------------------------------------------------------
# Lekce M4
#------------------------------------------------------------------------------
*:M4
*:_M_S_M4
#                                                            ../orig/m.typ:186
I:(1) Rozcvička
*:_M_R_L22
#                                                            ../orig/m.typ:187
D:Nezapomínejme, že Murphyho zákony jsou fyzikálně potvrzeny
 :druhým zákonem termodynamiky.

#                                                            ../orig/m.typ:188
I:(2) Balanced Keyboard Drill
*:_M_R_L23
#                                                            ../orig/m.typ:190
D:anti tam půl zkus rak savo nota hic kolem vůz cep buch
 :těžko mě více život pařát těsto číslo žvýkat sněť ňákej

#                                                            ../orig/m.typ:191
I:(3) Čtyřpísmenná slova (od t po z)
*:_M_R_L24
#                                                            ../orig/m.typ:208
S:Dear Tris,
 :
 :    It is so very warm at this time of year, I told my wife
 :that you and I wish to go west for a week or two. Did I
 :tell you what a wind we had? I went to town to vote for the
 :one man whom I want. I took a well-used tire.  When it went
 :down on a bad turn, in the woods, I had to walk. Then the
 :wind more than set in, and I had to wait by a wall. It got
 :our old tree.
 :
 :    I saw two men and set them to work on the car, till
 :they told me it was no use. If I were to turn it in, is it
 :true that you can take your car? I want a wide view and I
 :want to talk with you. Thus I wait upon your word.  Wire
 :yes if you will take this trip.
 :
 :Yours sincerely,

#                                                            ../orig/m.typ:209
I:(4) Pěti písmenná slova (od a k c)
*:_M_R_L25
#                                                            ../orig/m.typ:227
S:Dear Cab,
 :
 :    Could you apply to the court to allow my claim as agent
 :for Mr. Blank? I could bring in his books and see about his
 :bills. If asked, he can cover the costs by checks on a bank
 :that did not break.
 :
 :    Will you allow your child to come alone to see me?  He
 :can have every apple he can carry. By the way, being clean
 :and above board, you must be above bad cases, but you began
 :to bring in off-color cases after April.
 :
 :    I agree you do not cross the law, but why let men win
 :in a black cause on any basis? Why not build up your cases
 :from among men of our own class? Close the awful cases you
 :now carry along to court, and begin again.
 :
 :Sincerely yours,

#                                                            ../orig/m.typ:228
I:(5) Cílený odstavec (r, t)
*:_M_R_L26
#                                                            ../orig/m.typ:236
S:    In our motor party on the return trip an attractive
 :quartet first tried to tell thirty or forty short travel
 :stories. By turns they transferred to the theater, to art
 :matters, to court trial stories. In the latter a certain
 :doctor is hurt by a first truck, another truck is struck,
 :and three contractors are thrown to the street. The girl's
 :strong brother has been hurt. Further, there are arrests
 :and the sort of extra details that enter into true stories.

G:_M_E_M4
#------------------------------------------------------------------------------
# Lekce M5
#------------------------------------------------------------------------------
*:M5
*:_M_S_M5
#                                                            ../orig/m.typ:240
I:(1) Zahřívací kolo
*:_M_R_L27
#                                                            ../orig/m.typ:241
D:Werich: Bez lidí dobré vůle by život nebyl nic než nákladné
 :a nebezpečné dobrodružství.

#                                                            ../orig/m.typ:242
I:(2) Vyvážené klávesové cvičení
*:_M_R_L28
#                                                            ../orig/m.typ:244
D:běs příhoda výživa náměstí táborák Cipísek ňiť výška
 :žár šepot věnec bžikot máta čéška děs léno suk squělý

#                                                            ../orig/m.typ:245
I:(3) Pětipísmenná slova (od d k h)
*:_M_R_L29
#                                                            ../orig/m.typ:262
S:Dear Fred,
 :
 :    I have dared to ask you for an extra favor on the first.
 :If you are not dated, I am to draft you to drive me by horse
 :or car up the grade to the field house at eight. I guess you
 :have not heard fully about the great dance to be given by the
 :girls on the floor of the field house.
 :
 :    My hands have put fresh green goods on the walls.  Every
 :girl has a green dress, on its front a funny glass heart that
 :she gives as a favor. The old folks can drive up early, eat
 :and drink and enjoy it all. We will delay the dance till the
 :girls enter in a dozen files. It would crush me to death if
 :an error were found in the plans. Happy hours on earth are
 :never heavy. Can you doubt that you are going?
 :
 :Sincerely yours,

#                                                            ../orig/m.typ:263
I:(4) Pětipísmenná slova (od i k p)
*:_M_R_L30
#                                                            ../orig/m.typ:283
S:Dear Madam,
 :
 :    I have your two later notes of March 1.  Maybe it is a
 :large order for you to leave for the north in the month of
 :March.
 :
 :    Our place is miles away, but the real issue is that mu-
 :sic means much to us. A night of music, even one piece of
 :music, has often meant more to me than my local paper and all
 :the power I have known. If I can plant a love of music in all
 :parts of this place so that all who hear you sing can learn to
 :love it, it will mean more to me than money.
 :
 :    I never laugh at money, but isn't it plain in these
 :lines that price ought to be the least of all the items? The
 :point is that our plans for your party are more important. If
 :you read our other offer in the light of our love for music,
 :we might not seem so far away.
 :
 :Yours sincerely,

#                                                            ../orig/m.typ:284
I:(5) Cílený odstavec (u, y)
*:_M_R_L31
#                                                            ../orig/m.typ:297
S:    If truly quoted, you and Guy, mere youths, fly a con-
 :tinuous journey of thousands of miles yearly in your study
 :of numerous flying routes. You say you were south in July
 :in the dry country conspicuous for yucca, but now you are
 :busy buying a quota of various useful items to supply your
 :outfit for the famous Yukon. Yet I am suspicious when you
 :say this unusual survey is monotonous rather than glorious.
 :You should hurry surely to Vancouver for some delicious
 :yuletide fare. It seems only yesterday that I was conscious
 :of being young and vigorous enough to fly my buoyant plane.
 :If you lucky boys are victorious over any unusually furious,
 :dangerous, or anxious double duty on this survey, write a
 :quotable account yourself for the Journal.

G:_M_E_M5
#------------------------------------------------------------------------------
# Lekce M6
#------------------------------------------------------------------------------
*:M6
*:_M_S_M6
#                                                            ../orig/m.typ:301
I:(1) Rozcvička
*:_M_R_L32
#                                                            ../orig/m.typ:302
D:Tohle tedy není vůbec to samé tvrzení, jako vyprávěl on.

#                                                            ../orig/m.typ:303
I:(2) Vyvážené cvičení
*:_M_R_L33
#                                                            ../orig/m.typ:305
D:káva pěnkava šít čpět míle záře věnec demoška přeci
 :čachrovat žvýkat mávat nevěsta rétorika oužlab úkol

#                                                            ../orig/m.typ:306
I:(3) Pětipísmenná slova (q to s)
*:_M_R_L34
#                                                            ../orig/m.typ:326
S:Dear Alice,
 :
 :    I shall start my river story since you have shown you like
 :my style.
 :
 :    The scene is a state in the South.  A sweet girl speaks of
 :the sound and sight of the river. Seven men without shame raise
 :the stock sales and the boy tries to spend too much at the store.
 :In order to make a quiet and quick slide down the river, the men
 :seize the boat while the others, who are quite ready to serve the
 :girl, sleep.
 :
 :    It seems the girl has sense, for on a sheet of paper she
 :writes that her stock of gold is within reach from a round stone
 :under the small shade tree. She does not quote the boy, but does
 :refer to the sorry end of his short study, and in her reply to his
 :folks she will state how the gold may still be spent in the right
 :way, which will stamp the story as real.
 :
 :Yours sincerely,

#                                                            ../orig/m.typ:327
I:(4) Pětipísmenná slova (od t k z)
*:_M_R_L35
#                                                            ../orig/m.typ:348
S:Dear Mrs. White,
 :
 :    I wish to thank you for the words you wrote three weeks ago,
 :and I trust you will write again on the wrong and waste of war.
 :
 :    As I watch the wheels of events today, I think you value a
 :thing it has taken me a third of my years to see. In its total
 :trade the world is one whole, and each part in touch with the
 :other at most times.
 :
 :    The usual farm woman won't see a trade table or understand
 :its terms, for she is tired with her efforts to train and teach
 :her young. She has tried to throw her value into her home, which
 :to her is worth so much. War can not be put under until these
 :women see there is but one world, which truly is their world.
 :
 :    Where will you be while the thick wheat is harvested?  If
 :not across the water, would you visit us, using your voice to
 :teach us these things?
 :
 :Yours sincerely,

#                                                            ../orig/m.typ:349
I:(5) Cílený odstavec (n, m)
*:_M_R_L36
#                                                            ../orig/m.typ:357
S:    Important dinner company in our small apartment was
 :not common, and November ninth mamma was solemn in manner.
 :The moment nine American gentlemen were announced, fun and
 :argument began. I remember one ancient gentleman, manager
 :of much more income than mine, who was not solemn as imag-
 :ined, but funny and human, even if normal demand, planned
 :movements of modern machines to Canada, long term payments,
 :and columns of numbers meant much more to him than to me.

G:_M_E_M6
#------------------------------------------------------------------------------
# Lekce M7
#------------------------------------------------------------------------------
*:M7
*:_M_S_M7
#                                                            ../orig/m.typ:361
I:(1) Rozcvička
*:_M_R_L37
#                                                            ../orig/m.typ:362
D:Kolik hloupostí napovídají lidé jen proto, že chtějí
 :říci něco chytrého!

#                                                            ../orig/m.typ:363
I:(2) Vyvážené cvičení
*:_M_R_L38
#                                                            ../orig/m.typ:364
D:přít nesnášet, hvězdy záleží čmelák mouka Dáša

#                                                            ../orig/m.typ:365
I:(3) Přepište toto
*:_M_R_L39
#                                                            ../orig/m.typ:381
S:Dear Mr. and Mrs. Blank,
 :
 :    Your son has not called on me. If he is to become almost an
 :annual charge upon the county, the church will answer with action.
 :Yet, I am afraid his arrest can not assure his coming around and
 :asking us for advice. Of course he has to appear before August.
 :He bought on credit, got behind in cash, and the amount became too
 :big. I shall pay it.
 :
 :    You are an old couple, and I advise you to accept this.  Any-
 :way, he is not a common boy and must have a chance. He always does
 :appear to anyone as fit. I run across copies of his art.  I can
 :advise your son, attend to his credit, and try to help him arrive
 :at a change for the better.
 :
 :Sincerely yours,

#                                                            ../orig/m.typ:382
I:(4) Šestipísmenná slova (od d ke k)
*:_M_R_L40
#                                                            ../orig/m.typ:400
S:Dear Dick
 :
 :    I have a dollar. I expect you to follow me and take dinner.
 :Friday I didn't have cash, but a friend of the family had enough
 :for both of us.
 :
 :    Father is having all the lot, except the garden, filled in
 :during the week. Giving in to his desire, I intend to work the
 :ground. Doctor says that my health is hardly an excuse, so I had
 :better decide to make an effort. Indeed, I am driven either to
 :finish the work in the near future or pay to have it done.
 :
 :    I am hoping you will happen upon some kindly fellow to whom
 :a flower garden itself is fun, and inform me. I shall direct him,
 :as the entire effect will lie in the way we handle the ground
 :plan. Don't forget.
 :
 :Yours sincerely,

#                                                            ../orig/m.typ:401
I:(5) Cílený odstavec (q, z)
*:_M_R_L41
#                                                            ../orig/m.typ:408
S:    I quit the quiz when I saw the quantity of queer hazy
 :questions. To seize lesser prizes required answers to a
 :dozen queries. Only a quarter of the quotas qualified with
 :zest. Many had zero when the quiz asked:  In what zones are
 :Brazil, Switzerland, Arizona, or Texas? Zebras in our zoos
 :grow to what sizes? Analyze and quote one great citizen's
 :query as to zeppelins. Criticize the quality of jazz music.

G:_M_E_M7
#------------------------------------------------------------------------------
# Lekce M8
#------------------------------------------------------------------------------
*:M8
*:_M_S_M8
#                                                            ../orig/m.typ:412
I:(1) Pro zahřátí
*:_M_R_L42
#                                                            ../orig/m.typ:413
D:Kdo je bohatý? Kdo je spokojen se svým osudem. -- Tolstoj

#                                                            ../orig/m.typ:414
I:(2) Vyvážené klávesové cvičení
*:_M_R_L43
#                                                            ../orig/m.typ:415
D:muž číslo pěšák dálka téci puberťák věc Ňina

#                                                            ../orig/m.typ:416
I:(3) Šestipísmenná slova (od l k r)
*:_M_R_L44
#                                                            ../orig/m.typ:437
S:Dear Rollin,
 :
 :    I did notice a number of the pretty places I passed in
 :the air nearly two months ago, and I can at length locate
 :the best. If prices remain rather low, I will not return
 :for any person or be prompt at orders. I can play a record
 :or two, and not regret there is no report to be looked at.
 :I want to be myself and regard nature, not people.
 :
 :    To obtain this latter result is the proper reason for
 :making this quiet trip. So far from the public, matter in
 :the papers will be old and market policy of little moment.
 :It will please me to have you with us longer than the others.
 :I was really living for the period when I would be placed with
 :you both. Your mother has a lovely manner. I am glad to
 :oblige so recent a member of our office, too.
 :
 :    This letter is being mailed Monday, and in two days we
 :shall go.
 :
 :Yours sincerely,

#                                                            ../orig/m.typ:438
I:(4) Šestipísmenná slova (od s k z)
*:_M_R_L45
#                                                            ../orig/m.typ:458
S:Dear Sylvia,
 :
 :    I wonder if my sister talked to you on Sunday of the
 :thirty things we wanted to do this summer? We were trying
 :all the spring season at school to secure a supply of sim-
 :ple but strong materials for a camp in the valley.
 :
 :    It struck me as we were taking a walk down the street
 :that we would surely be unable to do as we stated unless you
 :took a sudden notion to help. It seemed to me on second
 :thought we should give thanks to you for giving tongue to our
 :wishes last winter, for you turned the folks in our favor.
 :
 :    My sister was saying that girls from twenty states had
 :signed our pledge, so we are united. Though this is off the
 :subject, I saw a pretty yellow and silver dress within a win-
 :dow on Main Street toward our corner. Would you think it
 :suitable for the writer?
 :
 :Sincerely yours,

#                                                            ../orig/m.typ:470
I:(5) Cílený odstavec (a, q)
*:_M_R_L45A
#
S:    I acquired a bequest from a quizzical Quaker. How
 :to apply it was a quandary. As a quasi artist, I began in
 :Albuquerque to make a quantity of plaques of chance Indian
 :acquaintances. My masquerade as an artist of quality in
 :that quaint land of quite Spanish art and adobe was adequate
 :and equally unique. Squeezed in quiet, antiquated adobe
 :quarters, I began quickly and without qualms to qualify as
 :an artist. After quarrels and questions over my queer tech-
 :niques, I acquired my quota of opaque plaques.

G:_M_E_M8
#------------------------------------------------------------------------------
# Lekce M9
#------------------------------------------------------------------------------
*:M9
*:_M_S_M9
#                                                            ../orig/m.typ:471
I:(1) Rozcvička
*:_M_R_L46
#                                                            ../orig/m.typ:472
D:Žádný učený z nebe nespadl, ale pitomce jako by shazovali.

#                                                            ../orig/m.typ:473
I:(2) Vyvážené klávesové cvičení
*:_M_R_L47
#                                                            ../orig/m.typ:474
D:stead ation retro geous contr ourse ultra super ntý under

#                                                            ../orig/m.typ:475
I:(3) Sedmipísmenná slova (a-f)
*:_M_R_L48
#                                                            ../orig/m.typ:498
S:Dear Annabel,
 :
 :    My brother and his college friends in the factory decided to arrange an
 :evening exactly as in the old days. After calling us, they arrived and we
 :carried out the idea. We used an old college catalog and each girl had an
 :old college dress.
 :
 :    Further to advance the evening, my brother advised us of an old address
 :near the freight yard where certain college boys brought this or that article
 :and were allowed a few dollars. As we went in, an old man came a step farther,
 :fell forward and against me. Brother charged him. Will you believe this care-
 :ful account I enclose? Between brother and me lay this old man who did seem
 :dead. I can't express my feeling. His head was covered with marks of blows.
 :
 :    Already we were anxious to go. Yet his safe was open, as if to furnish us
 :the old books with the many expense charges against the college boys. When I
 :looked to see who of our company were in them, I read one balance after another
 :paid from the old country to My Dearest Son. You are correct if you guess we
 :now ran, because we did. What follows? Today's paper doesn't have a line.
 :
 :Yours sincerely,

#                                                            ../orig/m.typ:499
I:(4) Sedmipísmenná slova (g-o)
*:_M_R_L49
#                                                            ../orig/m.typ:518
S:Dear Mrs. White,
 :
 :    I have been holding on, but this January I am getting out.
 :My wife herself may have told you of our opening. However, I go
 :at ten o'clock this morning, and your husband is still out. He is
 :to do my general work himself, and may not imagine there is any
 :measure of justice in that. We married men are obliged to do as
 :ordered.
 :
 :    I am leaving a hundred matters.  He has my opinion on each.
 :Tell him the minutes of the last meeting of the members are on my
 :table. Tell him I haven't an invoice, but have instead an October
 :bill, for our new machine parts. He may mention this item to the
 :manager, as he has neither its history nor my letters of inquiry.
 :
 :    I find nothing else to include. We shall miss you greatly,
 :and we shall be looking for you at our new home.
 :
 :Yours sincerely,

#                                                            ../orig/m.typ:519
I:(4) Sedmipísmenná slova (p až z)
*:_M_R_L50
#                                                            ../orig/m.typ:539
S:Dear Patrick,
 :
 :    I realize that this letter I am sending may subject you to some trouble.
 :I am writing tonight without waiting to go through various reports on our
 :present program. If I had thought that you would be willing to give me an
 :extra day, perhaps I would have come myself.
 :
 :    As soon as this letter has reached you, and you have finished reading the
 :several items about which I have written, I hope you can give extra working
 :time to my request for special records. These items will suggest a new plan as
 :I picture it. I shall add them to this note.
 :
 :    It is my purpose to prepare a fast station-to-station service that should
 :be in running order soon. I suppose it could be started next month.  Let me
 :ask, also, whether we could receipt each payment, as we receive it, on a
 :regular form similar to those in the package shipped you Tuesday. I am pleased
 :with your showing. You have been like a soldier on duty in any and all
 :weather. Success is your teacher.
 :
 :With my best regards,

G:_M_E_M9
#------------------------------------------------------------------------------
# Lekce M10
#------------------------------------------------------------------------------
*:M10
*:_M_S_M10
#                                                            ../orig/m.typ:542
B:				Lekce M10
#                                                            ../orig/m.typ:543
I:(1) Rozcvička
*:_M_R_L51
#                                                            ../orig/m.typ:544
D:Blažený není ten, kdo má, co si přeje, ale ten, kdo si nepřeje,
 :co nemá

#                                                            ../orig/m.typ:545
I:(2) Vyvážené klávesové cvičení
*:_M_R_L52
#                                                            ../orig/m.typ:546
D:inter itude circu gious right cious after extra micro sible

#                                                            ../orig/m.typ:547
I:(3) Osmipísmenná slova(a -- m)
*:_M_R_L53
#                                                            ../orig/m.typ:566
S:Dear Thomas,
 :
 :    First, I consider of definite interest anything from
 :the business of as good a customer as you. As director of
 :our division, I am to continue handling building material.
 :My judgment on all the evidence, which I send herewith
 :enclosed in a second envelope, is one of complete approval.
 :Let me have a contract covering the earliest delivery date.
 :Are you advising me what increase in your discount is to be
 :expected?
 :
 :    Second, this forenoon I saw your son and he told me of
 :his marriage in February. Although you had not entirely
 :finished the addition to your lake house by last December,
 :couldn't you exchange it, as it is, for my mountain home?
 :Your son said that his young wife wants to live on this
 :mountain to which all your children seem so attached.
 :
 :Sincerely yours,

#
I:(4) Osmipísmenná slova (n až z)
*:_M_R_L54
#                                                            ../orig/m.typ:587
S:Dear Nathan,
 :
 :    My last shipment has probably been received, for the purchase was made
 :Thursday. Tomorrow is Saturday, a pleasant day, for I go on my vacation.
 :
 :    Do you remember an original idea you proposed last November relative
 :to planning for some shipping from my property? My neighbor recently
 :called it a plan in a thousand, and we must get together so that I can
 :thank you properly. This is a national as well as personal question,
 :and I am trusting that you will be thinking that it is possible for you to
 :help put it into practice.
 :
 :    If you can possibly separate yourself from teachers and your
 :teaching position sometime soon, plan to get a standard car and
 :whatever else is required for the trip. The car would also be a
 :pleasure after you return to New York. May I persuade you in re-
 :plying to state that you are planning to come promptly? We will
 :make you one of the officers of the shipping business.
 :
 :Yours sincerely,

#                                                            ../orig/m.typ:588
I:(5) Slova o devíti písmenech (od a k i)
*:_M_R_L55
#                                                            ../orig/m.typ:605
S:Dear Son,
 :
 :    I am beginning this afternoon to give my immediate attention
 :to a Christmas that should be beautiful. I have addressed, to be
 :forwarded and delivered in good condition, some new equipment
 :according to your wish. I note, too, that your committee met.
 :What these gentlemen said is important and may be a sort of in-
 :surance that your plan does not fail. I certainly would not want
 :to duplicate for you the kind of education given me.
 :
 :    Be different by following more than one new idea, including
 :some of your own. If you can carefully take fair advantage of
 :every available condition, everybody should accept you cordially,
 :as answering to the character of a gentleman. Mother is enclosing
 :a few lines.
 :
 :Yours sincerely,

G:_M_E_M10
#------------------------------------------------------------------------------
# Lekce M11
#------------------------------------------------------------------------------
*:M11
*:_M_S_M11
#                                                            ../orig/m.typ:608
B:				Lekce M11
#                                                            ../orig/m.typ:609
I:(1) Pro procvičení
*:_M_R_L56
#                                                            ../orig/m.typ:610
D:Velmi silný je ten, kdo dovede mlčet, i když je v právu.

#                                                            ../orig/m.typ:611
I:(2) Vyvážené klávesové cvičení
*:_M_R_L57
#                                                            ../orig/m.typ:612
D:thing pleas ought quest ember count ditio state recei ction

#                                                            ../orig/m.typ:613
I:(3) Devítipísmenná slova (j až z)
*:_M_R_L58
#                                                            ../orig/m.typ:633
S:Dear Gertrude,
 :
 :    This letter has no reference to shipments which you have
 :so kindly purchased from me in the past. Rather, as you are
 :returning to this territory by September, our president has re-
 :quested me as secretary to ask that you make a statement before
 :our club the first Wednesday.
 :
 :    Let me say something of the questions we have been receiving
 :for the year. Recently I read that the old principle today still
 :applies. It is wonderful what our new knowledge has surprised us
 :into regarding as necessary for ourselves--sometimes things not
 :even mentioned yesterday.
 :
 :    Will you therefore represent this new deal and present the
 :situation to us in principle, sincerely, as you see it? Other-
 :wise, if you cannot make this provision now, I shall be glad to
 :call upon you later.
 :
 :Yours sincerely,

#                                                            ../orig/m.typ:634
I:(4) Desetipísmenná slova (a až z)
*:_M_R_L59
#                                                            ../orig/m.typ:655
S:Dear Alex,
 :
 :    We are especially interested in the settlement run by a
 :new department at the University. We appreciate the importance
 :of its additional study to understand impossible conditions in
 :the poor parts of our city, and its use for adjustment of some
 :particular boy or girl. Have you read our memorandum in this
 :connection?
 :
 :    Our city is absolutely too big.  With the automobile we can
 :distribute every person to his home along a line, our wide road,
 :run far out from the city. The difference between country and
 :city grows less and less, in accordance with such use of the auto-
 :mobile.
 :
 :    Concerning our collection of any remittance from you, this
 :would serve to form a Conference which would develop everything
 :that can make city governments bring full and rich experience
 :to all.
 :
 :Sincerely yours,

#                                                            ../orig/m.typ:656
I:(5) Jedenácti až čtrnáctipísmenná slova (a až z)
*:_M_R_L60
#                                                            ../orig/m.typ:673
S:Dear Sir,
 :
 :    I wish to acknowledge the recent interesting correspondence
 :from your office on the very considerable requirements of the new
 :law that have to do with any unfortunate advertising that might
 :appear in my papers.
 :
 :    Our association also has appreciated both your instructions
 :and the opportunity for prompt examination and understanding of
 :the new arrangement, particularly its application to all informa-
 :tion given the public about merchandise for sale. This has been
 :a real convenience in our consideration of the entire proposition.
 :
 :    I want to assure you that our co-operation under the new law
 :will be satisfactory in every way.
 :
 :Yours respectfully,

#                                                            ../orig/m.typ:674
I:(6) Cílený odstavec (l r z)
*:_M_R_L61
#                                                            ../orig/m.typ:687
S:    The JOURNAL learned that the relatives on their arrival in
 :April had already referred the trouble to lawyers. Their early re-
 :turn surprises me. As to the children themselves, the older girls
 :are personally agreeable, slender, and certainly full of zest. They
 :travel yearly and already are familiar with the world. Their father
 :was a quizzical old man who fairly idolized them. His will leaves
 :them very nearly a half-million dollars. Only the earlier, first
 :will is very irregular. I've already quizzed them about the real
 :hazards of quarrels over legal prizes of similar size. From their
 :replies I've realized slowly that the girls are all right. It
 :really amazes me that even persons like ourselves promptly seize
 :upon some hostile relative's version of an earlier will, which
 :should be recognized easily as false.

G:_M_E_M11
#------------------------------------------------------------------------------
# Lekce series M jump tables
#------------------------------------------------------------------------------
*:_M_E_M1
Q:Chcete pokračovat do lekce M2 [Y(ano)/N(ne)] ?
N:_M_MENU
G:_M_M_M2
*:_M_E_M2
Q:Chcete pokračovat do lekce M3 [Y(ano)/N(ne)] ?
N:_M_MENU
G:_M_M_M3
*:_M_E_M3
Q:Chcete pokračovat do lekce M4 [Y(ano)/N(ne)] ?
N:_M_MENU
G:_M_M_M4
*:_M_E_M4
Q:Chcete pokračovat do lekce M5 [Y(ano)/N(ne)] ?
N:_M_MENU
G:_M_M_M5
*:_M_E_M5
Q:Chcete pokračovat do lekce M6 [Y(ano)/N(ne)] ?
N:_M_MENU
G:_M_M_M6
*:_M_E_M6
Q:Chcete pokračovat do lekce M7 [Y(ano)/N(ne)] ?
N:_M_MENU
G:_M_M_M7
*:_M_E_M7
Q:Chcete pokračovat do lekce M8 [Y(ano)/N(ne)] ?
N:_M_MENU
G:_M_M_M8
*:_M_E_M8
Q:Chcete pokračovat do lekce M9 [Y(ano)/N(ne)] ?
N:_M_MENU
G:_M_M_M9
*:_M_E_M9
Q:Chcete pokračovat do lekce M10 [Y(ano)/N(ne)] ?
N:_M_MENU
G:_M_M_M10
*:_M_E_M10
Q:Chcete pokračovat do lekce M11 [Y(ano)/N(ne)] ?
N:_M_MENU
G:_M_M_M11
*:_M_E_M11
G:_M_MENU

*:_M_M_M1
B:                            Lekce M1
G:_M_S_M1
*:_M_M_M2
B:                            Lekce M2
G:_M_S_M2
*:_M_M_M3
B:                            Lekce M3
G:_M_S_M3
*:_M_M_M4
B:                            Lekce M4
G:_M_S_M4
*:_M_M_M5
B:                            Lekce M5
G:_M_S_M5
*:_M_M_M6
B:                            Lekce M6
G:_M_S_M6
*:_M_M_M7
B:                            Lekce M7
G:_M_S_M7
*:_M_M_M8
B:                            Lekce M8
G:_M_S_M8
*:_M_M_M9
B:                            Lekce M9
G:_M_S_M9
*:_M_M_M10
B:                           Lekce M10
G:_M_S_M10
*:_M_M_M11
B:                           Lekce M11
G:_M_S_M11
#------------------------------------------------------------------------------
# Lekce series M menu
#------------------------------------------------------------------------------
*:_M_MENU
M: UP=__SERIESMENU "Série M obsahuje těchto 11 lekcí"
 :_M_M_M1  "Lekce M1     Cvičení"
 :_M_M_M2  "Lekce M2     Cvičení"
 :_M_M_M3  "Lekce M3     Cvičení"
 :_M_M_M4  "Lekce M4     Cvičení"
 :_M_M_M5  "Lekce M5     Cvičení"
 :_M_M_M6  "Lekce M6     Cvičení"
 :_M_M_M7  "Lekce M7     Cvičení"
 :_M_M_M8  "Lekce M8     Cvičení"
 :_M_M_M9  "Lekce M9     Cvičení"
 :_M_M_M10 "Lekce M10    Cvičení"
 :_M_M_M11 "Lekce M11    Cvičení"
*:_M_EXIT
#------------------------------------------------------------------------------
G:__SERIESMENU
#==============================================================================
#==============================================================================
*:__S_S_SERIES
# Typist v2.2 - improved typing tutor program for UNIX systems
# Copyright (C) 1998 Simon Baldwin (simonb@sco.com)
#
#
# Translated, modified by Hynek Hanke (hanke@volny.cz)
#
# Copyright (C) 2001 Hynek Hanke (hanke@volny.cz), Gnumaniacs.Org
#
# This was translated and modified to Czech by Hynek "0A4h" Hanke
# hanke@volny.cz / Gnumaniacs.Org
# Please report bugs to hanke@volny.cz, *not* to Simon!
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

#------------------------------------------------------------------------------
# Series S
#------------------------------------------------------------------------------
G:_S_MENU
*:_S_NO_MENU
#------------------------------------------------------------------------------
# Lekce S1
#------------------------------------------------------------------------------
*:S1
*:_S_S_S1
*:_S_R_L0
#                                                             ../orig/s.typ:14
T:			Rychlostní cvičení
 :
 :Série lekcí S je navržena k tomu, aby vám pomohla zlepšit vaši
 :rychlost a přesnost psaní. Předpokládáme, že jste se již naučili
 :správně psát na nějakém předchozím kurzu nebo ze série T.
 :
 :Můžete používat tato cvičení i když neumíte správně psát
 :všemi deseti, ale doporučujeme, abyste se naučili, než
 :začnete, alespoň většinu písmen abecedy. Pokud nevíte,
 :jak napsat nějaký znak, budete se muset podívat. To je ale
 :velmi špatný zvyk a těžko se ho zbavuje. (Nemusíte se strachovat,
 :pokud sklápíte zrak pouze kvůli málo používaným klávesám,
 :jako je znak dolaru.)

*:_S_R_L1
#                                                             ../orig/s.typ:30
T:			  Pravidla
 :
 :Při opisování textu vás budu měřit. Od okamžiku, kdy zadáte první
 :písmeno řádky až do okamžiku, kdy stisknete ukončující ENTER,
 :poběží moje stopky. Až skončíte, spočítám vaši rychlost a převedu
 :ji na slova za sekundu (words per minute -- WPM). Sečtu také
 :všechny chyby a zobrazím vám jejich počet.
 :
 :Kdykoliv uděláte chybu, zapípám a rozsvítím písmeno, které jste měli
 :zadat, v obrácených barvách (černé písmeno na bílém pozadí).
 :Můžete chybu ignorovat a pokračovat, nebo se můžete také vrátit
 :a s použitím kláves DELETE nebo BACKSPACE ji opravit, ale já
 :to budu stále počítat za chybu.
 :
 :Pokud uděláte příliš mnoho chyb, zkuste to příště pomaleji.
 :Když neuděláte žádnou chybu, nebo pouze jednu či dvě, zkuste
 :příští odstavec rychleji.

#                                                             ../orig/s.typ:31
I:Nejprve rychlé rozcvičení. Tato anglická věta obsahuje celou abecedu.
*:_S_R_L2
#                                                             ../orig/s.typ:32
S:The quick brown fox jumped over the lazy dogs.

#                                                             ../orig/s.typ:33
I:Ještě jednou:
*:_S_R_L3
#                                                             ../orig/s.typ:34
S:The quick brown fox jumped over the lazy dogs.

#                                                             ../orig/s.typ:35
I:Když je kurzor na prázdné řádce, stiskněte ENTER a přeskočte ji.
*:_S_R_L4
#                                                             ../orig/s.typ:48
S:Dobrý den,
 :
 :právě jsem si koupil počítačový systém Heathkit H89
 :a rád bych si pro něj objednal dva balíky disket.
 :Systém používá 5 1/4 palcové jednostranné diskety.
 :
 :Přikládám šek na 45 dolarů. Prosím vyřiďte objednávku
 :co nejrychleji, protože dokud diskety nedorazí, nemohu
 :systém používat.
 :
 :Předem děkuje,
 :
 :Mgr. Žirafa

*:_S_R_L5
#                                                             ../orig/s.typ:61
S:Dobrý den,
 :
 :děkuji za rychlé zaslání disket. Dodané diskety jsou
 :ale pro jiný typ mechanik. Jak jsem uvedl v předchozím
 :dopise, můj systém podporuje pouze deseti-sektorové
 :diskety.
 :
 :Vrátím vám tyto dva balíčky hned jak obdržím ty správné.
 :
 :Předem děkuje,
 :
 :Mgr. Žirafa

*:_S_R_L6
#                                                             ../orig/s.typ:76
S:Vážený Mgr. Žirafo,
 :
 :děkujeme za informace o zaslání nevyhovujících disket.
 :Hluboce se vám za to omlouváme a vynasnažíme se to co
 :nejrychleji napravit.
 :
 :Prosíme Vás, abyste nám ještě jednou zaslal přesné
 :požadavky na typ disket, které jsou dané vaší mechanikou.
 :V případě potřeby vám můžeme nabídnout z našeho sortimentu
 :i jiné mechaniky.
 :
 :Doufáme, že se situace k oboustranné spokojenosti co
 :nejrychleji vyřeší. Ještě jednou se vám hluboce omlouváme.

G:_S_E_S1
#------------------------------------------------------------------------------
# Lekce S2
#------------------------------------------------------------------------------
*:S2
*:_S_S_S2
*:_S_R_L7
#                                                             ../orig/s.typ:83
T:
 :V této lekci si projdeme nějaké citáty od slavných (a méně
 :slavných) lidí.

#                                                             ../orig/s.typ:84
I:Marcus Aurelius
*:_S_R_L8
#                                                             ../orig/s.typ:85
S:Člověku se může žít dobře dokonce i v paláci.

#                                                             ../orig/s.typ:93
I:George Washington
*:_S_R_L12
#                                                             ../orig/s.typ:94
S:Pravé přátelství je květina pomalého růstu.

#                                                             ../orig/s.typ:95
I:Aristoteles
*:_S_R_L13
#                                                             ../orig/s.typ:96
S:I v mozku té nejmoudřejší ženy je pošetilý kout.

#                                                            ../orig/s.typ:119
I:James Holt McGravran.
*:_S_R_L18
#                                                            ../orig/s.typ:121
S:Existuje ještě rychlejší způsob jak přesouvat peníze,
 :než je elektronické bankovnictví. Nazývá se sňatek.

#                                                            ../orig/s.typ:124
I:Robert Frost
*:_S_R_L20
#                                                            ../orig/s.typ:125
S:Báseň začíná v radosti a končí v moudrosti.

#                                                            ../orig/s.typ:126
I:Louis Pasteur
*:_S_R_L21
#                                                            ../orig/s.typ:128
S:Když potkám dítě, vyvolává to ve mně dva pocity: měkkost
 :pro to, čím je, a respekt pro to, čím se může stát.

I:Murphy
*:_S_R_L22
S:Vždy si půjčujte peníze od pesimisty. Ten nedoufá, že by
 :je někdy dostal zpět.

I:Katharin Hepburn
*:_S_R_L23
S:Být milován je velmi demoralizující.

I:George Bernard Shaw
*:_S_R_L24
S:Dětství je tak úžasná věc. Je zločinem plýtvat s ní na dětech.

I:M.L.Mencken
*:_S_R_L25
S:Láska je triumf představivosti nad inteligencí.

I:Murphy
*:_S_R_L26
S:Počítače jsou nespolehlivé, lidé také. Avšak počítače jsou v tom
 :mnohem důkladnější.

I:Murphy
*:_S_R_L27
S:Jesltiže zůstáváš klidný, zatímco ostatní ztrácejí hlavu,
 :je to neklamná známka toho, že jsi problém nepochopil.

I:Nietzsche
*:_S_R_L28
S:Manželství je právě tak cenné jako ti, které spojuje.
 :Obvykle tedy nestojí za nic.


G:_S_E_S2
#------------------------------------------------------------------------------
# Lekce S3
#------------------------------------------------------------------------------
*:S3
*:_S_S_S3
*:_S_R_L29
#                                                            ../orig/s.typ:134
T:
 :V této lekci budeme opisovat ukázky z několika děl.
 :Snažte se psát co nejrychleji, ale bezchybně.
 :Pokud zjistíte, že děláte moc chyb, zpomalte.

I:Douglas Adams: Stopařův průvodce po galaxii
*:_S_R_L30
S:Dálnice jsou zařízení, která umožňují jistým lidem řítit
 :se z bodu A do B značnou rychlostí, zatímco jiní lidé se
 :značnou rychlostí řítí z bodu B do dobu A. Lidé, co bydlí
 :v bodě C, který leží přesně uprostřed, se občas musí divit,
 :co je na bodě A tak úžasného, že se taková spousta lidí
 :z bodu B jen třese na to, aby se tam dostali, a co je tak
 :zajímavého na bodě B, že taková spousta z bodu A stojí o to,
 :se tam dostat. A často si přejí, aby se lidi už jednou ksakru
 :rozhodli, kde vlastně chtějí být.

I:J. K. Jerome: Jalové myšlenky lenivého člověka
*:_S_R_L31
S:Lenošení se mi líbí, když bych neměl zaháleti, a ne, když je
 :to jediná věc, kterou mám na práci. Mám už tak hloupou povahu.
 :Nejraději se postavím zády ke kamnům a počítám v duchu, kolik
 :jsem komu dlužen, když je můj stůl plný dopisů, které mají být
 :zodpovězeny nejbližší poštou. Loudám-li se zvlášť s obědem, je
 :to tehdy, když mne na večer čeká velká práce. A jestliže z nějakých
 :nutných důvodů mám vstávati zvláště brzy, tu více než kdy jindy si
 :pochutnám na mimořádné půlhodince v posteli.

I:David Lodge: Hostující profesoři
*:_S_R_L32
S:Absolvovat vysokou školu v Americe není příliš těžké.
 :Student má značnou volnost, zkoušky skládá v libovolném
 :termínu, podvádět je snadné a kvůli výsledným známkám
 :se neprožívají zvláštní stresy nebo úzkostné stavy.
 :Student (či studentka) se tudíž může plně věnovat normálním
 :zájmům dospívajícího člověka --- sportu, alkoholu, zábavě
 :a opačnému pohlaví. Skutečný tlak začíná až v postgraduálním
 :stadiu, kdy se student tříbí a kalí v nelítostných cvičeních
 :a přísných prověrkách tak dlouho, dokud si nezaslouží být
 :pasován na PhDr. To už do věci investoval tolik času a peněz,
 :že pro něho nepřichází v úvahu žádná jiná kariéra než akademická,
 :a to výhradně úspěšná, neboť jiná je nepřijatelná. Zkrátka a dobře,
 :je vyškolen k profesi, která je prosáklá duchem volného podnikání
 :neméně než Wall Street a ve které každý vyučující vědec uzavírá
 :se svým zaměstnavatelem osobní smlouvu a má právo prodat své služby
 :tomu, kdo nabídne nejvíc.


I:C. D. Payne: Mladík v odboji
*:_S_R_L33
S:SOBOTA, 18. SRPNA
 :
 :Sem na prázdninách. Je to k nevíře. Tohle píšu ručně do
 :opravdickýho sešitu s tím, že to pak přepíšu do počítače. Je to
 :šílená dřina. Ale zřejmě v dobách, kdy tužka byla čerstvej
 :vynález, to musel bejt vobrovskej pokrok. Pak k ní ňákej génius
 :vymyslel gumu a všichni se jali apgrejdovat.

I:Douglas Adams: Stopařův průvodce po galaxii
 :Tento text jsme již opisovali na začátku lekce. Zkuste si
 :jej znovu a rychleji.
*:_S_R_L34
S:Dálnice jsou zařízení, které umožňuje jistým lidem řítit
 :se z bodu A do B značnou rychlostí, zatímco jiní lidé se
 :značnou rychlostí řítí z bodu B do dobu A. Lidé, co bydlí
 :v bodě C, který leží přesně uprostřed, se občas musí divit,
 :co je na bodě A tak úžasného, že se taková spousta lidí
 :z bodu B jen třese na to, aby se tam dostali, a co je tak
 :zajímavého na bodě B, že taková spousta z bodu A stojí o to,
 :se tam dostat. A často si přejí, aby se lidi už jednou ksakru
 :rozhodli, kde vlastně chtějí být.

G:_S_E_S3
#------------------------------------------------------------------------------
# Lekce S4
#------------------------------------------------------------------------------
*:S4
*:_S_S_S4
*:_S_R_L35
#                                                            ../orig/s.typ:202
T:
 :V této lekci opět pokračujeme několika ukázkami z různých knih.
#                                                            ../orig/s.typ:183
I:Douglas Adams: Stopařův průvodce po galaxii
*:_S_R_L36
S:Kdesi daleko v zaostalých a nezmapovaných končinách onoho
 :cípu Západního spirálního ramene naší Galaxie, který si rozhodně
 :nemůže dělat nároky na módnost, leží jedno malé, bezvýznamné žluté
 :slunce. Kolem něj zhruba ve vzdálenosti sto padesáti miliónů kilometrů
 :obíhá naprosto zanedbatelná nepatrná modrozelená planeta, na níž jsou
 :formy života vzešlé z opic tak úžasně primitivní, že se dosud domnívají,
 :že digitální hodinky jsou docela šikovný nápad. Hlavní problém této
 :planety spočívá -- nebo spíš spočíval -- v tom, že většina lidí, kteří
 :na ní žijí, je povětšinou nešťastná. Vyskytlo se mnoho pokusů o řešení,
 :většinou se však týkaly pohybu malých zelených kousků papíru, což je
 :zvláštní, protože ony malé zelené kousky papíru koneckonců nešťastné
 :nebyly.

I:J. K. Jerome: Tři muži ve člunu, o psu nemluvě
*:_S_R_L37
S:Nic mě tolik nepopudí, jako když si ti druzí jenom sedí a nic
 :nedělají, zatímco já pracuju.
 :
 :Jednou jsem bydlel s člověkem, který mě tímhle způsobem doháněl
 :skoro k šílenství. Vždycky když jsem něco dělal, on se povaloval na
 :pohovce a koukal na mě --- celé hodiny mě vydržel sledovat očima,
 :ať jsem se v tom pokoji kamkoli pohnul. Říkal, že mu dělá úžasně dobře,
 :když se může dívat, jak pilně markýruju práci. Prý mu to dokazuje, že
 :život není jen jalové snění, určené k prozevlování a prozívání, ale
 :vznešené poslání, plné povinností a tvrdé práce. Často už prý si kladl
 :otázku, jak mohl vůbec existovat, než se seznámil se mnou, když neměl
 :nikoho, koho by mohl pozorovat při práci.
 :
 :Tak takovýhle já nejsem. Já nevydržím klidně sedět, když vidím,
 :jak se někdo jiný otrocky lopotí. To musím vstát a dozírat na něj,
 :obcházet ho s rukama v kapsách a radit mu, jak na to. To dělá
 :ta moje činorodá povaha. Tomu se prostě neubráním.

I:Dr. Jiří Guth: Společenský katechismus
*:_S_R_L38
S:Jděte po ulici a pozorujte chování různých lidí --- podle
 :jejich chůze, chování, pohledů, posunů atd. posoudíte hned,
 :jakého asi jsou druhu a stanou se vám sympatickými nebo vzbuzují
 :odpor. Tedy pán bezohledně vám foukne kouř cigarety do tváře,
 :tam zavane vám z dámy celý voňavkářský krám a onde zas pozorujete,
 :kterak dáma se ohlíží zvědavě za toilettě dámy jiné, zlozvyk,
 :který zvláště v Praze bují jako koukol mezi pšenicí. A kdyby
 :to byly toliko závistivé a zvědavé dámy! Ale stačí jen drobná
 :věc vymykající se všeobecnosti a už je, ať tak dím, celá Praha vzhůru.
 :Kdysi odpoledne šel po Příkopech důstojník, nemající na sobě nic
 :nápaditějšího, než na čepici bílou pásku z manévrů. Šel jsem za
 :ním... Od piaristského kostela a k Živnostenské bance ohlédlo se
 :po něm třicet sedm osob!

#                                                            ../orig/s.typ:228
I:Julius Caesar, Akt III, Scéna II (Fórum) (anglicky)
*:_S_R_L39
#                                                            ../orig/s.typ:243
S:Friends, Romans, countrymen, lend me your ears;
 :I come to bury Caesar, not to praise him.
 :The evil that men do lives after them;
 :The good is oft interred with their bones;
 :So let it be with Caesar: The noble Brutus
 :Hath told you Caesar was ambitious:
 :If it were so, it was a grievous fault;
 :And grievously hath Caesar answer'd it.
 :Here, under leave of Brutus and the rest,--
 :For Brutus is an honourable man;
 :So are they all, all honourable men,--
 :Come I to speak in Caesar's funeral.
 :He was my friend, faithful and just to me;
 :But Brutus says he was ambitious;
 :And Brutus is an honourable man.

*:_S_R_L40
#                                                            ../orig/s.typ:263
S:I speak not to disprove what Brutus spoke,
 :But here I am to speak what I do know.
 :You all did love him once,--not without cause:
 :What cause withholds you, then, to mourn for him?
 :O judgement, thou art fled to brutish beasts,
 :And men have lost their reason!--Bear with me;
 :My heart is in the coffin there with Caesar,
 :And I must pause till it come back to me.


G:_S_E_S4
#------------------------------------------------------------------------------
# Lekce series S jump tables
#------------------------------------------------------------------------------
*:_S_E_S1
Q:Chcete pokračovat do lekce S2 [Y(ano)/N(ne)] ?
N:_S_MENU
G:_S_M_S2
*:_S_E_S2
Q:Chcete pokračovat do lekce S3 [Y(ano)/N(ne)] ?
N:_S_MENU
G:_S_M_S3
*:_S_E_S3
Q:Chcete pokračovat do lekce S4 [Y(ano)/N(ne)] ?
N:_S_MENU
G:_S_M_S4
*:_S_E_S4
G:_S_MENU

*:_S_M_S1
B:                            Lekce S1
G:_S_S_S1
*:_S_M_S2
B:                            Lekce S2
G:_S_S_S2
*:_S_M_S3
B:                            Lekce S3
G:_S_S_S3
*:_S_M_S4
B:                            Lekce S4
G:_S_S_S4
#------------------------------------------------------------------------------
# Lekce series S menu
#------------------------------------------------------------------------------
*:_S_MENU
M: UP=__SERIESMENU "Série S obsahuje tyto 4 lekce"
 :_S_M_S1 "Lekce S1     Dopisy Mgr. Žirafy"
 :_S_M_S2 "Lekce S2     Citáty"
 :_S_M_S3 "Lekce S3     Ukázky z knih"
 :_S_M_S4 "Lekce S4     Z knih; Část hry Shakespeara v angličtině"
*:_S_EXIT

#------------------------------------------------------------------------------
# End of file s.typ
G:__SERIESMENU
#==============================================================================
#==============================================================================
*:__S_N_SERIES
# Start of file n.typ
# Typist v2.2 - improved typing tutor program for UNIX systems
# Copyright (C) 1998 Simon Baldwin (simonb@sco.com))
#
# Translated, modified by Hynek Hanke (hanke@volny.cz)
#
# Copyright (C) 2001 Hynek Hanke (hanke@volny.cz), Gnumaniacs.Org
#
# This was translated and modified to Czech by Hynek "0A4h" Hanke
# hanke@volny.cz / Gnumaniacs.Org
# Please report bugs to hanke@volny.cz, *not* to Simon!
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

#------------------------------------------------------------------------------
# Series N
#------------------------------------------------------------------------------
G:_N_MENU
*:_N_NO_MENU
#------------------------------------------------------------------------------
# Lekce N1
#------------------------------------------------------------------------------
*:N1
*:_N_S_N1
*:_N_R_L0
#                                                             ../orig/n.typ:21
T:
 :			Lekce numerické klávesnice
 :
 :Série lekcí N vás naučí pracovat s numerickou klávesnicí.
 :K tomu, abyste mohli kurz absolvovat, nepotřebujete umět
 :psát deseti prsty na klasické klávesnici. Můžete tedy začít
 :přímo touto sérií.
 :
 :Když zadáváte numerické hodnoty, tak je většinou důležitější
 :přesnost než rychlost. Procházejte těmito lekcemi velmi pomalu.
 :Rychlost se později dostaví sama.
 :
 :Tak jako na standardní klávesnici musíte začínat v základní
 :pozici. Umístěte první tři prsty vaší pravé ruky na klávesy
 :4, 5, 6 (ukazováček, prostředníček, prsteníček).
 :
 :Palec a váš šestý prst jsou volné. Prsty by se měly pouze lehce
 :vznášet nad klávesnicí. Mezerník mačkejte palcem či jakýmkoliv
 :jiným prstem levé ruky.

#                                                             ../orig/n.typ:22
I:Používejte pouze prsteníček
*:_N_R_L1
#                                                             ../orig/n.typ:23
D:666666

#                                                             ../orig/n.typ:24
I:Používejte prostředníček pro psaní čísla 5.
*:_N_R_L2
#                                                             ../orig/n.typ:25
D:6565656

#                                                             ../orig/n.typ:26
I:4ku pište ukazováčkem.
*:_N_R_L3
#                                                             ../orig/n.typ:27
D:666444555444666

#                                                             ../orig/n.typ:28
I:Zkuste si teď pár řádek. ENTER mačkáme malíčkem.
*:_N_R_L4
#                                                             ../orig/n.typ:36
S:666444666
 :444555666
 :555444555
 :666444666
 :646464646
 :656565656
 :445566555
 :456456456

#                                                             ../orig/n.typ:37
I:Tečku pište prsteníčkem.
*:_N_R_L5
#                                                             ../orig/n.typ:38
D:555...555

*:_N_R_L6
#                                                             ../orig/n.typ:43
S:5.54.45.56.6
 :444.555
 :45.56.6
 :64.65.4
 :54.65.4

*:_N_R_L7
#                                                             ../orig/n.typ:48
S:445566.654
 :654456.546
 :546546.564
 :554466.645
 :555444.666

#                                                             ../orig/n.typ:49
I:Jedničku pište vychýlením ukazováčku dolů.
*:_N_R_L8
#                                                             ../orig/n.typ:50
D:444111444.444111444

*:_N_R_L9
#                                                             ../orig/n.typ:55
S:111.444
 :414.141
 :456.546
 :415.164
 :541.146

#                                                             ../orig/n.typ:56
I:Zopakujeme si, co jsme se již naučili.
*:_N_R_L10
#                                                             ../orig/n.typ:57
D:444555666111...555444666111

*:_N_R_L11
#                                                             ../orig/n.typ:66
S:414.564
 :546.145
 :546.145
 :644.146
 :615.645
 :564.145
 :546.164
 :111.555
 :514.651

G:_N_E_N1
#------------------------------------------------------------------------------
# Lekce N2
#------------------------------------------------------------------------------
*:N2
*:_N_S_N2
#                                                             ../orig/n.typ:69
I:Nejprve opakování z lekce 1.
*:_N_R_L12
#                                                             ../orig/n.typ:70
D:444.555.666.111.6541.6541

#                                                             ../orig/n.typ:71
I:2ku píšeme prstem z klávesy 5 (prostředníček).
*:_N_R_L13
#                                                             ../orig/n.typ:72
D:555222555.525.525.525

*:_N_R_L14
#                                                             ../orig/n.typ:79
S:45.25
 :52.52
 :62.62
 :22.22
 :51.12
 :12.52
 :24.42

#                                                             ../orig/n.typ:80
I:3ku píšeme prstem z klávesy 6 (prsteníček).
*:_N_R_L15
#                                                             ../orig/n.typ:81
D:666333666.636.636

*:_N_R_L16
#                                                             ../orig/n.typ:88
S:456.123
 :321.654
 :666.333
 :323.353
 :343.313
 :353.363
 :313.434

*:_N_R_L17
#                                                             ../orig/n.typ:97
S:12.33
 :45.33
 :65.35
 :12.35
 :65.25
 :25.63
 :43.53
 :13.36
 :34.31

#                                                             ../orig/n.typ:98
I:Nulu píšeme výraznějším vychýlením ukazováčku ze 4ky dolů.
*:_N_R_L18
#                                                             ../orig/n.typ:99
D:444000444.401.410

*:_N_R_L19
#                                                            ../orig/n.typ:100
D:410.020.030.040.060.104

*:_N_R_L20
#                                                            ../orig/n.typ:106
S:12.00
 :23.00
 :51.50
 :46.25
 :54.00
 :13.04

#                                                            ../orig/n.typ:107
I:8ku píšeme vychýlením prostředníčku z 5ky nahoru.
*:_N_R_L21
#                                                            ../orig/n.typ:108
D:555888555.852.258

*:_N_R_L22
#                                                            ../orig/n.typ:109
D:585.080.808.818.282

*:_N_R_L23
#                                                            ../orig/n.typ:115
S:81.05
 :84.80
 :88.88
 :58.28
 :80.18
 :28.38

#                                                            ../orig/n.typ:116
I:Devítku píšeme prstem z 6ky.
*:_N_R_L24
#                                                            ../orig/n.typ:117
D:666999666.393.696

*:_N_R_L25
#                                                            ../orig/n.typ:118
D:595.989.696.393.295

*:_N_R_L26
#                                                            ../orig/n.typ:126
S:.91
 :.90
 :.94
 :.95
 :.96
 :.93
 :.90
 :.95

#                                                            ../orig/n.typ:127
I:Poslední číslo je sedm. Pište jej prstem ze 4ky.
*:_N_R_L27
#                                                            ../orig/n.typ:128
D:444777444.0147.7410

*:_N_R_L28
#                                                            ../orig/n.typ:129
D:767.737.797.727.707.717

*:_N_R_L29
#                                                            ../orig/n.typ:130
D:1234567890.1234567890

*:_N_R_L30
#                                                            ../orig/n.typ:140
S:17.19
 :71.70
 :19.37
 :57.07
 :71.37
 :27.72
 :37.73
 :76.67
 :45.17
 :70.07

*:_N_R_L31
#                                                            ../orig/n.typ:149
S:75856
 :87237
 :21570
 :24870
 :47258
 :21573
 :21573
 :21584
 :35827

G:_N_E_N2
#------------------------------------------------------------------------------
# Lekce N3
#------------------------------------------------------------------------------
*:N3
*:_N_S_N3
#                                                            ../orig/n.typ:152
I:Nejprve si zopakujeme čísla.
*:_N_R_L32
#                                                            ../orig/n.typ:153
D:1234567890.0987654321

*:_N_R_L33
#                                                            ../orig/n.typ:154
D:12.34.56.78.90.10.29.38.47.57

*:_N_R_L34
#                                                            ../orig/n.typ:165
S:123.654
 :212.658
 :908.000
 :285.080
 :288.381
 :398.813
 :286.187
 :924.156
 :684.028
 :354.459
 :321.840

*:_N_R_L35
#                                                            ../orig/n.typ:178
S:12345
 :35840
 :25874
 :93682
 :71489
 :31265
 :97824
 :28617
 :39715
 :17935
 :28460
 :52846
 :28469

*:_N_R_L36
#                                                            ../orig/n.typ:187
S:1.00
 :2.05
 :3.50
 :4.52
 :5.81
 :6.95
 :7.00
 :8.45
 :9.50

*:_N_R_L37
#                                                            ../orig/n.typ:195
S:879.359
 :286.498
 :357.159
 :654.852
 :159.357
 :571.392
 :284.293
 :231.879

*:_N_R_L38
#                                                            ../orig/n.typ:203
S:100.200
 :258.246
 :369.741
 :123.987
 :582.714
 :239.900
 :273.194
 :372.973

#                                                            ../orig/n.typ:204
I:Mezeru mačkejte libovolným prstem levé ruky.
*:_N_R_L39
#                                                            ../orig/n.typ:205
D:111 222 333 444 555 666 777 888 999 000

*:_N_R_L40
#                                                            ../orig/n.typ:211
S:123 654 879 264
 :128 364 928 187
 :987 234 681 287
 :357 159 671 077
 :350 950 137 940
 :320 487 364 197

*:_N_R_L41
#                                                            ../orig/n.typ:220
S:82.01 35
 :28.50 12
 :50.00 79
 :40.25 37
 :82.50 19
 :99.95 61
 :12.95 87
 :40.00 55
 :64.50 99

G:_N_E_N3
#------------------------------------------------------------------------------
# Lekce series N jump tables
#------------------------------------------------------------------------------
*:_N_E_N1
Q:Chcete pokračovat do lekce N2 [Y(ano)/N(ne)] ?
N:_N_MENU
G:_N_M_N2
*:_N_E_N2
Q:Chcete pokračovat do lekce N3 [Y(ano)/N(ne)] ?
N:_N_MENU
G:_N_M_N3
*:_N_E_N3
G:_N_MENU

*:_N_M_N1
B:                            Lekce N1
G:_N_S_N1
*:_N_M_N2
B:                            Lekce N2
G:_N_S_N2
*:_N_M_N3
B:                            Lekce N3
G:_N_S_N3
#------------------------------------------------------------------------------
# Lekce series N menu
#------------------------------------------------------------------------------
*:_N_MENU
M: UP=__SERIESMENU "Série N obsahuje tyto 3 lekce"
 :_N_M_N1 "Lekce N1     4 5 . 6 1"
 :_N_M_N2 "Lekce N2     2 3 0 8 9 7"
 :_N_M_N3 "Lekce N3     Procvičování"
*:_N_EXIT

#------------------------------------------------------------------------------
# End of file n.typ
G:__SERIESMENU
#==============================================================================
*:__MORE_LESSONS
T:... spuštěním gtypistu s parametrem jako některým z těchto
 :jmen souborů můžete přistupovat i k jiným sadám lekcí:
 :
 : en.typ - Anglické lekce
 : esp.typ - Španělské lekce
 : ktde.typ - Německé lekce z ktouch
 : kten.typ - Anglické lekce z ktouch
 : ktfr.typ - Francouzské lekce z ktouch
 : ktlecten.typ - Další sada anglických lekcí z ktouch
 : ktno.typ - Norské lekce z ktouch
 : ktnumber.typ - Ktouch lekce pro numerickou klávesnici
 : ttde.typ - Německé lekce z tipptrainer
 :
 :Pro více informací si prohlédněte komentáře na začátku
 :každého .typ souboru.
G:__SERIESMENU
*:__HELP
T:                     Nápověda
 : o Jak program ovládat
 : o Proč mám opačně Y a Z? Co to je QWERTY?
 : o Jak se s pomocí programu mohu naučit psát na QWERTZ?
 : o Kam posílat oznámení o chybách
 :
 :Skrz lekce a menu se můžete pohybovat s použitím Fx kláves
 :v horní řadě klávesnice. Pokud se nalézáte uvnitř nějaké lekce,
 :tak vás stisk F12 přenese do menu lekce. Zde vás stisk F12
 :přenese do výběru sérií lekcí. Pakliže zmáčknete F12 ve výběru
 :lekcí, opustíte program. Na některé dotazy budete odpovídat ano/ne.
 :V takovém případě stisk Y znamená ano, stisk N znamená ne.
 :
 :Místo Fx kláves (např. pokud je váš terminál nemá) můžete použít
 :i klávesy od 1 do 9 pro F1-F9, 0 pro F10 a klávesu A pro F11
 :stejně jako S pro F12.
 :
 :Příručku ke gtypistu si můžete zobrazit zadáním
 :,,info gtypist'' či ,,info (gtypist)'' na vašem
 :terminálu. Pokud pracujete pod dosem, zobrazte
 :si soubor gtypist.html.
 :		--Pro další stranu stiskněte ENTER--
T: 		Proč mám opačně Y/Z, co je to QWERTY?
 :
 :Česká klávesnice má bohužel jeden obrovský problém a tím je
 :nestandardní poloha kláves Y a Z. Často se můžete setkat
 :s tím, že klávesa Y v horní řadě bude ve skutečnosti psát
 :písmeno Z a obdobně klávesa Z v řadě dolní bude psát Y.
 :Takovým klávesnicím se říká QWERTZ (podle polohy prvních
 :šesti kláves horní řady).
 :
 :Jelikož toto způsobuje obrovské problémy (zvlášť pokud jste
 :nuceni přepínat mezi českou a anglickou klávesnicí), zaměřuje
 :se tento kurz na klávesnici QWERTY tak, jak je mezinárodně
 :standardizovaná. Vřele vám doporučuji nastavit si na svém
 :systému také tuto klávesnici, pokud ji ještě nepoužíváte.
 :Není to žádný problém, prostě hledejte v nastavení klávesnice
 :slovo QWERTY a QWERTZ. Pokud máte QWERTZ, přepněte na QWERTY.
 :
 :Přeji mnoho ušetřených nervů.
 :		--Pro další stranu stiskněte ENTER--
T: 		Jak se s pomocí programu naučit QWERTZ
 :
 :Původní zaměření tohoto programu vám nebrání naučit
 :se pracovat s klávesnicí QWERTZ. Můžete používat kurzy
 :zaměřené na QWERTY a nesetkáte se s výraznějším problémem.
 :Pouze pamatujte, že na QWERTZ
 :
 :	Y píšeme levým malíčkem vpravo dolů
 : 	Z píšeme vychýlením pravého ukazováčku vlevo nahoru
 :
 :Někam si to zapište a ignorujte hlášky týkající se těchto dvou
 :písmen přímo v lekcích.
 :		--Pro další stranu stiskněte ENTER--
T:			Připomínky, oznámení o chybě
 :
 :Připomínky ohledně českých lekcí a jejich funkce prosím zasílejte
 :na hanke@volny.cz. S obecnými připomínkami o programu
 :a chybami (pokud jste si jisti, že se nejedná o chybu lekce)
 :se prosím obracejte na bug-gtypist@gnu.org.
 :
 :Na adrese hanke@volny.cz rád uvítám pomoc s lokalizací zbylých
 :lekcí a textů.
 :
 :


G:__SERIESMENU
#==============================================================================
# Series menu
#==============================================================================
*:__SERIESMENU
B:                       Series selection menu
M: "The following 9 lesson series are available"
 :__S_T_SERIES   "Série T     Výukový kurz QWERTY (cz)       (T1 - T16)"
 :__S_U_SERIES   "Série U     Opakování QWERTY (cz)          (U1 - U11)"
 :__S_N_SERIES   "Série N     Číselná klávesnice (cz)        (N1 - N3)"
 :__S_M_SERIES   "Série M     Procvičovací drilové testy (cz)(M1 - M11)"
 :__S_S_SERIES   "Série S     Rychlostní testy (cz)          (S1 - S4)"
 :__S_Q_SERIES   "Série Q     Rychlý kurz QWERTY (en)        (Q1 - Q5)"
 :__S_R_SERIES   "Série R     Dlouhý kurz QWERTY (cz)        (R1 - R14)"
 :__S_V_SERIES   "Série V     Ještě jeden kurz QWERTY (en)   (V1 - V19)"
 :__S_D_SERIES   "Série D     Výukový kurz kláv. Dvorak (en) (D1 - D14)"
 :__MORE_LESSONS "Další lekce..."
 :__HELP         "Nápověda"
#==============================================================================
