/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.row;

import java.io.FileInputStream;
import java.math.BigDecimal;
import java.security.MessageDigest;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import org.apache.commons.codec.language.DoubleMetaphone;
import org.apache.commons.codec.language.Metaphone;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.provider.local.LocalFile;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.vfs.KettleVFS;

public class ValueDataUtil {
    public static final String leftTrim(String string) {
        return Const.ltrim(string);
    }

    public static final String rightTrim(String string) {
        return Const.rtrim(string);
    }

    public static final boolean isSpace(char c) {
        return Const.isSpace(c);
    }

    public static final String trim(String string) {
        return Const.trim(string);
    }

    public static Long getLevenshtein_Distance(ValueMetaInterface metaA, Object dataA, ValueMetaInterface metaB, Object dataB) {
        if (dataA == null || dataB == null) {
            return null;
        }
        return new Long(StringUtils.getLevenshteinDistance((String)dataA.toString(), (String)dataB.toString()));
    }

    public static String get_Metaphone(ValueMetaInterface metaA, Object dataA) {
        if (dataA == null) {
            return null;
        }
        return new Metaphone().metaphone(dataA.toString());
    }

    public static String get_Double_Metaphone(ValueMetaInterface metaA, Object dataA) {
        if (dataA == null) {
            return null;
        }
        return new DoubleMetaphone().doubleMetaphone(dataA.toString());
    }

    public static String initCap(ValueMetaInterface metaA, Object dataA) {
        if (dataA == null) {
            return null;
        }
        return Const.initCap(dataA.toString());
    }

    public static String upperCase(ValueMetaInterface metaA, Object dataA) {
        if (dataA == null) {
            return null;
        }
        return dataA.toString().toUpperCase();
    }

    public static String lowerCase(ValueMetaInterface metaA, Object dataA) {
        if (dataA == null) {
            return null;
        }
        return dataA.toString().toLowerCase();
    }

    public static String maskXML(ValueMetaInterface metaA, Object dataA) {
        if (dataA == null) {
            return null;
        }
        return Const.maskXML(dataA.toString());
    }

    public static String useCDATA(ValueMetaInterface metaA, Object dataA) {
        if (dataA == null) {
            return null;
        }
        return "<![CDATA[" + dataA.toString() + "]]>";
    }

    public static String removeCR(ValueMetaInterface metaA, Object dataA) {
        if (dataA == null) {
            return null;
        }
        return Const.removeCR(dataA.toString());
    }

    public static String removeLF(ValueMetaInterface metaA, Object dataA) {
        if (dataA == null) {
            return null;
        }
        return Const.removeLF(dataA.toString());
    }

    public static String removeCRLF(ValueMetaInterface metaA, Object dataA) {
        if (dataA == null) {
            return null;
        }
        return Const.removeCRLF(dataA.toString());
    }

    public static String removeTAB(ValueMetaInterface metaA, Object dataA) {
        if (dataA == null) {
            return null;
        }
        return Const.removeTAB(dataA.toString());
    }

    public static String getDigits(ValueMetaInterface metaA, Object dataA) {
        if (dataA == null) {
            return null;
        }
        return Const.getDigitsOnly(dataA.toString());
    }

    public static String removeDigits(ValueMetaInterface metaA, Object dataA) {
        if (dataA == null) {
            return null;
        }
        return Const.removeDigits(dataA.toString());
    }

    public static long stringLen(ValueMetaInterface metaA, Object dataA) {
        if (dataA == null) {
            return 0L;
        }
        return dataA.toString().length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createChecksum(ValueMetaInterface metaA, Object dataA, String type) {
        String md5Hash = null;
        FileInputStream in = null;
        try {
            in = new FileInputStream(dataA.toString());
            int bytes = in.available();
            byte[] buffer = new byte[bytes];
            in.read(buffer);
            StringBuffer md5HashBuff = new StringBuffer(32);
            byte[] b = MessageDigest.getInstance(type).digest(buffer);
            int len = b.length;
            for (int x = 0; x < len; ++x) {
                md5HashBuff.append(String.format("%02x", b[x]));
            }
            md5Hash = md5HashBuff.toString();
        }
        catch (Exception e) {
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e) {}
        }
        return md5Hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long ChecksumCRC32(ValueMetaInterface metaA, Object dataA) {
        long checksum = 0L;
        FileObject file = null;
        try {
            file = KettleVFS.getFileObject(dataA.toString());
            CheckedInputStream cis = null;
            cis = new CheckedInputStream((FileInputStream)((LocalFile)file).getInputStream(), new CRC32());
            byte[] buf = new byte[128];
            while (cis.read(buf) >= 0) {
            }
            checksum = cis.getChecksum().getValue();
        }
        catch (Exception e) {
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (Exception e) {}
            }
        }
        return checksum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long ChecksumAdler32(ValueMetaInterface metaA, Object dataA) {
        long checksum = 0L;
        FileObject file = null;
        try {
            file = KettleVFS.getFileObject(dataA.toString());
            CheckedInputStream cis = null;
            cis = new CheckedInputStream((FileInputStream)((LocalFile)file).getInputStream(), new Adler32());
            byte[] buf = new byte[128];
            while (cis.read(buf) >= 0) {
            }
            checksum = cis.getChecksum().getValue();
        }
        catch (Exception e) {
        }
        finally {
            if (file != null) {
                try {
                    file.close();
                }
                catch (Exception e) {}
            }
        }
        return checksum;
    }

    public static Object plus(ValueMetaInterface metaA, Object dataA, ValueMetaInterface metaB, Object dataB) throws KettleValueException {
        if (dataA == null || dataB == null) {
            return null;
        }
        switch (metaA.getType()) {
            case 2: {
                return metaA.getString(dataA) + metaB.getString(dataB);
            }
            case 1: {
                return new Double(metaA.getNumber(dataA) + metaB.getNumber(dataB));
            }
            case 5: {
                return new Long(metaA.getInteger(dataA) + metaB.getInteger(dataB));
            }
            case 4: {
                return metaA.getBoolean(dataA) != false || metaB.getBoolean(dataB) != false;
            }
            case 6: {
                return metaA.getBigNumber(dataA).add(metaB.getBigNumber(dataB));
            }
        }
        throw new KettleValueException("The 'plus' function only works on numeric data and Strings.");
    }

    public static Object plus3(ValueMetaInterface metaA, Object dataA, ValueMetaInterface metaB, Object dataB, ValueMetaInterface metaC, Object dataC) throws KettleValueException {
        if (dataA == null || dataB == null || dataC == null) {
            return null;
        }
        switch (metaA.getType()) {
            case 2: {
                return metaA.getString(dataA) + metaB.getString(dataB) + metaC.getString(dataC);
            }
            case 1: {
                return new Double(metaA.getNumber(dataA) + metaB.getNumber(dataB) + metaC.getNumber(dataC));
            }
            case 5: {
                return new Long(metaA.getInteger(dataA) + metaB.getInteger(dataB) + metaC.getInteger(dataC));
            }
            case 4: {
                return metaA.getBoolean(dataA) != false || metaB.getBoolean(dataB) != false || metaB.getBoolean(dataC) != false;
            }
            case 6: {
                return metaA.getBigNumber(dataA).add(metaB.getBigNumber(dataB).add(metaC.getBigNumber(dataC)));
            }
        }
        throw new KettleValueException("The 'plus' function only works on numeric data and Strings.");
    }

    public static Object sum(ValueMetaInterface metaA, Object dataA, ValueMetaInterface metaB, Object dataB) throws KettleValueException {
        if (dataA == null && dataB == null) {
            return null;
        }
        if (dataA == null && dataB != null) {
            return metaA.convertData(metaB, dataB);
        }
        if (dataA != null && dataB == null) {
            return dataA;
        }
        return ValueDataUtil.plus(metaA, dataA, metaB, dataB);
    }

    public static Object loadFileContentInBinary(ValueMetaInterface metaA, Object dataA) throws KettleValueException {
        if (dataA == null) {
            return null;
        }
        FileObject file = null;
        FileInputStream fis = null;
        try {
            file = KettleVFS.getFileObject(dataA.toString());
            fis = (FileInputStream)((LocalFile)file).getInputStream();
            int fileSize = (int)file.getContent().getSize();
            byte[] content = Const.createByteArray(fileSize);
            fis.read(content, 0, fileSize);
            byte[] byArray = content;
            return byArray;
        }
        catch (Exception e) {
            throw new KettleValueException(e);
        }
        finally {
            try {
                if (file != null) {
                    file.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public static Object minus(ValueMetaInterface metaA, Object dataA, ValueMetaInterface metaB, Object dataB) throws KettleValueException {
        if (dataA == null || dataB == null) {
            return null;
        }
        switch (metaA.getType()) {
            case 1: {
                return new Double(metaA.getNumber(dataA) - metaB.getNumber(dataB));
            }
            case 5: {
                return new Long(metaA.getInteger(dataA) - metaB.getInteger(dataB));
            }
            case 6: {
                return metaA.getBigNumber(dataA).subtract(metaB.getBigNumber(dataB));
            }
            case 3: {
                return new Long(metaA.getInteger(dataA) - metaB.getInteger(dataB));
            }
        }
        throw new KettleValueException("The 'minus' function only works on numeric data.");
    }

    public static Object multiply(ValueMetaInterface metaA, Object dataA, ValueMetaInterface metaB, Object dataB) throws KettleValueException {
        if (dataA == null || dataB == null) {
            return null;
        }
        if (metaB.isString() && metaA.isNumeric() || metaB.isNumeric() && metaA.isString()) {
            int n;
            StringBuffer s;
            String append = "";
            if (metaB.isString()) {
                s = new StringBuffer(metaB.getString(dataB));
                append = metaB.getString(dataB);
                n = metaA.getInteger(dataA).intValue();
            } else {
                s = new StringBuffer(metaA.getString(dataA));
                append = metaA.getString(dataA);
                n = metaB.getInteger(dataB).intValue();
            }
            if (n == 0) {
                s.setLength(0);
            } else {
                for (int i = 1; i < n; ++i) {
                    s.append(append);
                }
            }
            return s.toString();
        }
        switch (metaA.getType()) {
            case 1: {
                return new Double(metaA.getNumber(dataA) * metaB.getNumber(dataB));
            }
            case 5: {
                return new Long(metaA.getInteger(dataA) * metaB.getInteger(dataB));
            }
            case 6: {
                return metaA.getBigNumber(dataA).multiply(metaB.getBigNumber(dataB));
            }
        }
        throw new KettleValueException("The 'multiply' function only works on numeric data optionally multiplying strings.");
    }

    public static Object divide(ValueMetaInterface metaA, Object dataA, ValueMetaInterface metaB, Object dataB) throws KettleValueException {
        if (dataA == null || dataB == null) {
            return null;
        }
        switch (metaA.getType()) {
            case 1: {
                return new Double(metaA.getNumber(dataA) / metaB.getNumber(dataB));
            }
            case 5: {
                return new Long(metaA.getInteger(dataA) / metaB.getInteger(dataB));
            }
            case 6: {
                return metaA.getBigNumber(dataA).divide(metaB.getBigNumber(dataB), 4);
            }
        }
        throw new KettleValueException("The 'divide' function only works on numeric data.");
    }

    public static Object sqrt(ValueMetaInterface metaA, Object dataA) throws KettleValueException {
        if (dataA == null) {
            return null;
        }
        switch (metaA.getType()) {
            case 1: {
                return new Double(Math.sqrt(metaA.getNumber(dataA)));
            }
            case 5: {
                return new Long(Math.round(Math.sqrt(metaA.getNumber(dataA))));
            }
            case 6: {
                return BigDecimal.valueOf(Math.sqrt(metaA.getNumber(dataA)));
            }
        }
        throw new KettleValueException("The 'multiply' function only works on numeric data optionally multiplying strings.");
    }

    public static Object percent1(ValueMetaInterface metaA, Object dataA, ValueMetaInterface metaB, Object dataB) throws KettleValueException {
        if (dataA == null || dataB == null) {
            return null;
        }
        switch (metaA.getType()) {
            case 1: {
                return new Double(100.0 * metaA.getNumber(dataA) / metaB.getNumber(dataB));
            }
            case 5: {
                return new Long(100L * metaA.getInteger(dataA) / metaB.getInteger(dataB));
            }
            case 6: {
                return metaA.getBigNumber(dataA).multiply(new BigDecimal(100)).divide(metaB.getBigNumber(dataB), 4);
            }
        }
        throw new KettleValueException("The 'A/B in %' function only works on numeric data");
    }

    public static Object percent2(ValueMetaInterface metaA, Object dataA, ValueMetaInterface metaB, Object dataB) throws KettleValueException {
        if (dataA == null || dataB == null) {
            return null;
        }
        switch (metaA.getType()) {
            case 1: {
                return new Double(metaA.getNumber(dataA) - metaA.getNumber(dataA) * metaB.getNumber(dataB) / 100.0);
            }
            case 5: {
                return new Long(metaA.getInteger(dataA) - metaA.getInteger(dataA) * metaB.getInteger(dataB) * 100L);
            }
            case 6: {
                return metaA.getBigNumber(dataA).subtract(metaA.getBigNumber(dataA).multiply(metaB.getBigNumber(dataB)).divide(new BigDecimal(100), 4));
            }
        }
        throw new KettleValueException("The 'A-B%' function only works on numeric data");
    }

    public static Object percent3(ValueMetaInterface metaA, Object dataA, ValueMetaInterface metaB, Object dataB) throws KettleValueException {
        if (dataA == null || dataB == null) {
            return null;
        }
        switch (metaA.getType()) {
            case 1: {
                return new Double(metaA.getNumber(dataA) + metaA.getNumber(dataA) * metaB.getNumber(dataB) / 100.0);
            }
            case 5: {
                return new Long(metaA.getInteger(dataA) + metaA.getInteger(dataA) * metaB.getInteger(dataB) * 100L);
            }
            case 6: {
                return metaA.getBigNumber(dataA).add(metaA.getBigNumber(dataA).multiply(metaB.getBigNumber(dataB)).divide(new BigDecimal(100), 4));
            }
        }
        throw new KettleValueException("The 'A+B%' function only works on numeric data");
    }

    public static Object combination1(ValueMetaInterface metaA, Object dataA, ValueMetaInterface metaB, Object dataB, ValueMetaInterface metaC, Object dataC) throws KettleValueException {
        if (dataA == null || dataB == null || dataC == null) {
            return null;
        }
        switch (metaA.getType()) {
            case 1: {
                return new Double(metaA.getNumber(dataA) + metaB.getNumber(dataB) * metaC.getNumber(dataC));
            }
            case 5: {
                return new Long(metaA.getInteger(dataA) + metaB.getInteger(dataB) * metaC.getInteger(dataC));
            }
            case 6: {
                BigDecimal product = metaB.getBigNumber(dataB).multiply(metaC.getBigNumber(dataC));
                return metaA.getBigNumber(dataA).add(product);
            }
        }
        throw new KettleValueException("The 'combination1' function only works on numeric data");
    }

    public static Object combination2(ValueMetaInterface metaA, Object dataA, ValueMetaInterface metaB, Object dataB) throws KettleValueException {
        if (dataA == null || dataB == null) {
            return null;
        }
        switch (metaA.getType()) {
            case 1: {
                return new Double(Math.sqrt(metaA.getNumber(dataA) * metaA.getNumber(dataA) + metaB.getNumber(dataB) * metaB.getNumber(dataB)));
            }
            case 5: {
                return new Long(Math.round(Math.sqrt(metaA.getInteger(dataA) * metaA.getInteger(dataA) + metaB.getInteger(dataB) / metaB.getInteger(dataB))));
            }
            case 6: {
                return BigDecimal.valueOf(Math.sqrt(metaA.getNumber(dataA) * metaA.getNumber(dataA) + metaB.getNumber(dataB) * metaB.getNumber(dataB)));
            }
        }
        throw new KettleValueException("The 'combination2' function only works on numeric data");
    }

    public static Object round(ValueMetaInterface metaA, Object dataA) throws KettleValueException {
        if (dataA == null) {
            return null;
        }
        switch (metaA.getType()) {
            case 1: {
                return new Double(Math.round(metaA.getNumber(dataA)));
            }
            case 5: {
                return metaA.getInteger(dataA);
            }
            case 6: {
                return new BigDecimal(Math.round(metaA.getNumber(dataA)));
            }
        }
        throw new KettleValueException("The 'round' function only works on numeric data");
    }

    public static Object abs(ValueMetaInterface metaA, Object dataA) throws KettleValueException {
        if (dataA == null) {
            return null;
        }
        switch (metaA.getType()) {
            case 1: {
                return new Double(Math.abs(metaA.getNumber(dataA)));
            }
            case 5: {
                return metaA.getInteger(Math.abs(metaA.getNumber(dataA).longValue()));
            }
            case 6: {
                return new BigDecimal(Math.abs(metaA.getNumber(dataA)));
            }
        }
        throw new KettleValueException("The 'abs' function only works on numeric data");
    }

    public static Object round(ValueMetaInterface metaA, Object dataA, ValueMetaInterface metaB, Object dataB) throws KettleValueException {
        if (dataA == null || dataB == null) {
            return null;
        }
        switch (metaA.getType()) {
            case 1: {
                return new Double(Const.round(metaA.getNumber(dataA), metaB.getInteger(dataB).intValue()));
            }
            case 5: {
                return metaA.getInteger(dataA);
            }
            case 6: {
                BigDecimal number = metaA.getBigNumber(dataA);
                return number.setScale(metaB.getInteger(dataB).intValue(), 6);
            }
        }
        throw new KettleValueException("The 'round' function only works on numeric data");
    }

    public static Object nvl(ValueMetaInterface metaA, Object dataA, ValueMetaInterface metaB, Object dataB) throws KettleValueException {
        switch (metaA.getType()) {
            case 2: {
                if (dataA == null) {
                    return metaB.getString(dataB);
                }
                return metaA.getString(dataA);
            }
            case 1: {
                if (dataA == null) {
                    return metaB.getNumber(dataB);
                }
                return metaA.getNumber(dataA);
            }
            case 5: {
                if (dataA == null) {
                    return metaB.getInteger(dataB);
                }
                return metaA.getInteger(dataA);
            }
            case 6: {
                if (dataA == null) {
                    return metaB.getBigNumber(dataB);
                }
                return metaA.getBigNumber(dataA);
            }
            case 3: {
                if (dataA == null) {
                    return metaB.getDate(dataB);
                }
                return metaA.getDate(dataA);
            }
            case 4: {
                if (dataA == null) {
                    return metaB.getBoolean(dataB);
                }
                return metaA.getBoolean(dataA);
            }
            case 8: {
                if (dataA == null) {
                    return metaB.getBinary(dataB);
                }
                return metaA.getBinary(dataA);
            }
        }
        throw new KettleValueException("The 'nvl' function doesn't know how to handle data type " + metaA.getType());
    }

    public static Object removeTimeFromDate(ValueMetaInterface metaA, Object dataA) throws KettleValueException {
        if (metaA.isDate()) {
            Calendar cal = Calendar.getInstance();
            Date date = metaA.getDate(dataA);
            if (date != null) {
                cal.setTime(date);
                return Const.removeTimeFromDate(date);
            }
            return null;
        }
        throw new KettleValueException("The 'removeTimeFromDate' function only works with a date");
    }

    public static Object addTimeToDate(ValueMetaInterface metaA, Object dataA, ValueMetaInterface metaB, Object dataB, ValueMetaInterface metaC, Object dataC) throws KettleValueException {
        if (dataA == null) {
            return null;
        }
        if (metaA.isDate()) {
            try {
                if (dataC == null) {
                    return Const.addTimeToDate(metaA.getDate(dataA), metaB.getString(dataB), null);
                }
                return Const.addTimeToDate(metaA.getDate(dataA), metaB.getString(dataB), metaC.getString(dataC));
            }
            catch (Exception e) {
                throw new KettleValueException(e);
            }
        }
        throw new KettleValueException("The 'addTimeToDate' function only works with a date");
    }

    public static Object addDays(ValueMetaInterface metaA, Object dataA, ValueMetaInterface metaB, Object dataB) throws KettleValueException {
        if (metaA.isDate() && metaB.isInteger()) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(metaA.getDate(dataA));
            cal.add(6, metaB.getInteger(dataB).intValue());
            return cal.getTime();
        }
        throw new KettleValueException("The 'addDays' function only works with a date and an integer");
    }

    public static Object DateDiff(ValueMetaInterface metaA, Object dataA, ValueMetaInterface metaB, Object dataB) throws KettleValueException {
        if (metaA.isDate() && metaB.isDate()) {
            if (dataA != null && dataB != null) {
                long diff = metaA.getDate(dataA).getTime() - metaB.getDate(dataB).getTime();
                return new Long(diff / 86400000L);
            }
            return null;
        }
        throw new KettleValueException("The 'DateDiff' function only works with dates");
    }

    public static Object yearOfDate(ValueMetaInterface metaA, Object dataA) throws KettleValueException {
        if (dataA == null) {
            return null;
        }
        if (metaA.isDate()) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(metaA.getDate(dataA));
            return new Long(calendar.get(1));
        }
        throw new KettleValueException("The 'yearOfDate' function only works with dates");
    }

    public static Object monthOfDate(ValueMetaInterface metaA, Object dataA) throws KettleValueException {
        if (dataA == null) {
            return null;
        }
        if (metaA.isDate()) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(metaA.getDate(dataA));
            return new Long(calendar.get(2) + 1);
        }
        throw new KettleValueException("The 'monthOfDate' function only works with dates");
    }

    public static Object dayOfYear(ValueMetaInterface metaA, Object dataA) throws KettleValueException {
        if (dataA == null) {
            return null;
        }
        if (metaA.isDate()) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(metaA.getDate(dataA));
            return new Long(calendar.get(6));
        }
        throw new KettleValueException("The 'dayOfYear' function only works with dates");
    }

    public static Object dayOfMonth(ValueMetaInterface metaA, Object dataA) throws KettleValueException {
        if (dataA == null) {
            return null;
        }
        if (metaA.isDate()) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(metaA.getDate(dataA));
            return new Long(calendar.get(5));
        }
        throw new KettleValueException("The 'dayOfMonth' function only works with dates");
    }

    public static Object dayOfWeek(ValueMetaInterface metaA, Object dataA) throws KettleValueException {
        if (dataA == null) {
            return null;
        }
        if (metaA.isDate()) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(metaA.getDate(dataA));
            return new Long(calendar.get(7));
        }
        throw new KettleValueException("The 'dayOfWeek' function only works with dates");
    }

    public static Object weekOfYear(ValueMetaInterface metaA, Object dataA) throws KettleValueException {
        if (dataA == null) {
            return null;
        }
        if (metaA.isDate()) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(metaA.getDate(dataA));
            return new Long(calendar.get(3));
        }
        throw new KettleValueException("The 'weekOfYear' function only works with dates");
    }

    public static Object weekOfYearISO8601(ValueMetaInterface metaA, Object dataA) throws KettleValueException {
        if (dataA == null) {
            return null;
        }
        if (metaA.isDate()) {
            Calendar calendar = Calendar.getInstance(Locale.ENGLISH);
            calendar.setMinimalDaysInFirstWeek(4);
            calendar.setFirstDayOfWeek(2);
            calendar.setTime(metaA.getDate(dataA));
            return new Long(calendar.get(3));
        }
        throw new KettleValueException("The 'weekOfYearISO8601' function only works with dates");
    }

    public static Object yearOfDateISO8601(ValueMetaInterface metaA, Object dataA) throws KettleValueException {
        if (dataA == null) {
            return null;
        }
        if (metaA.isDate()) {
            Calendar calendar = Calendar.getInstance(Locale.ENGLISH);
            calendar.setMinimalDaysInFirstWeek(4);
            calendar.setFirstDayOfWeek(2);
            calendar.setTime(metaA.getDate(dataA));
            int week = calendar.get(3);
            int month = calendar.get(2);
            int year = calendar.get(1);
            if (week >= 52 && month == 0) {
                --year;
            }
            if (week <= 2 && month == 11) {
                ++year;
            }
            return new Long(year);
        }
        throw new KettleValueException("The 'yearOfDateISO8601' function only works with dates");
    }

    public static String hexToByteDecode(ValueMetaInterface meta, Object data) throws KettleValueException {
        if (meta.isNull(data)) {
            return null;
        }
        String hexString = meta.getString(data);
        int len = hexString.length();
        char[] chArray = new char[(len + 1) / 2];
        boolean evenByte = true;
        int nextByte = 0;
        if (len % 2 == 1) {
            evenByte = false;
        }
        int j = 0;
        for (int i = 0; i < len; ++i) {
            int nibble;
            char c = hexString.charAt(i);
            if (c >= '0' && c <= '9') {
                nibble = c - 48;
            } else if (c >= 'A' && c <= 'F') {
                nibble = c - 65 + 10;
            } else if (c >= 'a' && c <= 'f') {
                nibble = c - 97 + 10;
            } else {
                throw new KettleValueException("invalid hex digit '" + c + "'.");
            }
            if (evenByte) {
                nextByte = nibble << 4;
            } else {
                chArray[j] = (char)(nextByte += nibble);
                ++j;
            }
            evenByte = !evenByte;
        }
        return new String(chArray);
    }

    public static String byteToHexEncode(ValueMetaInterface metaA, Object dataA) throws KettleValueException {
        if (dataA == null) {
            return null;
        }
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        String hex = metaA.getString(dataA);
        char[] s = hex.toCharArray();
        StringBuffer hexString = new StringBuffer(2 * s.length);
        for (int i = 0; i < s.length; ++i) {
            hexString.append(hexDigits[(s[i] & 0xF0) >> 4]);
            hexString.append(hexDigits[s[i] & 0xF]);
        }
        return hexString.toString();
    }

    public static String charToHexEncode(ValueMetaInterface meta, Object data) throws KettleValueException {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        if (meta.isNull(data)) {
            return null;
        }
        String hex = meta.getString(data);
        char[] s = hex.toCharArray();
        StringBuffer hexString = new StringBuffer(2 * s.length);
        for (int i = 0; i < s.length; ++i) {
            hexString.append(hexDigits[(s[i] & 0xF000) >> 12]);
            hexString.append(hexDigits[(s[i] & 0xF00) >> 8]);
            hexString.append(hexDigits[(s[i] & 0xF0) >> 4]);
            hexString.append(hexDigits[s[i] & 0xF]);
        }
        return hexString.toString();
    }

    public static String hexToCharDecode(ValueMetaInterface meta, Object data) throws KettleValueException {
        if (meta.isNull(data)) {
            return null;
        }
        String hexString = meta.getString(data);
        int len = hexString.length();
        char[] chArray = new char[(len + 3) / 4];
        int nextChar = 0;
        int charNr = len % 4;
        if (charNr == 0) {
            charNr = 4;
        }
        int j = 0;
        for (int i = 0; i < len; ++i) {
            int nibble;
            char c = hexString.charAt(i);
            if (c >= '0' && c <= '9') {
                nibble = c - 48;
            } else if (c >= 'A' && c <= 'F') {
                nibble = c - 65 + 10;
            } else if (c >= 'a' && c <= 'f') {
                nibble = c - 97 + 10;
            } else {
                throw new KettleValueException("invalid hex digit '" + c + "'.");
            }
            if (charNr == 4) {
                nextChar = nibble << 12;
                --charNr;
                continue;
            }
            if (charNr == 3) {
                nextChar += nibble << 8;
                --charNr;
                continue;
            }
            if (charNr == 2) {
                nextChar += nibble << 4;
                --charNr;
                continue;
            }
            chArray[j] = (char)(nextChar += nibble);
            charNr = 4;
            ++j;
        }
        return new String(chArray);
    }

    public static final String rightPad(String ret, int limit) {
        if (ret == null) {
            return ValueDataUtil.rightPad(new StringBuffer(), limit);
        }
        return ValueDataUtil.rightPad(new StringBuffer(ret), limit);
    }

    public static final String rightPad(StringBuffer ret, int limit) {
        int len = ret.length();
        if (len > limit) {
            ret.setLength(limit);
        } else {
            for (int l = len; l < limit; ++l) {
                ret.append(' ');
            }
        }
        return ret.toString();
    }

    public static final String replace(String string, String repl, String with) {
        StringBuffer str = new StringBuffer(string);
        for (int i = str.length() - 1; i >= 0; --i) {
            if (!str.substring(i).startsWith(repl)) continue;
            str.delete(i, i + repl.length());
            str.insert(i, with);
        }
        return str.toString();
    }

    public static void replaceBuffer(StringBuffer str, String code, String repl) {
        int clength = code.length();
        for (int i = str.length() - clength; i >= 0; --i) {
            String look = str.substring(i, i + clength);
            if (!look.equalsIgnoreCase(code)) continue;
            str.replace(i, i + clength, repl);
        }
    }

    public static final int nrSpacesBefore(String field) {
        int nr;
        int len = field.length();
        for (nr = 0; nr < len && field.charAt(nr) == ' '; ++nr) {
        }
        return nr;
    }

    public static final int nrSpacesAfter(String field) {
        int nr;
        int len = field.length();
        for (nr = 0; nr < len && field.charAt(field.length() - 1 - nr) == ' '; ++nr) {
        }
        return nr;
    }

    public static final boolean onlySpaces(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (ValueDataUtil.isSpace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

