/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.olap.action;

import ca.sqlpower.architect.olap.MondrianModel;
import ca.sqlpower.architect.olap.OLAPObject;
import ca.sqlpower.architect.olap.OLAPUtil;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.PlayPen;
import ca.sqlpower.architect.swingui.olap.CubePane;
import ca.sqlpower.architect.swingui.olap.DimensionPane;
import ca.sqlpower.architect.swingui.olap.DimensionUsageEditPanel;
import ca.sqlpower.architect.swingui.olap.OSUtils;
import ca.sqlpower.architect.swingui.olap.UsageComponent;
import ca.sqlpower.architect.swingui.olap.action.CreateUsageAction;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLObjectRuntimeException;
import ca.sqlpower.swingui.DataEntryPanel;
import ca.sqlpower.swingui.DataEntryPanelBuilder;
import java.awt.Component;
import java.util.concurrent.Callable;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class CreateDimensionUsageAction
extends CreateUsageAction<DimensionPane, CubePane> {
    private static final Logger logger = Logger.getLogger(CreateDimensionUsageAction.class);

    public CreateDimensionUsageAction(ArchitectSwingSession session, PlayPen pp) {
        super(session, pp, DimensionPane.class, CubePane.class, "Dimension Usage", (Icon)OSUtils.DIMENSION_USAGE_ADD_ICON);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke('s'));
    }

    @Override
    protected void createUsage(DimensionPane dp, CubePane cp) {
        MondrianModel.Dimension dimension = (MondrianModel.Dimension)((Object)dp.getModel());
        MondrianModel.Cube cube = (MondrianModel.Cube)((Object)cp.getModel());
        if (OLAPUtil.isNameUnique((OLAPObject)((Object)cp.getModel()), MondrianModel.DimensionUsage.class, dimension.getName())) {
            this.getSession().getWorkspace().begin("Create dimension usage");
            final MondrianModel.DimensionUsage du = new MondrianModel.DimensionUsage();
            try {
                du.setName(dimension.getName());
                du.setSource(dimension.getName());
                cube.addChild((SPObject)du);
                UsageComponent uc = new UsageComponent(this.getPlaypen().getContentPane(), du, dp, cp);
                this.getPlaypen().getContentPane().addChild((SPObject)uc, this.getPlaypen().getContentPane().getChildren().size());
                this.getSession().getWorkspace().commit();
            }
            catch (Throwable e) {
                this.getSession().getWorkspace().rollback("Error occurred: " + e.toString());
                throw new RuntimeException(e);
            }
            try {
                final DimensionUsageEditPanel mep = new DimensionUsageEditPanel(du);
                Callable<Boolean> okCall = new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        return mep.applyChanges();
                    }
                };
                Callable<Boolean> cancelCall = new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        du.getParent().removeChild((SPObject)du);
                        return true;
                    }
                };
                JDialog d = DataEntryPanelBuilder.createDataEntryPanelDialog((DataEntryPanel)mep, (Component)SwingUtilities.getWindowAncestor(this.getPlaypen()), (String)"Dimension Usage Properties", (String)DataEntryPanelBuilder.OK_BUTTON_LABEL, (Callable)okCall, (Callable)cancelCall);
                d.setLocationRelativeTo(this.getPlaypen());
                d.setVisible(true);
            }
            catch (SQLObjectException e) {
                throw new SQLObjectRuntimeException(e);
            }
        }
        String errorMsg = "Cube Dimension \"" + dimension.getName() + "\" already exists in \"" + ((MondrianModel.Cube)((Object)cp.getModel())).getName() + "\".\nDimension Usage was not created.";
        JOptionPane.showMessageDialog(this.getPlaypen(), errorMsg, "Duplicate Cube Dimension", 1);
    }
}

