/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel.colopedia;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.stream.Stream;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.ModifierFormat;
import net.sf.freecol.client.gui.action.ColopediaAction;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.client.gui.panel.colopedia.ColopediaGameObjectTypePanel;
import net.sf.freecol.client.gui.panel.colopedia.ColopediaPanel;
import net.sf.freecol.client.gui.panel.colopedia.ColopediaTreeItem;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.ResourceType;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.ImageUtils;

public class TerrainDetailPanel
extends ColopediaGameObjectTypePanel<TileType> {
    public TerrainDetailPanel(FreeColClient freeColClient, ColopediaPanel colopediaPanel) {
        super(freeColClient, colopediaPanel, ColopediaAction.PanelType.TERRAIN.getKey());
    }

    @Override
    public void addSubTrees(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(new ColopediaTreeItem(this, this.getId(), this.getName(), null));
        for (TileType t : this.getSpecification().getTileTypeList()) {
            Dimension size = this.getListItemIconSize();
            BufferedImage tileImage = this.getImageLibrary().getTileImageWithOverlayAndForest(t, new Dimension(-1, size.height));
            ImageIcon icon = new ImageIcon(ImageUtils.createCenteredImage(tileImage, size));
            node.add(this.buildItem(t, icon));
        }
        root.add(node);
    }

    @Override
    public void buildDetail(String id, JPanel panel) {
        if (this.getId().equals(id)) {
            return;
        }
        TileType tileType = this.getSpecification().getTileType(id);
        panel.setLayout(new MigLayout("wrap 4, gap 20"));
        String movementCost = String.valueOf(tileType.getBasicMoveCost() / 3);
        String defenseBonus = Messages.message("none");
        Modifier defenceModifier = CollectionUtils.first(tileType.getDefenceModifiers());
        if (defenceModifier != null) {
            defenseBonus = ModifierFormat.getModifierAsString(defenceModifier);
        }
        JLabel nameLabel = Utility.localizedHeaderLabel(tileType, Utility.FONTSPEC_SUBTITLE);
        panel.add((Component)nameLabel, "span, align center");
        panel.add((Component)Utility.localizedLabel("colopedia.terrain.terrainImage"), "spany 3");
        BufferedImage terrainImage = this.getImageLibrary().getTileImageWithOverlayAndForest(tileType, ImageLibrary.TILE_OVERLAY_SIZE);
        panel.add((Component)new JLabel(new ImageIcon(terrainImage)), "spany 3");
        List<ResourceType> resourceList = tileType.getResourceTypeValues();
        ResourceType rt = CollectionUtils.first(resourceList);
        if (rt != null) {
            panel.add(Utility.localizedLabel("colopedia.terrain.resource"));
            if (resourceList.size() > 1) {
                panel.add((Component)this.getResourceButton(rt), "split " + resourceList.size());
                for (int index = 1; index < resourceList.size(); ++index) {
                    panel.add(this.getResourceButton(resourceList.get(index)));
                }
            } else {
                panel.add(this.getResourceButton(rt));
            }
        } else {
            panel.add((Component)new JLabel(), "wrap");
        }
        panel.add(Utility.localizedLabel("colopedia.terrain.movementCost"));
        panel.add(new JLabel(movementCost));
        panel.add(Utility.localizedLabel("colopedia.terrain.defenseBonus"));
        panel.add(new JLabel(defenseBonus));
        panel.add(Utility.localizedLabel("colopedia.terrain.unattendedProduction"));
        this.addProduction(panel, tileType.getPossibleProduction(true));
        panel.add(Utility.localizedLabel("colopedia.terrain.colonistProduction"));
        this.addProduction(panel, tileType.getPossibleProduction(false));
        panel.add(Utility.localizedLabel("colopedia.terrain.description"));
        panel.add((Component)Utility.localizedTextArea(Messages.descriptionKey(tileType)), "span, growx");
    }

    private void addProduction(JPanel panel, Stream<AbstractGoods> production) {
        List<AbstractGoods> pro = CollectionUtils.transform(production, AbstractGoods::isPositive);
        Object tag = null;
        switch (pro.size()) {
            case 0: {
                panel.add((Component)new JLabel(), "wrap");
                break;
            }
            case 1: {
                tag = "span";
                break;
            }
            default: {
                tag = "span, split " + pro.size();
            }
        }
        for (AbstractGoods ag : pro) {
            panel.add((Component)this.getGoodsButton(ag.getType(), ag.getAmount()), tag);
            tag = null;
        }
    }
}

