/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.option;

import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.AbstractUnit;
import net.sf.freecol.common.model.NationType;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.option.AbstractOption;
import net.sf.freecol.common.option.IntegerOption;
import net.sf.freecol.common.option.StringOption;
import net.sf.freecol.common.option.UnitTypeOption;

public class AbstractUnitOption
extends AbstractOption<AbstractUnit> {
    private static final Logger logger = Logger.getLogger(AbstractUnitOption.class.getName());
    public static final String TAG = "unitOption";
    private static final UnitTypeOption.TypeSelector DEFAULT_SELECTOR = UnitTypeOption.TypeSelector.UNITS;
    private AbstractUnit value = null;
    private UnitTypeOption unitTypeOption = null;
    private StringOption roleOption = null;
    private IntegerOption numberOption = null;
    private NationType nationType = null;
    private static final String NATION_TYPE_TAG = "nationType";
    private static final String NUMBER_TAG = "number";
    private static final String ROLE_TAG = "role";
    private static final String UNIT_TYPE_TAG = "unitType";

    public AbstractUnitOption(Specification specification) {
        super(specification);
    }

    public AbstractUnitOption(String id, Specification specification) {
        super(id, specification);
    }

    private void requireUnitTypeOption() {
        if (this.unitTypeOption == null) {
            this.unitTypeOption = new UnitTypeOption(this.getId() + ".unitType", this.getSpecification());
        }
    }

    private void requireRoleOption() {
        if (this.roleOption == null) {
            this.roleOption = new StringOption(this.getId() + ".role", this.getSpecification());
        }
    }

    private void requireNumberOption() {
        if (this.numberOption == null) {
            this.numberOption = new IntegerOption(this.getId() + ".number", this.getSpecification());
        }
    }

    public final UnitTypeOption getUnitType() {
        return this.unitTypeOption;
    }

    public final StringOption getRole() {
        return this.roleOption;
    }

    public final IntegerOption getNumber() {
        return this.numberOption;
    }

    public final NationType getNationType() {
        return this.nationType;
    }

    @Override
    public AbstractUnitOption cloneOption() {
        Specification spec = this.getSpecification();
        AbstractUnitOption result = new AbstractUnitOption(this.getId(), spec);
        result.setValues(this);
        if (this.value != null) {
            AbstractUnit au = new AbstractUnit(this.value.getType(spec), this.value.getRoleId(), this.value.getNumber());
            result.setValue(au);
        }
        if (this.unitTypeOption != null) {
            result.unitTypeOption = this.unitTypeOption.cloneOption();
        }
        if (this.roleOption != null) {
            result.roleOption = this.roleOption.cloneOption();
        }
        if (this.numberOption != null) {
            result.numberOption = this.numberOption.cloneOption();
        }
        result.nationType = this.nationType;
        return result;
    }

    @Override
    public AbstractUnit getValue() {
        return this.value;
    }

    @Override
    public void setValue(AbstractUnit value) {
        Specification spec = this.getSpecification();
        AbstractUnit oldValue = this.value;
        this.value = value;
        if (value == null) {
            this.unitTypeOption = null;
            this.roleOption = null;
            this.numberOption = null;
        } else {
            this.requireUnitTypeOption();
            this.unitTypeOption.setValue(value.getType(spec));
            this.requireRoleOption();
            this.roleOption.setValue(value.getRoleId());
            this.requireNumberOption();
            this.numberOption.setValue(value.getNumber());
        }
        if (this.isDefined && (this.value == null != (oldValue == null) || this.value != null && !this.value.equals(oldValue))) {
            this.firePropertyChange("value", oldValue, this.value);
        }
        this.isDefined = true;
    }

    @Override
    public boolean isNullValueOK() {
        return true;
    }

    @Override
    public void generateChoices() {
        this.unitTypeOption.generateChoices();
        if (this.roleOption.getChoices().isEmpty() && this.roleOption.getValue() != null) {
            List<String> op = Collections.singletonList(this.roleOption.getValue());
            this.roleOption.setChoices(op);
        }
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        if (this.nationType != null) {
            xw.writeAttribute(NATION_TYPE_TAG, this.nationType);
        }
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        this.numberOption.toXML(xw, NUMBER_TAG);
        this.roleOption.toXML(xw, ROLE_TAG);
        this.unitTypeOption.toXML(xw, UNIT_TYPE_TAG);
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        Specification spec = this.getSpecification();
        this.nationType = xr.getType(spec, NATION_TYPE_TAG, NationType.class, null);
    }

    @Override
    public void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        super.readChildren(xr);
        AbstractUnit au = null;
        if (this.unitTypeOption != null && this.roleOption != null && this.numberOption != null) {
            au = new AbstractUnit(this.unitTypeOption.getValue(), this.roleOption.getValue(), (int)this.numberOption.getValue());
        }
        this.setValue(au);
    }

    @Override
    public void readChild(FreeColXMLReader xr) throws XMLStreamException {
        String tag = xr.getLocalName();
        if (tag != null) {
            switch (tag) {
                case "number": {
                    this.requireNumberOption();
                    this.numberOption.readFromXML(xr);
                    break;
                }
                case "role": {
                    this.requireRoleOption();
                    this.roleOption.readFromXML(xr);
                    break;
                }
                case "unitType": {
                    this.requireUnitTypeOption();
                    this.unitTypeOption.readFromXML(xr);
                    break;
                }
                default: {
                    super.readChild(xr);
                }
            }
        }
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(16);
        sb.append('[').append(this.getId()).append(' ').append(this.value);
        if (this.unitTypeOption != null) {
            sb.append(' ').append(this.unitTypeOption);
        }
        if (this.roleOption != null) {
            sb.append(' ').append(this.roleOption);
        }
        if (this.numberOption != null) {
            sb.append(' ').append(this.numberOption);
        }
        sb.append(']');
        return sb.toString();
    }
}

