/*
 * Decompiled with CFR 0.152.
 */
package com.o19s.es.ltr.ranker.normalizer;

import com.o19s.es.ltr.ranker.normalizer.Normalizer;

public class MinMaxFeatureNormalizer
implements Normalizer {
    float maximum;
    float minimum;

    public MinMaxFeatureNormalizer(float minimum, float maximum) {
        if (minimum >= maximum) {
            throw new IllegalArgumentException("Minimum " + Double.toString(minimum) + " must be smaller than than maximum: " + Double.toString(maximum));
        }
        this.minimum = minimum;
        this.maximum = maximum;
    }

    @Override
    public float normalize(float value) {
        return (value - this.minimum) / (this.maximum - this.minimum);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MinMaxFeatureNormalizer)) {
            return false;
        }
        MinMaxFeatureNormalizer that = (MinMaxFeatureNormalizer)other;
        if (this.minimum != that.minimum) {
            return false;
        }
        return this.maximum == that.maximum;
    }

    public int hashCode() {
        int hashCode = Float.hashCode(this.minimum);
        return hashCode += 31 * Float.hashCode(this.maximum);
    }
}

