/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.query.planner.physical.node.scroll;

import org.opensearch.action.search.ClearScrollResponse;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.search.sort.SortOrder;
import org.opensearch.sql.legacy.query.join.TableInJoinRequestBuilder;
import org.opensearch.sql.legacy.query.planner.physical.node.Paginate;

public class Scroll
extends Paginate {
    public Scroll(TableInJoinRequestBuilder request, int pageSize) {
        super(request, pageSize);
    }

    @Override
    public void close() {
        if (this.searchResponse != null) {
            LOG.debug("Closing all scroll resources");
            ClearScrollResponse clearScrollResponse = (ClearScrollResponse)this.client.prepareClearScroll().addScrollId(this.searchResponse.getScrollId()).get();
            if (!clearScrollResponse.isSucceeded()) {
                LOG.warn("Failed to close scroll: {}", (Object)clearScrollResponse.status());
            }
            this.searchResponse = null;
        } else {
            LOG.debug("Scroll already be closed");
        }
    }

    @Override
    protected void loadFirstBatch() {
        this.searchResponse = (SearchResponse)this.request.getRequestBuilder().addSort("_doc", SortOrder.ASC).addSort("_id", SortOrder.ASC).setSize(this.pageSize).setScroll(TimeValue.timeValueSeconds((long)this.timeout.intValue())).get();
    }

    @Override
    protected void loadNextBatch() {
        this.searchResponse = (SearchResponse)this.client.prepareSearchScroll(this.searchResponse.getScrollId()).setScroll(TimeValue.timeValueSeconds((long)this.timeout.intValue())).get();
    }
}

