/*
 * Decompiled with CFR 0.152.
 */
package io.mola.galimatias;

import com.ibm.icu.text.IDNA;
import io.mola.galimatias.ErrorHandler;
import io.mola.galimatias.GalimatiasParseException;
import io.mola.galimatias.Host;
import io.mola.galimatias.URLParsingSettings;
import io.mola.galimatias.URLUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Domain
extends Host {
    private static final long serialVersionUID = 2L;
    private final String domain;
    private final boolean unicode;

    private Domain(String domain, boolean unicode) {
        this.domain = domain;
        this.unicode = unicode;
    }

    public static Domain parseDomain(String input) throws GalimatiasParseException {
        return Domain.parseDomain(input, false);
    }

    public List<String> labels() {
        return Arrays.asList(Domain.splitWorker(this.domain, ".\u3002\uff0e\uff61", -1, true));
    }

    public static Domain parseDomain(String input, boolean unicode) throws GalimatiasParseException {
        return Domain.parseDomain(URLParsingSettings.create(), input, unicode);
    }

    public static Domain parseDomain(URLParsingSettings settings, String input, boolean unicode) throws GalimatiasParseException {
        if (input == null) {
            throw new NullPointerException();
        }
        if (input.isEmpty()) {
            throw new GalimatiasParseException("input is empty");
        }
        ErrorHandler errorHandler = settings.errorHandler();
        String domain = URLUtils.percentDecode(input);
        String asciiDomain = URLUtils.domainToASCII(domain, errorHandler);
        for (int i = 0; i < asciiDomain.length(); ++i) {
            char codePoint = asciiDomain.charAt(i);
            switch (codePoint) {
                case '\u0000': 
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': 
                case '#': 
                case '%': 
                case '/': 
                case ':': 
                case '<': 
                case '>': 
                case '?': 
                case '@': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '|': {
                    String message = "Illegal character in domain";
                    message = codePoint == ' ' ? message + ": space is not allowed" : (codePoint == '\t' ? message + ": tab is not allowed" : (codePoint == '\n' ? message + ": line break is not allowed" : (codePoint == '\r' ? message + ": carriage return is not allowed" : message + ": \u201c" + new String(Character.toChars(codePoint)) + "\u201d is not allowed")));
                    GalimatiasParseException exception = new GalimatiasParseException(message);
                    errorHandler.fatalError(exception);
                    throw exception;
                }
            }
        }
        if (!unicode) {
            return new Domain(asciiDomain, unicode);
        }
        return new Domain(URLUtils.domainToUnicode(asciiDomain, errorHandler), unicode);
    }

    @Override
    public String toString() {
        return this.domain;
    }

    @Override
    public String toHumanString() {
        if (this.unicode) {
            return this.domain;
        }
        IDNA.Info idnaInfo = new IDNA.Info();
        StringBuilder idnaOutput = new StringBuilder();
        IDNA.getUTS46Instance(0).nameToUnicode(this.domain, idnaOutput, idnaInfo);
        return idnaOutput.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Domain domain1 = (Domain)o;
        return !(this.domain != null ? !this.domain.equals(domain1.domain) : domain1.domain != null);
    }

    public int hashCode() {
        int result = this.domain != null ? this.domain.hashCode() : 0;
        return result;
    }

    private static String[] splitWorker(String str, String separatorChars, int max, boolean preserveAllTokens) {
        int len = str.length();
        ArrayList<String> list = new ArrayList<String>();
        int sizePlus1 = 1;
        int i = 0;
        int start = 0;
        boolean match = false;
        boolean lastMatch = false;
        if (separatorChars == null) {
            while (i < len) {
                if (Character.isWhitespace(str.charAt(i))) {
                    if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                            i = len;
                            lastMatch = false;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i;
            }
        } else if (separatorChars.length() == 1) {
            char sep = separatorChars.charAt(0);
            while (i < len) {
                if (str.charAt(i) == sep) {
                    if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                            i = len;
                            lastMatch = false;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i;
            }
        } else {
            while (i < len) {
                if (separatorChars.indexOf(str.charAt(i)) >= 0) {
                    if (match || preserveAllTokens) {
                        lastMatch = true;
                        if (sizePlus1++ == max) {
                            i = len;
                            lastMatch = false;
                        }
                        list.add(str.substring(start, i));
                        match = false;
                    }
                    start = ++i;
                    continue;
                }
                lastMatch = false;
                match = true;
                ++i;
            }
        }
        if (match || preserveAllTokens && lastMatch) {
            list.add(str.substring(start, i));
        }
        return list.toArray(new String[list.size()]);
    }
}

