/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.Rule;
import org.openhab.core.automation.RuleStatusInfo;
import org.openhab.core.automation.dto.RuleDTO;
import org.openhab.core.automation.dto.RuleDTOMapper;
import org.openhab.core.automation.events.RuleAddedEvent;
import org.openhab.core.automation.events.RuleRemovedEvent;
import org.openhab.core.automation.events.RuleStatusInfoEvent;
import org.openhab.core.automation.events.RuleUpdatedEvent;
import org.openhab.core.events.AbstractEventFactory;
import org.openhab.core.events.Event;
import org.openhab.core.events.EventFactory;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(service={EventFactory.class}, immediate=true)
public class RuleEventFactory
extends AbstractEventFactory {
    private final Logger logger = LoggerFactory.getLogger(RuleEventFactory.class);
    private static final String RULE_STATE_EVENT_TOPIC = "openhab/rules/{ruleID}/state";
    private static final String RULE_ADDED_EVENT_TOPIC = "openhab/rules/{ruleID}/added";
    private static final String RULE_REMOVED_EVENT_TOPIC = "openhab/rules/{ruleID}/removed";
    private static final String RULE_UPDATED_EVENT_TOPIC = "openhab/rules/{ruleID}/updated";
    private static final Set<String> SUPPORTED_TYPES = new HashSet<String>();

    static {
        SUPPORTED_TYPES.add(RuleAddedEvent.TYPE);
        SUPPORTED_TYPES.add(RuleRemovedEvent.TYPE);
        SUPPORTED_TYPES.add(RuleStatusInfoEvent.TYPE);
        SUPPORTED_TYPES.add(RuleUpdatedEvent.TYPE);
    }

    public RuleEventFactory() {
        super(SUPPORTED_TYPES);
    }

    protected Event createEventByType(String eventType, String topic, String payload, @Nullable String source) throws Exception {
        this.logger.trace("creating ruleEvent of type: {}", (Object)eventType);
        if (RuleAddedEvent.TYPE.equals(eventType)) {
            return this.createRuleAddedEvent(topic, payload, source);
        }
        if (RuleRemovedEvent.TYPE.equals(eventType)) {
            return this.createRuleRemovedEvent(topic, payload, source);
        }
        if (RuleStatusInfoEvent.TYPE.equals(eventType)) {
            return this.createRuleStatusInfoEvent(topic, payload, source);
        }
        if (RuleUpdatedEvent.TYPE.equals(eventType)) {
            return this.createRuleUpdatedEvent(topic, payload, source);
        }
        throw new IllegalArgumentException("The event type '" + eventType + "' is not supported by this factory.");
    }

    private Event createRuleUpdatedEvent(String topic, String payload, @Nullable String source) {
        RuleDTO[] ruleDTO = (RuleDTO[])RuleEventFactory.deserializePayload((String)payload, RuleDTO[].class);
        if (ruleDTO.length != 2) {
            throw new IllegalArgumentException("Creation of RuleUpdatedEvent failed: invalid payload: " + payload);
        }
        return new RuleUpdatedEvent(topic, payload, source, ruleDTO[0], ruleDTO[1]);
    }

    private Event createRuleStatusInfoEvent(String topic, String payload, @Nullable String source) {
        RuleStatusInfo statusInfo = (RuleStatusInfo)RuleEventFactory.deserializePayload((String)payload, RuleStatusInfo.class);
        if (statusInfo.getStatus() == null || statusInfo.getStatusDetail() == null) {
            throw new IllegalArgumentException("Creation of RuleStatusInfo failed: invalid payload: " + payload);
        }
        return new RuleStatusInfoEvent(topic, payload, source, statusInfo, this.getRuleId(topic));
    }

    private Event createRuleRemovedEvent(String topic, String payload, @Nullable String source) {
        RuleDTO ruleDTO = (RuleDTO)RuleEventFactory.deserializePayload((String)payload, RuleDTO.class);
        return new RuleRemovedEvent(topic, payload, source, ruleDTO);
    }

    private Event createRuleAddedEvent(String topic, String payload, @Nullable String source) {
        RuleDTO ruleDTO = (RuleDTO)RuleEventFactory.deserializePayload((String)payload, RuleDTO.class);
        return new RuleAddedEvent(topic, payload, source, ruleDTO);
    }

    private String getRuleId(String topic) {
        String[] topicElements = this.getTopicElements(topic);
        if (topicElements.length != 4) {
            throw new IllegalArgumentException("Event creation failed, invalid topic: " + topic);
        }
        return topicElements[2];
    }

    public static RuleUpdatedEvent createRuleUpdatedEvent(Rule rule, Rule oldRule, String source) {
        String topic = RuleEventFactory.buildTopic(RULE_UPDATED_EVENT_TOPIC, rule);
        RuleDTO ruleDto = RuleDTOMapper.map(rule);
        RuleDTO oldRuleDto = RuleDTOMapper.map(oldRule);
        LinkedList<RuleDTO> rules = new LinkedList<RuleDTO>();
        rules.add(ruleDto);
        rules.add(oldRuleDto);
        String payload = RuleEventFactory.serializePayload(rules);
        return new RuleUpdatedEvent(topic, payload, source, ruleDto, oldRuleDto);
    }

    public static RuleStatusInfoEvent createRuleStatusInfoEvent(RuleStatusInfo statusInfo, String ruleUID, String source) {
        String topic = RuleEventFactory.buildTopic(RULE_STATE_EVENT_TOPIC, ruleUID);
        String payload = RuleEventFactory.serializePayload((Object)statusInfo);
        return new RuleStatusInfoEvent(topic, payload, source, statusInfo, ruleUID);
    }

    public static RuleRemovedEvent createRuleRemovedEvent(Rule rule, String source) {
        String topic = RuleEventFactory.buildTopic(RULE_REMOVED_EVENT_TOPIC, rule);
        RuleDTO ruleDto = RuleDTOMapper.map(rule);
        String payload = RuleEventFactory.serializePayload((Object)ruleDto);
        return new RuleRemovedEvent(topic, payload, source, ruleDto);
    }

    public static RuleAddedEvent createRuleAddedEvent(Rule rule, String source) {
        String topic = RuleEventFactory.buildTopic(RULE_ADDED_EVENT_TOPIC, rule);
        RuleDTO ruleDto = RuleDTOMapper.map(rule);
        String payload = RuleEventFactory.serializePayload((Object)ruleDto);
        return new RuleAddedEvent(topic, payload, source, ruleDto);
    }

    private static String buildTopic(String topic, String ruleUID) {
        return topic.replace("{ruleID}", ruleUID);
    }

    private static String buildTopic(String topic, Rule rule) {
        return RuleEventFactory.buildTopic(topic, rule.getUID());
    }
}

