/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.Grouping;
import kotlin.collections.GroupingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.inspections.YAMLAddQuoteQuickFix;
import org.jetbrains.yaml.inspections.YAMLAddQuotesToSiblingsQuickFix;
import org.jetbrains.yaml.inspections.YAMLIncompatibleTypesInspectionKt;
import org.jetbrains.yaml.inspections.YamlIncompatibleTypesVisitor$getMostPopularTypeForSiblings$lambda$4$;
import org.jetbrains.yaml.inspections.YamlIncompatibleTypesVisitor$visitScalar$;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.meta.model.YamlStringType;
import org.jetbrains.yaml.psi.YAMLPsiElement;
import org.jetbrains.yaml.psi.YAMLQuotedText;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLValue;
import org.jetbrains.yaml.psi.YamlPsiElementVisitor;
import org.jetbrains.yaml.psi.YamlPsiUtilKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/yaml/inspections/YamlIncompatibleTypesVisitor;", "Lorg/jetbrains/yaml/psi/YamlPsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;Lcom/intellij/codeInspection/LocalInspectionToolSession;)V", "visitScalar", "", "scalar", "Lorg/jetbrains/yaml/psi/YAMLScalar;", "getMostPopularTypeForSiblings", "Lorg/jetbrains/yaml/meta/model/YamlMetaType;", "value", "Lorg/jetbrains/yaml/psi/YAMLValue;", "intellij.yaml.backend"})
@SourceDebugExtension(value={"SMAP\nYAMLIncompatibleTypesInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 YAMLIncompatibleTypesInspection.kt\norg/jetbrains/yaml/inspections/YamlIncompatibleTypesVisitor\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,87:1\n477#2:88\n1255#2,2:89\n477#2:93\n1063#2:94\n66#3,2:91\n1#4:95\n*S KotlinDebug\n*F\n+ 1 YAMLIncompatibleTypesInspection.kt\norg/jetbrains/yaml/inspections/YamlIncompatibleTypesVisitor\n*L\n43#1:88\n47#1:89,2\n59#1:93\n60#1:94\n57#1:91,2\n*E\n"})
final class YamlIncompatibleTypesVisitor
extends YamlPsiElementVisitor {
    @NotNull
    private final ProblemsHolder holder;
    @NotNull
    private final LocalInspectionToolSession session;

    public YamlIncompatibleTypesVisitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.holder = holder;
        this.session = session;
    }

    public void visitScalar(@NotNull YAMLScalar scalar) {
        Intrinsics.checkNotNullParameter((Object)scalar, (String)"scalar");
        YamlMetaType yamlMetaType = YamlPsiUtilKt.estimatedType(scalar);
        if (yamlMetaType == null) {
            return;
        }
        YamlMetaType estimatedType = yamlMetaType;
        YamlMetaType mostPopularType = this.getMostPopularTypeForSiblings((YAMLValue)scalar);
        if (mostPopularType == null || Intrinsics.areEqual((Object)mostPopularType, (Object)estimatedType)) {
            return;
        }
        Object[] objectArray = new Object[]{estimatedType.getDisplayName(), mostPopularType.getDisplayName()};
        ProblemsHolder.ProblemBuilder problemBuilder = this.holder.problem((PsiElement)scalar, YAMLBundle.message((String)"inspections.incompatible.types.message", (Object[])objectArray));
        Intrinsics.checkNotNullExpressionValue((Object)problemBuilder, (String)"problem(...)");
        ProblemsHolder.ProblemBuilder problem = problemBuilder;
        if (Intrinsics.areEqual((Object)mostPopularType, (Object)YamlStringType.getInstance())) {
            boolean bl;
            boolean singleQuote;
            block5: {
                Sequence<YAMLPsiElement> siblings;
                Sequence<YAMLPsiElement> $this$filterIsInstance$iv = siblings = YamlPsiUtilKt.findStructuralSiblings((YAMLValue)scalar);
                boolean $i$f$filterIsInstance = false;
                Sequence sequence = SequencesKt.filter($this$filterIsInstance$iv, (Function1)visitScalar$$inlined$filterIsInstance$1.INSTANCE);
                Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
                YAMLQuotedText yAMLQuotedText = (YAMLQuotedText)SequencesKt.firstOrNull((Sequence)sequence);
                singleQuote = yAMLQuotedText != null ? yAMLQuotedText.isSingleQuote() : false;
                PsiElement psiElement = (PsiElement)scalar;
                String string = YAMLBundle.message((String)"inspections.incompatible.types.quickfix.wrap.quotes.message", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                problem.fix((ModCommandAction)new YAMLAddQuoteQuickFix(psiElement, string, singleQuote));
                Sequence<YAMLPsiElement> $this$any$iv = siblings;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    YAMLPsiElement it = (YAMLPsiElement)element$iv;
                    boolean bl2 = false;
                    if (!(!Intrinsics.areEqual((Object)it, (Object)scalar) && !(it instanceof YAMLQuotedText))) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
            if (bl) {
                problem.fix((ModCommandAction)new YAMLAddQuotesToSiblingsQuickFix((YAMLValue)scalar, singleQuote));
            }
        }
        problem.register();
        super.visitScalar(scalar);
    }

    private final YamlMetaType getMostPopularTypeForSiblings(YAMLValue value) {
        PsiElement $this$parentOfType_u24default$iv = (PsiElement)value;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        YAMLSequence yAMLSequence = (YAMLSequence)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, YAMLSequence.class, (boolean)true);
        if (yAMLSequence == null) {
            return null;
        }
        YAMLSequence topSeq = yAMLSequence;
        return (YamlMetaType)YAMLIncompatibleTypesInspectionKt.access$memoizeWith2Keys((UserDataHolder)this.session, YAMLIncompatibleTypesInspectionKt.access$getSTRUCTURAL_SIBLINGS_TYPE_KEY$p(), topSeq, YamlPsiUtilKt.getKeysInBetween(value, topSeq), YamlIncompatibleTypesVisitor::getMostPopularTypeForSiblings$lambda$4);
    }

    private static final YamlMetaType getMostPopularTypeForSiblings$lambda$4$lambda$1(YAMLScalar it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return YamlPsiUtilKt.estimatedType(it);
    }

    private static final YamlMetaType getMostPopularTypeForSiblings$lambda$4(YAMLSequence seq, List ks) {
        Object v1;
        Intrinsics.checkNotNullParameter((Object)seq, (String)"seq");
        Intrinsics.checkNotNullParameter((Object)ks, (String)"ks");
        Sequence<YAMLPsiElement> $this$filterIsInstance$iv = YamlPsiUtilKt.findStructuralSiblings(seq, ks);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter($this$filterIsInstance$iv, (Function1)getMostPopularTypeForSiblings$lambda$4$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        Sequence $this$groupingBy$iv = SequencesKt.mapNotNull((Sequence)sequence, YamlIncompatibleTypesVisitor::getMostPopularTypeForSiblings$lambda$4$lambda$1);
        boolean $i$f$groupingBy = false;
        Iterable iterable = GroupingKt.eachCount((Grouping)((Grouping)new Grouping<YamlMetaType, YamlMetaType>($this$groupingBy$iv){
            final /* synthetic */ Sequence $this_groupingBy;
            {
                this.$this_groupingBy = $receiver;
            }

            public Iterator<YamlMetaType> sourceIterator() {
                return this.$this_groupingBy.iterator();
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             * WARNING - void declaration
             */
            public Object keyOf(Object element) {
                void var2_2;
                YamlMetaType it = (YamlMetaType)element;
                boolean bl = false;
                return var2_2;
            }
        })).entrySet();
        Iterator iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            v1 = null;
        } else {
            Object t = iterator.next();
            if (!iterator.hasNext()) {
                v1 = t;
            } else {
                Map.Entry it = (Map.Entry)t;
                boolean bl = false;
                int n = ((Number)it.getValue()).intValue();
                do {
                    Object t2 = iterator.next();
                    Map.Entry it2 = (Map.Entry)t2;
                    $i$a$-maxByOrNull-YamlIncompatibleTypesVisitor$getMostPopularTypeForSiblings$1$3 = false;
                    int n2 = ((Number)it2.getValue()).intValue();
                    if (n >= n2) continue;
                    t = t2;
                    n = n2;
                } while (iterator.hasNext());
                v1 = t;
            }
        }
        Map.Entry entry = v1;
        return entry != null ? (YamlMetaType)entry.getKey() : null;
    }
}

