/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.session.util;

import com.intellij.openapi.Disposable;
import com.intellij.util.Alarm;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0014\u0010\u0010\u001a\u00020\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/plugins/terminal/block/session/util/Debouncer;", "", "delay", "", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(ILcom/intellij/openapi/Disposable;)V", "scheduled", "Ljava/util/concurrent/atomic/AtomicBoolean;", "alarm", "Lcom/intellij/util/Alarm;", "useExtendedDelayOnce", "", "setExtendedDelayOnce", "", "execute", "action", "Lkotlin/Function0;", "intellij.terminal"})
public final class Debouncer {
    private final int delay;
    @NotNull
    private final AtomicBoolean scheduled;
    @NotNull
    private final Alarm alarm;
    private volatile boolean useExtendedDelayOnce;

    public Debouncer(int delay, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.delay = delay;
        this.scheduled = new AtomicBoolean(false);
        this.alarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, parentDisposable);
    }

    public final void setExtendedDelayOnce() {
        this.useExtendedDelayOnce = true;
    }

    public final void execute(@NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        if (this.scheduled.compareAndSet(false, true)) {
            Function0 request = () -> Debouncer.execute$lambda$0(this, action);
            int delay = this.useExtendedDelayOnce ? 100 + this.delay : this.delay;
            this.useExtendedDelayOnce = false;
            if (delay <= 0) {
                request.invoke();
            } else {
                this.alarm.addRequest(() -> Debouncer.execute$lambda$1(request), delay);
            }
        }
    }

    private static final Unit execute$lambda$0(Debouncer this$0, Function0 $action) {
        this$0.scheduled.set(false);
        $action.invoke();
        return Unit.INSTANCE;
    }

    private static final void execute$lambda$1(Function0 $tmp0) {
        $tmp0.invoke();
    }
}

