/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.classloading;

import java.lang.reflect.Field;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import org.gradle.api.GradleException;
import org.gradle.api.internal.classloading.GroovySystemLoader;

public class PreferenceCleaningGroovySystemLoader
implements GroovySystemLoader {
    private final Field prefListenerField;
    private final ClassLoader leakingLoader;

    public PreferenceCleaningGroovySystemLoader(ClassLoader leakingLoader) throws Exception {
        this.leakingLoader = leakingLoader;
        this.prefListenerField = AbstractPreferences.class.getDeclaredField("prefListeners");
        this.prefListenerField.setAccessible(true);
    }

    @Override
    public void shutdown() {
        try {
            Preferences groovyNode = Preferences.userRoot().node("/org/codehaus/groovy/tools/shell");
            PreferenceChangeListener[] prefListeners = (PreferenceChangeListener[])this.prefListenerField.get(groovyNode);
            if (prefListeners == null) {
                return;
            }
            for (PreferenceChangeListener prefListener : prefListeners) {
                ClassLoader prefListenerLoader = prefListener.getClass().getClassLoader();
                if (this.leakingLoader != prefListenerLoader) continue;
                groovyNode.removePreferenceChangeListener(prefListener);
            }
        }
        catch (Exception e) {
            throw new GradleException("Could not shut down the Groovy system for " + this.leakingLoader, (Throwable)e);
        }
    }

    @Override
    public void discardTypesFrom(ClassLoader classLoader) {
    }
}

