/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.file.nio;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import org.gradle.api.UncheckedIOException;
import org.gradle.internal.file.FileMetadata;
import org.gradle.internal.file.FileMetadataAccessor;
import org.gradle.internal.file.impl.DefaultFileMetadata;

public class NioFileMetadataAccessor
implements FileMetadataAccessor {
    @Override
    public FileMetadata stat(File file) {
        BasicFileAttributes attributes;
        Path path = file.toPath();
        try {
            attributes = Files.readAttributes(path, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
        }
        catch (IOException e) {
            return DefaultFileMetadata.missing(FileMetadata.AccessType.DIRECT);
        }
        FileMetadata.AccessType accessType = FileMetadata.AccessType.viaSymlink(attributes.isSymbolicLink());
        if (accessType == FileMetadata.AccessType.VIA_SYMLINK) {
            try {
                attributes = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
            }
            catch (IOException e) {
                return DefaultFileMetadata.missing(FileMetadata.AccessType.VIA_SYMLINK);
            }
        }
        if (attributes.isDirectory()) {
            return DefaultFileMetadata.directory(accessType);
        }
        if (attributes.isOther()) {
            throw new UncheckedIOException("Unsupported file type for " + file.getAbsolutePath());
        }
        return DefaultFileMetadata.file(attributes.lastModifiedTime().toMillis(), attributes.size(), accessType);
    }
}

