/*
 * Decompiled with CFR 0.152.
 */
package java2d.demos.Paint;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.font.TextLayout;
import java2d.ControlsSurface;
import java2d.CustomControls;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

public class Gradient
extends ControlsSurface {
    protected Color innerC;
    protected Color outerC;

    public Gradient() {
        this.setBackground(Color.white);
        this.innerC = Color.green;
        this.outerC = Color.blue;
        this.setControls(new Component[]{new DemoControls(this)});
    }

    @Override
    public void render(int w, int h, Graphics2D g2) {
        int w2 = w / 2;
        int h2 = h / 2;
        g2.setPaint(new GradientPaint(0.0f, 0.0f, this.outerC, (float)w * 0.35f, (float)h * 0.35f, this.innerC));
        g2.fillRect(0, 0, w2, h2);
        g2.setPaint(new GradientPaint(w, 0.0f, this.outerC, (float)w * 0.65f, (float)h * 0.35f, this.innerC));
        g2.fillRect(w2, 0, w2, h2);
        g2.setPaint(new GradientPaint(0.0f, h, this.outerC, (float)w * 0.35f, (float)h * 0.65f, this.innerC));
        g2.fillRect(0, h2, w2, h2);
        g2.setPaint(new GradientPaint(w, h, this.outerC, (float)w * 0.65f, (float)h * 0.65f, this.innerC));
        g2.fillRect(w2, h2, w2, h2);
        g2.setColor(Color.black);
        TextLayout tl = new TextLayout("GradientPaint", g2.getFont(), g2.getFontRenderContext());
        tl.draw(g2, (int)((double)(w / 2) - tl.getBounds().getWidth() / 2.0), (int)((double)(h / 2) + tl.getBounds().getHeight() / 2.0));
    }

    public static void main(String[] s) {
        Gradient.createDemoFrame(new Gradient());
    }

    static class DemoControls
    extends CustomControls
    implements ActionListener {
        Gradient demo;
        Color[] colors = new Color[]{Color.red, Color.orange, Color.yellow, Color.green, Color.blue, Color.lightGray, Color.cyan, Color.magenta};
        String[] colorName = new String[]{"Red", "Orange", "Yellow", "Green", "Blue", "lightGray", "Cyan", "Magenta"};
        JMenuItem[] innerMI = new JMenuItem[this.colors.length];
        JMenuItem[] outerMI = new JMenuItem[this.colors.length];
        ColoredSquare[] squares = new ColoredSquare[this.colors.length];
        JMenu imenu;
        JMenu omenu;

        public DemoControls(Gradient demo) {
            super(demo.name);
            this.demo = demo;
            JMenuBar inMenuBar = new JMenuBar();
            this.add(inMenuBar);
            JMenuBar outMenuBar = new JMenuBar();
            this.add(outMenuBar);
            Font font = new Font("Serif", 0, 10);
            this.imenu = inMenuBar.add(new JMenu("Inner Color"));
            this.imenu.setFont(font);
            this.imenu.setIcon(new ColoredSquare(this, demo.innerC));
            this.omenu = outMenuBar.add(new JMenu("Outer Color"));
            this.omenu.setFont(font);
            this.omenu.setIcon(new ColoredSquare(this, demo.outerC));
            for (int i = 0; i < this.colors.length; ++i) {
                this.squares[i] = new ColoredSquare(this, this.colors[i]);
                this.innerMI[i] = this.imenu.add(new JMenuItem(this.colorName[i]));
                this.innerMI[i].setFont(font);
                this.innerMI[i].setIcon(this.squares[i]);
                this.innerMI[i].addActionListener(this);
                this.outerMI[i] = this.omenu.add(new JMenuItem(this.colorName[i]));
                this.outerMI[i].setFont(font);
                this.outerMI[i].setIcon(this.squares[i]);
                this.outerMI[i].addActionListener(this);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (int i = 0; i < this.colors.length; ++i) {
                if (e.getSource().equals(this.innerMI[i])) {
                    this.demo.innerC = this.colors[i];
                    this.imenu.setIcon(this.squares[i]);
                    break;
                }
                if (!e.getSource().equals(this.outerMI[i])) continue;
                this.demo.outerC = this.colors[i];
                this.omenu.setIcon(this.squares[i]);
                break;
            }
            this.demo.repaint();
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(200, 37);
        }

        @Override
        public void run() {
            if (this.demo.getImageType() <= 1) {
                this.demo.setImageType(2);
            }
            Thread me = Thread.currentThread();
            while (this.thread == me) {
                for (int i = 0; i < this.innerMI.length; ++i) {
                    if (i == 4) continue;
                    try {
                        Thread.sleep(4444L);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    this.innerMI[i].doClick();
                }
            }
            this.thread = null;
        }

        class ColoredSquare
        implements Icon {
            Color color;

            public ColoredSquare(DemoControls this$0, Color c) {
                this.color = c;
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Color oldColor = g.getColor();
                g.setColor(this.color);
                g.fill3DRect(x, y, this.getIconWidth(), this.getIconHeight(), true);
                g.setColor(oldColor);
            }

            @Override
            public int getIconWidth() {
                return 12;
            }

            @Override
            public int getIconHeight() {
                return 12;
            }
        }
    }
}

