/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.transaction;

import jakarta.ws.rs.core.MultivaluedMap;
import java.util.List;
import java.util.Set;
import org.keycloak.http.HttpRequest;
import org.keycloak.models.KeycloakSession;

public class RequestContextHelper {
    public static final String SESSION_ATTRIBUTE = "REQ_CONTEXT_HELPER";
    private static final Set<String> ALLOWED_ATTRIBUTES = Set.of("grant_type", "urn:openid:params:grant-type:ciba", "scope", "urn:ietf:params:oauth:grant-type:token-exchange", "urn:ietf:params:oauth:token-type:access_token", "urn:ietf:params:oauth:grant-type:device_code", "response_type");
    private final KeycloakSession session;
    private String contextMessage;

    private RequestContextHelper(KeycloakSession session) {
        this.session = session;
    }

    public void setContextMessage(String message) {
        this.contextMessage = message;
    }

    public static RequestContextHelper getContext(KeycloakSession session) {
        RequestContextHelper ctxHelper = (RequestContextHelper)session.getAttribute(SESSION_ATTRIBUTE);
        if (ctxHelper != null) {
            return ctxHelper;
        }
        ctxHelper = new RequestContextHelper(session);
        session.setAttribute(SESSION_ATTRIBUTE, (Object)ctxHelper);
        return ctxHelper;
    }

    public String getContextInfo() {
        if (this.contextMessage != null) {
            return this.contextMessage;
        }
        try {
            HttpRequest httpRequest = this.session.getContext().getHttpRequest();
            if (httpRequest != null && httpRequest.getUri() != null) {
                return "HTTP " + httpRequest.getHttpMethod() + " " + httpRequest.getUri().getPath();
            }
        }
        catch (Exception e) {
            return "Unknown context";
        }
        return "Non-HTTP context";
    }

    public String getDetailedContextInfo() {
        try {
            HttpRequest httpRequest = this.session.getContext().getHttpRequest();
            if (httpRequest != null && httpRequest.getUri() != null) {
                StringBuilder builder = new StringBuilder("HTTP ").append(httpRequest.getHttpMethod()).append(" ").append(httpRequest.getUri().getRequestUri());
                MultivaluedMap formParams = httpRequest.getDecodedFormParameters();
                if (formParams != null && !formParams.isEmpty()) {
                    builder.append(", Form parameters [ ");
                    formParams.entrySet().forEach(entry -> {
                        String key = (String)entry.getKey();
                        List values = (List)entry.getValue();
                        values.forEach(value -> {
                            if (!ALLOWED_ATTRIBUTES.contains(key)) {
                                value = "***";
                            }
                            builder.append(key + "=" + value + ", ");
                        });
                    });
                    builder.append(" ]");
                }
                return builder.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.getContextInfo();
    }
}

