/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.models.annotations.internal;

import jakarta.persistence.ParameterMode;
import jakarta.persistence.StoredProcedureParameter;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.hibernate.boot.jaxb.mapping.spi.JaxbStoredProcedureParameterImpl;
import org.hibernate.boot.models.xml.spi.XmlDocumentContext;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.models.spi.ModelsContext;

public class StoredProcedureParameterJpaAnnotation
implements StoredProcedureParameter {
    private String name;
    private ParameterMode mode;
    private Class<?> type;

    public StoredProcedureParameterJpaAnnotation(ModelsContext modelContext) {
        this.name = "";
        this.mode = ParameterMode.IN;
    }

    public StoredProcedureParameterJpaAnnotation(StoredProcedureParameter annotation, ModelsContext modelContext) {
        this.name = annotation.name();
        this.mode = annotation.mode();
        this.type = annotation.type();
    }

    public StoredProcedureParameterJpaAnnotation(Map<String, Object> attributeValues, ModelsContext modelContext) {
        this.name = (String)attributeValues.get("name");
        this.mode = (ParameterMode)attributeValues.get("mode");
        this.type = (Class)attributeValues.get("type");
    }

    public Class<? extends Annotation> annotationType() {
        return StoredProcedureParameter.class;
    }

    public String name() {
        return this.name;
    }

    public void name(String value) {
        this.name = value;
    }

    public ParameterMode mode() {
        return this.mode;
    }

    public void mode(ParameterMode value) {
        this.mode = value;
    }

    public Class<?> type() {
        return this.type;
    }

    public void type(Class<?> value) {
        this.type = value;
    }

    public void apply(JaxbStoredProcedureParameterImpl jaxbParam, XmlDocumentContext xmlDocumentContext) {
        if (StringHelper.isNotEmpty(jaxbParam.getName())) {
            this.name(jaxbParam.getName());
        }
        if (jaxbParam.getMode() != null) {
            this.mode(jaxbParam.getMode());
        }
        if (StringHelper.isNotEmpty(jaxbParam.getClazz())) {
            this.type(xmlDocumentContext.resolveJavaType(jaxbParam.getClazz()).toJavaClass());
        }
    }
}

