/*
 * Decompiled with CFR 0.152.
 */
package org.tribuo.classification.sequence;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.tribuo.ImmutableFeatureMap;
import org.tribuo.ImmutableOutputInfo;
import org.tribuo.Prediction;
import org.tribuo.classification.Label;
import org.tribuo.provenance.ModelProvenance;
import org.tribuo.sequence.SequenceExample;
import org.tribuo.sequence.SequenceModel;

public abstract class ConfidencePredictingSequenceModel
extends SequenceModel<Label> {
    private static final long serialVersionUID = 1L;

    protected ConfidencePredictingSequenceModel(String name, ModelProvenance description, ImmutableFeatureMap featureIDMap, ImmutableOutputInfo<Label> labelIDMap) {
        super(name, description, featureIDMap, labelIDMap);
    }

    public abstract <SUB extends Subsequence> List<Double> scoreSubsequences(SequenceExample<Label> var1, List<Prediction<Label>> var2, List<SUB> var3);

    public static <SUB extends Subsequence> List<Double> multiplyWeights(List<Prediction<Label>> predictions, List<SUB> subsequences) {
        ArrayList<Double> scores = new ArrayList<Double>(subsequences.size());
        for (Subsequence subsequence : subsequences) {
            scores.add(ConfidencePredictingSequenceModel.multiplyWeights(predictions, subsequence));
        }
        return scores;
    }

    private static <SUB extends Subsequence> Double multiplyWeights(List<Prediction<Label>> predictions, SUB subsequence) {
        double counter = 1.0;
        for (int i = subsequence.begin; i < subsequence.end; ++i) {
            counter *= ((Label)predictions.get(i).getOutput()).getScore();
        }
        return counter;
    }

    public static class Subsequence
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final int begin;
        public final int end;

        public Subsequence(int begin, int end) {
            this.begin = begin;
            this.end = end;
        }

        public int length() {
            return this.end - this.begin;
        }

        public String toString() {
            return "(" + this.begin + "," + this.end + ")";
        }
    }
}

