/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.resources.settings;

import java.util.List;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.security.resources.ResourcePluginInfo;
import org.opensearch.security.setting.OpensearchDynamicSetting;
import org.opensearch.security.support.ConfigConstants;

public class ResourceSharingProtectedResourcesSetting
extends OpensearchDynamicSetting<List<String>> {
    private static final Logger logger = LogManager.getLogger(ResourceSharingProtectedResourcesSetting.class);
    public static final Setting<List<String>> PROTECTED_TYPES = Setting.listSetting((String)"plugins.security.experimental.resource_sharing.protected_types", ConfigConstants.OPENSEARCH_RESOURCE_SHARING_PROTECTED_TYPES_DEFAULT, Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Dynamic});
    private final ResourcePluginInfo resourcePluginInfo;

    public ResourceSharingProtectedResourcesSetting(Settings settings, ResourcePluginInfo resourcePluginInfo) {
        super(PROTECTED_TYPES, (List)PROTECTED_TYPES.get(settings));
        this.resourcePluginInfo = resourcePluginInfo;
    }

    @Override
    public void registerClusterSettingsChangeListener(ClusterSettings clusterSettings) {
        clusterSettings.addSettingsUpdateConsumer(PROTECTED_TYPES, newValue -> {
            logger.info(this.getClusterChangeMessage((List<String>)newValue));
            this.setDynamicSettingValue(newValue);
            this.resourcePluginInfo.updateProtectedTypes((List<String>)newValue);
        });
    }

    @Override
    protected String getClusterChangeMessage(List<String> newValue) {
        return String.format("Detected change in settings, new resource-sharing protected resource-types are %s", newValue);
    }
}

