/*
 * Decompiled with CFR 0.152.
 */
package com.intel.qat;

import com.github.luben.zstd.SequenceProducer;
import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.ZstdCompressCtx;
import com.github.luben.zstd.ZstdDecompressCtx;
import com.intel.qat.InternalJNI;
import com.intel.qat.QatZstdSequenceProducer;
import java.nio.ByteBuffer;
import java.nio.ReadOnlyBufferException;

public class QatZipper {
    public static final Algorithm DEFAULT_ALGORITHM = Algorithm.DEFLATE;
    public static final int DEFAULT_COMPRESS_LEVEL = 6;
    public static final Mode DEFAULT_MODE = Mode.AUTO;
    public static final int DEFAULT_RETRY_COUNT = 0;
    public static final PollingMode DEFAULT_POLLING_MODE = PollingMode.BUSY;
    public static final DataFormat DEFAULT_DATA_FORMAT = DataFormat.DEFLATE_GZIP_EXT;
    public static final HardwareBufferSize DEFAULT_HW_BUFFER_SIZE = HardwareBufferSize.DEFAULT_BUFFER_SIZE;
    private Algorithm algorithm = DEFAULT_ALGORITHM;
    private int level = 6;
    private Mode mode = DEFAULT_MODE;
    private int retryCount = 0;
    private PollingMode pollingMode = DEFAULT_POLLING_MODE;
    private DataFormat dataFormat = DEFAULT_DATA_FORMAT;
    private HardwareBufferSize hwBufferSize = DEFAULT_HW_BUFFER_SIZE;
    private boolean isValid;
    private int bytesRead;
    private int bytesWritten;
    private int qzKey;
    private ZstdCompressCtx zstdCompressCtx;
    private ZstdDecompressCtx zstdDecompressCtx;
    private boolean checksumFlag;

    public static boolean isQatAvailable() {
        return QatAvailableHolder.IS_QAT_AVAILABLE;
    }

    private QatZipper(Builder builder) throws RuntimeException {
        this.algorithm = builder.algorithm;
        this.level = builder.level;
        this.mode = builder.mode;
        this.retryCount = builder.retryCount;
        this.pollingMode = builder.pollingMode;
        this.dataFormat = builder.dataFormat;
        this.hwBufferSize = builder.hwBufferSize;
        if (this.retryCount < 0) {
            throw new IllegalArgumentException("Invalid value for retry count");
        }
        if (this.algorithm == Algorithm.ZSTD) {
            this.zstdCompressCtx = new ZstdCompressCtx();
            this.zstdDecompressCtx = new ZstdDecompressCtx();
        }
        int status = InternalJNI.setup(this, this.algorithm.ordinal(), this.level, this.mode.ordinal(), this.pollingMode.ordinal(), this.dataFormat.ordinal(), this.hwBufferSize.getValue());
        if (this.algorithm == Algorithm.ZSTD) {
            boolean QZ_OK = false;
            if (this.mode == Mode.HARDWARE || this.mode == Mode.AUTO && status == 0) {
                this.zstdCompressCtx.registerSequenceProducer((SequenceProducer)new QatZstdSequenceProducer());
                this.zstdCompressCtx.setSequenceProducerFallback(true);
            }
            this.zstdCompressCtx.setLevel(this.level);
        }
        this.isValid = true;
    }

    public QatZipper() {
        this(new Builder());
    }

    public QatZipper(Algorithm algorithm) {
        this(new Builder().setAlgorithm(algorithm));
    }

    public QatZipper(Algorithm algorithm, int level) {
        this(new Builder().setAlgorithm(algorithm).setLevel(level));
    }

    public int maxCompressedLength(long len) {
        if (!this.isValid) {
            throw new IllegalStateException("QAT session has been closed");
        }
        if (this.algorithm != Algorithm.ZSTD) {
            return InternalJNI.maxCompressedSize(this.qzKey, len);
        }
        return (int)Zstd.compressBound((long)len);
    }

    public int compress(byte[] src, byte[] dst) {
        return this.compress(src, 0, src.length, dst, 0, dst.length);
    }

    public int compress(byte[] src, int srcOffset, int srcLen, byte[] dst, int dstOffset, int dstLen) {
        int compressedSize;
        if (!this.isValid) {
            throw new IllegalStateException("QAT session has been closed");
        }
        if (src == null || dst == null || srcLen == 0 || dst.length == 0) {
            throw new IllegalArgumentException("Either source or destination array or both have size 0 or null value");
        }
        if (srcOffset < 0 || srcLen < 0 || srcOffset > src.length - srcLen) {
            throw new ArrayIndexOutOfBoundsException("Source offset is out of bound");
        }
        if (dstOffset < 0 || dstLen < 0 || dstOffset > dst.length - dstLen) {
            throw new ArrayIndexOutOfBoundsException("Destination offset is out of bound");
        }
        if (this.algorithm != Algorithm.ZSTD) {
            return this.compressByteArray(src, srcOffset, srcLen, dst, dstOffset, dstLen);
        }
        this.bytesWritten = 0;
        this.bytesRead = 0;
        this.bytesWritten = compressedSize = this.zstdCompressCtx.compressByteArray(dst, dstOffset, dstLen, src, srcOffset, srcLen);
        this.bytesRead = srcLen;
        return compressedSize;
    }

    private int compressByteArray(byte[] src, int srcOffset, int srcLen, byte[] dst, int dstOffset, int dstLen) {
        int compressedSize;
        this.bytesWritten = 0;
        this.bytesRead = 0;
        this.bytesWritten = compressedSize = InternalJNI.compressByteArray(this, this.qzKey, src, srcOffset, srcLen, dst, dstOffset, dstLen, this.retryCount);
        return compressedSize;
    }

    public int compress(ByteBuffer src, ByteBuffer dst) {
        if (!this.isValid) {
            throw new IllegalStateException("QAT session has been closed");
        }
        if (src == null || dst == null || src.position() == src.limit() || dst.position() == dst.limit()) {
            throw new IllegalArgumentException();
        }
        if (dst.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        if (this.algorithm != Algorithm.ZSTD) {
            return this.compressByteBuffer(src, dst);
        }
        return this.zstdCompressCtx.compress(dst, src);
    }

    private int compressByteBuffer(ByteBuffer src, ByteBuffer dst) {
        int srcPos = src.position();
        int dstPos = dst.position();
        this.bytesWritten = 0;
        this.bytesRead = 0;
        int compressedSize = 0;
        if (src.hasArray() && dst.hasArray()) {
            compressedSize = InternalJNI.compressByteBuffer(this.qzKey, src, src.array(), srcPos, src.remaining(), dst.array(), dstPos, dst.remaining(), this.retryCount);
            dst.position(dstPos + compressedSize);
        } else if (src.isDirect() && dst.isDirect()) {
            compressedSize = InternalJNI.compressDirectByteBuffer(this.qzKey, src, srcPos, src.remaining(), dst, dstPos, dst.remaining(), this.retryCount);
        } else if (src.hasArray() && dst.isDirect()) {
            compressedSize = InternalJNI.compressDirectByteBufferDst(this.qzKey, src, src.array(), srcPos, src.remaining(), dst, dstPos, dst.remaining(), this.retryCount);
        } else if (src.isDirect() && dst.hasArray()) {
            compressedSize = InternalJNI.compressDirectByteBufferSrc(this.qzKey, src, srcPos, src.remaining(), dst.array(), dstPos, dst.remaining(), this.retryCount);
            dst.position(dstPos + compressedSize);
        } else {
            int srcLen = src.remaining();
            int dstLen = dst.remaining();
            byte[] srcArr = new byte[srcLen];
            byte[] dstArr = new byte[dstLen];
            src.get(srcArr);
            dst.get(dstArr);
            src.position(src.position() - srcLen);
            dst.position(dst.position() - dstLen);
            int pos = src.position();
            compressedSize = InternalJNI.compressByteBuffer(this.qzKey, src, srcArr, 0, srcLen, dstArr, 0, dstLen, this.retryCount);
            src.position(pos + src.position());
            dst.put(dstArr, 0, compressedSize);
        }
        this.bytesRead = src.position() - srcPos;
        this.bytesWritten = dst.position() - dstPos;
        return compressedSize;
    }

    public int decompress(byte[] src, byte[] dst) {
        return this.decompress(src, 0, src.length, dst, 0, dst.length);
    }

    public int decompress(byte[] src, int srcOffset, int srcLen, byte[] dst, int dstOffset, int dstLen) {
        int decompressedSize;
        if (!this.isValid) {
            throw new IllegalStateException("QAT session has been closed");
        }
        if (src == null || dst == null || srcLen == 0 || dst.length == 0) {
            throw new IllegalArgumentException("Empty source or/and destination byte array(s)");
        }
        if (srcOffset < 0 || srcLen < 0 || srcOffset > src.length - srcLen) {
            throw new ArrayIndexOutOfBoundsException("Source offset is out of bound");
        }
        if (dstOffset < 0 || dstLen < 0 || dstOffset > dst.length - dstLen) {
            throw new ArrayIndexOutOfBoundsException("Destination offset is out of bound");
        }
        if (this.algorithm != Algorithm.ZSTD) {
            return this.decompressByteArray(src, srcOffset, srcLen, dst, dstOffset, dstLen);
        }
        this.bytesWritten = 0;
        this.bytesRead = 0;
        this.bytesWritten = decompressedSize = this.zstdDecompressCtx.decompressByteArray(dst, dstOffset, dstLen, src, srcOffset, srcLen);
        this.bytesRead = srcLen;
        return decompressedSize;
    }

    private int decompressByteArray(byte[] src, int srcOffset, int srcLen, byte[] dst, int dstOffset, int dstLen) {
        int decompressedSize;
        this.bytesWritten = 0;
        this.bytesRead = 0;
        this.bytesWritten = decompressedSize = InternalJNI.decompressByteArray(this, this.qzKey, src, srcOffset, srcLen, dst, dstOffset, dstLen, this.retryCount);
        return decompressedSize;
    }

    public int decompress(ByteBuffer src, ByteBuffer dst) {
        if (!this.isValid) {
            throw new IllegalStateException("QAT session has been closed");
        }
        if (src == null || dst == null || src.position() == src.limit() || dst.position() == dst.limit()) {
            throw new IllegalArgumentException();
        }
        if (dst.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        if (this.algorithm != Algorithm.ZSTD) {
            return this.decompressByteBuffer(src, dst);
        }
        if (!src.isDirect()) {
            throw new IllegalArgumentException("Zstd-jni requires source buffers to be direct byte buffers");
        }
        return this.zstdDecompressCtx.decompress(dst, src);
    }

    private int decompressByteBuffer(ByteBuffer src, ByteBuffer dst) {
        int srcPos = src.position();
        int dstPos = dst.position();
        this.bytesWritten = 0;
        this.bytesRead = 0;
        int decompressedSize = 0;
        if (src.hasArray() && dst.hasArray()) {
            decompressedSize = InternalJNI.decompressByteBuffer(this.qzKey, src, src.array(), srcPos, src.remaining(), dst.array(), dstPos, dst.remaining(), this.retryCount);
            dst.position(dstPos + decompressedSize);
        } else if (src.isDirect() && dst.isDirect()) {
            decompressedSize = InternalJNI.decompressDirectByteBuffer(this.qzKey, src, srcPos, src.remaining(), dst, dstPos, dst.remaining(), this.retryCount);
        } else if (src.hasArray() && dst.isDirect()) {
            decompressedSize = InternalJNI.decompressDirectByteBufferDst(this.qzKey, src, src.array(), srcPos, src.remaining(), dst, dstPos, dst.remaining(), this.retryCount);
        } else if (src.isDirect() && dst.hasArray()) {
            decompressedSize = InternalJNI.decompressDirectByteBufferSrc(this.qzKey, src, srcPos, src.remaining(), dst.array(), dstPos, dst.remaining(), this.retryCount);
            dst.position(dstPos + decompressedSize);
        } else {
            int srcLen = src.remaining();
            int dstLen = dst.remaining();
            byte[] srcArr = new byte[srcLen];
            byte[] dstArr = new byte[dstLen];
            src.get(srcArr);
            dst.get(dstArr);
            src.position(src.position() - srcLen);
            dst.position(dst.position() - dstLen);
            int pos = src.position();
            decompressedSize = InternalJNI.decompressByteBuffer(this.qzKey, src, srcArr, 0, srcLen, dstArr, 0, dstLen, this.retryCount);
            src.position(pos + src.position());
            dst.put(dstArr, 0, decompressedSize);
        }
        if (decompressedSize < 0) {
            throw new RuntimeException("QAT: Compression failed");
        }
        this.bytesRead = src.position() - srcPos;
        this.bytesWritten = dst.position() - dstPos;
        return decompressedSize;
    }

    public int getBytesRead() {
        return this.bytesRead;
    }

    public int getBytesWritten() {
        return this.bytesWritten;
    }

    public void setChecksumFlag(boolean checksumFlag) {
        if (this.algorithm != Algorithm.ZSTD) {
            throw new UnsupportedOperationException("Setting a checksum flag is currently valid only for ZSTD compressor");
        }
        this.zstdCompressCtx.setChecksum(checksumFlag);
    }

    public void end() throws RuntimeException {
        if (!this.isValid) {
            throw new IllegalStateException("Invalid QAT session");
        }
        InternalJNI.teardown(this.qzKey);
        this.isValid = false;
    }

    static class QatAvailableHolder {
        static final boolean IS_QAT_AVAILABLE;

        QatAvailableHolder() {
        }

        static {
            boolean isQatAvailable;
            try {
                QatZipper qzip = new Builder().setMode(Mode.HARDWARE).build();
                qzip.end();
                isQatAvailable = true;
            }
            catch (ExceptionInInitializerError | NoClassDefFoundError | RuntimeException | UnsatisfiedLinkError e) {
                isQatAvailable = false;
            }
            IS_QAT_AVAILABLE = isQatAvailable;
        }
    }

    public static enum Algorithm {
        DEFLATE,
        LZ4,
        ZSTD;

    }

    public static enum Mode {
        HARDWARE,
        AUTO;

    }

    public static enum PollingMode {
        BUSY,
        PERIODICAL;

    }

    public static enum DataFormat {
        DEFLATE_4B,
        DEFLATE_GZIP,
        DEFLATE_GZIP_EXT,
        DEFLATE_RAW,
        ZLIB;

    }

    public static enum HardwareBufferSize {
        DEFAULT_BUFFER_SIZE(65536),
        MAX_BUFFER_SIZE(524288);

        private final int value;

        private HardwareBufferSize(int hwBufferSize) {
            this.value = hwBufferSize;
        }

        public int getValue() {
            return this.value;
        }
    }

    public static class Builder {
        private Algorithm algorithm = DEFAULT_ALGORITHM;
        private int level = 6;
        private Mode mode = DEFAULT_MODE;
        private int retryCount = 0;
        private PollingMode pollingMode = DEFAULT_POLLING_MODE;
        private DataFormat dataFormat = DEFAULT_DATA_FORMAT;
        private HardwareBufferSize hwBufferSize = DEFAULT_HW_BUFFER_SIZE;

        public Builder setAlgorithm(Algorithm algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        Algorithm getAlgorithm() {
            return this.algorithm;
        }

        public Builder setLevel(int level) {
            this.level = level;
            return this;
        }

        public Builder setMode(Mode mode) {
            this.mode = mode;
            return this;
        }

        public Builder setRetryCount(int retryCount) {
            this.retryCount = retryCount;
            return this;
        }

        public Builder setPollingMode(PollingMode pollingMode) {
            this.pollingMode = pollingMode;
            return this;
        }

        public Builder setDataFormat(DataFormat dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        public Builder setHardwareBufferSize(HardwareBufferSize hwBufferSize) {
            this.hwBufferSize = hwBufferSize;
            return this;
        }

        public QatZipper build() throws RuntimeException {
            return new QatZipper(this);
        }

        public String toString() {
            return "QatZipper{algorithm=" + this.algorithm + ", level=" + this.level + ", mode=" + this.mode + ", retryCount=" + this.retryCount + ", pollingMode=" + this.pollingMode + ", dataFormat=" + this.dataFormat + ", hardwareBufferSize=" + this.hwBufferSize + "}";
        }
    }
}

