/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.sql.ast.expression.QualifiedName;
import org.opensearch.sql.calcite.CalcitePlanContext;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.expression.function.PPLFuncImpTable;

public class QualifiedNameResolver {
    private static final Logger log = LogManager.getLogger(QualifiedNameResolver.class);

    public static RexNode resolve(QualifiedName nameNode, CalcitePlanContext context) {
        log.debug("QualifiedNameResolver.resolve() called with nameNode={}, isResolvingJoinCondition={}", (Object)nameNode, (Object)context.isResolvingJoinCondition());
        if (context.isResolvingJoinCondition()) {
            return QualifiedNameResolver.resolveInJoinCondition(nameNode, context);
        }
        return QualifiedNameResolver.resolveInNonJoinCondition(nameNode, context);
    }

    private static RexNode resolveInJoinCondition(QualifiedName nameNode, CalcitePlanContext context) {
        log.debug("resolveInJoinCondition() called with nameNode={}", (Object)nameNode);
        return QualifiedNameResolver.resolveFieldWithAlias(nameNode, context, 2).or(() -> QualifiedNameResolver.resolveFieldWithoutAlias(nameNode, context, 2)).orElseThrow(() -> QualifiedNameResolver.getNotFoundException(nameNode));
    }

    private static RexNode resolveInNonJoinCondition(QualifiedName nameNode, CalcitePlanContext context) {
        log.debug("resolveInNonJoinCondition() called with nameNode={}", (Object)nameNode);
        return QualifiedNameResolver.resolveLambdaVariable(nameNode, context).or(() -> QualifiedNameResolver.resolveFieldDirectly(nameNode, context, 1)).or(() -> QualifiedNameResolver.resolveFieldWithAlias(nameNode, context, 1)).or(() -> QualifiedNameResolver.resolveFieldWithoutAlias(nameNode, context, 1)).or(() -> QualifiedNameResolver.resolveRenamedField(nameNode, context)).or(() -> QualifiedNameResolver.resolveCorrelationField(nameNode, context)).or(() -> QualifiedNameResolver.replaceWithNullLiteralInCoalesce(context)).orElseThrow(() -> QualifiedNameResolver.getNotFoundException(nameNode));
    }

    private static String joinParts(List<String> parts, int start, int length) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            if (start < i) {
                sb.append(".");
            }
            sb.append(parts.get(start + i));
        }
        return sb.toString();
    }

    private static String joinParts(List<String> parts, int start) {
        return QualifiedNameResolver.joinParts(parts, start, parts.size() - start);
    }

    private static Optional<RexNode> resolveFieldDirectly(QualifiedName nameNode, CalcitePlanContext context, int inputCount) {
        List<String> parts = nameNode.getParts();
        log.debug("resolveFieldDirectly() called with nameNode={}, parts={}, inputCount={}", (Object)nameNode, parts, (Object)inputCount);
        List currentFields = context.relBuilder.peek().getRowType().getFieldNames();
        if (currentFields.contains(nameNode.toString())) {
            try {
                return Optional.of(context.relBuilder.field(nameNode.toString()));
            }
            catch (IllegalArgumentException e) {
                log.debug("resolveFieldDirectly() failed: {}", (Object)e.getMessage());
            }
        }
        return Optional.empty();
    }

    private static Optional<RexNode> resolveFieldWithAlias(QualifiedName nameNode, CalcitePlanContext context, int inputCount) {
        List<String> parts = nameNode.getParts();
        log.debug("resolveFieldWithAlias() called with nameNode={}, parts={}, inputCount={}", (Object)nameNode, parts, (Object)inputCount);
        if (parts.size() >= 2) {
            String alias = parts.get(0);
            log.debug("resolveFieldWithAlias() trying alias={}", (Object)alias);
            for (int length = parts.size() - 1; 1 <= length; --length) {
                String field = QualifiedNameResolver.joinParts(parts, 1, length);
                log.debug("resolveFieldWithAlias() trying field={} with length={}", (Object)field, (Object)length);
                Optional<RexNode> fieldNode = QualifiedNameResolver.tryToResolveField(alias, field, context, inputCount);
                if (!fieldNode.isPresent()) continue;
                return Optional.of(QualifiedNameResolver.resolveFieldAccess(context, parts, 1, length, fieldNode.get()));
            }
        }
        return Optional.empty();
    }

    private static Optional<RexNode> tryToResolveField(String alias, String fieldName, CalcitePlanContext context, int inputCount) {
        log.debug("tryToResolveField() called with alias={}, fieldName={}, inputCount={}", (Object)alias, (Object)fieldName, (Object)inputCount);
        try {
            return Optional.of(context.relBuilder.field(inputCount, alias, fieldName));
        }
        catch (IllegalArgumentException e) {
            log.debug("tryToResolveField() failed: {}", (Object)e.getMessage());
            return Optional.empty();
        }
    }

    private static Optional<RexNode> resolveFieldWithoutAlias(QualifiedName nameNode, CalcitePlanContext context, int inputCount) {
        log.debug("resolveFieldWithoutAlias() called with nameNode={}, inputCount={}", (Object)nameNode, (Object)inputCount);
        List<Set<String>> inputFieldNames = QualifiedNameResolver.collectInputFieldNames(context, inputCount);
        List<String> parts = nameNode.getParts();
        for (int length = parts.size(); 1 <= length; --length) {
            String fieldName = QualifiedNameResolver.joinParts(parts, 0, length);
            log.debug("resolveFieldWithoutAlias() trying fieldName={} with length={}", (Object)fieldName, (Object)length);
            int foundInput = QualifiedNameResolver.findInputContainingFieldName(inputCount, inputFieldNames, fieldName);
            log.debug("resolveFieldWithoutAlias() foundInput={}", (Object)foundInput);
            if (foundInput == -1) continue;
            RexInputRef fieldNode = context.relBuilder.field(inputCount, foundInput, fieldName);
            return Optional.of(QualifiedNameResolver.resolveFieldAccess(context, parts, 0, length, (RexNode)fieldNode));
        }
        return Optional.empty();
    }

    private static int findInputContainingFieldName(int inputCount, List<Set<String>> inputFieldNames, String fieldName) {
        int foundInput = -1;
        for (int i = 0; i < inputCount; ++i) {
            if (!inputFieldNames.get(i).contains(fieldName)) continue;
            if (foundInput != -1) {
                throw new IllegalArgumentException("Ambiguous field: " + fieldName);
            }
            foundInput = i;
        }
        return foundInput;
    }

    private static List<Set<String>> collectInputFieldNames(CalcitePlanContext context, int inputCount) {
        ArrayList<Set<String>> inputFieldNames = new ArrayList<Set<String>>();
        for (int i = 0; i < inputCount; ++i) {
            int inputOrdinal = inputCount - i - 1;
            Set fieldNames = context.relBuilder.peek(inputOrdinal).getRowType().getFieldList().stream().map(RelDataTypeField::getName).collect(Collectors.toSet());
            inputFieldNames.add(fieldNames);
            log.debug("collectInputFieldNames() input[{}] fieldNames={}", (Object)inputOrdinal, fieldNames);
        }
        return inputFieldNames;
    }

    private static Optional<RexNode> resolveRenamedField(QualifiedName nameNode, CalcitePlanContext context) {
        log.debug("resolveRenamedField() called with nameNode={}", (Object)nameNode);
        List<String> parts = nameNode.getParts();
        if (parts.size() >= 2) {
            List<String> candidates = QualifiedNameResolver.findCandidatesByRenamedFieldName(nameNode, context);
            String alias = parts.get(0);
            for (String candidate : candidates) {
                try {
                    return Optional.of(context.relBuilder.field(alias, candidate));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            }
        }
        return Optional.empty();
    }

    private static List<String> findCandidatesByRenamedFieldName(QualifiedName renamedFieldName, CalcitePlanContext context) {
        String originalFieldName = QualifiedNameResolver.joinParts(renamedFieldName.getParts(), 1);
        return context.relBuilder.peek().getRowType().getFieldNames().stream().filter(col -> QualifiedNameResolver.getNameBeforeRename(col).equals(originalFieldName)).toList();
    }

    private static String getNameBeforeRename(String fieldName) {
        return fieldName.substring(fieldName.indexOf(".") + 1);
    }

    private static Optional<RexNode> resolveCorrelationField(QualifiedName nameNode, CalcitePlanContext context) {
        log.debug("resolveCorrelationField() called with nameNode={}", (Object)nameNode);
        List<String> parts = nameNode.getParts();
        return context.peekCorrelVar().map(correlation -> {
            List fieldNameList = correlation.getType().getFieldNames();
            for (int start = 0; start <= 1; ++start) {
                for (int length = parts.size() - start; 1 <= length; --length) {
                    String fieldName = QualifiedNameResolver.joinParts(parts, start, length);
                    log.debug("resolveCorrelationField() trying fieldName={}", (Object)fieldName);
                    if (!fieldNameList.contains(fieldName)) continue;
                    RexNode field = context.relBuilder.field((RexNode)correlation, fieldName);
                    return QualifiedNameResolver.resolveFieldAccess(context, parts, start, length, field);
                }
            }
            return null;
        });
    }

    private static RexNode resolveFieldAccess(CalcitePlanContext context, List<String> parts, int start, int length, RexNode field) {
        if (length == parts.size() - start) {
            return field;
        }
        String itemName = QualifiedNameResolver.joinParts(parts, length + start, parts.size() - length);
        return context.relBuilder.alias(QualifiedNameResolver.createItemAccess(field, itemName, context), String.join((CharSequence)".", parts.subList(start, parts.size())));
    }

    private static RexNode createItemAccess(RexNode field, String itemName, CalcitePlanContext context) {
        log.debug("createItemAccess() called with itemName={}", (Object)itemName);
        return PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.INTERNAL_ITEM, new RexNode[]{field, context.rexBuilder.makeLiteral(itemName)});
    }

    private static Optional<RexNode> resolveLambdaVariable(QualifiedName nameNode, CalcitePlanContext context) {
        log.debug("resolveLambdaVariable() called with nameNode={}", (Object)nameNode);
        String qualifiedName = nameNode.toString();
        return Optional.ofNullable((RexNode)context.getRexLambdaRefMap().get(qualifiedName));
    }

    private static Optional<RexNode> replaceWithNullLiteralInCoalesce(CalcitePlanContext context) {
        log.debug("replaceWithNullLiteralInCoalesce() called");
        if (context.isInCoalesceFunction()) {
            return Optional.of(context.rexBuilder.makeNullLiteral(context.rexBuilder.getTypeFactory().createSqlType(SqlTypeName.VARCHAR)));
        }
        return Optional.empty();
    }

    private static RuntimeException getNotFoundException(QualifiedName node) {
        return new IllegalArgumentException(String.format("Field [%s] not found.", node.toString()));
    }
}

