/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function;

import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.CompositeOperandTypeChecker;
import org.apache.calcite.sql.type.FamilyOperandTypeChecker;
import org.apache.calcite.sql.type.ImplicitCastOperandTypeChecker;
import org.apache.calcite.sql.type.SameOperandTypeChecker;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.util.Pair;
import org.opensearch.sql.calcite.type.ExprIPType;
import org.opensearch.sql.calcite.utils.OpenSearchTypeFactory;
import org.opensearch.sql.calcite.utils.UserDefinedFunctionUtils;
import org.opensearch.sql.data.type.ExprCoreType;
import org.opensearch.sql.data.type.ExprType;
import shaded.com.google.common.collect.Lists;

public interface PPLTypeChecker {
    public boolean checkOperandTypes(List<RelDataType> var1);

    public String getAllowedSignatures();

    public List<List<ExprType>> getParameterTypes();

    private static boolean validateOperands(List<SqlTypeFamily> funcTypeFamilies, List<RelDataType> operandTypes) {
        if (funcTypeFamilies.size() != operandTypes.size()) {
            return false;
        }
        for (int i = 0; i < operandTypes.size(); ++i) {
            SqlTypeName paramType = UserDefinedFunctionUtils.convertRelDataTypeToSqlTypeName(operandTypes.get(i));
            SqlTypeFamily funcTypeFamily = funcTypeFamilies.get(i);
            if (paramType.getFamily() == SqlTypeFamily.IGNORE || funcTypeFamily == SqlTypeFamily.IGNORE || funcTypeFamily.getTypeNames().contains(paramType)) continue;
            return false;
        }
        return true;
    }

    public static PPLFamilyTypeChecker family(SqlTypeFamily ... families) {
        return new PPLFamilyTypeChecker(families);
    }

    public static PPLFamilyTypeCheckerWrapper wrapFamily(ImplicitCastOperandTypeChecker typeChecker) {
        return new PPLFamilyTypeCheckerWrapper(typeChecker);
    }

    public static PPLCompositeTypeChecker wrapComposite(CompositeOperandTypeChecker typeChecker, boolean checkCompositionType) throws IllegalArgumentException, UnsupportedOperationException {
        if (checkCompositionType) {
            try {
                if (!PPLTypeChecker.isCompositionOr(typeChecker)) {
                    throw new IllegalArgumentException("Currently only support CompositeOperandTypeChecker with a OR composition");
                }
            }
            catch (ReflectiveOperationException | SecurityException | InaccessibleObjectException e) {
                throw new UnsupportedOperationException(String.format("Failed to check composition type of %s", typeChecker), e);
            }
        }
        for (SqlOperandTypeChecker rule : typeChecker.getRules()) {
            if (rule instanceof ImplicitCastOperandTypeChecker) continue;
            throw new IllegalArgumentException("Currently only compositions of ImplicitCastOperandTypeChecker are supported, found:" + rule.getClass().getName());
        }
        return new PPLCompositeTypeChecker(typeChecker);
    }

    public static PPLComparableTypeChecker wrapComparable(SameOperandTypeChecker typeChecker) {
        return new PPLComparableTypeChecker(typeChecker);
    }

    public static PPLDefaultTypeChecker wrapDefault(SqlOperandTypeChecker typeChecker) {
        return new PPLDefaultTypeChecker(typeChecker);
    }

    public static PPLTypeChecker wrapUDT(final List<List<ExprType>> allowedSignatures) {
        return new PPLTypeChecker(){

            @Override
            public boolean checkOperandTypes(List<RelDataType> types) {
                List<ExprType> argExprTypes = types.stream().map(OpenSearchTypeFactory::convertRelDataTypeToExprType).toList();
                for (List allowedSignature : allowedSignatures) {
                    if (allowedSignature.size() != types.size() || !IntStream.range(0, allowedSignature.size()).allMatch(i -> ((ExprType)allowedSignature.get(i)).equals(argExprTypes.get(i)))) continue;
                    return true;
                }
                return false;
            }

            @Override
            public String getAllowedSignatures() {
                return PPLTypeChecker.formatExprSignatures(allowedSignatures);
            }

            @Override
            public List<List<ExprType>> getParameterTypes() {
                return allowedSignatures;
            }
        };
    }

    private static String getFamilySignatures(FamilyOperandTypeChecker typeChecker) {
        List<List<ExprType>> allowedExprSignatures = PPLTypeChecker.getExprSignatures(typeChecker);
        return PPLTypeChecker.formatExprSignatures(allowedExprSignatures);
    }

    private static List<List<ExprType>> getExprSignatures(FamilyOperandTypeChecker typeChecker) {
        SqlOperandCountRange operandCountRange = typeChecker.getOperandCountRange();
        int min = operandCountRange.getMin();
        int max = operandCountRange.getMax();
        ArrayList<SqlTypeFamily> families = new ArrayList<SqlTypeFamily>();
        for (int i = 0; i < min; ++i) {
            families.add(typeChecker.getOperandSqlTypeFamily(i));
        }
        ArrayList<List<ExprType>> allowedSignatures = new ArrayList<List<ExprType>>(PPLTypeChecker.getExprSignatures(families));
        int MAX_ARGS = 10;
        max = Math.min(max, 10);
        for (int i = min; i < max; ++i) {
            families.add(typeChecker.getOperandSqlTypeFamily(i));
            allowedSignatures.addAll(PPLTypeChecker.getExprSignatures(families));
        }
        return allowedSignatures;
    }

    private static List<ExprType> getExprTypes(SqlTypeFamily family) {
        List<RelDataType> concreteTypes = switch (family) {
            case SqlTypeFamily.DATETIME -> List.of(OpenSearchTypeFactory.TYPE_FACTORY.createSqlType(SqlTypeName.TIMESTAMP), OpenSearchTypeFactory.TYPE_FACTORY.createSqlType(SqlTypeName.DATE), OpenSearchTypeFactory.TYPE_FACTORY.createSqlType(SqlTypeName.TIME));
            case SqlTypeFamily.NUMERIC -> List.of(OpenSearchTypeFactory.TYPE_FACTORY.createSqlType(SqlTypeName.INTEGER), OpenSearchTypeFactory.TYPE_FACTORY.createSqlType(SqlTypeName.DOUBLE));
            case SqlTypeFamily.INTEGER -> List.of(OpenSearchTypeFactory.TYPE_FACTORY.createSqlType(SqlTypeName.INTEGER));
            case SqlTypeFamily.ANY, SqlTypeFamily.IGNORE -> List.of(OpenSearchTypeFactory.TYPE_FACTORY.createSqlType(SqlTypeName.ANY));
            case SqlTypeFamily.DATETIME_INTERVAL -> SqlTypeName.INTERVAL_TYPES.stream().map(type -> OpenSearchTypeFactory.TYPE_FACTORY.createSqlIntervalType(new SqlIntervalQualifier(type.getStartUnit(), type.getEndUnit(), SqlParserPos.ZERO))).collect(Collectors.toList());
            default -> {
                RelDataType type = family.getDefaultConcreteType((RelDataTypeFactory)OpenSearchTypeFactory.TYPE_FACTORY);
                if (type == null) {
                    yield List.of(OpenSearchTypeFactory.TYPE_FACTORY.createSqlType(SqlTypeName.OTHER));
                }
                yield List.of(type);
            }
        };
        return concreteTypes.stream().map(OpenSearchTypeFactory::convertRelDataTypeToExprType).distinct().collect(Collectors.toList());
    }

    private static List<List<ExprType>> getExprSignatures(List<SqlTypeFamily> families) {
        List exprTypes = families.stream().map(PPLTypeChecker::getExprTypes).collect(Collectors.toList());
        return Lists.cartesianProduct(exprTypes);
    }

    private static String getFamilySignature(List<SqlTypeFamily> families) {
        List<List<ExprType>> signatures = PPLTypeChecker.getExprSignatures(families);
        return PPLTypeChecker.formatExprSignatures(signatures);
    }

    private static boolean isCompositionOr(CompositeOperandTypeChecker typeChecker) throws NoSuchFieldException, IllegalAccessException, InaccessibleObjectException, SecurityException {
        Field compositionField = CompositeOperandTypeChecker.class.getDeclaredField("composition");
        compositionField.setAccessible(true);
        CompositeOperandTypeChecker.Composition composition = (CompositeOperandTypeChecker.Composition)compositionField.get(typeChecker);
        return composition == CompositeOperandTypeChecker.Composition.OR;
    }

    private static String formatExprSignatures(List<List<ExprType>> signatures) {
        return signatures.stream().map(types -> "[" + types.stream().map(t -> t == ExprCoreType.UNDEFINED ? "ANY" : t.toString()).collect(Collectors.joining(",")) + "]").collect(Collectors.joining("|"));
    }

    public static class PPLFamilyTypeChecker
    implements PPLTypeChecker {
        private final List<SqlTypeFamily> families;

        public PPLFamilyTypeChecker(SqlTypeFamily ... families) {
            this.families = List.of(families);
        }

        @Override
        public boolean checkOperandTypes(List<RelDataType> types) {
            if (this.families.size() != types.size()) {
                return false;
            }
            return PPLTypeChecker.validateOperands(this.families, types);
        }

        @Override
        public String getAllowedSignatures() {
            return PPLTypeChecker.getFamilySignature(this.families);
        }

        @Override
        public List<List<ExprType>> getParameterTypes() {
            return PPLTypeChecker.getExprSignatures(this.families);
        }

        public String toString() {
            return String.format("PPLFamilyTypeChecker[families=%s]", this.getAllowedSignatures());
        }
    }

    public static class PPLFamilyTypeCheckerWrapper
    implements PPLTypeChecker {
        protected final ImplicitCastOperandTypeChecker innerTypeChecker;

        public PPLFamilyTypeCheckerWrapper(ImplicitCastOperandTypeChecker typeChecker) {
            this.innerTypeChecker = typeChecker;
        }

        @Override
        public boolean checkOperandTypes(List<RelDataType> types) {
            SqlOperandTypeChecker sqlOperandTypeChecker;
            ImplicitCastOperandTypeChecker implicitCastOperandTypeChecker = this.innerTypeChecker;
            if (implicitCastOperandTypeChecker instanceof SqlOperandTypeChecker && !(sqlOperandTypeChecker = (SqlOperandTypeChecker)implicitCastOperandTypeChecker).getOperandCountRange().isValidCount(types.size())) {
                return false;
            }
            List<SqlTypeFamily> families = IntStream.range(0, types.size()).mapToObj(arg_0 -> ((ImplicitCastOperandTypeChecker)this.innerTypeChecker).getOperandSqlTypeFamily(arg_0)).collect(Collectors.toList());
            return PPLTypeChecker.validateOperands(families, types);
        }

        @Override
        public String getAllowedSignatures() {
            ImplicitCastOperandTypeChecker implicitCastOperandTypeChecker = this.innerTypeChecker;
            if (implicitCastOperandTypeChecker instanceof FamilyOperandTypeChecker) {
                FamilyOperandTypeChecker familyOperandTypeChecker = (FamilyOperandTypeChecker)implicitCastOperandTypeChecker;
                List<List<ExprType>> allowedExprSignatures = PPLTypeChecker.getExprSignatures(familyOperandTypeChecker);
                return PPLTypeChecker.formatExprSignatures(allowedExprSignatures);
            }
            return "";
        }

        @Override
        public List<List<ExprType>> getParameterTypes() {
            ImplicitCastOperandTypeChecker implicitCastOperandTypeChecker = this.innerTypeChecker;
            if (implicitCastOperandTypeChecker instanceof FamilyOperandTypeChecker) {
                FamilyOperandTypeChecker familyOperandTypeChecker = (FamilyOperandTypeChecker)implicitCastOperandTypeChecker;
                return PPLTypeChecker.getExprSignatures(familyOperandTypeChecker);
            }
            return Collections.emptyList();
        }
    }

    public static class PPLCompositeTypeChecker
    implements PPLTypeChecker {
        private final List<? extends SqlOperandTypeChecker> allowedRules;

        public PPLCompositeTypeChecker(CompositeOperandTypeChecker typeChecker) {
            this.allowedRules = typeChecker.getRules();
        }

        private static boolean validateWithFamilyTypeChecker(SqlOperandTypeChecker checker, List<RelDataType> types) {
            if (!checker.getOperandCountRange().isValidCount(types.size())) {
                return false;
            }
            if (checker instanceof ImplicitCastOperandTypeChecker) {
                ImplicitCastOperandTypeChecker implicitCastOperandTypeChecker = (ImplicitCastOperandTypeChecker)checker;
                List<SqlTypeFamily> families = IntStream.range(0, types.size()).mapToObj(arg_0 -> ((ImplicitCastOperandTypeChecker)implicitCastOperandTypeChecker).getOperandSqlTypeFamily(arg_0)).toList();
                return PPLTypeChecker.validateOperands(families, types);
            }
            throw new IllegalArgumentException("Currently only compositions of ImplicitCastOperandTypeChecker are supported");
        }

        @Override
        public boolean checkOperandTypes(List<RelDataType> types) {
            boolean operandCountValid = this.allowedRules.stream().anyMatch(rule -> rule.getOperandCountRange().isValidCount(types.size()));
            if (!operandCountValid) {
                return false;
            }
            return this.allowedRules.stream().anyMatch(rule -> PPLCompositeTypeChecker.validateWithFamilyTypeChecker(rule, types));
        }

        @Override
        public String getAllowedSignatures() {
            StringBuilder builder = new StringBuilder();
            for (SqlOperandTypeChecker sqlOperandTypeChecker : this.allowedRules) {
                if (sqlOperandTypeChecker instanceof FamilyOperandTypeChecker) {
                    FamilyOperandTypeChecker familyOperandTypeChecker = (FamilyOperandTypeChecker)sqlOperandTypeChecker;
                    if (!builder.isEmpty()) {
                        builder.append("|");
                    }
                    builder.append(PPLTypeChecker.getFamilySignatures(familyOperandTypeChecker));
                    continue;
                }
                throw new IllegalArgumentException("Currently only compositions of FamilyOperandTypeChecker are supported");
            }
            return builder.toString();
        }

        @Override
        public List<List<ExprType>> getParameterTypes() {
            ArrayList<List<ExprType>> parameterTypes = new ArrayList<List<ExprType>>();
            for (SqlOperandTypeChecker sqlOperandTypeChecker : this.allowedRules) {
                if (sqlOperandTypeChecker instanceof FamilyOperandTypeChecker) {
                    FamilyOperandTypeChecker familyOperandTypeChecker = (FamilyOperandTypeChecker)sqlOperandTypeChecker;
                    parameterTypes.addAll(PPLTypeChecker.getExprSignatures(familyOperandTypeChecker));
                    continue;
                }
                throw new IllegalArgumentException("Currently only compositions of FamilyOperandTypeChecker are supported");
            }
            return parameterTypes;
        }
    }

    public static class PPLComparableTypeChecker
    implements PPLTypeChecker {
        private final SameOperandTypeChecker innerTypeChecker;

        @Override
        public boolean checkOperandTypes(List<RelDataType> types) {
            if (!this.innerTypeChecker.getOperandCountRange().isValidCount(types.size())) {
                return false;
            }
            for (int i = 0; i < types.size() - 1; ++i) {
                RelDataType type_l = types.get(i);
                RelDataType type_r = types.get(i + 1);
                if (type_l instanceof ExprIPType || type_r instanceof ExprIPType) {
                    return false;
                }
                if (PPLComparableTypeChecker.isComparable(type_l, type_r)) continue;
                return false;
            }
            return true;
        }

        private static boolean isComparable(RelDataType type1, RelDataType type2) {
            ExprType exprType2;
            if (type1.isStruct() != type2.isStruct()) {
                return false;
            }
            if (type1.isStruct()) {
                int n = type1.getFieldCount();
                if (n != type2.getFieldCount()) {
                    return false;
                }
                for (Pair pair : Pair.zip((List)type1.getFieldList(), (List)type2.getFieldList())) {
                    if (PPLComparableTypeChecker.isComparable(((RelDataTypeField)pair.left).getType(), ((RelDataTypeField)pair.right).getType())) continue;
                    return false;
                }
                return true;
            }
            if (SqlTypeUtil.isNumeric((RelDataType)type1) && SqlTypeUtil.isNumeric((RelDataType)type2)) {
                return true;
            }
            ExprType exprType1 = OpenSearchTypeFactory.convertRelDataTypeToExprType(type1);
            if (!exprType1.shouldCast(exprType2 = OpenSearchTypeFactory.convertRelDataTypeToExprType(type2))) {
                return true;
            }
            return type1.getFamily() == SqlTypeFamily.ANY || type2.getFamily() == SqlTypeFamily.ANY;
        }

        @Override
        public String getAllowedSignatures() {
            int min = this.innerTypeChecker.getOperandCountRange().getMin();
            int max = this.innerTypeChecker.getOperandCountRange().getMax();
            String typeName = "COMPARABLE_TYPE";
            if (min == -1 || max == -1) {
                return String.format("[%s...]", "COMPARABLE_TYPE");
            }
            ArrayList<CallSite> signatures = new ArrayList<CallSite>();
            int MAX_ARGS = 10;
            max = Math.min(10, max);
            for (int i = min; i <= max; ++i) {
                signatures.add((CallSite)((Object)("[" + String.join((CharSequence)",", Collections.nCopies(i, "COMPARABLE_TYPE")) + "]")));
            }
            return String.join((CharSequence)",", signatures);
        }

        @Override
        public List<List<ExprType>> getParameterTypes() {
            return List.of(List.of(ExprCoreType.UNKNOWN, ExprCoreType.UNKNOWN));
        }

        @Generated
        public PPLComparableTypeChecker(SameOperandTypeChecker innerTypeChecker) {
            this.innerTypeChecker = innerTypeChecker;
        }
    }

    public static class PPLDefaultTypeChecker
    implements PPLTypeChecker {
        private final SqlOperandTypeChecker internal;

        public PPLDefaultTypeChecker(SqlOperandTypeChecker typeChecker) {
            this.internal = typeChecker;
        }

        @Override
        public boolean checkOperandTypes(List<RelDataType> types) {
            if (!this.internal.getOperandCountRange().isValidCount(types.size())) {
                return false;
            }
            SqlOperandTypeChecker sqlOperandTypeChecker = this.internal;
            if (sqlOperandTypeChecker instanceof FamilyOperandTypeChecker) {
                FamilyOperandTypeChecker familyChecker = (FamilyOperandTypeChecker)sqlOperandTypeChecker;
                List<SqlTypeFamily> families = IntStream.range(0, types.size()).mapToObj(arg_0 -> ((FamilyOperandTypeChecker)familyChecker).getOperandSqlTypeFamily(arg_0)).collect(Collectors.toList());
                return PPLTypeChecker.validateOperands(families, types);
            }
            return true;
        }

        @Override
        public String getAllowedSignatures() {
            SqlOperandTypeChecker sqlOperandTypeChecker = this.internal;
            if (sqlOperandTypeChecker instanceof FamilyOperandTypeChecker) {
                FamilyOperandTypeChecker familyChecker = (FamilyOperandTypeChecker)sqlOperandTypeChecker;
                return PPLTypeChecker.getFamilySignatures(familyChecker);
            }
            int min = this.internal.getOperandCountRange().getMin();
            int max = this.internal.getOperandCountRange().getMax();
            if (min == -1 || max == -1) {
                return "[ANY...]";
            }
            if (min == max) {
                return "[" + String.join((CharSequence)",", Collections.nCopies(min, "ANY")) + "]";
            }
            ArrayList<CallSite> signatures = new ArrayList<CallSite>();
            int MAX_ARGS = 10;
            max = Math.min(10, max);
            for (int i = min; i <= max; ++i) {
                signatures.add((CallSite)((Object)("[" + String.join((CharSequence)",", Collections.nCopies(i, "ANY")) + "]")));
            }
            return String.join((CharSequence)"|", signatures);
        }

        @Override
        public List<List<ExprType>> getParameterTypes() {
            SqlOperandTypeChecker sqlOperandTypeChecker = this.internal;
            if (sqlOperandTypeChecker instanceof FamilyOperandTypeChecker) {
                FamilyOperandTypeChecker familyChecker = (FamilyOperandTypeChecker)sqlOperandTypeChecker;
                return PPLTypeChecker.getExprSignatures(familyChecker);
            }
            int min = this.internal.getOperandCountRange().getMin();
            int max = this.internal.getOperandCountRange().getMax();
            if (min == -1 || max == -1) {
                return List.of(List.of(ExprCoreType.UNKNOWN));
            }
            ArrayList<List<ExprType>> parameterTypes = new ArrayList<List<ExprType>>();
            int MAX_ARGS = 10;
            max = Math.min(10, max);
            for (int i = min; i <= max; ++i) {
                parameterTypes.add(Collections.nCopies(i, ExprCoreType.UNKNOWN));
            }
            return parameterTypes;
        }
    }
}

