/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.store.lockmanager;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.index.store.RemoteBufferedOutputDirectory;
import org.opensearch.index.store.lockmanager.FileLockInfo;
import org.opensearch.index.store.lockmanager.LockInfo;
import org.opensearch.index.store.lockmanager.RemoteStoreLockManager;

@PublicApi(since="2.8.0")
public class RemoteStoreMetadataLockManager
implements RemoteStoreLockManager {
    private static final Logger logger = LogManager.getLogger(RemoteStoreMetadataLockManager.class);
    private final RemoteBufferedOutputDirectory lockDirectory;

    public RemoteStoreMetadataLockManager(RemoteBufferedOutputDirectory lockDirectory) {
        this.lockDirectory = lockDirectory;
    }

    @Override
    public void acquire(LockInfo lockInfo) throws IOException {
        assert (lockInfo instanceof FileLockInfo) : "lockInfo should be instance of FileLockInfo";
        IndexOutput indexOutput = this.lockDirectory.createOutput(lockInfo.generateLockName(), IOContext.DEFAULT);
        indexOutput.close();
    }

    @Override
    public void release(LockInfo lockInfo) throws IOException {
        assert (lockInfo instanceof FileLockInfo) : "lockInfo should be instance of FileLockInfo";
        String[] lockFiles = this.lockDirectory.listAll();
        try {
            String lockToRelease = ((FileLockInfo)lockInfo).getLockForAcquirer(lockFiles);
            this.lockDirectory.deleteFile(lockToRelease);
        }
        catch (NoSuchFileException e) {
            logger.info("No lock file found for acquirerId: {}", (Object)((FileLockInfo)lockInfo).getAcquirerId());
        }
    }

    public String fetchLockedMetadataFile(String filenamePrefix, String acquirerId) throws IOException {
        Collection<String> lockFiles = this.lockDirectory.listFilesByPrefix(filenamePrefix);
        List lockFilesForAcquirer = lockFiles.stream().filter(lockFile -> acquirerId.equals(FileLockInfo.LockFileUtils.getAcquirerIdFromLock(lockFile))).map(FileLockInfo.LockFileUtils::getFileToLockNameFromLock).collect(Collectors.toList());
        if (lockFilesForAcquirer.size() == 0) {
            throw new FileNotFoundException("No lock file found for prefix: " + filenamePrefix + " and acquirerId: " + acquirerId);
        }
        assert (lockFilesForAcquirer.size() == 1);
        return (String)lockFilesForAcquirer.get(0);
    }

    public Set<String> fetchLockedMetadataFiles(String filenamePrefix) throws IOException {
        Collection<String> lockFiles = this.lockDirectory.listFilesByPrefix(filenamePrefix);
        return lockFiles.stream().map(FileLockInfo.LockFileUtils::getFileToLockNameFromLock).collect(Collectors.toSet());
    }

    @Override
    public Boolean isAcquired(LockInfo lockInfo) throws IOException {
        assert (lockInfo instanceof FileLockInfo) : "lockInfo should be instance of FileLockInfo";
        Collection<String> lockFiles = this.lockDirectory.listFilesByPrefix(((FileLockInfo)lockInfo).getLockPrefix());
        return !lockFiles.isEmpty();
    }

    @Override
    public void cloneLock(LockInfo originalLockInfo, LockInfo clonedLockInfo) throws IOException {
        assert (originalLockInfo instanceof FileLockInfo) : "originalLockInfo should be instance of FileLockInfo";
        assert (clonedLockInfo instanceof FileLockInfo) : "clonedLockInfo should be instance of FileLockInfo";
        String originalResourceId = Objects.requireNonNull(((FileLockInfo)originalLockInfo).getAcquirerId());
        String clonedResourceId = Objects.requireNonNull(((FileLockInfo)clonedLockInfo).getAcquirerId());
        assert (originalResourceId != null && clonedResourceId != null) : "provided resourceIds should not be null";
        String[] lockFiles = this.lockDirectory.listAll();
        String lockNameForAcquirer = ((FileLockInfo)originalLockInfo).getLockForAcquirer(lockFiles);
        String fileToLockName = FileLockInfo.LockFileUtils.getFileToLockNameFromLock(lockNameForAcquirer);
        this.acquire(FileLockInfo.getLockInfoBuilder().withFileToLock(fileToLockName).withAcquirerId(clonedResourceId).build());
    }

    @Override
    public void delete() throws IOException {
        this.lockDirectory.delete();
    }
}

