/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indices.store;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opensearch.OpenSearchException;
import org.opensearch.action.ActionType;
import org.opensearch.action.FailedNodeException;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.nodes.BaseNodeResponse;
import org.opensearch.action.support.nodes.BaseNodesRequest;
import org.opensearch.action.support.nodes.BaseNodesResponse;
import org.opensearch.action.support.nodes.TransportNodesAction;
import org.opensearch.cluster.ClusterName;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.index.shard.ShardId;
import org.opensearch.env.NodeEnvironment;
import org.opensearch.gateway.AsyncShardFetch;
import org.opensearch.index.store.Store;
import org.opensearch.indices.IndicesService;
import org.opensearch.indices.store.ShardAttributes;
import org.opensearch.indices.store.TransportNodesListShardStoreMetadataHelper;
import org.opensearch.threadpool.ThreadPool;
import org.opensearch.transport.TransportRequest;
import org.opensearch.transport.TransportService;

public class TransportNodesListShardStoreMetadataBatch
extends TransportNodesAction<Request, NodesStoreFilesMetadataBatch, NodeRequest, NodeStoreFilesMetadataBatch>
implements AsyncShardFetch.Lister<NodesStoreFilesMetadataBatch, NodeStoreFilesMetadataBatch> {
    public static final String ACTION_NAME = "internal:cluster/nodes/indices/shard/store/batch";
    public static final ActionType<NodesStoreFilesMetadataBatch> TYPE = new ActionType("internal:cluster/nodes/indices/shard/store/batch", NodesStoreFilesMetadataBatch::new);
    private final Settings settings;
    private final IndicesService indicesService;
    private final NodeEnvironment nodeEnv;

    @Inject
    public TransportNodesListShardStoreMetadataBatch(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, IndicesService indicesService, NodeEnvironment nodeEnv, ActionFilters actionFilters) {
        super(ACTION_NAME, threadPool, clusterService, transportService, actionFilters, Request::new, NodeRequest::new, "fetch_shard_store", NodeStoreFilesMetadataBatch.class);
        this.settings = settings;
        this.indicesService = indicesService;
        this.nodeEnv = nodeEnv;
    }

    @Override
    public void list(Map<ShardId, ShardAttributes> shardAttributes, DiscoveryNode[] nodes, ActionListener<NodesStoreFilesMetadataBatch> listener) {
        this.execute(new Request(shardAttributes, nodes), listener);
    }

    @Override
    protected NodeRequest newNodeRequest(Request request) {
        return new NodeRequest(request);
    }

    @Override
    protected NodeStoreFilesMetadataBatch newNodeResponse(StreamInput in) throws IOException {
        return new NodeStoreFilesMetadataBatch(in);
    }

    @Override
    protected NodesStoreFilesMetadataBatch newResponse(Request request, List<NodeStoreFilesMetadataBatch> responses, List<FailedNodeException> failures) {
        return new NodesStoreFilesMetadataBatch(this.clusterService.getClusterName(), responses, failures);
    }

    @Override
    protected NodeStoreFilesMetadataBatch nodeOperation(NodeRequest request) {
        try {
            return new NodeStoreFilesMetadataBatch(this.clusterService.localNode(), this.listStoreMetadata(request));
        }
        catch (IOException e) {
            throw new OpenSearchException("Failed to list store metadata for shards [" + String.valueOf(request.getShardAttributes().keySet().stream().map(ShardId::toString)) + "]", (Throwable)e, new Object[0]);
        }
    }

    private Map<ShardId, NodeStoreFilesMetadata> listStoreMetadata(NodeRequest request) throws IOException {
        HashMap<ShardId, NodeStoreFilesMetadata> shardStoreMetadataMap = new HashMap<ShardId, NodeStoreFilesMetadata>();
        for (Map.Entry<ShardId, ShardAttributes> shardAttributes : request.getShardAttributes().entrySet()) {
            ShardId shardId = shardAttributes.getKey();
            try {
                TransportNodesListShardStoreMetadataHelper.StoreFilesMetadata storeFilesMetadata = TransportNodesListShardStoreMetadataHelper.listShardMetadataInternal(this.logger, shardId, this.nodeEnv, this.indicesService, shardAttributes.getValue().getCustomDataPath(), this.settings, this.clusterService);
                shardStoreMetadataMap.put(shardId, new NodeStoreFilesMetadata(storeFilesMetadata, null));
            }
            catch (Exception e) {
                if (e.getMessage().contains("node doesn't have meta data for index ") || e instanceof IOException) {
                    shardStoreMetadataMap.put(shardId, null);
                    continue;
                }
                shardStoreMetadataMap.put(shardId, new NodeStoreFilesMetadata(new TransportNodesListShardStoreMetadataHelper.StoreFilesMetadata(shardId, Store.MetadataSnapshot.EMPTY, Collections.emptyList()), e));
            }
        }
        return shardStoreMetadataMap;
    }

    public static class NodeStoreFilesMetadataBatch
    extends BaseNodeResponse {
        private final Map<ShardId, NodeStoreFilesMetadata> nodeStoreFilesMetadataBatch;

        protected NodeStoreFilesMetadataBatch(StreamInput in) throws IOException {
            super(in);
            this.nodeStoreFilesMetadataBatch = in.readMap(ShardId::new, i -> {
                if (i.readBoolean()) {
                    return new NodeStoreFilesMetadata(i);
                }
                return null;
            });
        }

        public NodeStoreFilesMetadataBatch(DiscoveryNode node, Map<ShardId, NodeStoreFilesMetadata> nodeStoreFilesMetadataBatch) {
            super(node);
            this.nodeStoreFilesMetadataBatch = nodeStoreFilesMetadataBatch;
        }

        public Map<ShardId, NodeStoreFilesMetadata> getNodeStoreFilesMetadataBatch() {
            return this.nodeStoreFilesMetadataBatch;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeMap(this.nodeStoreFilesMetadataBatch, (o, k) -> k.writeTo(o), (o, v) -> {
                if (v != null) {
                    o.writeBoolean(true);
                    v.writeTo(o);
                } else {
                    o.writeBoolean(false);
                }
            });
        }
    }

    public static class Request
    extends BaseNodesRequest<Request> {
        private final Map<ShardId, ShardAttributes> shardAttributes;

        public Request(StreamInput in) throws IOException {
            super(in);
            this.shardAttributes = in.readMap(ShardId::new, ShardAttributes::new);
        }

        public Request(Map<ShardId, ShardAttributes> shardAttributes, DiscoveryNode[] nodes) {
            super(nodes);
            this.shardAttributes = Objects.requireNonNull(shardAttributes);
        }

        public Map<ShardId, ShardAttributes> getShardAttributes() {
            return this.shardAttributes;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeMap(this.shardAttributes, (o, k) -> k.writeTo(o), (o, v) -> v.writeTo(o));
        }
    }

    public static class NodeRequest
    extends TransportRequest {
        private final Map<ShardId, ShardAttributes> shardAttributes;

        public NodeRequest(StreamInput in) throws IOException {
            super(in);
            this.shardAttributes = in.readMap(ShardId::new, ShardAttributes::new);
        }

        public NodeRequest(Request request) {
            this.shardAttributes = Objects.requireNonNull(request.getShardAttributes());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeMap(this.shardAttributes, (o, k) -> k.writeTo(o), (o, v) -> v.writeTo(o));
        }

        public Map<ShardId, ShardAttributes> getShardAttributes() {
            return this.shardAttributes;
        }
    }

    public static class NodesStoreFilesMetadataBatch
    extends BaseNodesResponse<NodeStoreFilesMetadataBatch> {
        public NodesStoreFilesMetadataBatch(StreamInput in) throws IOException {
            super(in);
        }

        public NodesStoreFilesMetadataBatch(ClusterName clusterName, List<NodeStoreFilesMetadataBatch> nodes, List<FailedNodeException> failures) {
            super(clusterName, nodes, failures);
        }

        @Override
        protected List<NodeStoreFilesMetadataBatch> readNodesFrom(StreamInput in) throws IOException {
            return in.readList(NodeStoreFilesMetadataBatch::new);
        }

        @Override
        protected void writeNodesTo(StreamOutput out, List<NodeStoreFilesMetadataBatch> nodes) throws IOException {
            out.writeList(nodes);
        }
    }

    public static class NodeStoreFilesMetadata {
        private TransportNodesListShardStoreMetadataHelper.StoreFilesMetadata storeFilesMetadata;
        private Exception storeFileFetchException;

        public NodeStoreFilesMetadata(TransportNodesListShardStoreMetadataHelper.StoreFilesMetadata storeFilesMetadata) {
            this.storeFilesMetadata = storeFilesMetadata;
            this.storeFileFetchException = null;
        }

        public NodeStoreFilesMetadata(StreamInput in) throws IOException {
            this.storeFilesMetadata = new TransportNodesListShardStoreMetadataHelper.StoreFilesMetadata(in);
            this.storeFileFetchException = in.readBoolean() ? in.readException() : null;
        }

        public NodeStoreFilesMetadata(TransportNodesListShardStoreMetadataHelper.StoreFilesMetadata storeFilesMetadata, Exception storeFileFetchException) {
            this.storeFilesMetadata = storeFilesMetadata;
            this.storeFileFetchException = storeFileFetchException;
        }

        public TransportNodesListShardStoreMetadataHelper.StoreFilesMetadata storeFilesMetadata() {
            return this.storeFilesMetadata;
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.storeFilesMetadata.writeTo(out);
            if (this.storeFileFetchException != null) {
                out.writeBoolean(true);
                out.writeException((Throwable)this.storeFileFetchException);
            } else {
                out.writeBoolean(false);
            }
        }

        public static boolean isEmpty(NodeStoreFilesMetadata response) {
            return response.storeFilesMetadata() == null || response.storeFilesMetadata().isEmpty() && response.getStoreFileFetchException() == null;
        }

        public Exception getStoreFileFetchException() {
            return this.storeFileFetchException;
        }

        public String toString() {
            return "[[" + String.valueOf(this.storeFilesMetadata) + "]]";
        }
    }
}

